package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingImgInfoDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingImgInfo;
import com.chenyang.nse.bussiness.service.core.TCoreMaskingImgInfoService;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@Repository
public class TCoreMaskingImgInfoServiceImpl implements TCoreMaskingImgInfoService {
   @Autowired
   TCoreMaskingImgInfoDao tCoreMaskingImgInfoDao;

   public TCoreMaskingImgInfo querynumByip(String ip) {
      List<TCoreMaskingImgInfo> list = this.tCoreMaskingImgInfoDao.queryAll(new Criterion[]{Restrictions.eq("ip", ip)});
      return list.size() > 0 ? (TCoreMaskingImgInfo)list.get(0) : null;
   }

   public void saveOrUpdate(TCoreMaskingImgInfo tCoreMaskingImgInfo) {
      this.tCoreMaskingImgInfoDao.saveOrUpdate(tCoreMaskingImgInfo);
   }
}
