package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncryptionTableRuleDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryptionRuleTable;
import com.chenyang.nse.bussiness.entity.vo.TableRuleInfo;
import com.chenyang.nse.bussiness.service.core.TableRuleService;
import com.chenyang.nse.bussiness.tools.dataprocess.hive.HiveEncDecType;
import com.chenyang.nse.bussiness.tools.dataprocess.hive.hdfs.TableInfo;
import com.chenyang.nse.bussiness.tools.dataprocess.hive.hdfs.format.HiveFileType;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import java.sql.Connection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TableRuleServiceImpl implements TableRuleService {
   @Autowired
   TCoreEncryptionTableRuleDao dao;
   @Autowired
   TCoreDatasystemDao systemDao;

   public TableRuleInfo getHiveStoreInfo(String projectId, String dataSystemId, String schema, String table) {
      if (projectId != null && projectId.length() != 0) {
         if (dataSystemId != null && dataSystemId.length() != 0) {
            if (schema != null && schema.length() != 0) {
               if (table != null && table.length() != 0) {
                  TCoreDatasystem datasystem = (TCoreDatasystem)this.systemDao.get(dataSystemId);
                  if (datasystem == null) {
                     return null;
                  } else if (datasystem.getDbtype() == null) {
                     return null;
                  } else if (!datasystem.getDbtype().toUpperCase().trim().startsWith("HIVE")) {
                     return null;
                  } else {
                     HiveFileType fileType = null;

                     try {
                        Connection connection = JdbcTool.getConnection(datasystem);
                        Throwable tableRule = null;

                        try {
                           Map<String, String> format = JdbcTool.queryHdfsFileInfoForTDH(connection, schema, table);
                           TableInfo tableInfo = new TableInfo();
                           tableInfo.format = format;
                           fileType = tableInfo.getFileType();
                        } catch (Throwable var19) {
                           tableRule = var19;
                           throw var19;
                        } finally {
                           if (connection != null) {
                              if (tableRule != null) {
                                 try {
                                    connection.close();
                                 } catch (Throwable var18) {
                                    tableRule.addSuppressed(var18);
                                 }
                              } else {
                                 connection.close();
                              }
                           }

                        }
                     } catch (Exception var21) {
                        return null;
                     }

                     TableRuleInfo info = new TableRuleInfo();
                     info.setProjectId(projectId);
                     info.setDataSystemId(dataSystemId);
                     info.setSchema(schema);
                     info.setTable(table);
                     info.setStoreType(fileType.getTypeName());
                     TCoreEncryptionRuleTable tableRule = this.dao.get(projectId, info.getDataSystemId(), schema, table);
                     if (tableRule != null) {
                        info.setId(tableRule.getId());
                        info.setEncType(tableRule.getEnctype());
                     }

                     switch (fileType) {
                        case orc:
                           info.setDefEncType(HiveEncDecType.jdbc.getTypeName());
                           break;
                        case text:
                           info.setDefEncType(HiveEncDecType.webHdfs.getTypeName());
                        case seq:
                        case parquet:
                     }

                     if (info.getEncType() == null && info.getDefEncType() != null) {
                        info.setEncType(info.getDefEncType());
                     }

                     return info;
                  }
               } else {
                  return null;
               }
            } else {
               return null;
            }
         } else {
            return null;
         }
      } else {
         return null;
      }
   }

   public boolean saveHiveTableRuleInfo(TableRuleInfo info) {
      if (info != null && info.getProjectId() != null && info.getProjectId().length() != 0 && info.getDataSystemId() != null && info.getDataSystemId().length() != 0 && info.getSchema() != null && info.getSchema().length() != 0 && info.getTable() != null && info.getTable().length() != 0) {
         Date now = new Date();
         TCoreEncryptionRuleTable table = this.dao.get(info.getProjectId(), info.getDataSystemId(), info.getSchema(), info.getTable());
         if (table != null) {
            table.setUpdatetime(now);
            table.setUpdateuser(info.getUsername());
            table.setProjectid(info.getProjectId());
            table.setDatasystemid(info.getDataSystemId());
            table.setSchemaname(info.getSchema());
            table.setTablename(info.getTable());
            table.setEnctype(info.getEncType());
            table.setFlag("0");
            this.dao.update(table);
         } else {
            table = new TCoreEncryptionRuleTable();
            table.setProjectid(info.getProjectId());
            table.setDatasystemid(info.getDataSystemId());
            table.setSchemaname(info.getSchema());
            table.setTablename(info.getTable());
            table.setEnctype(info.getEncType());
            table.setCreatetime(now);
            table.setUpdatetime(now);
            table.setCreateuser(info.getUsername());
            table.setUpdateuser(info.getUsername());
            this.dao.save(table);
         }

         return true;
      } else {
         return false;
      }
   }

   public List<String> getHiveStoreFileTypes() {
      return HiveFileType.getFileTypeNames();
   }

   public List<String> getHiveEncDecTypeNames() {
      return HiveEncDecType.getHiveEncDecTypeNames();
   }
}
