package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreWatermarkKeyInfoDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreWatermarkKeyInfo;
import com.chenyang.nse.bussiness.service.core.WaterMarkService;
import com.chenyang.nse.bussiness.tools.string.BinaryConversion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class WaterMarkServiceImpl implements WaterMarkService {
   @Autowired
   private TCoreWatermarkKeyInfoDao tCoreWatermarkKeyInfoDao;

   public List isExistKey(String key) {
      List<TCoreWatermarkKeyInfo> list = this.tCoreWatermarkKeyInfoDao.queryAll(new Criterion[]{Restrictions.eq("secretkey", key)});
      return list;
   }

   public void saveWaterMarkInfo(TCoreWatermarkKeyInfo tCoreWatermarkKeyInfo) {
      this.tCoreWatermarkKeyInfoDao.saveOrUpdate(tCoreWatermarkKeyInfo);
   }

   public List<TCoreWatermarkKeyInfo> queryWaterMarkInfo(PageInfo pageInfo) {
      List<TCoreWatermarkKeyInfo> list = this.tCoreWatermarkKeyInfoDao.queryByPageInfo(pageInfo, Order.desc("createtime"));
      return list;
   }

   public List<TCoreWatermarkKeyInfo> queryWaterMarkInfobyId(String taskid) {
      List<TCoreWatermarkKeyInfo> list = this.tCoreWatermarkKeyInfoDao.queryAll(new Criterion[]{Restrictions.eq("id", taskid)});
      return list;
   }

   public void delWaterMarkInfobyId(String taskid) {
      this.tCoreWatermarkKeyInfoDao.removeById(taskid);
   }

   public List isExistKeyname(String keyname) {
      List<TCoreWatermarkKeyInfo> list = this.tCoreWatermarkKeyInfoDao.queryAll(new Criterion[]{Restrictions.eq("keyname", keyname)});
      return list;
   }

   public List<Map<String, String>> getMatchingInfo(String textval) {
      List<Map<String, String>> relist = new ArrayList();
      Map<String, String> similarmap = new HashMap();
      Map<String, String> matchmap = new HashMap();
      List<TCoreWatermarkKeyInfo> list = this.tCoreWatermarkKeyInfoDao.queryAll();
      String[] values = textval.split("\n|\r");
      Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
      Map<String, String> mapval = new HashMap();
      Map<String, Integer> maxmap = new HashMap();

      for(int i = 0; i < list.size(); ++i) {
         String key = ((TCoreWatermarkKeyInfo)list.get(i)).getSecretkey();
         List<String> listval = new ArrayList();
         Map<Integer, String> map = new HashMap();

         for(int z = 0; z < values.length; ++z) {
            String fileVal = values[z];

            for(int j = 0; j < fileVal.length(); ++j) {
               String byfileval = "";
               char strchar = fileVal.charAt(j);
               Matcher isNum = pattern.matcher(String.valueOf(strchar));
               if (isNum.matches()) {
                  byfileval = BinaryConversion.decimalToBinary(Integer.valueOf(String.valueOf(strchar)));
               } else {
                  String bystr = BinaryConversion.StrToBinstr(strchar);
                  byfileval = bystr.substring(bystr.length() - 4);
               }

               listval.add(byfileval);
            }

            for(int j = 0; j < key.length(); ++j) {
               String bykeychar = BinaryConversion.decimalToBinary(j) + BinaryConversion.decimalToBinary(Integer.valueOf(String.valueOf(key.charAt(j))));

               for(int k = 0; k < listval.size() - 1; ++k) {
                  String comval = (String)listval.get(k) + (String)listval.get(k + 1);
                  if (comval.equals(bykeychar)) {
                     map.put(j, String.valueOf(key.charAt(j)));
                  }
               }
            }
         }

         String traceval = "";

         for(int j = 0; j < 10; ++j) {
            String val = (String)map.get(j);
            if ("".equals(val) || val == null) {
               val = "*";
            }

            traceval = traceval + val;
         }

         mapval.put(key, traceval);
      }

      for(String key : mapval.keySet()) {
         maxmap.put(key, getSimilarity(key, (String)mapval.get(key)));
      }

      int max = 0;
      int value = 0;

      for(String key : maxmap.keySet()) {
         value = (Integer)maxmap.get(key);
         if (max < value) {
            max = value;
         }
      }

      if (max == 0) {
         return relist;
      } else {
         for(Map.Entry<String, Integer> entry : maxmap.entrySet()) {
            if (max == (Integer)entry.getValue()) {
               String key = (String)entry.getKey();
               similarmap.put(key, max + "%");
               matchmap.put(key, mapval.get(key));
            }
         }

         relist.add(similarmap);
         relist.add(matchmap);
         return relist;
      }
   }

   private static Integer getSimilarity(String key, String value) {
      int ismatchct = 0;

      for(int i = 0; i < 10; ++i) {
         if (key.charAt(i) == value.charAt(i)) {
            ++ismatchct;
         }
      }

      Integer percentage = ismatchct * 100 / 10;
      return percentage;
   }
}
