package com.chenyang.nse.bussiness.service.core.impl.encryption;

import cn.hutool.core.util.ObjectUtil;
import com.chenyang.nse.bussiness.dao.core.key.TCoreKeyTypeManagementDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreSecretkeyDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncryptionDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncryptionTypeFieldDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreSecretkey;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryption;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryptionTypeField;
import com.chenyang.nse.bussiness.entity.orm.table.core.key.TCoreKeyTypeManagement;
import com.chenyang.nse.bussiness.entity.vo.AutoDetectVO;
import com.chenyang.nse.bussiness.entity.vo.AutoFieldVO;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.service.core.encryption.TCoreEncryptionService;
import com.chenyang.nse.bussiness.tools.encryption.EncProvider;
import com.chenyang.nse.bussiness.tools.encryption.SM4Util;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.token.TokenUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;

@Service
public class TCoreEncryptionServiceImpl implements TCoreEncryptionService {
   private static final String ROOT_SECRET_KEY = "5b1a3c65aaa314042f759fa47eb009d6";
   @Autowired
   TCoreEncryptionDao tCoreEncryptionDao;
   @Autowired
   HttpServletRequest request;
   @Autowired
   TCoreSecretkeyDao tCoreSecretkeyDao;
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   TCoreEncryptionTypeFieldDao tCoreEncryptionTypeFieldDao;
   @Autowired
   TCoreKeyTypeManagementDao tCoreKeyTypeManagementDao;
   protected Logger logger = LoggerFactory.getLogger(this.getClass());

   public void save(TCoreEncryption encryption) {
      String username = TokenUtil.getUserId(this.request.getHeader("token"));
      if (encryption.getId() != null && !encryption.getId().equals("")) {
         TCoreEncryption tCoreEncryption = (TCoreEncryption)this.tCoreEncryptionDao.get(encryption.getId());
         tCoreEncryption.setEncryption_name(encryption.getEncryption_name());
         tCoreEncryption.setEncryption_type(encryption.getEncryption_type());
         tCoreEncryption.setUpdatetime(new Date());
         tCoreEncryption.setUpdateuser(username);
         tCoreEncryption.setNote(encryption.getNote());
         this.tCoreEncryptionDao.saveOrUpdate(tCoreEncryption);
      } else {
         encryption.setCreatetime(new Date());
         encryption.setCreateuser(username);
         this.tCoreEncryptionDao.save(encryption);
      }

   }

   public List<ComboboxVO> initEncryptionTypeList() {
      return this.tCoreEncryptionDao.initEncryptionTypeList();
   }

   public List<TCoreEncryptionTypeField> deleteEncryption(String encryptionId) {
      List<TCoreSecretkey> tCoreSecretkeys = this.tCoreSecretkeyDao.queryAll(new Criterion[]{Restrictions.eq("encryption_id", encryptionId)});
      List<TCoreEncryptionTypeField> curFlagFieldList = new ArrayList();

      for(TCoreSecretkey tCoreSecretkey : tCoreSecretkeys) {
         if (!ObjectUtil.isEmpty(this.delSecretKey(tCoreSecretkey.getId()))) {
            for(TCoreEncryptionTypeField tCoreEncryptionTypeField : this.delSecretKey(tCoreSecretkey.getId())) {
               curFlagFieldList.add(tCoreEncryptionTypeField);
            }
         }
      }

      if (curFlagFieldList.size() > 0) {
         return curFlagFieldList;
      } else {
         if (!ObjectUtil.isEmpty(this.tCoreEncryptionDao.get(encryptionId))) {
            this.tCoreEncryptionDao.removeById(encryptionId);
         }

         return null;
      }
   }

   public String getRandomValue(String type) {
      String result = "";

      try {
         result = EncProvider.generateKey(type);
         result = this.getEncDataKey(result);
      } catch (Exception e) {
         e.printStackTrace();
         result = "";
      }

      return result;
   }

   public String getEncDataKey(String dataKey) {
      TCoreKeyTypeManagement tCoreKeyTypeManagement = (TCoreKeyTypeManagement)this.tCoreKeyTypeManagementDao.queryUnique(new Criterion[]{Restrictions.eq("isuse", "1")});
      String systemKey = tCoreKeyTypeManagement.getSystemkey();
      String systemKeySecret = null;

      try {
         systemKeySecret = SM4Util.decryptEcb("5b1a3c65aaa314042f759fa47eb009d6", systemKey, "0", (String)null, (String)null, (String)null);
      } catch (Exception e) {
         e.printStackTrace();
      }

      dataKey = SM4Util.encryptEcb(systemKeySecret, dataKey, "0", (String)null, (String)null, (String)null);
      return dataKey;
   }

   public String getDecDataKey(String encDataKey) {
      TCoreKeyTypeManagement tCoreKeyTypeManagement = (TCoreKeyTypeManagement)this.tCoreKeyTypeManagementDao.queryUnique(new Criterion[]{Restrictions.eq("isuse", "1")});
      String systemKey = tCoreKeyTypeManagement.getSystemkey();
      String systemKeySecret = null;

      try {
         systemKeySecret = SM4Util.decryptEcb("5b1a3c65aaa314042f759fa47eb009d6", systemKey, "0", (String)null, (String)null, (String)null);
      } catch (Exception e) {
         e.printStackTrace();
      }

      try {
         encDataKey = SM4Util.decryptEcb(systemKeySecret, encDataKey, "0", (String)null, (String)null, (String)null);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return encDataKey;
   }

   public String testEncryption(String type, String param, String isLike, String secret_key, String keepfirst, String encdigit, String twoindex) {
      String cipher = "";
      if (Objects.isNull(isLike) || "".equals(isLike)) {
         isLike = "0";
      }

      try {
         String secretKey = this.getDecDataKey(secret_key);
         cipher = EncProvider.encryptEcb(type, secretKey, param, isLike, (String)null, (String)null, (String)null);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return cipher;
   }

   public void saveSecretKey(TCoreSecretkey tCoreSecretKey) {
      String username = TokenUtil.getUserId(this.request.getHeader("token"));
      if (tCoreSecretKey.getId() != null && !tCoreSecretKey.getId().equals("")) {
         TCoreSecretkey secretkey = (TCoreSecretkey)this.tCoreSecretkeyDao.get(tCoreSecretKey.getId());
         secretkey.setSecret_key_name(tCoreSecretKey.getSecret_key_name());
         secretkey.setUpdatetime(new Date());
         secretkey.setUpdateuser(username);
         this.tCoreSecretkeyDao.saveOrUpdate(secretkey);
      } else {
         tCoreSecretKey.setCreatetime(new Date());
         tCoreSecretKey.setCreateuser(username);
         this.tCoreSecretkeyDao.save(tCoreSecretKey);
      }

   }

   public List<TCoreEncryptionTypeField> delSecretKey(String keyId) {
      List<TCoreEncryptionTypeField> tCoreEncryptionTypeFieldList = this.tCoreEncryptionTypeFieldDao.queryAll();
      List<TCoreEncryptionTypeField> curDelFieldList = new ArrayList();
      List<TCoreEncryptionTypeField> curFlagFieldList = new ArrayList();

      for(TCoreEncryptionTypeField tCoreEncryptionTypeField : tCoreEncryptionTypeFieldList) {
         if (keyId.equals(tCoreEncryptionTypeField.getEncryption_secretkey_id())) {
            curFlagFieldList.add(tCoreEncryptionTypeField);
         }
      }

      if (curFlagFieldList.size() > 0) {
         return curFlagFieldList;
      } else {
         if (curDelFieldList.size() > 0) {
            for(TCoreEncryptionTypeField curTCoreEncryptionTypeField : curDelFieldList) {
               this.tCoreEncryptionTypeFieldDao.removeById(curTCoreEncryptionTypeField.getId());
            }
         }

         if (!ObjectUtil.isEmpty(this.tCoreSecretkeyDao.get(keyId))) {
            this.tCoreSecretkeyDao.removeById(keyId);
         }

         return null;
      }
   }

   public List<TCoreEncryption> queryEncryptionList(String encryption_name) {
      List<TCoreEncryption> encryptionList = this.tCoreEncryptionDao.queryAll(new Criterion[]{Restrictions.like("encryption_name", encryption_name, MatchMode.ANYWHERE)});

      for(TCoreEncryption tCoreEncryption : encryptionList) {
         List<TCoreSecretkey> keyList = this.tCoreSecretkeyDao.queryAll(new Criterion[]{Restrictions.eq("encryption_id", tCoreEncryption.getId())});
         tCoreEncryption.setList(keyList);
      }

      return encryptionList;
   }

   public Map<String, String> queryEncryptionInfo(String secretKeyId) {
      Map returnMap = new HashMap();
      String encryptionType = "";
      TCoreSecretkey tCoreSecretkey = (TCoreSecretkey)this.tCoreSecretkeyDao.queryUnique(new Criterion[]{Restrictions.eq("id", secretKeyId)});
      TCoreEncryption tCoreEncryption = (TCoreEncryption)this.tCoreEncryptionDao.queryUnique(new Criterion[]{Restrictions.eq("id", tCoreSecretkey.getEncryption_id())});
      if (tCoreEncryption != null) {
         encryptionType = tCoreEncryption.getEncryption_type();
      }

      returnMap.put("encryptionType", encryptionType);
      String dataKey = "";
      String sectet_key_value = tCoreSecretkey.getSectet_key_value();
      returnMap.put("secretkey", this.getDecDataKey(sectet_key_value));
      return returnMap;
   }

   public Map<String, String> queryEncryptionInfo(String keyName, String sKeyName) {
      Map<String, String> returnMap = new HashMap();
      String encryptionType = "";
      String secretKeyId = null;

      try {
         secretKeyId = this.tCoreSecretkeyDao.queryIdByKeyAndSKey(keyName, sKeyName);
      } catch (EmptyResultDataAccessException var8) {
         returnMap.put("msg", "加密类型和秘钥不匹配");
         return returnMap;
      }

      TCoreSecretkey tCoreSecretkey = (TCoreSecretkey)this.tCoreSecretkeyDao.queryUnique(new Criterion[]{Restrictions.eq("id", secretKeyId)});
      TCoreEncryption tCoreEncryption = (TCoreEncryption)this.tCoreEncryptionDao.queryUnique(new Criterion[]{Restrictions.eq("id", tCoreSecretkey.getEncryption_id())});
      if (tCoreEncryption != null) {
         encryptionType = tCoreEncryption.getEncryption_type();
      }

      returnMap.put("encryptionType", encryptionType);
      returnMap.put("secretkey", tCoreSecretkey.getSectet_key_value());
      returnMap.put("secretkeyId", secretKeyId);
      return returnMap;
   }

   public AutoDetectVO autoDetect(AutoDetectVO autoDetectVO) throws SQLException {
      String dataSystemId = autoDetectVO.getDataSystemId();
      TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(dataSystemId);
      Connection conn = JdbcTool.getConnection(datasystem);
      Statement stmt = conn.createStatement();
      List<AutoFieldVO> columnsList = autoDetectVO.getColumnArr();
      String encString = "";
      Integer bestLength = 0;

      for(AutoFieldVO fieldVO : columnsList) {
         ResultSet rs = stmt.executeQuery("SELECT max(length(" + fieldVO.getColumnName() + ")) as maxLength FROM " + autoDetectVO.getTableName());

         while(rs.next()) {
            System.out.println(rs.getInt(1));
            Integer length = rs.getInt(1);
            StringBuffer encValue = new StringBuffer("");

            for(int i = 0; i < length; ++i) {
               encValue.append("啊");
            }

            try {
               encString = EncProvider.encryptEcb("SM4", SM4Util.generateKey(), encValue.toString(), fieldVO.getIsLike(), (String)null, (String)null, (String)null);
               bestLength = encString.length() + 10;
               bestLength = bestLength < fieldVO.getOriginalLength() ? fieldVO.getOriginalLength() : bestLength;
               fieldVO.setBestLength(bestLength);
            } catch (Exception e) {
               e.printStackTrace();
            }
         }
      }

      try {
         if (stmt != null) {
            stmt.close();
         }

         if (conn != null) {
            conn.close();
         }
      } catch (SQLException e) {
         e.printStackTrace();
      }

      return autoDetectVO;
   }

   public String getProcesslog(String path) {
      File logFile = new File(path);
      BufferedReader reader = null;
      StringBuffer stringBuffer = new StringBuffer();

      try {
         if (!logFile.exists()) {
            this.logger.warn("文件" + logFile + "不存在,重新创建一个");
            FileTool.fileDirsCreate(path);
            logFile.createNewFile();
         }

         reader = new BufferedReader(new FileReader(logFile));
         String lineStr = null;

         while((lineStr = reader.readLine()) != null) {
            stringBuffer.append(lineStr);
            stringBuffer.append("\n");
         }

         reader.close();
      } catch (Exception e) {
         this.logger.error(e.getMessage(), e);
         throw new RuntimeException(e);
      } finally {
         if (reader != null) {
            try {
               reader.close();
            } catch (IOException e) {
               this.logger.error(e.getMessage(), e);
               throw new RuntimeException(e);
            }
         }

      }

      return stringBuffer.toString();
   }

   public void updateFlag(String projectId, String dataSystemId, String schema, String tableName, String columnName, String flag) {
      TCoreEncryptionTypeField tCoreEncryptionTypeField = (TCoreEncryptionTypeField)this.tCoreEncryptionTypeFieldDao.queryUnique(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("datasystem_id", dataSystemId), Restrictions.eq("tschemas", schema), Restrictions.eq("names", tableName), Restrictions.eq("table_field_id", columnName)});
      tCoreEncryptionTypeField.setFlag(flag);
      this.tCoreEncryptionTypeFieldDao.update(tCoreEncryptionTypeField);
   }
}
