package com.chenyang.nse.bussiness.service.core.mappletxml;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.core.mappletxml.TCoreRulEKeyStrInfoDAO;
import com.chenyang.nse.bussiness.dao.table.core.mappletxml.TCoreRuleMappletInfoDAO;
import com.chenyang.nse.bussiness.dao.table.core.mappletxml.TCoreRulePortDAO;
import com.chenyang.nse.bussiness.dao.table.core.mappletxml.TCoreRuleRandomNumInfoDAO;
import com.chenyang.nse.bussiness.dao.table.core.mappletxml.TCoreRuleRandomStrInfoDAO;
import com.chenyang.nse.bussiness.dao.table.core.mappletxml.TCoreRuleSubstitutionInfoDAO;
import com.chenyang.nse.bussiness.dao.table.core.mappletxml.TCoreRuleTransformationInfoDAO;
import com.chenyang.nse.bussiness.entity.orm.table.core.mappletxml.TCoreRulEKeyStrInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.mappletxml.TCoreRuleMappletInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.mappletxml.TCoreRulePort;
import com.chenyang.nse.bussiness.entity.orm.table.core.mappletxml.TCoreRuleRandomNumInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.mappletxml.TCoreRuleRandomStrInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.mappletxml.TCoreRuleSubstitutionInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.mappletxml.TCoreRuleTransformationInfo;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.entity.vo.mappletxml.MappletxmlVO;
import com.chenyang.nse.bussiness.entity.vo.mappletxml.TCoreRulePortVO;
import com.chenyang.nse.bussiness.entity.vo.mappletxml.TCoreRuleTransformationInfoVO;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MappletxmlDetailsServiceImpl implements MappletxmlDetailsService {
   @Autowired
   private TCoreRuleMappletInfoDAO tCoreRuleMappletInfoDAO;
   @Autowired
   private TCoreRuleTransformationInfoDAO tCoreRuleTransformationInfoDAO;
   @Autowired
   private TCoreRuleSubstitutionInfoDAO tCoreRuleSubstitutionInfoDAO;
   @Autowired
   private TCoreRuleRandomStrInfoDAO tCoreRuleRandomStrInfoDAO;
   @Autowired
   private TCoreRulEKeyStrInfoDAO tCoreRulEKeyStrInfoDAO;
   @Autowired
   private TCoreRuleRandomNumInfoDAO tCoreRuleRandomNumInfoDAO;
   @Autowired
   private TCoreRulePortDAO tCoreRulePortDAO;

   public DataGridVO<TCoreRuleMappletInfo> selectMappletxmlDetails(PageInfo pageinfo) {
      List<TCoreRuleMappletInfo> list = this.tCoreRuleMappletInfoDAO.queryByPageInfo(pageinfo, Order.desc("creationtime"));
      return new DataGridVO<TCoreRuleMappletInfo>(pageinfo.getCount(), list);
   }

   public String deleteMappletxmlDetails(String mappletxmldetailsid) {
      this.tCoreRuleMappletInfoDAO.removeById(mappletxmldetailsid);

      for(TCoreRuleTransformationInfo tCoreRuleTransformationInfo : this.tCoreRuleTransformationInfoDAO.queryAll(new Criterion[]{Restrictions.eq("mappletinfoid", mappletxmldetailsid)})) {
         String id = tCoreRuleTransformationInfo.getId();

         for(TCoreRulePort tCoreRulePort : this.tCoreRulePortDAO.queryAll(new Criterion[]{Restrictions.eq("transformationinfoid", id)})) {
            String tCoreRulePortid = tCoreRulePort.getId();
            this.tCoreRuleSubstitutionInfoDAO.remove(new Criterion[]{Restrictions.eq("portid", tCoreRulePortid)});
            this.tCoreRuleRandomStrInfoDAO.remove(new Criterion[]{Restrictions.eq("portid", tCoreRulePortid)});
            this.tCoreRulEKeyStrInfoDAO.remove(new Criterion[]{Restrictions.eq("portid", tCoreRulePortid)});
         }

         this.tCoreRulePortDAO.remove(new Criterion[]{Restrictions.eq("transformationinfoid", id)});
      }

      this.tCoreRuleTransformationInfoDAO.remove(new Criterion[]{Restrictions.eq("mappletinfoid", mappletxmldetailsid)});
      return "1";
   }

   public MappletxmlVO updataMappletxmlDetails(String mappletxmldetailsid) {
      MappletxmlVO mappletxmlVO = new MappletxmlVO();
      List<TCoreRuleTransformationInfoVO> transformationInfoList = new ArrayList();
      TCoreRuleMappletInfo tCoreRuleMappletInfo = (TCoreRuleMappletInfo)this.tCoreRuleMappletInfoDAO.get(mappletxmldetailsid);

      for(TCoreRuleTransformationInfo tCoreRuleTransformationInfo : this.tCoreRuleTransformationInfoDAO.queryAll(new Criterion[]{Restrictions.eq("mappletinfoid", mappletxmldetailsid)})) {
         TCoreRuleTransformationInfoVO TCoreRuleTransformationInfoVO = new TCoreRuleTransformationInfoVO();
         List<TCoreRulePortVO> portListVO = new ArrayList();
         String tCoreRuleTransformationInfoid = tCoreRuleTransformationInfo.getId();

         for(TCoreRulePort tCoreRulePort : this.tCoreRulePortDAO.queryAll(new Criterion[]{Restrictions.eq("transformationinfoid", tCoreRuleTransformationInfoid)})) {
            TCoreRulePortVO tCoreRulePortVO = new TCoreRulePortVO();
            String tCoreRulePortid = tCoreRulePort.getId();
            tCoreRulePortVO.settCoreRulePort(tCoreRulePort);
            if ("randomstr".equals(tCoreRulePort.getMaskingOption())) {
               List<TCoreRuleRandomStrInfo> tCoreRuleRandomStrInfolist = this.tCoreRuleRandomStrInfoDAO.queryAll(new Criterion[]{Restrictions.eq("portid", tCoreRulePortid)});
               tCoreRulePortVO.settCoreRuleRandomStrInfo((TCoreRuleRandomStrInfo)tCoreRuleRandomStrInfolist.get(0));
            }

            if ("keystr".equals(tCoreRulePort.getMaskingOption())) {
               List<TCoreRulEKeyStrInfo> tCoreRulEKeyStrInfolist = this.tCoreRulEKeyStrInfoDAO.queryAll(new Criterion[]{Restrictions.eq("portid", tCoreRulePortid)});
               tCoreRulePortVO.settCoreRulEKeyStrInfo((TCoreRulEKeyStrInfo)tCoreRulEKeyStrInfolist.get(0));
            }

            if ("keynum".equals(tCoreRulePort.getMaskingOption())) {
               List<TCoreRulEKeyStrInfo> tCoreRulEKeyStrInfolist = this.tCoreRulEKeyStrInfoDAO.queryAll(new Criterion[]{Restrictions.eq("portid", tCoreRulePortid)});
               tCoreRulePortVO.settCoreRulEKeyStrInfo((TCoreRulEKeyStrInfo)tCoreRulEKeyStrInfolist.get(0));
            }

            if ("substitution".equals(tCoreRulePort.getMaskingOption())) {
               List<TCoreRuleSubstitutionInfo> TCoreRuleSubstitutionInfolist = this.tCoreRuleSubstitutionInfoDAO.queryAll(new Criterion[]{Restrictions.eq("portid", tCoreRulePortid)});
               tCoreRulePortVO.settCoreRuleSubstitutionInfo((TCoreRuleSubstitutionInfo)TCoreRuleSubstitutionInfolist.get(0));
            }

            if ("randomnum".equals(tCoreRulePort.getMaskingOption())) {
               List<TCoreRuleRandomNumInfo> TCoreRuleRandomNumInfolist = this.tCoreRuleRandomNumInfoDAO.queryAll(new Criterion[]{Restrictions.eq("portid", tCoreRulePortid)});
               tCoreRulePortVO.settCoreRuleRandomNumInfo((TCoreRuleRandomNumInfo)TCoreRuleRandomNumInfolist.get(0));
            }

            if ("randomdate".equals(tCoreRulePort.getMaskingOption())) {
               List<TCoreRuleRandomNumInfo> TCoreRuleRandomNumInfolist = this.tCoreRuleRandomNumInfoDAO.queryAll(new Criterion[]{Restrictions.eq("portid", tCoreRulePortid)});
               tCoreRulePortVO.settCoreRuleRandomNumInfo((TCoreRuleRandomNumInfo)TCoreRuleRandomNumInfolist.get(0));
            }

            portListVO.add(tCoreRulePortVO);
         }

         TCoreRuleTransformationInfoVO.settCoreRuleTransformationInfo(tCoreRuleTransformationInfo);
         TCoreRuleTransformationInfoVO.setPortListVO(portListVO);
         transformationInfoList.add(TCoreRuleTransformationInfoVO);
      }

      mappletxmlVO.settCoreRuleMappletInfo(tCoreRuleMappletInfo);
      mappletxmlVO.setTransformationInfoList(transformationInfoList);
      return mappletxmlVO;
   }

   public List<TCoreRuleMappletInfo> selectMappletxmlList() {
      List<TCoreRuleMappletInfo> list = this.tCoreRuleMappletInfoDAO.queryAll();
      return list;
   }

   public List<TCoreRuleMappletInfo> selectMapplet(String mappletname, String id) {
      List<TCoreRuleMappletInfo> list = null;
      if (id != null && !"".equals(id)) {
         list = this.tCoreRuleMappletInfoDAO.queryAll(new Criterion[]{Restrictions.eq("mappletenglishname", mappletname), Restrictions.ne("id", id)});
         return list;
      } else {
         list = this.tCoreRuleMappletInfoDAO.queryAll(new Criterion[]{Restrictions.eq("mappletenglishname", mappletname)});
         return list;
      }
   }
}
