package com.chenyang.nse.bussiness.service.core.subset;

import com.chenyang.nse.bussiness.dao.table.core.subset.TCoreSubsetFieldDao;
import com.chenyang.nse.bussiness.dao.table.core.subset.TCoreSubsetInfoDao;
import com.chenyang.nse.bussiness.dao.table.core.subset.TCoreSubsetRelationDao;
import com.chenyang.nse.bussiness.dao.table.core.subset.TCoreSubsetTableDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.subset.TCoreSubsetInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.subset.TCoreSubsetTable;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class NewSubsetServiceImpl implements NewsubsetService {
   @Autowired
   private TCoreSubsetFieldDao tCoreSubsetFieldDao;
   @Autowired
   private TCoreSubsetInfoDao tCoreSubsetInfoDao;
   @Autowired
   private TCoreSubsetRelationDao tCoreSubsetRelationDao;
   @Autowired
   private TCoreSubsetTableDao tCoreSubsetTableDao;

   public void savaTable(Map<String, String> map) {
      String tablename = (String)map.get("selectTablename");
      String schema = (String)map.get("schema");
      String systemID = (String)map.get("systemID");
      String systemType = (String)map.get("systemType");
      String taskname = (String)map.get("taskname");
      String[] TablenameArray = tablename.split(",");
      TCoreSubsetInfo tCoreSubsetInfo = new TCoreSubsetInfo();
      tCoreSubsetInfo.setCreatetime(new Date());
      tCoreSubsetInfo.setSubname(taskname);
      this.tCoreSubsetInfoDao.save(tCoreSubsetInfo);

      for(int i = 0; i < TablenameArray.length; ++i) {
         TCoreSubsetTable tCoreSubsetTable = new TCoreSubsetTable();
         tCoreSubsetTable.setTablename(TablenameArray[i]);
         tCoreSubsetTable.setSystemID(systemID);
         tCoreSubsetTable.setSchemaName(schema);
         tCoreSubsetTable.setSubsetid(tCoreSubsetInfo.getId());
         this.tCoreSubsetTableDao.save(tCoreSubsetTable);
      }

   }

   public List<ComboboxVO> getSubsetName() {
      List<ComboboxVO> subsetName = this.tCoreSubsetInfoDao.getSubsetName();
      return subsetName;
   }

   public List<ComboboxVO> getTableNames(String subsetnameid) {
      List<ComboboxVO> tableNames = this.tCoreSubsetTableDao.getTableNames(subsetnameid);
      return tableNames;
   }
}
