package com.chenyang.nse.bussiness.service.engine.impl;

import com.chenyang.nse.bussiness.dao.core.EngineDao;
import com.chenyang.nse.bussiness.dao.table.console.engine.TConsoleEngineTypeDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreEngineDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingTaskDao;
import com.chenyang.nse.bussiness.entity.orm.table.console.engine.TConsoleEngineType;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngine;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTask;
import com.chenyang.nse.bussiness.enumeration.EengineType;
import com.chenyang.nse.bussiness.service.engine.EngineOperateService;
import com.chenyang.nse.bussiness.service.engine.product.EngineProductService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class EngineOperateServiceImpl implements EngineOperateService {
   @Autowired
   private TCoreMaskingTaskDao tCoreMaskingTaskDao;
   @Autowired
   private TCoreEngineDao tCoreEngineDao;
   @Autowired
   private EngineDao engineDao;
   @Autowired
   private TConsoleEngineTypeDao tConsoleEngineTypeDao;
   @Autowired
   @Qualifier("infoProductService")
   private EngineProductService infoProductService;
   @Autowired
   @Qualifier("kettleProductService")
   private EngineProductService kettleProductService;

   public void executeTask(String taskid) {
      TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingTaskDao.get(taskid);
      String engineId = task.getEngineid();
      TCoreEngine engine = (TCoreEngine)this.tCoreEngineDao.get(engineId);
      String engineTypeId = engine.getEnginetypeid();
      TConsoleEngineType engineType = (TConsoleEngineType)this.tConsoleEngineTypeDao.get(engineTypeId);
      String enginetype = engineType.getEnginetype();
      if (enginetype.equals(EengineType.POWERCENTER961.getType())) {
         this.infoProductService.executeTask(taskid);
      }

      if (enginetype.equals(EengineType.KETTLE7.getType())) {
         this.kettleProductService.executeTask(taskid);
      }

   }

   public void executeTask(String taskid, String userid) {
   }

   public void saveTask(String taskid) {
      TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingTaskDao.get(taskid);
      String engineId = task.getEngineid();
      TCoreEngine engine = (TCoreEngine)this.tCoreEngineDao.get(engineId);
      String engineTypeId = engine.getEnginetypeid();
      TConsoleEngineType engineType = (TConsoleEngineType)this.tConsoleEngineTypeDao.get(engineTypeId);
      String enginetype = engineType.getEnginetype();
      if (enginetype.equals(EengineType.POWERCENTER961.getType())) {
         this.infoProductService.saveTask(taskid);
      }

      if (enginetype.equals(EengineType.KETTLE7.getType())) {
         this.kettleProductService.saveTask(taskid);
      }

   }
}
