package com.chenyang.nse.bussiness.service.engine.product;

import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingFileDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingFilecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingFilesystemDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingTableDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingTablecolumnDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTable;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTablecolumn;
import com.chenyang.nse.bussiness.enumeration.EmaskingDirection;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EngineProductCommonUtil {
   @Autowired
   private TCoreMaskingTableDao tCoreMaskingTableDao;
   @Autowired
   private TCoreMaskingTablecolumnDao tCoreMaskingTablecolumnDao;
   @Autowired
   private TCoreMaskingFilesystemDao tCoreMaskingFilesystemDao;
   @Autowired
   private TCoreMaskingFileDao tCoreMaskingFileDao;
   @Autowired
   private TCoreMaskingFilecolumnDao tCoreMaskingFilecolumnDao;

   public List<TCoreMaskingTable> queryTable(String taskid) {
      List<TCoreMaskingTable> list = this.tCoreMaskingTableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid)});
      return list;
   }

   public List<TCoreMaskingTable> queryTableSource(String taskid) {
      List<TCoreMaskingTable> list = this.tCoreMaskingTableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("datadirection", EmaskingDirection.DATA_SOURCE.getFlag())});
      return list;
   }

   public List<TCoreMaskingTable> queryTableTarget(String taskid) {
      List<TCoreMaskingTable> list = this.tCoreMaskingTableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("datadirection", EmaskingDirection.DATA_TARGET.getFlag())});
      return list;
   }

   public TCoreMaskingTable queryTableTarget(String taskid, String mappingkey) {
      TCoreMaskingTable table = (TCoreMaskingTable)this.tCoreMaskingTableDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("datadirection", EmaskingDirection.DATA_TARGET.getFlag()), Restrictions.eq("mappingkey", mappingkey)});
      return table;
   }

   public List<TCoreMaskingTablecolumn> queryTableColumnSource(String taskid, String tableid) {
      List<TCoreMaskingTablecolumn> list = this.tCoreMaskingTablecolumnDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("tableid", tableid), Restrictions.eq("datadirection", EmaskingDirection.DATA_SOURCE.getFlag())});
      return list;
   }

   public List<TCoreMaskingTablecolumn> queryTableColumnTarget(String taskid, String tableid) {
      List<TCoreMaskingTablecolumn> list = this.tCoreMaskingTablecolumnDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("tableid", tableid), Restrictions.eq("datadirection", EmaskingDirection.DATA_TARGET.getFlag())});
      return list;
   }

   public TCoreMaskingTablecolumn queryTableColumnTarget(String taskid, String tableid, String mappingkey) {
      TCoreMaskingTablecolumn column = (TCoreMaskingTablecolumn)this.tCoreMaskingTablecolumnDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("tableid", tableid), Restrictions.eq("datadirection", EmaskingDirection.DATA_TARGET.getFlag()), Restrictions.eq("mappingkey", mappingkey)});
      return column;
   }
}
