package com.chenyang.nse.bussiness.service.info.db;

import com.power.xml.entity.ColumnInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class INFORMIX extends CommonMethod implements DatabaseTool {
   public static final String[][] exporttype = new String[][]{{"normal", "正常导出", "selected"}};
   public static final String[][] importtype = new String[][]{{"normal", "正常导入", "selected"}};

   public String ImportMethod() {
      StringBuffer targetradio = new StringBuffer();
      targetradio.append("<select name='execution_type' >");

      for(String[] radio : importtype) {
         targetradio.append(MessageFormat.format(this.sourceradio(), "'" + radio[0] + "'", radio[1], radio[2]));
      }

      targetradio.append("</select>");
      return targetradio.toString();
   }

   public String ExportMethod() {
      StringBuffer sourceradio = new StringBuffer();
      sourceradio.append("<select name='execution_type' >");

      for(String[] radio : exporttype) {
         sourceradio.append(MessageFormat.format(this.sourceradio(), "'" + radio[0] + "'", radio[1], radio[2]));
      }

      sourceradio.append("</select>");
      return sourceradio.toString();
   }

   public Map TargetParameter_normal() {
      Map<String, String> map = this.TargetParameter_fnormal();
      map.put("targetParameter", this.isrebuild() + this.isindex() + this.isprimary() + this.istrigger() + this.isfunction());
      return map;
   }

   public Map TargetParameter_normal1() {
      Map<String, String> map = this.TargetParameter_fnormal();
      map.put("targetParameter", this.isrebuild() + this.isindex() + this.isprimary() + this.istrigger() + this.isfunction() + this.isassignspace());
      return map;
   }

   public Map TargetParameter_notNormal() {
      Map<String, String> map = this.TargetParameter_fnotnormal();
      return map;
   }

   public List<StringBuffer> SynTriggersParam(Connection s_conn, Map map) {
      List<StringBuffer> listTriggers = new ArrayList();
      String targetSchemaName = (String)map.get("targetbydefine");
      String sourceSchemaName = (String)map.get("sourceSchemaName");
      PreparedStatement ps = null;
      ResultSet rs = null;
      String sql = " select systriggers.trigid,systrigbody.data from systriggers,systrigbody where datakey ='D' and systriggers.owner = '" + sourceSchemaName + "' and systriggers.trigid = systrigbody.trigid order by systrigbody.trigid,systrigbody.seqno";
      HashMap<String, String> hashmap = new HashMap();

      try {
         ps = s_conn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            String text = hashmap.get(rs.getString("trigid")) == null ? "" : (String)hashmap.get(rs.getString("trigid"));
            hashmap.put(rs.getString("trigid"), text + rs.getString("data"));
         }

         Iterator iter = hashmap.entrySet().iterator();

         while(iter.hasNext()) {
            StringBuffer sb = new StringBuffer();
            Map.Entry entry = (Map.Entry)iter.next();
            String sql_val = (String)entry.getValue();
            sb.append(sql_val.replaceAll(sourceSchemaName, targetSchemaName));
            listTriggers.add(sb);
            System.out.println(sb.toString());
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return listTriggers;
   }

   public List<StringBuffer> SynFunctionParam(Connection s_conn, Map map) {
      List<StringBuffer> listProcedure = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;
      String targetSchemaName = (String)map.get("targetbydefine");
      String sourceSchemaName = (String)map.get("sourceSchemaName");
      String sql = "select sysprocedures.procid,sysprocbody.seqno,data from sysprocedures, sysprocbody where datakey ='T' and sysprocedures.owner = '" + sourceSchemaName + "' and sysprocedures.procid = sysprocbody.procid order by sysprocbody.procid,sysprocbody.seqno";
      HashMap<String, String> hashmap = new HashMap();

      try {
         ps = s_conn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            String text = hashmap.get(rs.getString("procid")) == null ? "" : (String)hashmap.get(rs.getString("procid"));
            hashmap.put(rs.getString("procid"), text + rs.getString("data"));
         }

         Iterator iter = hashmap.entrySet().iterator();

         while(iter.hasNext()) {
            StringBuffer sb = new StringBuffer();
            Map.Entry entry = (Map.Entry)iter.next();
            String sql_val = (String)entry.getValue();
            sb.append(sql_val.replaceAll(sourceSchemaName, targetSchemaName));
            listProcedure.add(sb);
            System.out.println(sb.toString());
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return listProcedure;
   }

   public List<StringBuffer> SynProcedureParam(Connection s_conn, Map map) {
      return null;
   }

   public ColumnInfo getPwc_columnInfo_target(Map map) {
      ColumnInfo columnInfo = this.getPwc_columnInfo_target_all_base(map);
      return columnInfo;
   }

   public ColumnInfo getPwc_columnInfo_source(Map map) {
      ColumnInfo columnInfo = this.getPwc_columnInfo_source_all_base(map);
      return columnInfo;
   }

   public List<StringBuffer> SynViewParam(Connection srcconn, Map map) {
      return null;
   }

   public String SynConstraintParam(Connection srcconn, Map map) {
      return null;
   }

   public String SynPartition(Connection s_conn, Map map) {
      return null;
   }

   public Map TargetParameter_normalEM() {
      return null;
   }
}
