package com.chenyang.nse.bussiness.service.info.db;

import com.power.xml.entity.ColumnInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OCEANBASE extends CommonMethod implements DatabaseTool {
   public static final String[][] exporttype = new String[][]{{"normal", "正常导出", "selected"}};
   public static final String[][] importtype = new String[][]{{"normal", "正常导入", "selected"}};

   public String ImportMethod() {
      StringBuffer targetradio = new StringBuffer();
      targetradio.append("<select name='execution_type' >");

      for(String[] radio : importtype) {
         targetradio.append(MessageFormat.format(this.sourceradio(), "'" + radio[0] + "'", radio[1], radio[2]));
      }

      targetradio.append("</select>");
      return targetradio.toString();
   }

   public String ExportMethod() {
      StringBuffer sourceradio = new StringBuffer();
      sourceradio.append("<select name='execution_type' >");

      for(String[] radio : exporttype) {
         sourceradio.append(MessageFormat.format(this.sourceradio(), "'" + radio[0] + "'", radio[1], radio[2]));
      }

      sourceradio.append("</select>");
      return sourceradio.toString();
   }

   public Map TargetParameter_normal() {
      Map<String, String> map = this.TargetParameter_fnormal();
      map.put("targetParameter", this.isrebuild() + this.isindex() + this.isprimary() + this.isfunction() + this.isview());
      return map;
   }

   public Map TargetParameter_normalEM() {
      Map<String, String> map = this.TargetParameter_fnormal();
      map.put("targetParameter", this.isrebuild());
      return map;
   }

   public Map TargetParameter_normal1() {
      Map<String, String> map = this.TargetParameter_fnormal();
      map.put("targetParameter", this.isrebuild() + this.isindex() + this.isprimary() + this.isfunction() + this.isview());
      return map;
   }

   public Map TargetParameter_notNormal() {
      Map<String, String> map = this.TargetParameter_fnotnormal();
      return map;
   }

   public List<StringBuffer> SynTriggersParam(Connection s_conn, Map map) {
      List<StringBuffer> listTriggers = new ArrayList();
      String targetSchemaName = (String)map.get("targetSchemaName");
      String sourceSchemaName = (String)map.get("sourceSchema");
      String tableName = (String)map.get("tableName");
      PreparedStatement ps = null;
      ResultSet rs = null;
      ResultSet rss = null;
      String sql = "select TRIGGER_NAME from all_triggers where table_name='" + tableName + "' AND owner = '" + sourceSchemaName + "'";

      try {
         ps = s_conn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            String trigname = rs.getString(1);
            String sql1 = "SELECT dbms_metadata.get_ddl('TRIGGER', '" + trigname + "','" + sourceSchemaName + "') AS SQLTEXT FROM DUAL";
            ps = s_conn.prepareStatement(sql1);
            rss = ps.executeQuery();

            while(rss.next()) {
               StringBuffer sb = new StringBuffer();
               String csql = rss.getString(1).toUpperCase().substring(0, rss.getString(1).toUpperCase().indexOf("END;") + 4).replaceAll(sourceSchemaName, targetSchemaName);
               sb.append(csql);
               listTriggers.add(sb);
            }
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return listTriggers;
   }

   public List<StringBuffer> SynFunctionParam(Connection s_conn, Map map) {
      List<StringBuffer> listFunction = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;
      ResultSet rss = null;
      String targetSchemaName = (String)map.get("targetSchemaName");
      String sourceSchemaName = (String)map.get("sourceSchema");
      String sql = "select DISTINCT name from all_source where OWNER='" + sourceSchemaName + "' AND TYPE='FUNCTION'";

      try {
         ps = s_conn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            String sql1 = "SELECT dbms_metadata.get_ddl('FUNCTION', '" + rs.getString("NAME") + "','" + sourceSchemaName + "') AS SQLTEXT FROM DUAL";
            ps = s_conn.prepareStatement(sql1);
            rss = ps.executeQuery();

            while(rss.next()) {
               StringBuffer sb = new StringBuffer();
               sb.append(rss.getString(1).replaceAll(sourceSchemaName, targetSchemaName));
               listFunction.add(sb);
               System.out.println(sb.toString());
            }
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return listFunction;
   }

   public List<StringBuffer> SynProcedureParam(Connection s_conn, Map map) {
      List<StringBuffer> listProcedure = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;
      ResultSet rss = null;
      String targetSchemaName = (String)map.get("targetSchemaName");
      String sourceSchemaName = (String)map.get("sourceSchema");
      String sql = "select DISTINCT name from all_source where OWNER='" + sourceSchemaName + "' AND TYPE='PROCEDURE'";

      try {
         ps = s_conn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            StringBuffer sb = new StringBuffer();
            String sql1 = "SELECT dbms_metadata.get_ddl('PROCEDURE', '" + rs.getString("NAME") + "','" + sourceSchemaName + "') AS SQLTEXT FROM DUAL";
            ps = s_conn.prepareStatement(sql1);
            rss = ps.executeQuery();

            while(rss.next()) {
               sb.append(rss.getString(1).replaceAll(sourceSchemaName, targetSchemaName));
               listProcedure.add(sb);
               System.out.println(sb.toString());
            }
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return listProcedure;
   }

   public ColumnInfo getPwc_columnInfo_target(Map map) {
      ColumnInfo columnInfo = this.getPwc_columnInfo_target_all_base(map);
      return columnInfo;
   }

   public ColumnInfo getPwc_columnInfo_source(Map map) {
      ColumnInfo columnInfo = this.getPwc_columnInfo_source_all_base(map);
      return columnInfo;
   }

   public List<StringBuffer> SynViewParam(Connection s_conn, Map map) {
      System.out.println("视图");
      List<StringBuffer> listProcedure = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;
      ResultSet rss = null;
      String targetSchemaName = (String)map.get("targetSchemaName");
      String sourceSchemaName = (String)map.get("sourceSchema");
      String sql1 = "SELECT view_name FROM dba_views u where owner='" + sourceSchemaName + "'";
      String sql = "";

      try {
         ps = s_conn.prepareStatement(sql1);
         rs = ps.executeQuery();

         while(rs.next()) {
            String vname = rs.getString("VIEW_NAME");
            sql = "SELECT dbms_metadata.get_ddl('VIEW', '" + vname + "','" + sourceSchemaName + "') AS SQLTEXT FROM DUAL";
            ps = s_conn.prepareStatement(sql);
            rss = ps.executeQuery();

            while(rss.next()) {
               StringBuffer sb = new StringBuffer();
               String sql2 = rss.getString(1).replaceAll(sourceSchemaName, targetSchemaName);
               sb.append(sql2);
               listProcedure.add(sb);
            }
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return listProcedure;
   }

   public String SynConstraintParam(Connection s_conn, Map map) {
      PreparedStatement ps = null;
      ResultSet rs = null;
      String sql = "SELECT DBMS_METADATA.GET_DDL('TABLE',u.table_name) SQL1 FROM USER_TABLES u  WHERE u.table_name='" + map.get("tableName") + "'";
      String sql1 = "";

      try {
         ps = s_conn.prepareStatement(sql);
         rs = ps.executeQuery();
         if (rs.next()) {
            new StringBuffer();
            sql = rs.getString("SQL1");
            if (sql.indexOf("PARTITION") != -1 && sql.substring(0, sql.indexOf(".")).equals(map.get("sourceSchemaName"))) {
               sql1 = sql.substring(0, sql.toUpperCase().indexOf("USING INDEX PCTFREE")) + ")";
            }
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return sql1;
   }

   public String SynPartition(Connection s_conn, Map map) {
      PreparedStatement ps = null;
      ResultSet rs = null;
      String sql = "SELECT dbms_metadata.get_ddl('TABLE', '" + map.get("tableName") + "','" + map.get("sourceSchemaName") + "') AS SQLTEXT FROM DUAL";

      try {
         ps = s_conn.prepareStatement(sql);
         rs = ps.executeQuery();
         if (rs.next()) {
            new StringBuffer();
            sql = rs.getString(1);
            if (sql.indexOf("PARTITION") == -1) {
               sql = "false";
            } else {
               sql = sql.substring(sql.indexOf("PARTITION"));
            }
         } else {
            sql = "false";
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return sql;
   }
}
