package com.chenyang.nse.bussiness.service.key.impl;


import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import com.chenyang.nse.bussiness.ccore.CcoreSDF;
import org.apache.commons.lang3.StringUtils;

public class CcoreSdfParam {
   static long ret = 0L;
   static long[] phDeviceHandle = new long[1];
   static long[] phSessionHandle = new long[1];

   public static Map<String, String> createParam(String pucPassword) {
      HashMap<String, String> map = new HashMap(16);
      System.out.println("\n///////// OpenDevice /////////");
      ret = CcoreSDF.OpenDevice(phDeviceHandle);
      if (ret != 0L) {
         System.out.printf("OpenDevice error ret = 0x%08x ", ret);
         return null;
      } else {
         System.out.println("OpenDevice phDeviceHandle = " + phDeviceHandle[0]);
         System.out.println("\n///////// OpenSession /////////");
         ret = CcoreSDF.OpenSession(phDeviceHandle[0], phSessionHandle);
         if (ret != 0L) {
            System.out.printf("OpenSession error ret = 0x%08x ", ret);
            return null;
         } else {
            System.out.println("OpenSession phSessionHandle = " + phSessionHandle[0]);
            System.out.println("\n///////// GenerateRandom /////////");
            byte[] pucRandom = new byte[16];
            System.out.println("开始生成第1次秘钥明文：");
            ret = CcoreSDF.GenerateRandom(phSessionHandle[0], 16L, pucRandom);
            if (ret != 0L) {
               System.out.printf("GenerateRandom error ret = 0x%08x ", ret);
               return null;
            } else {
               System.out.println("pucRandom:");

               for(byte b : pucRandom) {
                  System.out.printf("%02x ", b);
               }

               System.out.printf("\n\n");
               System.out.println("第1次秘钥明文生成结束。\n\n");
               long[] phKeyHandle = new long[1];
               System.out.println("\n///////// GenerateKeyWithIPK_ECC /////////");
               CcoreSDF.ECCCipher pucKeyCPECC = new CcoreSDF.ECCCipher();
               pucKeyCPECC.C = new byte[128];
               ret = CcoreSDF.GenerateKeyWithIPK_ECC(phSessionHandle[0], 1L, 128L, pucKeyCPECC, phKeyHandle);
               if (ret != 0L) {
                  System.out.printf("GenerateKeyWithIPK_ECC error ret = 0x%08x ", ret);
                  return null;
               } else {
                  System.out.println(" GenerateKeyWithIPK_ECC pucKeyCPECC.x:");

                  for(byte b : pucKeyCPECC.x) {
                     System.out.printf("%02x ", b);
                  }

                  System.out.printf("\r\n");
                  String pucKeyCPECCX = Arrays.toString(pucKeyCPECC.x);
                  System.out.println(" 打印GenerateKeyWithIPK_ECC pucKeyCPECC.x:" + pucKeyCPECCX);
                  System.out.printf("\r\n");
                  System.out.println("\n GenerateKeyWithIPK_ECC pucKeyCPECC.y:");

                  for(byte b : pucKeyCPECC.y) {
                     System.out.printf("%02x ", b);
                  }

                  System.out.printf("\r\n");
                  String pucKeyCPECCY = Arrays.toString(pucKeyCPECC.y);
                  System.out.println(" 打印GenerateKeyWithIPK_ECC pucKeyCPECC.y:" + pucKeyCPECCY);
                  System.out.printf("\r\n");
                  System.out.println(" GenerateKeyWithIPK_ECC pucKeyCPECC.M:");

                  for(byte b : pucKeyCPECC.M) {
                     System.out.printf("%02x ", b);
                  }

                  System.out.printf("\r\n");
                  String pucKeyCPECCM = Arrays.toString(pucKeyCPECC.M);
                  System.out.println(" 打印GenerateKeyWithIPK_ECC pucKeyCPECC.m:" + pucKeyCPECCM);
                  System.out.printf("\r\n");
                  System.out.printf("\n GenerateKeyWithIPK_ECC pucKeyCPECC.L:%d\n", pucKeyCPECC.L);
                  System.out.printf("\r\n");
                  System.out.println("\n GenerateKeyWithIPK_ECC pucKeyCPECC.C:");

                  for(byte b : pucKeyCPECC.C) {
                     System.out.printf("%02x ", b);
                  }

                  System.out.printf("\r\n");
                  String pucKeyCPECCC = Arrays.toString(pucKeyCPECC.C);
                  System.out.println(" 打印GenerateKeyWithIPK_ECC pucKeyCPECC.C:" + pucKeyCPECCC);
                  System.out.println("\nGenerateKeyWithIPK_ECC phKeyHandle = " + phKeyHandle[0]);
                  ret = CcoreSDF.GetPrivateKeyAccessRight(phSessionHandle[0], 1L, StringUtils.isEmpty(pucPassword) ? "11111111" : pucPassword, 8L);
                  if (ret != 0L) {
                     System.out.printf("eeGetPrivateKeyAccessRight error ret = 0x%08x ", ret);
                     return null;
                  } else {
                     System.out.println("\n///////// ImportKeyWithISK_ECC /////////");
                     ret = CcoreSDF.ImportKeyWithISK_ECC(phSessionHandle[0], 1L, pucKeyCPECC, phKeyHandle);
                     if (ret != 0L) {
                        System.out.printf("ImportKeyWithISK_ECC error ret = 0x%08x ", ret);
                        return null;
                     } else {
                        System.out.println("\nImportKeyWithISK_ECC phKeyHandle = " + phKeyHandle[0]);
                        map.put("ecccipherbits", "0L");
                        map.put("ecccipherx", pucKeyCPECCX.replace("[", "").replace("]", ""));
                        map.put("eccciphery", pucKeyCPECCY.replace("[", "").replace("]", ""));
                        map.put("ecccipherm", pucKeyCPECCM.replace("[", "").replace("]", ""));
                        map.put("ecccipherc", pucKeyCPECCC.replace("[", "").replace("]", ""));
                        map.put("ecccipherl", String.valueOf(pucKeyCPECC.L));
                        CcoreSDF.CloseSession(phSessionHandle[0]);
                        return map;
                     }
                  }
               }
            }
         }
      }
   }

   public static boolean testCcoreSDF() {
      System.out.println("\n///////// OpenDevice /////////");
      ret = CcoreSDF.OpenDevice(phDeviceHandle);
      if (ret != 0L) {
         System.out.printf("OpenDevice error ret = 0x%08x ", ret);
         return false;
      } else {
         System.out.println("OpenDevice phDeviceHandle = " + phDeviceHandle[0]);
         System.out.println("\n///////// OpenSession /////////");
         ret = CcoreSDF.OpenSession(phDeviceHandle[0], phSessionHandle);
         if (ret != 0L) {
            System.out.printf("OpenSession error ret = 0x%08x ", ret);
            return false;
         } else {
            System.out.println("OpenSession phSessionHandle = " + phSessionHandle[0]);
            System.out.println("\n///////// GenerateRandom /////////");
            byte[] pucRandom = new byte[16];
            System.out.println("开始生成第1次秘钥明文：");
            ret = CcoreSDF.GenerateRandom(phSessionHandle[0], 16L, pucRandom);
            if (ret != 0L) {
               System.out.printf("GenerateRandom error ret = 0x%08x ", ret);
               return false;
            } else {
               CcoreSDF.CloseSession(phSessionHandle[0]);
               return true;
            }
         }
      }
   }
}
