package com.chenyang.nse.bussiness.service.redis;

import java.util.HashMap;
import java.util.List;
import java.util.Set;

public interface RedisService {
   Object queryValue(String cacheName, String key);

   void delCacheValue(String key, String cacheName);

   boolean set(final String key, Object value);

   boolean set(final String key, Object value, Long expireTime);

   void remove(final String... keys);

   void removeLikePrefix(String keyLike);

   void removePattern(final String pattern);

   void remove(final String key);

   boolean exists(final String key);

   Object get(final String key);

   void hmSet(String key, Object hashKey, Object value);

   void hmDel(String key, Object hashKey);

   Object hmGet(String key, Object hashKey);

   Object hkeys(String key);

   void lPush(String k, Object v);

   List<Object> lRange(String k, long l, long l1);

   void add(String key, Object value);

   Set<Object> setMembers(String key);

   void zAdd(String key, Object value, double scoure);

   void zAdd(String key, Object value, double scoure, Long expireTime);

   Set<Object> rangeByScore(String key, double scoure, double scoure1);

   Set<Object> range(String key, int scoure, int scoure1);

   void zRem(String key, Object... member);

   Long zCard(String key);

   void pipeline(HashMap<String, Object> map, String key);
}
