package com.chenyang.nse.bussiness.service.webApi.business;

import com.chenyang.nse.bussiness.tools.dataprocess.ApplicationContextProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretKeyCache {
   private static final Logger LOGGER = LoggerFactory.getLogger(SecretKeyCache.class);
   private final long REFRESH_TIME_MS;
   private ReadWriteLock lock;
   private Map<String, String> keys;
   private Map<String, String> pkeys;
   private boolean initialized;
   private AtomicBoolean inprogress;
   private Thread refreshPtr;

   public static SecretKeyCache instance() {
      return SecretKeyCacheHolder.INSTANCE;
   }

   public String getKey(String id) {
      if (id != null && id.length() != 0) {
         String var2;
         try {
            this.lock.readLock().lock();
            var2 = (String)this.keys.get(id);
         } finally {
            this.lock.readLock().unlock();
         }

         return var2;
      } else {
         return null;
      }
   }

   public String getPKey(String project, String fieldId) {
      String id = project + ":" + fieldId;
      return this.getPKey(id);
   }

   public String getPKey(String id) {
      if (id != null && id.length() != 0) {
         String var2;
         try {
            this.lock.readLock().lock();
            var2 = (String)this.pkeys.get(id);
         } finally {
            this.lock.readLock().unlock();
         }

         return var2;
      } else {
         return null;
      }
   }

   private SecretKeyCache() {
      this.REFRESH_TIME_MS = 300000L;
      this.initialized = false;
      this.lock = new ReentrantReadWriteLock(true);
      this.keys = new HashMap();
      this.inprogress = new AtomicBoolean(false);
   }

   public void invalidate() {
      this.tick();
   }

   public void initialize() {
      if (!this.initialized) {
         this.tick();
         this.initialized = true;
      }
   }

   private void tick() {
      if (this.inprogress.compareAndSet(false, true)) {
         if (this.refreshPtr != null) {
            this.refreshPtr.interrupt();
            this.refreshPtr = null;
         }

         this.refreshPtr = new Thread(() -> {
            while(true) {
               try {
                  this.refresh();
                  Thread.sleep(300000L);
               } catch (Exception e) {
                  LOGGER.error(e.getMessage(), e);
                  e.printStackTrace();
               }
            }
         });
         this.refreshPtr.start();
         LOGGER.info("key cache over");
      }
   }

   synchronized void refresh() {
      try {
         this.inprogress.set(true);
         this.lock.writeLock().lock();
         KeyLoader.MulKey mulKey = this.loading();
         this.keys = mulKey.bKeys;
         this.pkeys = mulKey.pKeys;
      } finally {
         this.lock.writeLock().unlock();
         this.inprogress.compareAndSet(true, false);
      }

   }

   private KeyLoader.MulKey loading() {
      KeyLoader loader = (KeyLoader)ApplicationContextProvider.getBean(KeyLoader.class);
      KeyLoader.MulKey data = loader.load();
      if (data == null) {
         data = new KeyLoader.MulKey();
      }

      return data;
   }

   static class SecretKeyCacheHolder {
      public static final SecretKeyCache INSTANCE = new SecretKeyCache();
   }
}
