package com.chenyang.nse.bussiness.tools.dataprocess;

import ch.qos.logback.classic.Logger;
import com.ghca.fastjson.JSONObject;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncryptionTypeFieldDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreJiaMiJieMiJinDuDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.ColumnPrimaryKeyInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryptionTypeField;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreJiaMiJieMiJinDu;
import com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.service.core.encryption.TCoreEncryptionService;
import com.chenyang.nse.bussiness.service.core.encryption.impl.TCoreEncryptionContext;
import com.chenyang.nse.bussiness.tools.dataprocess.common.ColumnBatchInfo;
import com.chenyang.nse.bussiness.tools.dataprocess.common.CustomPolicy;
import com.chenyang.nse.bussiness.tools.dataprocess.common.RecordBatchInfo;
import com.chenyang.nse.bussiness.tools.encryption.EncProvider;
import com.chenyang.nse.bussiness.tools.encryption.EncUtils;
import com.chenyang.nse.bussiness.tools.encryption.SM4Util;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.logger.LoggerBuilder;
import com.chenyang.nse.bussiness.tools.number.IntegerTool;
import com.chenyang.nse.bussiness.tools.propertyutil.PropertyGhcaUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.jdbc.core.JdbcTemplate;

public class NewLoadingTask implements Runnable {
   private String copySuffix;
   private String encryptionlikeopen;
   private String encryptionlabel;
   private String projectId;
   private String dataSystemId;
   private TCoreDatasystem tCoreDatasystem;
   private String columnType;
   private String columnSize;
   private String schema;
   private String tableName;
   private List<ColumnInfoVO> columnInfoList;
   private List<com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO> allColumn;
   private String[] primaryKeys;
   List<ColumnPrimaryKeyInfo> columnPrimaryKeyInfoList;
   private Connection connection;
   private static String COLUMN_OUT_OF_RANGE = " 列加密后长度超出范围，请修改列长度";
   private static String CHECK_ALL_COLUMN_OUT_OF_RANGE = " 表加密后校验列合计长度超出数据库要求范围";
   private static String COLUMN_ALL_ENCRYPTED = "该列不存在明文数据，无需处理";
   private static String CHECK_COLUMN = "checkColumn";
   private boolean isReload;
   private JdbcTemplate jdbcTemplate;
   private List<com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO> allColumnList;
   private Properties props;
   private EncTaskStateContainer container;
   private Logger encryptionlogger;
   private TCoreJiaMiJieMiJinDuDao tCoreJiaMiJieMiJinDuDao;
   private TCoreEncryptionService tCoreEncryptionService;
   public static boolean ARGODB_FLAG;

   public NewLoadingTask(TCoreDatasystem tCoreDatasystem, String columnType, String columnSize) {
      this.tCoreDatasystem = tCoreDatasystem;
      this.connection = JdbcTool.getConnection(tCoreDatasystem);
      this.columnType = columnType;
      this.columnSize = columnSize;
   }

   public NewLoadingTask(String projectId, String dataSystemId, TCoreDatasystem tCoreDatasystem, String schema, String tableName, String[] primaryKeys, List<ColumnInfoVO> columnInfoList, List<com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO> allColumn, List<ColumnPrimaryKeyInfo> columnPrimaryKeyInfoList, List<com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO> allColumnList, boolean isReload) {
      this.copySuffix = PropertyGhcaUtil.copySuffix;
      this.encryptionlikeopen = PropertyGhcaUtil.encryptionlikeopen;
      this.encryptionlabel = PropertyGhcaUtil.encryptionlabel;
      this.projectId = projectId;
      this.dataSystemId = dataSystemId;
      this.tCoreDatasystem = tCoreDatasystem;
      this.schema = schema;
      this.tableName = tableName;
      this.columnInfoList = columnInfoList;
      this.allColumn = allColumn;
      this.primaryKeys = primaryKeys;
      this.columnPrimaryKeyInfoList = columnPrimaryKeyInfoList;
      this.allColumnList = allColumnList;
      this.connection = JdbcTool.getConnection(tCoreDatasystem);
      this.isReload = isReload;
      this.jdbcTemplate = (JdbcTemplate)ApplicationContextProvider.getBean(JdbcTemplate.class);

      try {
         this.props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String loggerPath = System.getProperty("user.dir") + File.separator + "encryprocesslog" + File.separator + projectId + File.separator + dataSystemId;
      this.encryptionlogger = (new LoggerBuilder()).getLogger(loggerPath, schema + "." + tableName);
      this.tCoreJiaMiJieMiJinDuDao = (TCoreJiaMiJieMiJinDuDao)ApplicationContextProvider.getBean(TCoreJiaMiJieMiJinDuDao.class);
      this.tCoreEncryptionService = (TCoreEncryptionService)ApplicationContextProvider.getBean(TCoreEncryptionContext.class);
      this.container = EncTaskTracker.instance().container();
      this.container.add(projectId, schema, tableName, columnInfoList);
      EncTaskTracker.instance().register(this.container);
   }

   public void run() {
      try {
         this.encryptionlogger.info("==========================>计时开始");
         this.runTask();
         this.encryptionlogger.info("==========================>计时结束");
      } finally {
         EncTaskTracker.instance().over(this.container.getTask());
      }

   }

   private void runTask() {
      Thread.currentThread().setName("pool-" + this.tableName + "-thread");
      this.encryptionlogger.info("启动执行JHQ2-MULTI线程！！");
      StringBuilder addColumnString = new StringBuilder();
      StringBuilder addColumnStrings = new StringBuilder();
      Set<String> columnMap = JdbcTool.getColumnMap(this.connection, this.schema, this.tableName);
      StringBuilder selectStrBuilder = new StringBuilder();
      StringBuilder updateStrBuilder = new StringBuilder();
      StringBuilder backupsStrBuilder = new StringBuilder();

      for(int i = 0; i < this.columnInfoList.size(); ++i) {
         String columnName = ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName();
         String columnType = ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnType();
         String columnSize = ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnSize();
         if (this.isReload && this.checkColumnAllEncrypted(columnName)) {
            return;
         }

         this.tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, columnName, "-1");
         String columNameCopy = columnName + this.copySuffix;
         EdbType edbType = EdbType.valueOf(this.tCoreDatasystem.getDbtype());
         switch (edbType) {
            case ORACLE:
            case POSTGRESQL:
            case GAUSS:
            case GREENPLUM:
            case DM:
            case KINGBASE:
            case DB2:
               columNameCopy = "\"" + columNameCopy + "\"";
            default:
               StringBuilder columnSizeBuilder = new StringBuilder();
               switch (columnType.toUpperCase()) {
                  case "VARCHAR2":
                  case "VARCHAR":
                  case "CHAR":
                  case "NVARCHAR":
                  case "VARCHARBYTE":
                  case "NCHAR":
                  case "BPCHAR":
                  case "NVARCHAR2":
                     columnSizeBuilder.append("(").append(((ColumnInfoVO)this.columnInfoList.get(i)).getRealitycolumnsize()).append(")");
               }

               String copyColumn = columnName + this.copySuffix;
               if (!this.isReload && !columnMap.contains(copyColumn) && !columnMap.contains(columNameCopy)) {
                  if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
                     addColumnStrings.append(columNameCopy).append(",");
                     addColumnString.append(" add ").append(columNameCopy).append(" ").append(columnType).append(columnSizeBuilder).append(" ");
                  } else if (!this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                     if (this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                        addColumnStrings.append(columNameCopy).append(",");
                        addColumnString.append(" add ").append(columNameCopy).append(" ").append(columnType).append(columnSizeBuilder).append(",");
                     } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                        addColumnStrings.append(columNameCopy).append(",");
                        if (i == 0) {
                           addColumnString.append(" add ");
                        }

                        addColumnString.append(columNameCopy).append(" ").append(columnType).append(columnSizeBuilder).append(",");
                     } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                        addColumnStrings.append(columNameCopy).append(",");
                        addColumnString.append(columNameCopy).append(" ").append(columnType).append(columnSizeBuilder).append(",");
                     } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                        addColumnStrings.append(columNameCopy).append(",");
                        addColumnString.append(columNameCopy).append(" ").append(columnType).append(columnSizeBuilder).append(",");
                     } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE.toString())) {
                        addColumnStrings.append(columNameCopy).append(",");
                        addColumnString.append(columNameCopy).append(" ").append(columnType).append(columnSizeBuilder).append(",");
                     } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                        addColumnStrings.append(columNameCopy).append(",");
                        addColumnString.append(columNameCopy).append(" ").append(columnType).append(columnSizeBuilder).append(",");
                     } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
                        addColumnStrings.append(columNameCopy).append(",");
                        addColumnString.append(" ADD COLUMN ").append(columNameCopy).append(" ").append(columnType).append(columnSizeBuilder).append(" ");
                     } else {
                        addColumnStrings.append(columNameCopy).append(",");
                        addColumnString.append(" add ").append(columNameCopy).append(" ").append(columnType).append(columnSizeBuilder).append(",");
                     }
                  } else {
                     addColumnStrings.append(columNameCopy).append(",");
                     addColumnString.append(" add ").append(columNameCopy).append(" ").append(columnType).append(columnSizeBuilder).append(",");
                  }
               }

               if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
                  selectStrBuilder.append("\"" + columnName + "\"").append(",");
                  updateStrBuilder.append("\"" + columnName + "\"").append("=?,");
                  if (columnType.equalsIgnoreCase("char")) {
                     backupsStrBuilder.append("\"" + columnName + this.copySuffix + "\"").append("= TRIM(").append("\"" + columnName + "\"),");
                  } else {
                     backupsStrBuilder.append("\"" + columnName + this.copySuffix + "\"").append("=").append("\"" + columnName + "\",");
                  }
               } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString())) {
                  selectStrBuilder.append("\"" + columnName + "\"").append(",");
                  updateStrBuilder.append("\"" + columnName + "\"").append("=?,");
                  backupsStrBuilder.append("\"" + columnName + this.copySuffix + "\"").append("=").append("\"" + columnName + "\",");
               } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                  selectStrBuilder.append("\"" + columnName + "\"").append(",");
                  updateStrBuilder.append("\"" + columnName + "\"").append("=?,");
                  backupsStrBuilder.append("\"" + columnName + this.copySuffix + "\"").append("=").append("\"" + columnName + "\",");
               } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                  selectStrBuilder.append("\"" + columnName + "\"").append(",");
                  updateStrBuilder.append("\"" + columnName + "\"").append("=?,");
                  backupsStrBuilder.append("\"" + columnName + this.copySuffix + "\"").append("=").append("\"" + columnName + "\",");
               } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                  selectStrBuilder.append(columnName).append(",");
                  updateStrBuilder.append(columnName).append("=?,");
                  backupsStrBuilder.append(columnName + this.copySuffix).append("=").append(columnName + ",");
               } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                  selectStrBuilder.append("\"" + columnName + "\"").append(",");
                  updateStrBuilder.append("\"" + columnName + "\"").append("=?,");
                  backupsStrBuilder.append("\"" + columnName + this.copySuffix + "\"").append("=").append("\"" + columnName + "\",");
               } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                  selectStrBuilder.append("\"" + columnName + "\"").append(",");
                  updateStrBuilder.append("\"" + columnName + "\"").append("=?,");
                  backupsStrBuilder.append("\"" + columnName + this.copySuffix + "\"").append("=").append("\"" + columnName + "\",");
               } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE.toString())) {
                  selectStrBuilder.append(columnName).append(",");
                  updateStrBuilder.append(columnName).append("=?,");
                  if (ARGODB_FLAG) {
                     backupsStrBuilder.append(columnName + this.copySuffix).append("=").append(columnName + ",");
                  } else {
                     backupsStrBuilder.append("\"" + columnName + this.copySuffix + "\"").append("=").append("\"" + columnName + "\",");
                  }
               } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                  selectStrBuilder.append(columnName).append(",");
                  updateStrBuilder.append(columnName).append("=?,");
                  if (ARGODB_FLAG) {
                     backupsStrBuilder.append(columnName + this.copySuffix).append("=").append(columnName + ",");
                  } else {
                     backupsStrBuilder.append("\"" + columnName + this.copySuffix + "\"").append("=").append("\"" + columnName + "\",");
                  }
               } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
                  selectStrBuilder.append("\"" + columnName + "\"").append(",");
                  updateStrBuilder.append(columnName).append("=?,");
                  backupsStrBuilder.append(columnName + this.copySuffix).append("=").append(columnName + ",");
               } else if (!this.tCoreDatasystem.getDbtype().equals(EdbType.MYSQL.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.OCEANBASE.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.MARIADB.toString())) {
                  selectStrBuilder.append(columnName).append(",");
                  updateStrBuilder.append(columnName).append("=?,");
                  backupsStrBuilder.append(columnName + this.copySuffix).append("=").append(columnName + ",");
               } else {
                  if (IntegerTool.isNumeric(columnName)) {
                     selectStrBuilder.append("`" + columnName + "`").append(",");
                  } else {
                     selectStrBuilder.append(columnName).append(",");
                  }

                  updateStrBuilder.append(columnName).append("=?,");
                  backupsStrBuilder.append(columnName + this.copySuffix).append("=").append(columnName + ",");
               }
         }
      }

      if (!"DB2".equals(this.tCoreDatasystem.getDbtype()) && addColumnString.length() > 0) {
         addColumnString = addColumnString.deleteCharAt(addColumnString.length() - 1);
      }

      if (!this.isReload) {
         try {
            if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
               this.addTableField(this.connection, "\"" + this.schema + "\"", "\"" + this.tableName + "\"", addColumnStrings, addColumnString, this.encryptionlogger, this.tCoreDatasystem);
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString())) {
               this.addTableField(this.connection, "\"" + this.schema + "\"", "\"" + this.tableName + "\"", addColumnStrings, addColumnString, this.encryptionlogger, this.tCoreDatasystem);
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
               this.addTableField(this.connection, "\"" + this.schema + "\"", "\"" + this.tableName + "\"", addColumnStrings, addColumnString, this.encryptionlogger, this.tCoreDatasystem);
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
               this.addTableField(this.connection, "\"" + this.schema + "\"", "\"" + this.tableName + "\"", addColumnStrings, addColumnString, this.encryptionlogger, this.tCoreDatasystem);
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
               this.addTableField(this.connection, this.schema, this.tableName, addColumnStrings, addColumnString, this.encryptionlogger, this.tCoreDatasystem);
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
               this.addTableField(this.connection, "\"" + this.schema + "\"", "\"" + this.tableName + "\"", addColumnStrings, addColumnString, this.encryptionlogger, this.tCoreDatasystem);
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
               this.addTableField(this.connection, "\"" + this.schema + "\"", "\"" + this.tableName + "\"", addColumnStrings, addColumnString, this.encryptionlogger, this.tCoreDatasystem);
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE.toString())) {
               this.addTableField(this.connection, this.schema, this.tableName, addColumnStrings, addColumnString, this.encryptionlogger, this.tCoreDatasystem);
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
               this.addTableField(this.connection, this.schema, this.tableName, addColumnStrings, addColumnString, this.encryptionlogger, this.tCoreDatasystem);
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
               this.addTableField(this.connection, this.schema, this.tableName, addColumnStrings, addColumnString, this.encryptionlogger, this.tCoreDatasystem);
            } else {
               this.addTableField(this.connection, this.schema, this.tableName, addColumnStrings, addColumnString, this.encryptionlogger, this.tCoreDatasystem);
            }
         } catch (SQLException e) {
            this.encryptionlogger.error("copy列添加失败：" + e.getMessage());

            for(int i = 0; i < this.columnInfoList.size(); ++i) {
               String columnName = ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName();
               this.tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, columnName, "4");
            }

            TCoreJiaMiJieMiJinDu tCoreJiaMiJieMiJinDu = new TCoreJiaMiJieMiJinDu();
            tCoreJiaMiJieMiJinDu.setProjectid(this.projectId);
            tCoreJiaMiJieMiJinDu.setDatasystemid(this.dataSystemId);
            tCoreJiaMiJieMiJinDu.setSchemahh(this.schema);
            tCoreJiaMiJieMiJinDu.setTablename(this.tableName);
            tCoreJiaMiJieMiJinDu.setFlag("4");
            this.tCoreJiaMiJieMiJinDuDao.save(tCoreJiaMiJieMiJinDu);
            return;
         }
      }

      try {
         EncryptProcessUtil.addAllColumnLength(this.connection, this.encryptionlogger, this.tCoreDatasystem, this.columnInfoList, this.schema, this.tableName, this.allColumnList);
      } catch (SQLException throwables) {
         this.encryptionlogger.error("扩展原列长度失败：" + throwables.getMessage());

         for(int i = 0; i < this.columnInfoList.size(); ++i) {
            String columnName = ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName();
            this.tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, columnName, "4");
         }

         TCoreJiaMiJieMiJinDu tCoreJiaMiJieMiJinDu = new TCoreJiaMiJieMiJinDu();
         tCoreJiaMiJieMiJinDu.setProjectid(this.projectId);
         tCoreJiaMiJieMiJinDu.setDatasystemid(this.dataSystemId);
         tCoreJiaMiJieMiJinDu.setSchemahh(this.schema);
         tCoreJiaMiJieMiJinDu.setTablename(this.tableName);
         tCoreJiaMiJieMiJinDu.setFlag("4");
         tCoreJiaMiJieMiJinDu.setState("扩展加密列失败");
         tCoreJiaMiJieMiJinDu.setStarttime(new Date());
         this.tCoreJiaMiJieMiJinDuDao.save(tCoreJiaMiJieMiJinDu);
         return;
      }

      TCoreJiaMiJieMiJinDu tCoreJiaMiJieMiJin1 = null;
      List<TCoreJiaMiJieMiJinDu> tCoreJiaMiJieMiJinList1 = this.tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinDu(this.dataSystemId, this.projectId, this.schema, this.tableName, "1");
      int cpp1 = tCoreJiaMiJieMiJinList1.size();
      if (cpp1 > 0) {
         for(int npp1 = 0; npp1 < cpp1; ++npp1) {
            tCoreJiaMiJieMiJin1 = (TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList1.get(npp1);
         }
      }

      if (null != tCoreJiaMiJieMiJin1) {
         this.tCoreJiaMiJieMiJinDuDao.remove(tCoreJiaMiJieMiJin1);
      }

      List<TCoreJiaMiJieMiJinDu> tCoreJiaList = this.tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinDu(this.dataSystemId, this.projectId, this.schema, this.tableName, "0");
      int cpppppp = tCoreJiaList.size();
      if (cpppppp == 0) {
         TCoreJiaMiJieMiJinDu tCoreJiaMiJieMiJinDu = new TCoreJiaMiJieMiJinDu();
         tCoreJiaMiJieMiJinDu.setProjectid(this.projectId);
         tCoreJiaMiJieMiJinDu.setDatasystemid(this.dataSystemId);
         tCoreJiaMiJieMiJinDu.setSchemahh(this.schema);
         tCoreJiaMiJieMiJinDu.setTablename(this.tableName);
         tCoreJiaMiJieMiJinDu.setFlag("0");
         this.tCoreJiaMiJieMiJinDuDao.save(tCoreJiaMiJieMiJinDu);
      }

      if (this.primaryKeys.length > 0) {
         for(int i = 0; i < this.primaryKeys.length; ++i) {
            if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
               selectStrBuilder.append("\"" + this.primaryKeys[i] + "\"").append(",");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString())) {
               selectStrBuilder.append("\"" + this.primaryKeys[i] + "\"").append(",");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
               selectStrBuilder.append("\"" + this.primaryKeys[i] + "\"").append(",");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
               selectStrBuilder.append("\"" + this.primaryKeys[i] + "\"").append(",");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
               selectStrBuilder.append(this.primaryKeys[i]).append(",");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE.toString())) {
               selectStrBuilder.append(this.primaryKeys[i]).append(",");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
               selectStrBuilder.append(this.primaryKeys[i]).append(",");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
               selectStrBuilder.append(this.primaryKeys[i]).append(",");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
               selectStrBuilder.append("\"" + this.primaryKeys[i] + "\"").append(",");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
               selectStrBuilder.append("\"" + this.primaryKeys[i] + "\"").append(",");
            } else if (!this.tCoreDatasystem.getDbtype().equals(EdbType.MYSQL.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.OCEANBASE.toString())) {
               selectStrBuilder.append(this.primaryKeys[i]).append(",");
            } else if (IntegerTool.isNumeric(this.primaryKeys[i])) {
               selectStrBuilder.append("`" + this.primaryKeys[i] + "`").append(",");
            } else {
               selectStrBuilder.append(this.primaryKeys[i]).append(",");
            }
         }
      }

      selectStrBuilder.deleteCharAt(selectStrBuilder.length() - 1);
      if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
         String substring = selectStrBuilder.toString();
         String[] arr = substring.split(",");
         List list = new ArrayList();

         for(int i = 0; i < arr.length; ++i) {
            String s = arr[i].trim();
            if (!list.contains(s)) {
               list.add(s);
            }
         }

         substring = StringUtils.strip(list.toString(), "[]");
         selectStrBuilder.setLength(0);
         selectStrBuilder.append(substring);
      }

      String selectSQL = null;
      if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
         selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + this.schema + "\".\"" + this.tableName + "\"";
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString())) {
         selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + this.schema + "\".\"" + this.tableName + "\"";
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
         selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + this.schema + "\".\"" + this.tableName + "\"";
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
         selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + this.schema + "\".\"" + this.tableName + "\"";
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
         selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM " + this.schema + "." + this.tableName;
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE.toString())) {
         selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM " + this.schema + "." + this.tableName;
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
         selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM " + this.schema + "." + this.tableName;
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
         selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + this.schema + "\".\"" + this.tableName + "\"";
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
         selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + this.schema + "\".\"" + this.tableName + "\"";
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
         selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM " + this.schema + "." + this.tableName;
      } else {
         selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM `" + this.schema + "`.`" + this.tableName + "`";
      }

      StringBuilder selectStrBuilder_temp = new StringBuilder(selectSQL);
      selectStrBuilder_temp.append(" where ");

      for(int i = 0; i < this.columnInfoList.size(); ++i) {
         if (i > 0) {
            selectStrBuilder_temp.append(" or ");
         }

         if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
            selectStrBuilder_temp.append(" \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" NOT LIKE '%" + this.encryptionlabel + "%' and \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" is not null ");
         } else if (!this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
            if (this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
               selectStrBuilder_temp.append(" \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" NOT LIKE '%" + this.encryptionlabel + "%' and \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" is not null ");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
               selectStrBuilder_temp.append(" " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " NOT LIKE '%" + this.encryptionlabel + "%' and " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " is not null ");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE.toString())) {
               selectStrBuilder_temp.append(" " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " NOT LIKE '%" + this.encryptionlabel + "%' and " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " is not null ");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
               selectStrBuilder_temp.append(" " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " NOT LIKE '%" + this.encryptionlabel + "%' and " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " is not null ");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
               selectStrBuilder_temp.append(" " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " NOT LIKE '%" + this.encryptionlabel + "%' and " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " is not null ");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
               selectStrBuilder_temp.append(" \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" NOT LIKE '%" + this.encryptionlabel + "%' and \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" is not null ");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
               selectStrBuilder_temp.append(" \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" NOT LIKE '%" + this.encryptionlabel + "%' and \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" is not null ");
            } else {
               selectStrBuilder_temp.append(" " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " NOT LIKE '%" + this.encryptionlabel + "%' and " + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + " is not null ");
            }
         } else if ("BLOB".equalsIgnoreCase(((ColumnInfoVO)this.columnInfoList.get(i)).getColumnType())) {
            selectStrBuilder_temp.append("  \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" is not null ");
         } else if ("JSON".equalsIgnoreCase(((ColumnInfoVO)this.columnInfoList.get(i)).getColumnType())) {
            selectStrBuilder_temp.append(" \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" NOT LIKE '%" + this.encryptionlabel + "%' and \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" is not null  ");
         } else {
            selectStrBuilder_temp.append(" \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" NOT LIKE '%" + this.encryptionlabel + "%' and \"" + ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName() + "\" is not null ");
         }
      }

      selectStrBuilder_temp.append(" order by ");
      if (this.primaryKeys.length > 0) {
         for(int i = 0; i < this.primaryKeys.length; ++i) {
            if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
               selectStrBuilder_temp.append("\"" + this.primaryKeys[i] + "\"").append(",");
            } else if (!this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
               if (this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                  selectStrBuilder_temp.append("\"" + this.primaryKeys[i] + "\"").append(",");
               } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                  selectStrBuilder_temp.append(this.primaryKeys[i]).append(",");
               } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE.toString())) {
                  selectStrBuilder_temp.append(this.primaryKeys[i]).append(",");
               } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                  selectStrBuilder_temp.append(this.primaryKeys[i]).append(",");
               } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
                  selectStrBuilder_temp.append(this.primaryKeys[i]).append(",");
               } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                  selectStrBuilder_temp.append("\"" + this.primaryKeys[i] + "\"").append(",");
               } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                  selectStrBuilder_temp.append("\"" + this.primaryKeys[i] + "\"").append(",");
               } else {
                  selectStrBuilder_temp.append(this.primaryKeys[i]).append(",");
               }
            } else {
               selectStrBuilder_temp.append("\"" + this.primaryKeys[i] + "\"").append(",");
            }
         }
      }

      selectStrBuilder_temp.deleteCharAt(selectStrBuilder_temp.length() - 1);
      selectSQL = selectStrBuilder_temp.toString();
      updateStrBuilder.deleteCharAt(updateStrBuilder.length() - 1);
      backupsStrBuilder.deleteCharAt(backupsStrBuilder.length() - 1);
      String updateSQL = "";
      String backupsSQL = "";
      if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
         updateSQL = "UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET " + updateStrBuilder.toString();
         backupsSQL = "UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET " + backupsStrBuilder.toString();
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString())) {
         updateSQL = "UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET " + updateStrBuilder.toString();
         backupsSQL = "UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET " + backupsStrBuilder.toString();
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
         updateSQL = "UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET " + updateStrBuilder.toString();
         backupsSQL = "UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET " + backupsStrBuilder.toString();
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
         updateSQL = "UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET " + updateStrBuilder.toString();
         backupsSQL = "UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET " + backupsStrBuilder.toString();
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
         updateSQL = "UPDATE " + this.schema + "." + this.tableName + " SET " + updateStrBuilder.toString();
         backupsSQL = "UPDATE " + this.schema + "." + this.tableName + " SET " + backupsStrBuilder.toString();
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE.toString())) {
         updateSQL = "UPDATE " + this.schema + "." + this.tableName + " SET " + updateStrBuilder.toString();
         backupsSQL = "UPDATE " + this.schema + "." + this.tableName + " SET " + backupsStrBuilder.toString();
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
         updateSQL = "UPDATE " + this.schema + "." + this.tableName + " SET " + updateStrBuilder.toString();
         backupsSQL = "UPDATE " + this.schema + "." + this.tableName + " SET " + backupsStrBuilder.toString();
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
         updateSQL = "UPDATE " + this.schema + "." + this.tableName + " SET " + updateStrBuilder.toString();
         backupsSQL = "UPDATE " + this.schema + "." + this.tableName + " SET " + backupsStrBuilder.toString();
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
         updateSQL = "UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET " + updateStrBuilder.toString();
         backupsSQL = "UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET " + backupsStrBuilder.toString();
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
         updateSQL = "UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET " + updateStrBuilder.toString();
         backupsSQL = "UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET " + backupsStrBuilder.toString();
      } else {
         updateSQL = "UPDATE `" + this.schema + "`.`" + this.tableName + "` SET " + updateStrBuilder.toString();
         backupsSQL = "UPDATE `" + this.schema + "`.`" + this.tableName + "` SET " + backupsStrBuilder.toString();
      }

      int count = 0;
      if (this.primaryKeys.length > 0) {
         updateSQL = updateSQL + " WHERE ";
         backupsSQL = backupsSQL + " WHERE ";

         for(int i = 0; i < this.primaryKeys.length; ++i) {
            if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
               updateSQL = updateSQL + "\"" + this.primaryKeys[i] + "\"=? ";
               backupsSQL = backupsSQL + "\"" + this.primaryKeys[i] + "\"=? ";
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString())) {
               updateSQL = updateSQL + "\"" + this.primaryKeys[i] + "\"=? ";
               backupsSQL = backupsSQL + "\"" + this.primaryKeys[i] + "\"=? ";
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
               updateSQL = updateSQL + "\"" + this.primaryKeys[i] + "\"=? ";
               backupsSQL = backupsSQL + "\"" + this.primaryKeys[i] + "\"=? ";
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
               updateSQL = updateSQL + "\"" + this.primaryKeys[i] + "\"=? ";
               backupsSQL = backupsSQL + "\"" + this.primaryKeys[i] + "\"=? ";
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
               updateSQL = updateSQL + this.primaryKeys[i] + "=? ";
               backupsSQL = backupsSQL + this.primaryKeys[i] + "=? ";
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE.toString())) {
               updateSQL = updateSQL + this.primaryKeys[i] + "=? ";
               backupsSQL = backupsSQL + this.primaryKeys[i] + "=? ";
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
               updateSQL = updateSQL + this.primaryKeys[i] + "=? ";
               backupsSQL = backupsSQL + this.primaryKeys[i] + "=? ";
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
               updateSQL = updateSQL + this.primaryKeys[i] + "=? ";
               backupsSQL = backupsSQL + this.primaryKeys[i] + "=? ";
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
               updateSQL = updateSQL + "\"" + this.primaryKeys[i] + "\"=? ";
               backupsSQL = backupsSQL + "\"" + this.primaryKeys[i] + "\"=? ";
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
               updateSQL = updateSQL + "\"" + this.primaryKeys[i] + "\"=? ";
               backupsSQL = backupsSQL + "\"" + this.primaryKeys[i] + "\"=? ";
            } else if (!this.tCoreDatasystem.getDbtype().equals(EdbType.MYSQL.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.OCEANBASE.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.MARIADB.toString())) {
               updateSQL = updateSQL + this.primaryKeys[i] + "=? ";
               backupsSQL = backupsSQL + this.primaryKeys[i] + "=? ";
            } else if (IntegerTool.isNumeric(this.primaryKeys[i])) {
               updateSQL = updateSQL + "`" + this.primaryKeys[i] + "`=? ";
               backupsSQL = backupsSQL + "`" + this.primaryKeys[i] + "`=? ";
            } else {
               updateSQL = updateSQL + this.primaryKeys[i] + "=? ";
               backupsSQL = backupsSQL + this.primaryKeys[i] + "=? ";
            }

            ++count;
            if (count < this.primaryKeys.length) {
               updateSQL = updateSQL + " AND ";
               backupsSQL = backupsSQL + " AND ";
            }
         }
      }

      int batchMaxCount = 10000;
      if ("OCEANBASE".equals(this.tCoreDatasystem.getDbtype())) {
         int oceanbasecount = 3;

         try {
            Properties properties = PropertiesLoaderUtils.loadAllProperties("config.properties");
            String property = properties.getProperty("oceanbasecount");
            if (property != null && property.length() > 0) {
               oceanbasecount = Integer.valueOf(property.trim());
            }
         } catch (Exception e) {
            for(ColumnInfoVO columnInfoVO : this.columnInfoList) {
               this.tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, columnInfoVO.getColumnName(), "4");
            }

            e.printStackTrace();
         }

         batchMaxCount = oceanbasecount;
      } else {
         try {
            Properties properties = PropertiesLoaderUtils.loadAllProperties("config.properties");
            String property = properties.getProperty("encbatchcount");
            if (property != null && property.length() > 0) {
               batchMaxCount = Integer.valueOf(property.trim());
            }
         } catch (Exception e) {
            for(ColumnInfoVO columnInfoVO : this.columnInfoList) {
               this.tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, columnInfoVO.getColumnName(), "4");
            }

            e.printStackTrace();
         }
      }

      PreparedStatement preparedStatementSelect = null;
      ResultSet rs = null;

      label1328:
      while(true) {
         try {
            if (!this.tCoreDatasystem.getDbtype().equals("HIVE")) {
               this.connection.setAutoCommit(false);
            }

            this.encryptionlogger.info("read data sql : {}", selectSQL);
            if (EdbType.MSSQLSERVER.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
               preparedStatementSelect = this.connection.prepareStatement(selectSQL, 1004, 1007);
            } else {
               preparedStatementSelect = this.connection.prepareStatement(selectSQL, 1003, 1007);
            }

            preparedStatementSelect.setFetchSize(batchMaxCount);
            rs = preparedStatementSelect.executeQuery();
            int curBatchCount = 0;
            int totalBatchCount = 0;
            this.encryptionlogger.info("data loop");
            ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue(1), Executors.defaultThreadFactory(), new CustomPolicy());
            List<RecordBatchInfo> recordBatchInfoList = new ArrayList(10000);

            while(rs.next()) {
               List<ColumnBatchInfo> columnBatchInfoList = new ArrayList(this.columnInfoList.size());
               List<String> primaryKeyList = new ArrayList(this.primaryKeys.length);
               RecordBatchInfo recordBatchInfo = new RecordBatchInfo();
               recordBatchInfo.setColumnBatchInfoList(columnBatchInfoList);
               recordBatchInfo.setPrimaryKeyList(primaryKeyList);
               recordBatchInfoList.add(recordBatchInfo);

               for(int i = 0; i < this.columnInfoList.size(); ++i) {
                  ColumnBatchInfo columnBatchInfo = new ColumnBatchInfo();
                  columnBatchInfo.setSecretKey(((ColumnInfoVO)this.columnInfoList.get(i)).getSecretKey());
                  if ("BLOB".equals(((ColumnInfoVO)this.columnInfoList.get(i)).getColumnType())) {
                     columnBatchInfo.setIsBlob(true);
                     Blob blob = rs.getBlob(((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName());
                     columnBatchInfo.setBlob(blob);
                  } else {
                     columnBatchInfo.setIsBlob(false);
                     String value = rs.getString(((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName());
                     String encryptionType = ((ColumnInfoVO)this.columnInfoList.get(i)).getEncryptionType();
                     String isLike = ((ColumnInfoVO)this.columnInfoList.get(i)).getIsLike();
                     if (!"MYSQL".equals(this.tCoreDatasystem.getDbtype()) && !"MARIADB".equals(this.tCoreDatasystem.getDbtype()) && (((ColumnInfoVO)this.columnInfoList.get(i)).getColumnType().equalsIgnoreCase("char") || ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnType().equalsIgnoreCase("bpchar") || ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnType().equalsIgnoreCase("nchar")) && StringUtils.isNotEmpty(value)) {
                        value = value.trim();
                     }

                     String keepfirst = ((ColumnInfoVO)this.columnInfoList.get(i)).getKeepfirst();
                     String encdigit = ((ColumnInfoVO)this.columnInfoList.get(i)).getEncdigit();
                     String twoindex = ((ColumnInfoVO)this.columnInfoList.get(i)).getTwoindex();
                     columnBatchInfo.setEncryptionType(encryptionType);
                     columnBatchInfo.setValue(value);
                     columnBatchInfo.setIsLike(isLike);
                     columnBatchInfo.setKeepFirst(keepfirst);
                     columnBatchInfo.setEncDigit(encdigit);
                     columnBatchInfo.setTwoIndex(twoindex);
                  }

                  columnBatchInfoList.add(columnBatchInfo);
               }

               for(int i = 0; i < this.primaryKeys.length; ++i) {
                  primaryKeyList.add(rs.getString(this.primaryKeys[i]));
               }

               ++curBatchCount;
               if (curBatchCount == batchMaxCount) {
                  String finalUpdateSQL = updateSQL;
                  String finalBackupsSQL = backupsSQL;
                  List<RecordBatchInfo> finalRecordBatchInfoList = recordBatchInfoList;
                  int finalBatchMaxCount = batchMaxCount;
                  executor.submit(() -> {
                     try {
                        this.process(finalUpdateSQL, finalBackupsSQL, finalRecordBatchInfoList, finalBatchMaxCount);
                     } finally {
                        finalRecordBatchInfoList.clear();
                        if (finalRecordBatchInfoList instanceof ArrayList) {
                           ((ArrayList) finalRecordBatchInfoList).trimToSize();
                        }

                     }

                  });
                  recordBatchInfoList = new ArrayList(10000);
                  curBatchCount = 0;
               }
            }

            if (curBatchCount > 0) {
               String finalUpdateSQL1 = updateSQL;
               String finalBackupsSQL1 = backupsSQL;
               int finalBatchMaxCount1 = batchMaxCount;
               List<RecordBatchInfo> finalRecordBatchInfoList1 = recordBatchInfoList;
               executor.submit(() -> {
                  try {
                     this.process(finalUpdateSQL1, finalBackupsSQL1, finalRecordBatchInfoList1, finalBatchMaxCount1);
                  } finally {
                     finalRecordBatchInfoList1.clear();
                     if (finalRecordBatchInfoList1 instanceof ArrayList) {
                        ((ArrayList) finalRecordBatchInfoList1).trimToSize();
                     }

                  }

               });
               recordBatchInfoList = null;
            }

            executor.shutdown();
            if (executor.awaitTermination(30L, TimeUnit.MINUTES)) {
               System.out.println("全部完成");
            } else {
               executor.shutdownNow();
               System.out.println("未全部完成，强制停止");
            }
            break;
         } catch (Throwable e) {
            if (!(e instanceof SQLRecoverableException)) {
               this.encryptionlogger.error("loading task error", e);
               Iterator var97 = this.columnInfoList.iterator();

               while(true) {
                  if (!var97.hasNext()) {
                     break label1328;
                  }

                  ColumnInfoVO columnInfoVO = (ColumnInfoVO)var97.next();
                  this.tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, columnInfoVO.getColumnName(), "4");
               }
            }

            this.encryptionlogger.info("db reconnection!");
            this.connection = JdbcTool.getConnection(this.tCoreDatasystem);
         } finally {
            try {
               if (null != rs) {
                  rs.close();
               }

               if (null != preparedStatementSelect) {
                  preparedStatementSelect.close();
               }

               if (null != this.connection) {
                  this.connection.close();
               }
            } catch (Exception e) {
               e.printStackTrace();
            }

         }
      }

      this.encryptionlogger.info("data loop done");

      for(ColumnInfoVO columnInfoVO : this.columnInfoList) {
         String check = this.checkEncryption(this.tCoreDatasystem, columnInfoVO, this.encryptionlogger);
         if (!"ok".equals(check)) {
            this.encryptionlogger.error("正常信息：字段" + columnInfoVO.getColumnName() + "加密校验失败");
            this.tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, columnInfoVO.getColumnName(), "4");
         } else {
            this.encryptionlogger.info("正常信息：字段" + columnInfoVO.getColumnName() + "加密校验成功");
            String columnName = columnInfoVO.getColumnName();
            this.tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, columnName, "5");

            try {
               TCoreEncryptionTypeFieldDao fieldDao = (TCoreEncryptionTypeFieldDao)ApplicationContextProvider.getBean(TCoreEncryptionTypeFieldDao.class);
               TCoreEncryptionTypeField field = (TCoreEncryptionTypeField)fieldDao.queryUnique(new Criterion[]{Restrictions.eq("id", columnInfoVO.getTcoreencryptionfieldId())});
               Date date = new Date();
               field.setCreatetime(date);
               fieldDao.update(field);
            } catch (Exception var49) {
            }
         }
      }

   }

   private void process(String finalUpdateSQL, String finalBackupsSQL, List<RecordBatchInfo> finalRecordBatchInfo, int bacthMaxCount) {
      if (finalRecordBatchInfo.size() < bacthMaxCount) {
         this.encryptionlogger.info("执行不满足分页的加密");
      }

      Connection connection = null;
      PreparedStatement pstmt = null;
      PreparedStatement pstmt_backups = null;

      try {
         connection = JdbcTool.getConnection(this.tCoreDatasystem);
         if (!this.tCoreDatasystem.getDbtype().equals("HIVE")) {
            connection.setAutoCommit(false);
         }

         pstmt = connection.prepareStatement(finalUpdateSQL);
         pstmt_backups = connection.prepareStatement(finalBackupsSQL);

         for(RecordBatchInfo recordBatchInfoTemp : finalRecordBatchInfo) {
            List<ColumnBatchInfo> columnBatchInfoListTemp = recordBatchInfoTemp.getColumnBatchInfoList();

            for(int i = 0; i < columnBatchInfoListTemp.size(); ++i) {
               ColumnBatchInfo columnBatchInfo = (ColumnBatchInfo)columnBatchInfoListTemp.get(i);
               if (columnBatchInfo.getIsBlob()) {
                  byte[] x = blobToBytes(columnBatchInfo.getBlob());
                  byte x1 = x[0];
                  byte x2 = x[1];
                  if (x1 != -1 && x2 != -1) {
                     boolean where = false;
                     byte[] s = SM4Util.encryptEcbBlob(columnBatchInfo.getSecretKey(), x, (String[])null);
                     byte[] prefixBytes = new byte[]{-1, -1};
                     byte[] newArray = new byte[prefixBytes.length + s.length];
                     System.arraycopy(prefixBytes, 0, newArray, 0, prefixBytes.length);
                     System.arraycopy(s, 0, newArray, prefixBytes.length, s.length);
                     pstmt.setBlob(i + 1, new ByteArrayInputStream(newArray));
                  }
               } else {
                  String value = this.doEncryptionMethod(columnBatchInfo.getEncryptionType(), columnBatchInfo.getSecretKey(), columnBatchInfo.getValue(), columnBatchInfo.getIsLike(), columnBatchInfo.getKeepFirst(), columnBatchInfo.getEncDigit(), columnBatchInfo.getTwoIndex());
                  if ("JSON".equals(((ColumnInfoVO)this.columnInfoList.get(i)).getColumnType())) {
                     if (StringUtils.isNotBlank(value)) {
                        String jsonkey = this.props.getProperty("jsonkey");
                        pstmt.setString(i + 1, "{\"" + jsonkey + "\":\"" + value + "\"}");
                     } else {
                        pstmt.setString(i + 1, value);
                     }
                  } else {
                     pstmt.setString(i + 1, value);
                  }
               }
            }

            List<String> primaryKeyListTemp = recordBatchInfoTemp.getPrimaryKeyList();

            for(int i = 0; i < primaryKeyListTemp.size(); ++i) {
               if (!this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                  String cname = this.primaryKeys[i];
                  com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO columnInfoVO = (com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO)this.allColumnList.stream().filter((c) -> c.getColumnname().equals(cname)).findFirst().get();
                  if (!this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                     pstmt.setString(this.columnInfoList.size() + i + 1, (String)primaryKeyListTemp.get(i));
                     pstmt_backups.setString(i + 1, (String)primaryKeyListTemp.get(i));
                  } else if (columnInfoVO.getTypename().toLowerCase(Locale.ROOT).contains("int")) {
                     pstmt.setLong(this.columnInfoList.size() + i + 1, Long.parseLong((String)primaryKeyListTemp.get(i)));
                     pstmt_backups.setLong(i + 1, Long.parseLong((String)primaryKeyListTemp.get(i)));
                  } else {
                     pstmt.setString(this.columnInfoList.size() + i + 1, (String)primaryKeyListTemp.get(i));
                     pstmt_backups.setString(i + 1, (String)primaryKeyListTemp.get(i));
                  }
               } else {
                  String cname = this.primaryKeys[i];
                  com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO columnInfoVO = (com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO)this.allColumnList.stream().filter((c) -> c.getColumnname().equals(cname)).findFirst().get();
                  if (!columnInfoVO.getTypename().toLowerCase(Locale.ROOT).contains("int") && !columnInfoVO.getTypename().toLowerCase(Locale.ROOT).equals("serial") && !columnInfoVO.getTypename().toLowerCase(Locale.ROOT).equals("imos_id") && !columnInfoVO.getTypename().toLowerCase(Locale.ROOT).equals("bigserial")) {
                     pstmt.setString(this.columnInfoList.size() + i + 1, (String)primaryKeyListTemp.get(i));
                     pstmt_backups.setString(i + 1, (String)primaryKeyListTemp.get(i));
                  } else {
                     pstmt.setLong(this.columnInfoList.size() + i + 1, Long.parseLong((String)primaryKeyListTemp.get(i)));
                     pstmt_backups.setLong(i + 1, Long.parseLong((String)primaryKeyListTemp.get(i)));
                  }
               }
            }

            if (this.tCoreDatasystem.getDbtype().equals("HIVE")) {
               pstmt.executeUpdate();
            } else {
               pstmt_backups.addBatch();
               pstmt.addBatch();
            }
         }

         if (!this.isReload) {
            pstmt_backups.executeBatch();
            pstmt_backups.clearBatch();
         } else {
            pstmt_backups.clearBatch();
         }

         pstmt.executeBatch();
         pstmt.clearBatch();
         connection.commit();
         this.encryptionlogger.info("加密完成条数为：{}", finalRecordBatchInfo.size());
      } catch (Throwable e) {
         this.encryptionlogger.error("process error 1", e);
         System.out.println(Thread.currentThread().getName() + "-" + e.getMessage());

         try {
            connection.rollback();
         } catch (SQLException ex) {
            this.encryptionlogger.error("process error 2", ex);
            ex.printStackTrace();
         }
      } finally {
         try {
            if (null != pstmt) {
               pstmt.close();
            }

            if (null != pstmt_backups) {
               pstmt_backups.close();
            }

            if (null != connection) {
               connection.close();
            }
         } catch (Throwable e) {
            System.out.println(Thread.currentThread().getName() + "-" + e.getMessage());
         }

         finalRecordBatchInfo.clear();
      }

   }

   private boolean checkColumnAllEncrypted(String columnName) {
      ResultSet resultSet = null;

      boolean var8;
      try {
         Connection conn = JdbcTool.getConnection(this.tCoreDatasystem);
         Throwable var4 = null;

         try {
            Statement stmt = conn.createStatement();
            Throwable var6 = null;

            try {
               if (!EdbType.ORACLE.toString().equals(this.tCoreDatasystem.getDbtype()) && !EdbType.POSTGRESQL.toString().equals(this.tCoreDatasystem.getDbtype()) && !EdbType.GREENPLUM.toString().equals(this.tCoreDatasystem.getDbtype()) && !EdbType.DM.toString().equals(this.tCoreDatasystem.getDbtype()) && !EdbType.KINGBASE.toString().equals(this.tCoreDatasystem.getDbtype()) && !EdbType.GAUSS.toString().equals(this.tCoreDatasystem.getDbtype())) {
                  if (EdbType.MYSQL.toString().equals(this.tCoreDatasystem.getDbtype()) || EdbType.MSSQLSERVER.toString().equals(this.tCoreDatasystem.getDbtype()) || EdbType.HIVE.toString().equals(this.tCoreDatasystem.getDbtype()) || EdbType.HIVE_TDH.toString().equals(this.tCoreDatasystem.getDbtype())) {
                     resultSet = stmt.executeQuery("SELECT count(1) AS num FROM " + this.schema + "." + this.tableName + " WHERE " + columnName + " IS NOT NULL AND " + columnName + " NOT LIKE '%" + this.encryptionlabel + "%'");
                  }
               } else {
                  resultSet = stmt.executeQuery("SELECT COUNT(1) AS num FROM \"" + this.schema + "\".\"" + this.tableName + "\" WHERE \"" + columnName + "\"IS NOT NULL AND \"" + columnName + "\" NOT LIKE '%" + this.encryptionlabel + "%'");
               }

               int num;
               for(num = 0; resultSet.next(); num = resultSet.getInt("num")) {
               }

               var8 = num == 0;
            } catch (Throwable var52) {
               var6 = var52;
               throw var52;
            } finally {
               if (stmt != null) {
                  if (var6 != null) {
                     try {
                        stmt.close();
                     } catch (Throwable var51) {
                        var6.addSuppressed(var51);
                     }
                  } else {
                     stmt.close();
                  }
               }

            }
         } catch (Throwable var54) {
            var4 = var54;
            throw var54;
         } finally {
            if (conn != null) {
               if (var4 != null) {
                  try {
                     conn.close();
                  } catch (Throwable var50) {
                     var4.addSuppressed(var50);
                  }
               } else {
                  conn.close();
               }
            }

         }
      } catch (Exception e) {
         throw new RuntimeException(e);
      } finally {
         if (null != resultSet) {
            try {
               resultSet.close();
            } catch (SQLException e) {
               throw new RuntimeException(e);
            }
         }

      }

      return var8;
   }

   private void addTableField(Connection con, String schema, String tableName, StringBuilder addColumnStrings, StringBuilder addColumnString, Logger encryptionlogger, TCoreDatasystem tCoreDatasystem) throws SQLException {
      if (null != addColumnString && addColumnString.length() > 0) {
         String sql = "";
         if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
            sql = "alter table " + schema + "." + tableName + "  add column(" + addColumnString + ")";
         } else if (tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
            sql = "alter table " + schema + "." + tableName + "  add column(" + addColumnString + ")";
         } else if (tCoreDatasystem.getDbtype().equals(EdbType.HIVE.toString())) {
            sql = "alter table " + schema + "." + tableName + "  add columns(" + addColumnString + ")";
         } else if (tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
            sql = "alter table " + schema + "." + tableName + "  add columns(" + addColumnString + ")";
         } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
            sql = "alter table " + schema + "." + tableName + " " + addColumnString + "";
         } else {
            sql = "alter table " + schema + "." + tableName + " " + addColumnString;
         }

         if (null != addColumnStrings) {
            encryptionlogger.info("新增加密列开始：" + addColumnStrings + "  sql语句：" + sql);
         }

         if ("DB2".equals(tCoreDatasystem.getDbtype())) {
            CallableStatement cs = con.prepareCall("call SYSPROC.ADMIN_CMD('reorg table " + schema + "." + tableName + "')");
            cs.execute();
            cs.close();
         }

         PreparedStatement preStatement = con.prepareStatement(sql);
         preStatement.executeUpdate();
         preStatement.close();
         if ("DB2".equals(tCoreDatasystem.getDbtype())) {
            CallableStatement cs = con.prepareCall("call SYSPROC.ADMIN_CMD('reorg table " + schema + "." + tableName + "')");
            cs.execute();
            cs.close();
         }

         if (null != addColumnStrings) {
            encryptionlogger.info("新增加密列完成：" + addColumnStrings + "  sql语句：" + sql);
         }
      }

   }

   private String getSqlPaging(String sql1, String sql2) {
      String sqlPaging111 = null;
      if (EdbType.DB2.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
         sqlPaging111 = "SELECT " + sql1 + " FROM ( select row_number() over() as RN ,TT.* FROM  (" + sql2 + " ) TT ) where RN>" + 1 + " AND RN <= " + 10;
      } else if (!EdbType.ORACLE.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.DM.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
         if (EdbType.POSTGRESQL.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
            sqlPaging111 = sql2 + " offset " + 1 + " limit " + 10;
         } else if (EdbType.GREENPLUM.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
            sqlPaging111 = sql2 + " limit " + 1 + " OFFSET " + 10;
         } else if (!EdbType.MYSQL.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.KINGBASE.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.GAUSS.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.HIVE_TDH.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.MARIADB.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.HIVE.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.OCEANBASE.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
            if (EdbType.MSSQLSERVER.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
               sqlPaging111 = sql2 + " OFFSET " + 1 + " ROWS FETCH NEXT " + 10 + " ROWS ONLY";
            }
         } else {
            sqlPaging111 = sql2 + " limit " + 1 + "," + 10;
         }
      } else {
         sqlPaging111 = "SELECT " + sql1 + " FROM ( select ROWNUM RN ,TT.* FROM  (" + sql2 + " ) TT ) where RN>" + 1 + " AND RN <= " + 10;
      }

      return sqlPaging111;
   }

   private static byte[] blobToBytes(Blob blob) throws Exception {
      try {
         InputStream inputStream = blob.getBinaryStream();
         Throwable var2 = null;

         byte[] var7;
         try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Throwable var4 = null;

            try {
               byte[] buffer = new byte[4096];
               int bytesRead = -1;

               while((bytesRead = inputStream.read(buffer)) != -1) {
                  outputStream.write(buffer, 0, bytesRead);
               }

               var7 = outputStream.toByteArray();
            } catch (Throwable var32) {
               var4 = var32;
               throw var32;
            } finally {
               if (outputStream != null) {
                  if (var4 != null) {
                     try {
                        outputStream.close();
                     } catch (Throwable var31) {
                        var4.addSuppressed(var31);
                     }
                  } else {
                     outputStream.close();
                  }
               }

            }
         } catch (Throwable var34) {
            var2 = var34;
            throw var34;
         } finally {
            if (inputStream != null) {
               if (var2 != null) {
                  try {
                     inputStream.close();
                  } catch (Throwable var30) {
                     var2.addSuppressed(var30);
                  }
               } else {
                  inputStream.close();
               }
            }

         }

         return var7;
      } catch (Exception e) {
         e.printStackTrace();
         throw new Exception("444");
      }
   }

   private String doEncryptionMethod(String encryptionType, String secretKey, String value, String isLike, String keepfirst, String encdigit, String twoindex) throws Exception {
      if (null != encryptionType && !"".equals(encryptionType)) {
         value = EncProvider.encryptEcb(encryptionType, secretKey, value, isLike, keepfirst, encdigit, twoindex);
      }

      return value;
   }

   private String checkEncryption(TCoreDatasystem tCoreDatasystem, ColumnInfoVO columnInfoVO, Logger encryptionlogger) {
      encryptionlogger.info("正常信息：开始校验");
      ResultSet rsCount = null;
      int checkNum = Integer.valueOf(this.props.getProperty("checkNum"));
      int sumNum = 0;
      TCoreEncryptionService tCoreEncryptionService = (TCoreEncryptionService)ApplicationContextProvider.getBean(TCoreEncryptionContext.class);

      try {
         Connection conn = JdbcTool.getConnection(tCoreDatasystem);
         Throwable var9 = null;

         try {
            Statement stmt = conn.createStatement();
            Throwable var11 = null;

            try {
               Set<String> columnMap = JdbcTool.getColumnMap(conn, this.schema, this.tableName);
               Boolean bb;
               if (!columnMap.contains(columnInfoVO.getColumnName() + this.copySuffix)) {
                  return "ok";
               }

               encryptionlogger.info("正常信息：校验连接创建成功");
               bb = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
                  bb = false;
               }

               Boolean bbb = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                  bbb = false;
               }

               Boolean isgreenplum = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                  isgreenplum = false;
               }

               Boolean SQBoolean = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                  SQBoolean = false;
               }

               Boolean DMBoolean = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                  DMBoolean = false;
               }

               Boolean isHivetdh = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                  isHivetdh = false;
               }

               Boolean isDB2 = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
                  isDB2 = false;
               }

               Boolean isKingbase = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                  isKingbase = false;
               }

               encryptionlogger.info("正常信息：加密非空校验开始");
               int iCLimitCount = 0;
               ResultSet rsC = null;
               String columnName = columnInfoVO.getColumnName();

               Blob columnNameN;
               try {
                  if (bb) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + this.schema + "\".\"" + this.tableName + "\" WHERE \"" + columnName + this.copySuffix + "\" IS NOT NULL AND \"" + columnName + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                  } else if (bbb) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + this.schema + "." + this.tableName + " WHERE \"" + columnName + this.copySuffix + "\" IS NOT NULL AND (" + columnName + " IS NULL ) offset " + iCLimitCount + " limit " + checkNum + " )t");
                  } else if (isgreenplum) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + this.schema + "." + this.tableName + " WHERE \"" + columnName + this.copySuffix + "\" IS NOT NULL AND (" + columnName + " IS NULL ) offset " + iCLimitCount + " limit " + checkNum + " )t");
                  } else if (isHivetdh) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM " + this.schema + "." + this.tableName + " WHERE " + columnName + this.copySuffix + " IS NOT NULL AND " + columnName + " IS NULL  limit " + iCLimitCount + " , " + checkNum);
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + this.schema + "." + this.tableName + " WHERE \"" + columnName + this.copySuffix + "\" IS NOT NULL AND (" + columnName + " IS NULL ) offset " + iCLimitCount + " limit " + checkNum + " )t");
                  } else if (SQBoolean) {
                     rsC = stmt.executeQuery(" select  count(1) AS num FROM (  select *, ROW_NUMBER() OVER(Order by " + columnName + " desc ) AS RowId FROM " + this.schema + "." + this.tableName + ") as a  where " + columnName + this.copySuffix + " IS NOT NULL AND " + columnName + " IS NULL and RowId between " + iCLimitCount + " and " + checkNum);
                  } else if (DMBoolean) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + this.schema + "\".\"" + this.tableName + "\" WHERE \"" + columnName + this.copySuffix + "\" IS NOT NULL AND \"" + columnName + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                  } else if (isDB2) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM " + this.schema + "." + this.tableName + " WHERE \"" + columnName + this.copySuffix + "\" IS NOT NULL AND (\"" + columnName + "\" IS NULL  ) limit " + iCLimitCount + " ," + checkNum + "");
                  } else if (isKingbase) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + this.schema + "." + this.tableName + " WHERE length(" + columnName + this.copySuffix + ") > 0 AND length(" + columnName + ") = 0 limit " + iCLimitCount + "," + checkNum + " )t");
                  } else {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM `" + this.schema + "`.`" + this.tableName + "` WHERE " + columnName + this.copySuffix + " IS NOT NULL AND (" + columnName + " IS NULL ) limit " + iCLimitCount + "," + checkNum + " )t");
                  }

                  int num;
                  for(num = 0; rsC.next(); num = rsC.getInt("num")) {
                  }

                  if (num > 0) {
                     StringBuilder mg = new StringBuilder();
                     mg.append("数据源：");
                     mg.append(this.schema);
                     mg.append("表：");
                     mg.append(this.tableName);
                     mg.append("列：");
                     mg.append(columnName);
                     mg.append("加密后的数据为空，加密失败，准备回滚。");
                     encryptionlogger.info("异常信息：加密非空校验：加密后的数据为空，加密失败，准备回滚。");
                     return mg.toString();
                  }

                  encryptionlogger.info("正常信息：加密非空校验通过");
               } catch (Exception e) {
                  e.printStackTrace();
               } finally {
                  if (rsC != null) {
                     try {
                        rsC.close();
                     } catch (SQLException e) {
                        e.printStackTrace();
                     }
                  }

               }

               encryptionlogger.info("正常信息：解密校验开始");
               ResultSet rs1 = null;

               try {
                  if (bb) {
                     rs1 = stmt.executeQuery("select nn.\"" + columnName + "\",nn.\"" + columnName + this.copySuffix + "\" from (select t.\"" + columnName + "\",t.\"" + columnName + this.copySuffix + "\",rownum rn from \"" + this.schema + "\".\"" + this.tableName + "\" t) nn where nn.rn>=" + iCLimitCount + "and nn.rn<" + checkNum);
                  } else if (bbb) {
                     rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + this.copySuffix + "\" from \"" + this.schema + "\".\"" + this.tableName + "\" OFFSET " + iCLimitCount + " LIMIT " + checkNum);
                  } else if (isgreenplum) {
                     rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + this.copySuffix + "\" from \"" + this.schema + "\".\"" + this.tableName + "\" OFFSET " + iCLimitCount + " LIMIT " + checkNum);
                  } else if (isHivetdh) {
                     rs1 = stmt.executeQuery("select " + columnName + "," + columnName + this.copySuffix + " from " + this.schema + "." + this.tableName + " LIMIT " + iCLimitCount + " , " + checkNum);
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                     rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + this.copySuffix + "\" from \"" + this.schema + "\".\"" + this.tableName + "\" LIMIT " + checkNum + " OFFSET " + iCLimitCount);
                  } else if (SQBoolean) {
                     rs1 = stmt.executeQuery("SELECT " + columnName + "," + columnName + this.copySuffix + ", 0 AS _NAV_ORDER_F_ FROM " + this.schema + "." + this.tableName + " ORDER BY _NAV_ORDER_F_ OFFSET " + iCLimitCount + " ROWS FETCH NEXT " + checkNum + " ROWS ONLY");
                  } else if (DMBoolean) {
                     rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + this.copySuffix + "\" from \"" + this.schema + "\".\"" + this.tableName + "\" LIMIT " + iCLimitCount + "," + checkNum);
                  } else if (isDB2) {
                     rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + this.copySuffix + "\" from \"" + this.schema + "\".\"" + this.tableName + "\" LIMIT " + iCLimitCount + "," + checkNum);
                  } else if (isKingbase) {
                     String kingbaseSql = "select \"" + columnName + "\",\"" + columnName + this.copySuffix + "\" from \"" + this.schema + "\".\"" + this.tableName + "\"";
                     if (this.primaryKeys.length > 0) {
                        kingbaseSql = kingbaseSql + " order by " + this.primaryKeys[0].toString() + " ";
                     }

                     kingbaseSql = kingbaseSql + " LIMIT " + iCLimitCount + "," + checkNum;
                     rs1 = stmt.executeQuery(kingbaseSql);
                  } else {
                     rs1 = stmt.executeQuery(this.checkColumn(this.schema, this.tableName, columnName, columnName + this.copySuffix, iCLimitCount, checkNum));
                  }

                  while(rs1.next()) {
                     Blob blobN;
                     if ("BLOB".equals(columnInfoVO.getColumnType())) {
                        Blob copy = rs1.getBlob(columnName);
                        if (copy != null) {
                           Blob columnNameNew = rs1.getBlob(columnName + this.copySuffix);
                           String secretKeyId = columnInfoVO.getSecretKeyId();
                           Map<String, String> encryptionInfo = tCoreEncryptionService.queryEncryptionInfo(secretKeyId);
                           if (null != encryptionInfo.get("encryptionType") && !"".equals(encryptionInfo.get("encryptionType")) && columnNameNew != null) {
                              if ("BLOB".equals(columnInfoVO.getColumnType())) {
                                 byte[] bytes = copy.getBytes(1L, 2);
                                 if (bytes[0] != -1 || bytes[1] != -1) {
                                    StringBuilder mg111 = new StringBuilder();
                                    mg111.append("数据源：");
                                    mg111.append(this.schema);
                                    mg111.append("表：");
                                    mg111.append(this.tableName);
                                    mg111.append("列：");
                                    mg111.append(columnName);
                                    mg111.append("加密后的数据解密后与元数据不一致，准备回滚。");
                                    encryptionlogger.info("异常信息：加密后的数据解密后与元数据不一致，准备回滚。");
                                    return mg111.toString();
                                 }
                              }

                              Boolean isEq = true;
                              if ("BLOB".equals(columnInfoVO.getColumnType())) {
                                 Blob mg111 = rs1.getBlob(columnName);
                                 blobN = rs1.getBlob(columnName + this.copySuffix);
                                 byte[] x = blobToBytes(mg111);
                                 byte[] x1 = SM4Util.decryptEcbBlob((String)encryptionInfo.get("secretkey"), x, (String[])null);
                                 byte[] x2 = blobToBytes(blobN);
                                 isEq = Arrays.equals(x2, x1);
                              }

                              if (!isEq) {
                                 StringBuilder mg111 = new StringBuilder();
                                 mg111.append("数据源：");
                                 mg111.append(this.schema);
                                 mg111.append("表：");
                                 mg111.append(this.tableName);
                                 mg111.append("列：");
                                 mg111.append(columnName);
                                 mg111.append("加密后的数据解密后与元数据不一致，准备回滚。");
                                 encryptionlogger.info("异常信息：加密后的数据解密后与元数据不一致，准备回滚。");
                                 return mg111.toString();
                              }
                           }
                        }
                     } else {
                        String copy = rs1.getString(columnName);
                        if (StringUtils.isNotEmpty(copy)) {
                           if ("JSON".equals(columnInfoVO.getColumnType())) {
                              String columnNameNew = this.props.getProperty("jsonkey");
                              JSONObject jsonObject = JSONObject.parseObject(copy);
                              copy = jsonObject.getString(columnNameNew);
                           }

                           String columnNameNew1 = rs1.getString(columnName + this.copySuffix);
                           String secretKeyId = columnInfoVO.getSecretKeyId();
                           Map<String, String> encryptionInfo = tCoreEncryptionService.queryEncryptionInfo(secretKeyId);
                           if (null != encryptionInfo.get("encryptionType") && !"".equals(encryptionInfo.get("encryptionType")) && !StringUtils.isBlank(columnNameNew1)) {
                              if (!copy.contains(this.props.getProperty("encryption.label"))) {
                                 StringBuilder mg111 = new StringBuilder();
                                 mg111.append("数据源：");
                                 mg111.append(this.schema);
                                 mg111.append("表：");
                                 mg111.append(this.tableName);
                                 mg111.append("列：");
                                 mg111.append(columnName);
                                 mg111.append("加密后的数据解密后与元数据不一致，准备回滚。");
                                 encryptionlogger.info("异常信息：加密后的数据解密后与元数据不一致，准备回滚。");
                                 return mg111.toString();
                              }

                              Boolean isEq = EncUtils.compareStringEq(columnNameNew1, EncProvider.decryptEcb((String)encryptionInfo.get("encryptionType"), (String)encryptionInfo.get("secretkey"), copy, columnInfoVO.getIsLike(), columnInfoVO.getKeepfirst(), columnInfoVO.getEncdigit(), columnInfoVO.getTwoindex()));
                              if (!isEq) {
                                 StringBuilder mg111 = new StringBuilder();
                                 mg111.append("数据源：");
                                 mg111.append(this.schema);
                                 mg111.append("表：");
                                 mg111.append(this.tableName);
                                 mg111.append("列：");
                                 mg111.append(columnName);
                                 mg111.append("加密后的数据解密后与元数据不一致，准备回滚。");
                                 encryptionlogger.info("异常信息：加密后的数据解密后与元数据不一致，准备回滚。");
                                 return mg111.toString();
                              }
                           }
                        }
                     }
                  }

                  encryptionlogger.info("正常信息：解密校验通过");
               } catch (Exception e) {
                  e.printStackTrace();
                  encryptionlogger.info("结束校验");
                  return "e1";
               } finally {
                  if (rs1 != null) {
                     try {
                        rs1.close();
                     } catch (SQLException e) {
                        e.printStackTrace();
                     }
                  }

               }
            } catch (Throwable var155) {
               var11 = var155;
               throw var155;
            } finally {
               if (stmt != null) {
                  if (var11 != null) {
                     try {
                        stmt.close();
                     } catch (Throwable var148) {
                        var11.addSuppressed(var148);
                     }
                  } else {
                     stmt.close();
                  }
               }

            }
         } catch (Throwable var157) {
            var9 = var157;
            throw var157;
         } finally {
            if (conn != null) {
               if (var9 != null) {
                  try {
                     conn.close();
                  } catch (Throwable var147) {
                     var9.addSuppressed(var147);
                  }
               } else {
                  conn.close();
               }
            }

         }
      } catch (Exception e) {
         e.printStackTrace();
         encryptionlogger.info("正常信息：校验结束");
         return "e2";
      }

      encryptionlogger.info("正常信息：校验结束");
      return "ok";
   }

   public long getColumnsCheckLength(String dbType, String schema, String tableName) {
      String sqlColumnLength = "";
      ResultSet resultSet = null;

      try {
         switch (dbType) {
            case "MYSQL":
            case "MARIADB":
            case "OCEANBASE":
               sqlColumnLength = "select sum(T.CHARACTER_OCTET_LENGTH) as ALL_LENGTH  from information_schema.columns T  where TABLE_SCHEMA = '" + schema.toLowerCase(Locale.ROOT) + "' and TABLE_NAME = '" + tableName.toUpperCase(Locale.ROOT) + "' AND DATA_TYPE IN ('varchar','char')";
               break;
            case "ORACLE":
               sqlColumnLength = "SELECT SUM(DATA_LENGTH) AS ALL_LENGTH FROM  dba_tab_columns WHERE TABLE_NAME  = '" + tableName.toUpperCase(Locale.ROOT) + "' and OWNER  = '" + schema.toUpperCase(Locale.ROOT) + "' AND DATA_TYPE IN ('VARCHAR2','CHAR')";
               break;
            case "DM":
               sqlColumnLength = "select SUM(DATA_LENGTH) AS ALL_LENGTH \t\n from all_tab_columns a \n where a.owner = '" + schema.toUpperCase(Locale.ROOT) + "' and a.Table_Name = '" + tableName.toUpperCase(Locale.ROOT) + "' and data_type like '%CHAR%'";
               break;
            case "KINGBASE":
            case "GREENPLUM":
            case "POSTGRESQL":
            case "GAUSS":
               sqlColumnLength = "select SUM(character_octet_length) as ALL_LENGTH  from information_schema.columns  where TABLE_SCHEMA = '" + schema.toLowerCase(Locale.ROOT) + "' and TABLE_NAME = '" + tableName.toLowerCase(Locale.ROOT) + "' and data_type like '%char%' ";
               break;
            case "MSSQLSERVER":
               sqlColumnLength = "select SUM(CHARACTER_MAXIMUM_LENGTH) AS ALL_LENGTH from INFORMATION_SCHEMA.COLUMNS A  where A.TABLE_CATALOG = '" + schema.toLowerCase(Locale.ROOT) + "' and A.TABLE_NAME = '" + tableName.toLowerCase() + "' and DATA_TYPE like '%char%' and CHARACTER_OCTET_LENGTH > -1 ";
               break;
            case "HIVE_TDH":
               sqlColumnLength = "select SUM(column_length) AS ALL_LENGTH from `system`.`columns_v`  where `database_name` = '" + schema.toLowerCase(Locale.ROOT) + "' and table_name = '" + tableName.toLowerCase() + "' and column_type like '%char%' ";
               break;
            case "DB2":
               sqlColumnLength = "select SUM(LENGTH) AS ALL_LENGTH from syscat.columns  where TABSCHEMA = '" + schema + "' and TABNAME = '" + tableName + "' and TYPENAME like '%CHAR%' ";
         }

         PreparedStatement preparedStatement = this.connection.prepareStatement(sqlColumnLength);
         resultSet = preparedStatement.executeQuery();
         String allLength = null;
         if (resultSet.next()) {
            allLength = resultSet.getString("ALL_LENGTH");
         }

         long var8 = StringUtils.isEmpty(allLength) ? 0L : Long.parseLong(allLength);
         return var8;
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (resultSet != null) {
               resultSet.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return 0L;
   }

   public HashMap<String, Object> checkTableColumnLength(HashMap<String, Object> resultMap, String dbType, String columnName, long columnsCheckLength, int columnLength) {
      switch (dbType) {
         case "MYSQL":
         case "MARIADB":
         case "OCEANBASE":
            if ("varchar".equals(this.columnType.toLowerCase(Locale.ROOT))) {
               if (columnLength > 16383) {
                  resultMap.put(CHECK_COLUMN, columnName + COLUMN_OUT_OF_RANGE);
                  break;
               }
            } else if ("char".equals(this.columnType.toLowerCase(Locale.ROOT)) && columnLength > 255) {
               resultMap.put(CHECK_COLUMN, columnName + COLUMN_OUT_OF_RANGE);
               break;
            }

            columnsCheckLength += (long)(Integer.parseInt(this.columnSize) * 4);
            if (columnsCheckLength > 65000L) {
               resultMap.put(CHECK_COLUMN, CHECK_ALL_COLUMN_OUT_OF_RANGE);
            }
            break;
         case "ORACLE":
            if ("VARCHAR2".equals(this.columnType.toUpperCase(Locale.ROOT))) {
               if (columnLength > 4000) {
                  resultMap.put(CHECK_COLUMN, columnName + COLUMN_OUT_OF_RANGE);
               }
            } else if ("CHAR".equals(this.columnType.toUpperCase(Locale.ROOT)) && columnLength > 2000) {
               resultMap.put(CHECK_COLUMN, columnName + COLUMN_OUT_OF_RANGE);
            }
            break;
         case "KINGBASE":
         case "GREENPLUM":
         case "POSTGRESQL":
         case "GAUSS":
            if (this.columnType.toUpperCase(Locale.ROOT).indexOf("CHAR") >= 0 && columnLength > 10485760) {
               resultMap.put(CHECK_COLUMN, columnName + COLUMN_OUT_OF_RANGE);
            }
            break;
         case "HIVE_TDH":
            if (this.columnType.toUpperCase(Locale.ROOT).indexOf("CHAR") >= 0 && columnLength > 8000) {
               resultMap.put(CHECK_COLUMN, columnName + COLUMN_OUT_OF_RANGE);
            }
            break;
         case "DM":
            if (this.columnType.toUpperCase(Locale.ROOT).indexOf("CHAR") >= 0 && columnLength > 8188) {
               resultMap.put(CHECK_COLUMN, columnName + COLUMN_OUT_OF_RANGE);
            }
            break;
         case "DB2":
            if (this.columnType.toUpperCase(Locale.ROOT).indexOf("CHAR") >= 0 && columnLength > 8912) {
               resultMap.put(CHECK_COLUMN, columnName + COLUMN_OUT_OF_RANGE);
            }
            break;
         case "MSSQLSERVER":
            if (!"varchar".equals(this.columnType.toLowerCase(Locale.ROOT)) && !"char".equals(this.columnType.toLowerCase(Locale.ROOT))) {
               if (("nchar".equals(this.columnType.toLowerCase(Locale.ROOT)) || "nvarchar".equals(this.columnType.toLowerCase(Locale.ROOT))) && columnLength > 4000) {
                  resultMap.put(CHECK_COLUMN, columnName + COLUMN_OUT_OF_RANGE);
                  return resultMap;
               }
            } else if (columnLength > 8000) {
               resultMap.put(CHECK_COLUMN, columnName + COLUMN_OUT_OF_RANGE);
               return resultMap;
            }

            columnsCheckLength += (long)Integer.parseInt(this.columnSize);
            if (columnsCheckLength > 8060L) {
               resultMap.put(CHECK_COLUMN, CHECK_ALL_COLUMN_OUT_OF_RANGE);
            }
      }

      return resultMap;
   }

   private String checkColumn(String schema, String tableName, String columnName, String checkColumnName, int iCLimitCount, int limitCount) {
      String sql = String.format("SELECT %s,%s FROM %s.%s limit %s,%s", columnName, checkColumnName, schema, tableName, iCLimitCount, limitCount);
      return sql;
   }
}
