package com.chenyang.nse.bussiness.tools.dataprocess;

import ch.qos.logback.classic.Logger;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreJiaMiJieMiJinDuDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.ColumnPrimaryKeyInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreJiaMiJieMiJinDu;
import com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.service.core.encryption.TCoreEncryptionService;
import com.chenyang.nse.bussiness.service.core.encryption.impl.TCoreEncryptionContext;
import com.chenyang.nse.bussiness.tools.encryption.EncProvider;
import com.chenyang.nse.bussiness.tools.encryption.EncUtils;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.logger.LoggerBuilder;
import com.chenyang.nse.bussiness.tools.propertyutil.PropertyGhcaUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;

public class RemoveLoadingTask implements Callable {
   private String copySuffix = "";
   protected static final String COMPLETE = "6";
   protected static final String RUNNING = "-2";
   protected static final String FAIL = "44";
   private int jiamiTasktotalCounts = 0;
   private int jiamiTaskFinishCounts = 0;
   private int failCount = 0;
   private String dataSystemId;
   private String projectId;
   private String tableName;
   private String columnName;
   private String columnType;
   private String columnSize;
   private Connection connection;
   private TCoreDatasystem tCoreDatasystem;
   private String schema;
   private String[] primaryKeys;
   private List<ColumnInfoVO> columnInfoList;
   private List<com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO> allColumnList;
   List<ColumnPrimaryKeyInfo> columnPrimaryKeyInfoList;
   HashSet<ColumnEncryption> columnSet = null;
   Properties props = new Properties();
   private JdbcTemplate jdbcTemplate;
   private boolean isKeepReadData = true;
   private int startRow = 0;
   private int maxPackageCount = 100000;
   EncTaskStateContainer container;
   private static String COLUMN_OUT_OF_RANGE = " 列解密后长度超出范围，请修改列长度";
   private static String CHECK_ALL_COLUMN_OUT_OF_RANGE = " 表解密后校验列合计长度超出数据库要求范围";
   private static String CHECK_COLUMN = "checkColumn";

   public RemoveLoadingTask(String projectId, String dataSystemId, TCoreDatasystem tCoreDatasystem, String schema, String tableName, String[] primaryKeys, List<ColumnInfoVO> columnInfoList, List<ColumnPrimaryKeyInfo> columnPrimaryKeyInfoList, List<com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO> allColumnList) {
      this.copySuffix = PropertyGhcaUtil.copySuffix;
      this.projectId = projectId;
      this.dataSystemId = dataSystemId;
      this.tCoreDatasystem = tCoreDatasystem;
      this.schema = schema;
      this.tableName = tableName;
      this.columnInfoList = columnInfoList;
      this.primaryKeys = primaryKeys;
      this.columnPrimaryKeyInfoList = columnPrimaryKeyInfoList;
      this.allColumnList = allColumnList;
      this.connection = JdbcTool.getConnection(tCoreDatasystem);
      this.jdbcTemplate = (JdbcTemplate)ApplicationContextProvider.getBean(JdbcTemplate.class);

      try {
         this.props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      this.container = EncTaskTracker.instance().container();
      this.container.add(projectId, schema, tableName, columnInfoList);
      EncTaskTracker.instance().register(this.container);
   }

   public Map<String, Object> call() {
      Map var1;
      try {
         var1 = this.runTask();
      } finally {
         EncTaskTracker.instance().over(this.container.getTask());
      }

      return var1;
   }

   public Map<String, Object> runTask() {
      String loggerPath = System.getProperty("user.dir") + File.separator + "encryprocesslog" + File.separator + this.projectId + File.separator + this.dataSystemId;
      Logger encryptionlogger = (new LoggerBuilder()).getLogger(loggerPath, this.schema + "." + this.tableName);
      Thread.currentThread().setName("pool-" + this.tableName + "-thread");
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      encryptionlogger.info("启动执行线程！！");
      TCoreJiaMiJieMiJinDuDao tCoreJiaMiJieMiJinDuDao = (TCoreJiaMiJieMiJinDuDao)ApplicationContextProvider.getBean(TCoreJiaMiJieMiJinDuDao.class);
      TCoreEncryptionService tCoreEncryptionService = (TCoreEncryptionService)ApplicationContextProvider.getBean(TCoreEncryptionContext.class);
      HashMap<String, Object> resultMap = new HashMap();
      Boolean doresult = true;
      String selectSQL = "";
      String updateSQL = "";
      StringBuilder selectStrBuilder = new StringBuilder();
      StringBuilder updateStrBuilder = new StringBuilder();
      int cl = this.columnInfoList.size();
      StringBuilder addColumnString = new StringBuilder();
      StringBuilder addColumnStrings = new StringBuilder();
      Set<String> columnMap = JdbcTool.getColumnMap(this.connection, this.schema, this.tableName);
      int columnsCheckLength = this.getColumnsCheckLength(this.tCoreDatasystem.getDbtype(), this.schema, this.tableName);
      int max = 0;

      try {
         Properties properties = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String property = properties.getProperty("encryption.field.max");
         if (property != null && property.length() > 0) {
            max = Integer.valueOf(property.trim());
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      for(int i = 0; i < this.columnInfoList.size(); ++i) {
         this.columnName = ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName();
         this.columnType = ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnType();
         this.columnSize = ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnSize();
         int columnLength = Integer.parseInt(this.columnSize);
         if (max > 0 && Integer.parseInt(this.columnSize) >= max) {
            this.columnSize = String.valueOf(max);
         }

         String columnName = ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName();
         resultMap = this.checkTableColumnLength(resultMap, this.tCoreDatasystem.getDbtype(), columnName, columnsCheckLength, columnLength);
         if (!CollectionUtils.isEmpty(resultMap)) {
            return resultMap;
         }

         tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, columnName, "-2");
         String columNamecopy = columnName + this.copySuffix;
         if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
            columNamecopy = "\"" + columNamecopy + "\"";
         }

         if (this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString())) {
            columNamecopy = "\"" + columNamecopy + "\"";
         }

         if (this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
            columNamecopy = "\"" + columNamecopy + "\"";
         }

         if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
            columNamecopy = "\"" + columNamecopy + "\"";
         }

         if (this.tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
            columNamecopy = "\"" + columNamecopy + "\"";
         }

         String columnSizestr = "";
         if ("VARCHAR2".equalsIgnoreCase(this.columnType) || "varchar".equalsIgnoreCase(this.columnType) || "char".equalsIgnoreCase(this.columnType)) {
            columnSizestr = "(" + this.columnSize + ")";
         }

         boolean isupk = false;
         if (isupk) {
            columnSizestr = columnSizestr + " not null ";
         }

         String copyColumn = columnName + this.copySuffix;
         if (!columnMap.contains(copyColumn) && !columnMap.contains(columNamecopy)) {
            if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
               addColumnStrings.append(columNamecopy).append(",");
               addColumnString.append(" add ").append(columNamecopy).append(" ").append(this.columnType).append(columnSizestr).append(" ");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString())) {
               addColumnStrings.append(columNamecopy).append(",");
               addColumnString.append(" add ").append(columNamecopy).append(" ").append(this.columnType).append(columnSizestr).append(",");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
               addColumnStrings.append(columNamecopy).append(",");
               addColumnString.append(" add ").append(columNamecopy).append(" ").append(this.columnType).append(columnSizestr).append(",");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
               addColumnStrings.append(columNamecopy).append(",");
               if (i == 0) {
                  addColumnString.append(" add ");
               }

               addColumnString.append(columNamecopy).append(" ").append(this.columnType).append(columnSizestr).append(",");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
               addColumnStrings.append(columNamecopy).append(",");
               addColumnString.append(columNamecopy).append(" ").append(this.columnType).append(columnSizestr).append(",");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
               columnSizestr = columnSizestr.indexOf("2147483647") > -1 ? "" : columnSizestr;
               addColumnStrings.append(columNamecopy).append(",");
               addColumnString.append(columNamecopy).append(" ").append(this.columnType).append(columnSizestr).append(",");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
               columnSizestr = columnSizestr.indexOf("2147483647") > -1 ? "" : columnSizestr;
               addColumnStrings.append(columNamecopy).append(",");
               addColumnString.append(" add ").append(columNamecopy).append(" ").append(this.columnType).append(columnSizestr).append("; ALTER TABLE ").append(this.schema).append(".").append(this.tableName);
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
               addColumnStrings.append(columNamecopy).append(",");
               addColumnString.append(columNamecopy).append(" ").append(this.columnType).append(columnSizestr).append(" ");
            } else {
               addColumnStrings.append(columNamecopy).append(",");
               addColumnString.append(" add ").append(columNamecopy).append(" ").append(this.columnType).append(columnSizestr).append(",");
            }
         }

         if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
            selectStrBuilder.append("\"" + columnName + "\"").append(",");
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString())) {
            selectStrBuilder.append("\"" + columnName + "\"").append(",");
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
            selectStrBuilder.append("\"" + columnName + "\"").append(",");
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
            selectStrBuilder.append(columnName).append(",");
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
            selectStrBuilder.append(columnName).append(",");
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
            selectStrBuilder.append("\"" + columnName + "\"").append(",");
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
            selectStrBuilder.append("\"" + columnName + "\"").append(",");
         } else {
            selectStrBuilder.append(columnName).append(",");
         }

         updateStrBuilder.append(columNamecopy).append("=?,");
      }

      if (addColumnString.length() > 0) {
         addColumnString = addColumnString.deleteCharAt(addColumnString.length() - 1);
      }

      try {
         if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
            this.addTableField(this.connection, "\"" + this.schema + "\"", "\"" + this.tableName + "\"", addColumnStrings, addColumnString, encryptionlogger, this.tCoreDatasystem);
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString())) {
            this.addTableField(this.connection, "\"" + this.schema + "\"", "\"" + this.tableName + "\"", addColumnStrings, addColumnString, encryptionlogger, this.tCoreDatasystem);
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
            this.addTableField(this.connection, "\"" + this.schema + "\"", "\"" + this.tableName + "\"", addColumnStrings, addColumnString, encryptionlogger, this.tCoreDatasystem);
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
            this.addTableField(this.connection, this.schema, this.tableName, addColumnStrings, addColumnString, encryptionlogger, this.tCoreDatasystem);
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
            this.addTableField(this.connection, this.schema, this.tableName, addColumnStrings, addColumnString, encryptionlogger, this.tCoreDatasystem);
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
            this.addTableField(this.connection, "\"" + this.schema + "\"", "\"" + this.tableName + "\"", addColumnStrings, addColumnString, encryptionlogger, this.tCoreDatasystem);
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
            this.addTableField(this.connection, "\"" + this.schema + "\"", "\"" + this.tableName + "\"", addColumnStrings, addColumnString, encryptionlogger, this.tCoreDatasystem);
         } else {
            this.addTableField(this.connection, this.schema, this.tableName, addColumnStrings, addColumnString, encryptionlogger, this.tCoreDatasystem);
         }
      } catch (SQLException e) {
         encryptionlogger.error(e.getMessage());
      }

      TCoreJiaMiJieMiJinDu tCoreJiaMiJieMiJin1 = new TCoreJiaMiJieMiJinDu();
      List<TCoreJiaMiJieMiJinDu> tCoreJiaMiJieMiJinList1 = tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinDu(this.dataSystemId, this.projectId, this.schema, this.tableName, "0");
      int cpp1 = tCoreJiaMiJieMiJinList1.size();
      if (cpp1 > 0) {
         for(int npp1 = 0; npp1 < cpp1; ++npp1) {
            tCoreJiaMiJieMiJin1 = (TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList1.get(npp1);
         }
      }

      if (null != tCoreJiaMiJieMiJin1) {
         tCoreJiaMiJieMiJinDuDao.remove(tCoreJiaMiJieMiJin1);
      }

      List<TCoreJiaMiJieMiJinDu> tCoreJiaList = tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinDu(this.dataSystemId, this.projectId, this.schema, this.tableName, "1");
      int cpppppp = tCoreJiaList.size();
      if (cpppppp == 0) {
         TCoreJiaMiJieMiJinDu tCoreJiaMiJieMiJinDu = new TCoreJiaMiJieMiJinDu();
         tCoreJiaMiJieMiJinDu.setProjectid(this.projectId);
         tCoreJiaMiJieMiJinDu.setDatasystemid(this.dataSystemId);
         tCoreJiaMiJieMiJinDu.setSchemahh(this.schema);
         tCoreJiaMiJieMiJinDu.setTablename(this.tableName);
         tCoreJiaMiJieMiJinDu.setFlag("1");
         tCoreJiaMiJieMiJinDuDao.save(tCoreJiaMiJieMiJinDu);
      }

      if (this.primaryKeys.length > 0) {
         for(int i = 0; i < this.primaryKeys.length; ++i) {
            if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
               selectStrBuilder.append("\"" + this.primaryKeys[i] + "\"").append(",");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString())) {
               selectStrBuilder.append("\"" + this.primaryKeys[i] + "\"").append(",");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
               selectStrBuilder.append("\"" + this.primaryKeys[i] + "\"").append(",");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
               selectStrBuilder.append(this.primaryKeys[i]).append(",");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE.toString())) {
               selectStrBuilder.append(this.primaryKeys[i]).append(",");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
               selectStrBuilder.append(this.primaryKeys[i]).append(",");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
               selectStrBuilder.append("\"" + this.primaryKeys[i] + "\"").append(",");
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
               selectStrBuilder.append("\"" + this.primaryKeys[i] + "\"").append(",");
            } else {
               selectStrBuilder.append(this.primaryKeys[i]).append(",");
            }
         }
      }

      selectStrBuilder.deleteCharAt(selectStrBuilder.length() - 1);
      if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
         String substring = selectStrBuilder.toString();
         String[] arr = substring.split(",");
         List list = new ArrayList();

         for(int i = 0; i < arr.length; ++i) {
            String s = arr[i].trim();
            if (!list.contains(s)) {
               list.add(s);
            }
         }

         substring = StringUtils.strip(list.toString(), "[]");
         selectStrBuilder.setLength(0);
         selectStrBuilder.append(substring);
      }

      if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
         selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + this.schema + "\".\"" + this.tableName + "\"";
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString())) {
         selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + this.schema + "\".\"" + this.tableName + "\"";
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
         selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + this.schema + "\".\"" + this.tableName + "\"";
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
         selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM " + this.schema + "." + this.tableName;
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE.toString())) {
         selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM " + this.schema + "." + this.tableName;
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
         selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM " + this.schema + "." + this.tableName;
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
         selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + this.schema + "\".\"" + this.tableName + "\"";
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
         selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM \"" + this.schema + "\".\"" + this.tableName + "\"";
      } else {
         selectSQL = "SELECT " + selectStrBuilder.toString() + " FROM " + this.schema + "." + this.tableName;
      }

      updateStrBuilder.deleteCharAt(updateStrBuilder.length() - 1);
      if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
         updateSQL = "UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET " + updateStrBuilder.toString();
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString())) {
         updateSQL = "UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET " + updateStrBuilder.toString();
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
         updateSQL = "UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET " + updateStrBuilder.toString();
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
         updateSQL = "UPDATE " + this.schema + "." + this.tableName + " SET " + updateStrBuilder.toString();
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE.toString())) {
         updateSQL = "UPDATE " + this.schema + "." + this.tableName + " SET " + updateStrBuilder.toString();
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
         updateSQL = "UPDATE " + this.schema + "." + this.tableName + " SET " + updateStrBuilder.toString();
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
         updateSQL = "UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET " + updateStrBuilder.toString();
      } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
         updateSQL = "UPDATE \"" + this.schema + "\".\"" + this.tableName + "\" SET " + updateStrBuilder.toString();
      } else {
         updateSQL = "UPDATE " + this.schema + "." + this.tableName + " SET " + updateStrBuilder.toString();
      }

      int count = 0;
      if (this.primaryKeys.length > 0) {
         updateSQL = updateSQL + " WHERE ";

         for(int i = 0; i < this.primaryKeys.length; ++i) {
            if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
               updateSQL = updateSQL + "\"" + this.primaryKeys[i] + "\"=? ";
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString())) {
               updateSQL = updateSQL + "\"" + this.primaryKeys[i] + "\"=? ";
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
               updateSQL = updateSQL + "\"" + this.primaryKeys[i] + "\"=? ";
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
               updateSQL = updateSQL + this.primaryKeys[i] + "=? ";
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE.toString())) {
               updateSQL = updateSQL + this.primaryKeys[i] + "=? ";
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
               updateSQL = updateSQL + this.primaryKeys[i] + "=? ";
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
               updateSQL = updateSQL + "\"" + this.primaryKeys[i] + "\"=? ";
            } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
               updateSQL = updateSQL + "\"" + this.primaryKeys[i] + "\"=? ";
            } else {
               updateSQL = updateSQL + this.primaryKeys[i] + "=? ";
            }

            ++count;
            if (count < this.primaryKeys.length) {
               updateSQL = updateSQL + " AND ";
            }
         }
      }

      PreparedStatement stmt = null;
      ResultSet rs = null;
      ResultSet rsCount = null;
      PreparedStatement pstmt = null;
      Connection selcon = null;
      int bacthMaxCount = 10000;
      int curBacthCount = 0;

      try {
         this.connection.setAutoCommit(false);
         selcon = JdbcTool.getConnection(this.tCoreDatasystem);
         selcon.setAutoCommit(false);
         String sqlp = this.getSqlPaging(selectStrBuilder.toString(), selectSQL);
         stmt = selcon.prepareStatement(sqlp, 1003, 1007);
         stmt.setFetchSize(10);
         rs = stmt.executeQuery();
         Map<String, String> mt = new HashMap();
         ResultSetMetaData rsMetadata = rs.getMetaData();
         int countMT = rsMetadata.getColumnCount();

         for(int i = 1; i < countMT + 1; ++i) {
            String columnNameCol = rsMetadata.getColumnLabel(i);
            String columnTypeCol = rsMetadata.getColumnTypeName(i);
            if (!mt.containsKey(columnNameCol)) {
               mt.put(columnNameCol, columnTypeCol);
            }
         }

         Statement stmtCount = null;
         stmtCount = this.connection.createStatement();
         encryptionlogger.info("执行查询SQL：" + selectSQL);
         String selectCountTable = "";
         if (this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
            selectCountTable = "select count(*) as \"table_rows\" from \"" + this.schema + "\".\"" + this.tableName + "\"";
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString())) {
            selectCountTable = "select count(*) as \"table_rows\" from \"" + this.schema + "\".\"" + this.tableName + "\"";
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
            selectCountTable = "select count(*) as \"table_rows\" from \"" + this.schema + "\".\"" + this.tableName + "\"";
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
            selectCountTable = "select count(*) as table_rows from " + this.schema + "." + this.tableName;
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE.toString())) {
            selectCountTable = "select count(*) as table_rows from " + this.schema + "." + this.tableName;
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
            selectCountTable = "select count(*) as table_rows from " + this.schema + "." + this.tableName;
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
            selectCountTable = "select count(*) as \"table_rows\" from \"" + this.schema + "\".\"" + this.tableName + "\"";
         } else if (this.tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
            selectCountTable = "select count(*) as \"table_rows\" from \"" + this.schema + "\".\"" + this.tableName + "\"";
         } else {
            selectCountTable = "select count(*) as table_rows from " + this.schema + "." + this.tableName;
         }

         for(rsCount = stmtCount.executeQuery(selectCountTable); rsCount.next(); this.jiamiTasktotalCounts = rsCount.getInt("table_rows")) {
         }

         if (rsCount != null) {
            try {
               rsCount.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

         TCoreJiaMiJieMiJinDu tCoreJiaMiJieMiJin = new TCoreJiaMiJieMiJinDu();
         List<TCoreJiaMiJieMiJinDu> tCoreJiaMiJieMiJinList = tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinDu(this.dataSystemId, this.projectId, this.schema, this.tableName, "1");
         int cpp = tCoreJiaMiJieMiJinList.size();
         if (cpp > 0) {
            for(int npp = 0; npp < cpp; ++npp) {
               tCoreJiaMiJieMiJin = (TCoreJiaMiJieMiJinDu)tCoreJiaMiJieMiJinList.get(npp);
            }
         }

         if (null != tCoreJiaMiJieMiJin) {
            tCoreJiaMiJieMiJin.setTotalcounts(this.jiamiTasktotalCounts);
            tCoreJiaMiJieMiJin.setStarttime(new Date());
            tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJieMiJin);
         }

         Boolean bh = false;
         if (this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString())) {
            bh = true;
         }

         pstmt = this.connection.prepareStatement(updateSQL);

         label1487:
         while(true) {
            ResultSet rs1;
            while(true) {
               if (!this.isKeepReadData) {
                  break label1487;
               }

               PreparedStatement tableDataStatement = null;
               String sql1 = selectStrBuilder.toString();
               String sqlPaging = null;
               if (this.tCoreDatasystem.getDbtype().equals(EdbType.DB2.toString())) {
                  sqlPaging = "SELECT " + sql1 + " FROM ( select row_number() over() as RN ,TT.* FROM  (" + selectSQL + " ) TT ) where RN>" + this.startRow + " AND RN <= " + (this.startRow + this.maxPackageCount);
               } else if (!this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString()) && !this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                  if (this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString())) {
                     sqlPaging = selectSQL + " offset " + this.startRow + " limit " + this.maxPackageCount;
                  } else if (EdbType.GREENPLUM.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
                     sqlPaging = selectSQL + " limit " + this.maxPackageCount + " OFFSET " + this.startRow;
                  } else if (!EdbType.MYSQL.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.KINGBASE.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.GAUSS.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.HIVE.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.MARIADB.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.HIVE_TDH.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
                     if (EdbType.MSSQLSERVER.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
                        sqlPaging = selectSQL + " ORDER BY " + sql1 + " OFFSET " + this.startRow + " ROWS FETCH NEXT " + this.maxPackageCount + " ROWS ONLY";
                     }
                  } else {
                     sqlPaging = selectSQL + " limit " + this.startRow + "," + this.maxPackageCount;
                  }
               } else {
                  sqlPaging = "SELECT " + sql1 + " FROM ( select ROWNUM RN ,TT.* FROM  (" + selectSQL + " ) TT ) where RN>" + this.startRow + " AND RN <= " + (this.startRow + this.maxPackageCount);
               }

               this.startRow += this.maxPackageCount;
               System.out.println("-------- 读取数据SQL：" + sqlPaging);
               if (EdbType.MSSQLSERVER.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
                  tableDataStatement = this.connection.prepareStatement(sqlPaging, 1004, 1007);
               } else {
                  tableDataStatement = this.connection.prepareStatement(sqlPaging, 1004, 1008);
               }

               tableDataStatement.setFetchSize(100000);
               rs1 = tableDataStatement.executeQuery();
               if (!this.isCanKeepRead(rs1)) {
                  this.isKeepReadData = false;
                  break label1487;
               }

               if (!"HIVE".equals(this.tCoreDatasystem.getDbtype()) && !"HIVE_TDH".equals(this.tCoreDatasystem.getDbtype())) {
                  break;
               }

               if (!rs1.next()) {
                  break label1487;
               }

               for(int i = 0; i < this.columnInfoList.size(); ++i) {
                  String secretkeyId = ((ColumnInfoVO)this.columnInfoList.get(i)).getSecretKeyId();
                  String encryptionType = ((ColumnInfoVO)this.columnInfoList.get(i)).getEncryptionType();
                  String secretKey = ((ColumnInfoVO)this.columnInfoList.get(i)).getSecretKey();
                  String isLike = ((ColumnInfoVO)this.columnInfoList.get(i)).getIsLike();
                  String value = rs1.getString(((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName());
                  String keepfirst = ((ColumnInfoVO)this.columnInfoList.get(i)).getKeepfirst();
                  String encdigit = ((ColumnInfoVO)this.columnInfoList.get(i)).getEncdigit();
                  String twoindex = ((ColumnInfoVO)this.columnInfoList.get(i)).getTwoindex();
                  value = this.doDecryptionMethod(encryptionType, secretKey, value, isLike, keepfirst, encdigit, twoindex);
                  pstmt.setString(i + 1, value);
               }

               for(int i = 0; i < this.primaryKeys.length; ++i) {
                  if (bh) {
                     String cname = this.primaryKeys[i];
                     com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO columnInfoVO = (com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO)this.allColumnList.stream().filter((c) -> c.getColumnname().equals(cname)).findFirst().get();
                     if (columnInfoVO.getTypename().toLowerCase(Locale.ROOT).contains("int")) {
                        pstmt.setInt(this.columnInfoList.size() + i + 1, Integer.parseInt(rs1.getString(this.primaryKeys[i])));
                     } else {
                        pstmt.setString(this.columnInfoList.size() + i + 1, rs1.getString(this.primaryKeys[i]));
                     }
                  } else {
                     pstmt.setString(this.columnInfoList.size() + i + 1, rs1.getString(this.primaryKeys[i]));
                  }
               }

               pstmt.addBatch();
               ++this.jiamiTaskFinishCounts;
               ++curBacthCount;
               if (curBacthCount != bacthMaxCount) {
                  break;
               }

               try {
                  pstmt.executeBatch();
                  this.connection.commit();
               } catch (Exception t) {
                  encryptionlogger.error(t.getMessage());
                  encryptionlogger.warn("提交到" + this.jiamiTaskFinishCounts + "行，执行异常!");
                  encryptionlogger.warn("{}行解密数据提交失败!", curBacthCount);
                  if (null != tCoreJiaMiJieMiJin) {
                     tCoreJiaMiJieMiJin.setExceptionstring(t.toString());
                     tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJieMiJin);
                  }

                  doresult = false;
                  TCoreJiaMiJieMiJinDu tCoreJiaMiJie = new TCoreJiaMiJieMiJinDu();
                  List<TCoreJiaMiJieMiJinDu> tCoreJiaMiJieList = tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinDu(this.dataSystemId, this.projectId, this.schema, this.tableName, "1");
                  int cpplll = tCoreJiaMiJieList.size();
                  if (cpplll > 0) {
                     for(int npplll = 0; npplll < cpplll; ++npplll) {
                        tCoreJiaMiJie = (TCoreJiaMiJieMiJinDu)tCoreJiaMiJieList.get(npplll);
                     }
                  }

                  tCoreJiaMiJie.setState("-1");
                  this.jiamiTaskFinishCounts -= curBacthCount;
                  tCoreJiaMiJieMiJin.setFinishcounts(this.jiamiTaskFinishCounts);
                  tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJie);
                  curBacthCount = 0;
                  continue;
               }

               curBacthCount = 0;
               if (null != tCoreJiaMiJieMiJin && doresult) {
                  tCoreJiaMiJieMiJin.setFinishcounts(this.jiamiTaskFinishCounts);
                  tCoreJiaMiJieMiJin.setState("0");
                  tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJieMiJin);
               }

               encryptionlogger.info("解密完成行数为：" + this.jiamiTaskFinishCounts);
               break;
            }

            while(true) {
               while(true) {
                  if (!rs1.next()) {
                     continue label1487;
                  }

                  for(int i = 0; i < this.columnInfoList.size(); ++i) {
                     String secretkeyId = ((ColumnInfoVO)this.columnInfoList.get(i)).getSecretKeyId();
                     String encryptionType = ((ColumnInfoVO)this.columnInfoList.get(i)).getEncryptionType();
                     String secretKey = ((ColumnInfoVO)this.columnInfoList.get(i)).getSecretKey();
                     String isLike = ((ColumnInfoVO)this.columnInfoList.get(i)).getIsLike();
                     String value = rs1.getString(((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName());
                     String keepfirst = ((ColumnInfoVO)this.columnInfoList.get(i)).getKeepfirst();
                     String encdigit = ((ColumnInfoVO)this.columnInfoList.get(i)).getEncdigit();
                     String twoindex = ((ColumnInfoVO)this.columnInfoList.get(i)).getTwoindex();
                     value = this.doDecryptionMethod(encryptionType, secretKey, value, isLike, keepfirst, encdigit, twoindex);
                     pstmt.setString(i + 1, value);
                  }

                  for(int i = 0; i < this.primaryKeys.length; ++i) {
                     if (bh) {
                        String cname = this.primaryKeys[i];
                        com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO columnInfoVO = (com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO)this.allColumnList.stream().filter((c) -> c.getColumnname().equals(cname)).findFirst().get();
                        if (columnInfoVO.getTypename().toLowerCase(Locale.ROOT).contains("int")) {
                           pstmt.setInt(this.columnInfoList.size() + i + 1, Integer.parseInt(rs1.getString(this.primaryKeys[i])));
                        } else {
                           pstmt.setString(this.columnInfoList.size() + i + 1, rs1.getString(this.primaryKeys[i]));
                        }
                     } else {
                        pstmt.setString(this.columnInfoList.size() + i + 1, rs1.getString(this.primaryKeys[i]));
                     }
                  }

                  pstmt.addBatch();
                  ++this.jiamiTaskFinishCounts;
                  ++curBacthCount;
                  if (curBacthCount == bacthMaxCount) {
                     try {
                        pstmt.executeBatch();
                        this.connection.commit();
                        break;
                     } catch (Exception t) {
                        encryptionlogger.error(t.getMessage());
                        encryptionlogger.warn("提交到" + this.jiamiTaskFinishCounts + "行，执行异常!");
                        encryptionlogger.warn("{}行解密数据提交失败!", curBacthCount);
                        if (null != tCoreJiaMiJieMiJin) {
                           tCoreJiaMiJieMiJin.setExceptionstring(t.toString());
                           tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJieMiJin);
                        }

                        doresult = false;
                        TCoreJiaMiJieMiJinDu tCoreJiaMiJie = new TCoreJiaMiJieMiJinDu();
                        List<TCoreJiaMiJieMiJinDu> tCoreJiaMiJieList = tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinDu(this.dataSystemId, this.projectId, this.schema, this.tableName, "1");
                        int cpplll = tCoreJiaMiJieList.size();
                        if (cpplll > 0) {
                           for(int npplll = 0; npplll < cpplll; ++npplll) {
                              tCoreJiaMiJie = (TCoreJiaMiJieMiJinDu)tCoreJiaMiJieList.get(npplll);
                           }
                        }

                        tCoreJiaMiJie.setState("-1");
                        this.jiamiTaskFinishCounts -= curBacthCount;
                        tCoreJiaMiJieMiJin.setFinishcounts(this.jiamiTaskFinishCounts);
                        tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJie);
                        curBacthCount = 0;
                     }
                  }
               }

               curBacthCount = 0;
               if (null != tCoreJiaMiJieMiJin && doresult) {
                  tCoreJiaMiJieMiJin.setFinishcounts(this.jiamiTaskFinishCounts);
                  tCoreJiaMiJieMiJin.setState("0");
                  tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJieMiJin);
               }

               encryptionlogger.info("解密完成行数为：" + this.jiamiTaskFinishCounts);
            }
         }

         if (curBacthCount > 0) {
            try {
               pstmt.executeBatch();
               this.connection.commit();
            } catch (Exception e) {
               encryptionlogger.error(e.getMessage());
               encryptionlogger.warn("提交到" + this.jiamiTaskFinishCounts + "行，执行异常!");
               encryptionlogger.warn("{}行解密数据提交失败!", curBacthCount);
               if (null != tCoreJiaMiJieMiJin) {
                  tCoreJiaMiJieMiJin.setExceptionstring(e.toString());
                  tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJieMiJin);
               }

               doresult = false;
               TCoreJiaMiJieMiJinDu tCoreJiaMiJie = new TCoreJiaMiJieMiJinDu();
               List<TCoreJiaMiJieMiJinDu> tCoreJiaMiJieList = tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinDu(this.dataSystemId, this.projectId, this.schema, this.tableName, "1");
               int cpplll = tCoreJiaMiJieList.size();
               if (cpplll > 0) {
                  for(int npplll = 0; npplll < cpplll; ++npplll) {
                     tCoreJiaMiJie = (TCoreJiaMiJieMiJinDu)tCoreJiaMiJieList.get(npplll);
                  }
               }

               tCoreJiaMiJie.setState("-1");
               tCoreJiaMiJieMiJin.setFinishcounts(this.jiamiTaskFinishCounts - curBacthCount);
               this.failCount += curBacthCount;
               tCoreJiaMiJieMiJin.setFailcounts(this.failCount);
               tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJie);
            }
         } else {
            this.connection.commit();
         }

         String flag = doresult ? "6" : "44";
         encryptionlogger.info("解密完成！");
         encryptionlogger.info("解密完成总行数：" + this.jiamiTaskFinishCounts);

         for(int i = 0; i < this.columnInfoList.size(); ++i) {
            String columnName = ((ColumnInfoVO)this.columnInfoList.get(i)).getColumnName();
            tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, columnName, flag);
         }

         if (null != tCoreJiaMiJieMiJin && doresult) {
            tCoreJiaMiJieMiJin.setFinishcounts(this.jiamiTaskFinishCounts);
            tCoreJiaMiJieMiJin.setState("1");
            tCoreJiaMiJieMiJin.setEndtime(new Date());
            tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJieMiJin);
         }
      } catch (Exception e) {
         encryptionlogger.error(e.getMessage());
         encryptionlogger.warn("提交到" + this.jiamiTaskFinishCounts + "行，执行异常!");
         tCoreEncryptionService.updateFlag(this.projectId, this.dataSystemId, this.schema, this.tableName, this.columnName, "44");

         try {
            this.connection.rollback();
         } catch (SQLException ex) {
            ex.printStackTrace();
         }

         TCoreJiaMiJieMiJinDu tCoreJiaMiJie = new TCoreJiaMiJieMiJinDu();
         List<TCoreJiaMiJieMiJinDu> tCoreJiaMiJieList = tCoreJiaMiJieMiJinDuDao.queryTCoreJiaMiJieMiJinDu(this.dataSystemId, this.projectId, this.schema, this.tableName, "1");
         int cpplll = tCoreJiaMiJieList.size();
         if (cpplll > 0) {
            for(int npplll = 0; npplll < cpplll; ++npplll) {
               tCoreJiaMiJie = (TCoreJiaMiJieMiJinDu)tCoreJiaMiJieList.get(npplll);
            }
         }

         tCoreJiaMiJie.setState("-1");
         this.failCount += curBacthCount;
         tCoreJiaMiJie.setFailcounts(this.failCount);
         tCoreJiaMiJieMiJinDuDao.update(tCoreJiaMiJie);
      } finally {
         if (this.connection != null) {
            try {
               this.connection.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

         if (selcon != null) {
            try {
               selcon.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

         if (stmt != null) {
            try {
               stmt.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

         if (rs != null) {
            try {
               rs.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

         if (rsCount != null) {
            try {
               rsCount.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

         if (pstmt != null) {
            try {
               pstmt.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

      }

      return resultMap;
   }

   private HashMap<String, Object> checkTableColumnLength(HashMap<String, Object> resultMap, String dbType, String columnName, int columnsCheckLength, int columnLength) {
      switch (dbType) {
         case "MYSQL":
            columnsCheckLength += Integer.parseInt(this.columnSize) * 4;
            if (columnsCheckLength > 65000) {
               resultMap.put(CHECK_COLUMN, CHECK_ALL_COLUMN_OUT_OF_RANGE);
            }
            break;
         case "MSSQLSERVER":
            columnsCheckLength += Integer.parseInt(this.columnSize);
            if (columnsCheckLength > 8060) {
               resultMap.put(CHECK_COLUMN, CHECK_ALL_COLUMN_OUT_OF_RANGE);
            }
      }

      return resultMap;
   }

   public int getColumnsCheckLength(String dbType, String schema, String tableName) {
      String sqlColumnLength = "";
      ResultSet resultSet = null;

      try {
         switch (dbType) {
            case "MYSQL":
               sqlColumnLength = "select sum(T.CHARACTER_OCTET_LENGTH) as ALL_LENGTH  from information_schema.columns T  where TABLE_SCHEMA = '" + schema.toLowerCase(Locale.ROOT) + "' and TABLE_NAME = '" + tableName.toUpperCase(Locale.ROOT) + "' AND DATA_TYPE IN ('varchar','char')";
               break;
            case "ORACLE":
               sqlColumnLength = "SELECT SUM(DATA_LENGTH) AS ALL_LENGTH FROM  dba_tab_columns WHERE TABLE_NAME  = '" + tableName.toUpperCase(Locale.ROOT) + "' and OWNER  = '" + schema.toUpperCase(Locale.ROOT) + "' AND DATA_TYPE IN ('VARCHAR2','CHAR')";
               break;
            case "DM":
               sqlColumnLength = "select SUM(DATA_LENGTH) AS ALL_LENGTH \t\n from all_tab_columns a \n where a.owner = '" + schema.toUpperCase(Locale.ROOT) + "' and a.Table_Name = '" + tableName.toUpperCase(Locale.ROOT) + "' and data_type like '%CHAR%'";
               break;
            case "KINGBASE":
            case "POSTGRESQL":
            case "GAUSS":
               sqlColumnLength = "select SUM(character_octet_length) as ALL_LENGTH  from information_schema.columns  where TABLE_SCHEMA = '" + schema.toLowerCase(Locale.ROOT) + "' and TABLE_NAME = '" + tableName.toLowerCase(Locale.ROOT) + "' and data_type like '%char%' ";
               break;
            case "MSSQLSERVER":
               sqlColumnLength = "select SUM(CHARACTER_MAXIMUM_LENGTH) AS ALL_LENGTH from INFORMATION_SCHEMA.COLUMNS A  where A.TABLE_CATALOG = '" + schema.toLowerCase(Locale.ROOT) + "' and A.TABLE_NAME = '" + tableName.toLowerCase() + "' and DATA_TYPE like '%char%' and CHARACTER_OCTET_LENGTH > -1 ";
               break;
            case "HIVE_TDH":
               sqlColumnLength = "select SUM(column_length) AS ALL_LENGTH from `system`.`columns_v`  where `database_name` = '" + schema.toLowerCase(Locale.ROOT) + "' and table_name = '" + tableName.toLowerCase() + "' and column_type like '%char%' ";
         }

         PreparedStatement preparedStatement = this.connection.prepareStatement(sqlColumnLength);
         resultSet = preparedStatement.executeQuery();
         String allLength = null;
         if (resultSet.next()) {
            allLength = resultSet.getString("ALL_LENGTH");
         }

         int var8 = StringUtils.isEmpty(allLength) ? 0 : Integer.parseInt(allLength);
         return var8;
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (resultSet != null) {
               resultSet.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return 0;
   }

   private String doDecryptionMethod(String encryptionType, String secretKey, String value, String isLike, String keepfirst, String encdigit, String twoindex) throws Exception {
      if (null != encryptionType && !"".equals(encryptionType) && value != null) {
         value = EncProvider.decryptEcb(encryptionType, secretKey, value, isLike, keepfirst, encdigit, twoindex);
      }

      return value;
   }

   private void addTableField(Connection con, String schema, String tableName, StringBuilder addColumnStrings, StringBuilder addColumnString, Logger encryptionlogger, TCoreDatasystem tCoreDatasystem) throws SQLException {
      if (null != addColumnString && addColumnString.length() > 0) {
         String sql = "";
         if (tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
            sql = "alter table " + schema + "." + tableName + "  add column(" + addColumnString + ")";
         } else if (tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
            sql = "alter table " + schema + "." + tableName + "  add column(" + addColumnString + ")";
         } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
            sql = "alter table " + schema + "." + tableName + " " + addColumnString;
         } else if (tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
            sql = "alter table " + schema + "." + tableName + "  add columns(" + addColumnString + ")";
         } else {
            sql = "alter table " + schema + "." + tableName + " " + addColumnString;
         }

         if (!tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
            PreparedStatement preStatement = con.prepareStatement(sql);
            preStatement.executeUpdate();
            preStatement.close();
         } else {
            Set<String> columnMap = JdbcTool.getColumnMap(con, schema, tableName);
            List<ColumnInfoVO> copys = new ArrayList();
            List<ColumnInfoVO> ciphers = new ArrayList();

            for(ColumnInfoVO c : this.columnInfoList) {
               String ccipher = c.getColumnName() + PropertyGhcaUtil.cipherSuffix;
               if (columnMap.contains(ccipher)) {
                  ciphers.add(c);
               } else {
                  copys.add(c);
               }
            }

            StringBuilder hiveAddColumnString = new StringBuilder();
            if (copys.size() > 0) {
               for(ColumnInfoVO c : copys) {
                  String hiveColumnNameCopy = c.getColumnName() + PropertyGhcaUtil.copySuffix;
                  if (!columnMap.contains(hiveColumnNameCopy)) {
                     String hiveColumnSize = c.getColumnSize();
                     hiveColumnSize = "(" + hiveColumnSize + ")";
                     hiveAddColumnString.append(hiveColumnNameCopy).append(" ").append(c.getColumnType()).append(hiveColumnSize).append(",");
                  }
               }

               if (addColumnString.length() > 0) {
                  hiveAddColumnString = hiveAddColumnString.deleteCharAt(hiveAddColumnString.length() - 1);
                  String hivesql = "alter table " + schema + "." + tableName + "  add columns(" + hiveAddColumnString + ")";
                  PreparedStatement preStatement = con.prepareStatement(hivesql);
                  preStatement.executeUpdate();
                  preStatement.close();
                  if (null != addColumnStrings) {
                     encryptionlogger.info("新增解密列完成：" + addColumnStrings + "  sql语句：" + sql);
                  }
               }
            }

            if (ciphers.size() > 0) {
               List<String> hiveSqlList = new ArrayList();

               for(ColumnInfoVO c : ciphers) {
                  String hivesql = "";
                  String hiveColumnNameCopy = c.getColumnName() + PropertyGhcaUtil.copySuffix;
                  if (!columnMap.contains(hiveColumnNameCopy)) {
                     String hiveColumnSize = c.getColumnSize();
                     hiveColumnSize = "(" + hiveColumnSize + ")";
                     hivesql = "ALTER TABLE " + schema + "." + tableName + "  change " + c.getColumnName() + PropertyGhcaUtil.cipherSuffix + " " + hiveColumnNameCopy + " " + c.getColumnType() + hiveColumnSize;
                     hiveSqlList.add(hivesql);
                  }
               }

               for(String s : hiveSqlList) {
                  PreparedStatement preStatement = con.prepareStatement(s);
                  preStatement.executeUpdate();
                  preStatement.close();
               }
            }
         }

         if (null != addColumnStrings) {
            encryptionlogger.info("新增解密列：" + addColumnStrings + "  sql语句：" + sql);
         }
      } else {
         encryptionlogger.info("解密要产生的中间列已经存在，无须新增。");
      }

   }

   private String checkDecryption(TCoreDatasystem tCoreDatasystem, ColumnInfoVO columnInfoVO, Logger encryptionlogger) {
      encryptionlogger.info("开始校验");
      ResultSet rsCount = null;
      int sumNum = 0;
      TCoreEncryptionService tCoreEncryptionService = (TCoreEncryptionService)ApplicationContextProvider.getBean(TCoreEncryptionContext.class);

      try {
         Connection conn = JdbcTool.getConnection(tCoreDatasystem);
         Throwable var8 = null;

         try {
            Statement stmt = conn.createStatement();
            Throwable var10 = null;

            try {
               Boolean bb = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
                  bb = false;
               }

               Boolean bbb = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString())) {
                  bbb = false;
               }

               Boolean SQBoolean = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                  SQBoolean = false;
               }

               Boolean DMBoolean = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                  DMBoolean = false;
               }

               String selectCountTable = "";
               if (bb) {
                  selectCountTable = "select count(*) as \"table_rows\" from \"" + this.schema + "\".\"" + this.tableName + "\"";
               } else if (bbb) {
                  selectCountTable = "select count(*) as \"table_rows\" from \"" + this.schema + "\".\"" + this.tableName + "\"";
               } else if (SQBoolean) {
                  selectCountTable = "select count(*) as table_rows from " + this.schema + "." + this.tableName;
               } else if (DMBoolean) {
                  selectCountTable = "select count(*) as \"table_rows\" from \"" + this.schema + "\".\"" + this.tableName + "\"";
               } else {
                  selectCountTable = "select count(*) as table_rows from " + this.schema + "." + this.tableName;
               }

               for(ResultSet var140 = stmt.executeQuery(selectCountTable); var140.next(); sumNum = var140.getInt("table_rows")) {
               }

               int checkNum = Integer.valueOf(this.props.getProperty("checkNum"));
               int pageSize = 0;
               int limitCount = checkNum;
               pageSize = sumNum / checkNum;
               int tmpPage = 0;
               tmpPage = sumNum % checkNum == 0 ? 0 : 1;
               int var10000 = pageSize + tmpPage;
               int iCLimitCount = 0;
               int iCLimitCount1 = checkNum;
               ResultSet rsC = null;

               String tmpPage1;
               try {
                  if (bb) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + this.schema + "\".\"" + this.tableName + "\" WHERE \"" + this.columnName + "\" IS NOT NULL AND \"" + this.columnName + this.copySuffix + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + iCLimitCount1 + ")");
                  } else if (bbb) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + this.schema + "." + this.tableName + " WHERE " + this.columnName + " IS NOT NULL AND (" + this.columnName + this.copySuffix + " IS NULL  ) offset " + iCLimitCount + " limit " + limitCount + " )t");
                  } else if (SQBoolean) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM (SELECT * FROM " + this.schema + "." + this.tableName + " WHERE " + this.columnName + " IS NOT NULL AND (" + this.columnName + this.copySuffix + " IS NULL  ) limit " + iCLimitCount + "," + limitCount + " )t");
                  } else if (DMBoolean) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + this.schema + "\".\"" + this.tableName + "\" WHERE \"" + this.columnName + "\" IS NOT NULL AND \"" + this.columnName + this.copySuffix + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + iCLimitCount1 + ")");
                  } else {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + this.schema + "." + this.tableName + " WHERE " + this.columnName + " IS NOT NULL AND (" + this.columnName + this.copySuffix + " IS NULL ) limit " + iCLimitCount + "," + limitCount + " )t");
                  }

                  int num;
                  for(num = 0; rsC.next(); num = rsC.getInt("num")) {
                  }

                  encryptionlogger.info("校验进度：" + (iCLimitCount1 > sumNum ? sumNum : iCLimitCount1));
                  if (num > 0) {
                     StringBuilder mg = new StringBuilder();
                     mg.append("数据源：");
                     mg.append(this.schema);
                     mg.append("表：");
                     mg.append(this.tableName);
                     mg.append("列：");
                     mg.append(this.columnName);
                     mg.append("解密后的数据为空，加密失败，准备回滚。");
                     tmpPage1 = mg.toString();
                     return tmpPage1;
                  }
               } catch (Exception e) {
                  e.printStackTrace();
               } finally {
                  if (rsC != null) {
                     try {
                        rsC.close();
                     } catch (SQLException e) {
                        e.printStackTrace();
                     }
                  }

               }

               int pageSize1 = 0;
               int limitCount1 = checkNum;
               pageSize1 = checkNum / checkNum;
               int tmpPage2 = 0;
               int LimitCount = 0;
               ResultSet rs1 = null;

               try {
                  String columnNameN;
                  try {
                     if (bb) {
                        rs1 = stmt.executeQuery("select nn.\"" + this.columnName + "\",nn.\"" + this.columnName + this.copySuffix + "\" from (select t.\"" + this.columnName + "\",t.\"" + this.columnName + this.copySuffix + "\",rownum rn from \"" + this.schema + "\".\"" + this.tableName + "\" t) nn where nn.rn>=" + iCLimitCount + "and nn.rn<" + limitCount1);
                     } else if (bbb) {
                        rs1 = stmt.executeQuery("select \"" + this.columnName + "\",\"" + this.columnName + this.copySuffix + "\" from \"" + this.schema + "\".\"" + this.tableName + "\" LIMIT " + limitCount1 + " OFFSET " + iCLimitCount);
                     } else if (SQBoolean) {
                        rs1 = stmt.executeQuery("SELECT " + this.columnName + "," + this.columnName + this.copySuffix + ", 0 AS _NAV_ORDER_F_ FROM " + this.schema + "." + this.tableName + " ORDER BY _NAV_ORDER_F_ OFFSET " + iCLimitCount + " ROWS FETCH NEXT " + limitCount1 + " ROWS ONLY");
                     } else if (DMBoolean) {
                        rs1 = stmt.executeQuery("select \"" + this.columnName + "\",\"" + this.columnName + this.copySuffix + "\" from \"" + this.schema + "\".\"" + this.tableName + "\" LIMIT " + iCLimitCount + "," + limitCount1);
                     } else {
                        rs1 = stmt.executeQuery(this.checkColumn(this.schema, this.tableName, this.columnName, this.columnName + this.copySuffix, iCLimitCount, limitCount1));
                     }

                     while(rs1.next()) {
                        String copy = rs1.getString(this.columnName + this.copySuffix);
                        if (null != copy) {
                           columnNameN = rs1.getString(this.columnName);
                           String secretKeyId = columnInfoVO.getSecretKeyId();
                           Map<String, String> encryptionInfo = tCoreEncryptionService.queryEncryptionInfo(secretKeyId);
                           if (null != encryptionInfo.get("encryptionType") && !"".equals(encryptionInfo.get("encryptionType"))) {
                              Boolean isEq = EncUtils.compareStringEq(columnNameN, EncProvider.encryptEcb((String)encryptionInfo.get("encryptionType"), (String)encryptionInfo.get("secretkey"), copy, columnInfoVO.getIsLike(), columnInfoVO.getKeepfirst(), columnInfoVO.getEncdigit(), columnInfoVO.getTwoindex()));
                              if (!isEq) {
                                 StringBuilder mg111 = new StringBuilder();
                                 mg111.append("数据源：");
                                 mg111.append(this.schema);
                                 mg111.append("表：");
                                 mg111.append(this.tableName);
                                 mg111.append("列：");
                                 mg111.append(this.columnName);
                                 mg111.append("解密后的数据加密后与元数据不一致，准备回滚。");
                                 String var34 = mg111.toString();
                                 return var34;
                              }
                           }
                        }
                     }
                  } catch (Exception e) {
                     e.printStackTrace();
                     encryptionlogger.info("校验出错，结束校验");
                     encryptionlogger.info("错误信息：" + e.getMessage());
                     columnNameN = "e1";
                     return columnNameN;
                  }
               } finally {
                  if (rs1 != null) {
                     try {
                        rs1.close();
                     } catch (SQLException e) {
                        e.printStackTrace();
                     }
                  }

               }
            } catch (Throwable var135) {
               var10 = var135;
               throw var135;
            } finally {
               if (stmt != null) {
                  if (var10 != null) {
                     try {
                        stmt.close();
                     } catch (Throwable var128) {
                        var10.addSuppressed(var128);
                     }
                  } else {
                     stmt.close();
                  }
               }

            }
         } catch (Throwable var137) {
            var8 = var137;
            throw var137;
         } finally {
            if (conn != null) {
               if (var8 != null) {
                  try {
                     conn.close();
                  } catch (Throwable var127) {
                     var8.addSuppressed(var127);
                  }
               } else {
                  conn.close();
               }
            }

         }
      } catch (Exception e) {
         e.printStackTrace();
         encryptionlogger.info("校验出错，结束校验");
         encryptionlogger.info("错误信息：" + e.getMessage());
         return "e2";
      }

      encryptionlogger.info("结束校验");
      return "ok";
   }

   private String checkColumn(String schema, String tableName, String columnName, String checkColumnName, int iCLimitCount, int limitCount) {
      String sql = String.format("SELECT %s,%s FROM %s.%s limit %s,%s", columnName, checkColumnName, schema, tableName, iCLimitCount, limitCount);
      return sql;
   }

   public void deleteCopyColumn(ColumnInfoVO columnInfoVo, String copySuffix, PreparedStatement stmt, Logger encryptionlogger) {
      this.updateFieldFlag(columnInfoVo.getTcoreencryptionfieldId(), "44");
      String rollback;
      if (!this.tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
         rollback = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\" DROP (\"" + this.columnName + copySuffix + "\")";
      } else if (!this.tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString())) {
         rollback = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\" DROP COLUMN \"" + this.columnName + copySuffix + "\"";
      } else if (!this.tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
         rollback = this.delCopyColumn(this.schema, this.tableName, this.columnName + copySuffix);
      } else if (!this.tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
         rollback = "ALTER TABLE \"" + this.schema + "\".\"" + this.tableName + "\" DROP COLUMN \"" + this.columnName + copySuffix + "\"";
      } else {
         rollback = this.delCopyColumn(this.schema, this.tableName, this.columnName + copySuffix);
      }

      encryptionlogger.info("解密出错，删除解密列：" + columnInfoVo.getColumnName());

      try {
         stmt.executeUpdate(rollback);
      } catch (SQLException var7) {
         encryptionlogger.info("删除解密列：" + columnInfoVo.getColumnName() + " 失败， sql语句：" + rollback);
      }

   }

   private int updateFieldFlag(String id, String flag) {
      int num = this.jdbcTemplate.update("UPDATE t_core_encryption_field SET flag = ? WHERE id = ?", new Object[]{flag, id});
      return num;
   }

   private String delCopyColumn(String schema, String tableName, String columnName) {
      String sql = String.format("ALTER TABLE %s.%s DROP COLUMN %s", schema, tableName, columnName);
      return sql;
   }

   private boolean isCanKeepRead(ResultSet rs) throws SQLException {
      boolean isCan = true;
      if (!"HIVE".equals(this.tCoreDatasystem.getDbtype()) && !"HIVE_TDH".equals(this.tCoreDatasystem.getDbtype())) {
         rs.last();
         if (rs.getRow() <= 0) {
            isCan = false;
         }

         rs.beforeFirst();
         System.out.println("isCanKeepRead方法:" + isCan);
         return isCan;
      } else {
         return true;
      }
   }

   public String getSqlPaging(String sql1, String sql2) {
      String sqlPaging111 = null;
      if (EdbType.DB2.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
         sqlPaging111 = "SELECT " + sql1 + " FROM ( select row_number() over() as RN ,TT.* FROM  (" + sql2 + " ) TT ) where RN>" + 1 + " AND RN <= " + 10;
      } else if (!EdbType.ORACLE.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.DM.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
         if (EdbType.POSTGRESQL.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
            sqlPaging111 = sql2 + " offset " + 1 + " limit " + 10;
         } else if (EdbType.GREENPLUM.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
            sqlPaging111 = sql2 + " limit " + 1 + " OFFSET " + 10;
         } else if (!EdbType.MYSQL.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.KINGBASE.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.GAUSS.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.HIVE.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.MARIADB.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype()) && !EdbType.HIVE_TDH.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
            if (EdbType.MSSQLSERVER.toString().equalsIgnoreCase(this.tCoreDatasystem.getDbtype())) {
               sqlPaging111 = sql2 + " ORDER BY " + sql1 + " OFFSET " + 1 + " ROWS FETCH NEXT " + 10 + " ROWS ONLY";
            }
         } else {
            sqlPaging111 = sql2 + " limit " + 1 + "," + 10;
         }
      } else {
         sqlPaging111 = "SELECT " + sql1 + " FROM ( select ROWNUM RN ,TT.* FROM  (" + sql2 + " ) TT ) where RN>" + 1 + " AND RN <= " + 10;
      }

      return sqlPaging111;
   }
}
