package com.chenyang.nse.bussiness.tools.dataprocess.hive.hdfs.format;

import com.chenyang.nse.bussiness.entity.db.ColumnInfo;
import com.chenyang.nse.bussiness.tools.dataprocess.hive.hdfs.TableInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Scanner;

public class TextFileReader extends HdfsFileReader {
   private final TableInfo table;
   private final byte[] buffer;
   private Scanner scanner;

   public TextFileReader(TableInfo table, byte[] buffer) {
      this.table = table;
      this.buffer = buffer;
   }

   public void load() throws IOException {
      ByteArrayInputStream stream = new ByteArrayInputStream(this.buffer);
      this.scanner = (new Scanner(stream)).useDelimiter(this.table.lineDelimiter);
   }

   public DataBatch next() throws IOException {
      boolean has = this.scanner.hasNext();
      if (!has) {
         return null;
      } else {
         String content = this.scanner.next();
         String[] data = content.split(this.table.sourceDelimiters);
         DataBatch batch = new DataBatch();
         DataBatch.DataRow row = new DataBatch.DataRow();

         for(int i = 0; i < this.table.cols.size(); ++i) {
            ColumnInfo columnInfo = (ColumnInfo)this.table.cols.get(i);
            DataBatch.DataCell cell = new DataBatch.DataCell();
            cell.column = columnInfo.getColumnname();
            DataBatch.DataValue value = new DataBatch.DataValue();
            value.value = i > data.length - 1 ? "" : data[i];
            cell.value = value;
            row.cells.add(cell);
         }

         batch.rows.add(row);
         return batch;
      }
   }
}
