package com.chenyang.nse.bussiness.tools.dmp;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.tools.command.CommandTool;
import com.chenyang.nse.bussiness.tools.datatime.DateTime1Tool;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class DmpGenerateTool {
   public static final int arraySize = 10000;
   public static final String STR_DATA_SEPARATOR = "#_#";
   static char[] map = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

   private static List<Integer> parsingDataByLine(List<String> colTypeList, String lineStr) {
      new StringBuffer();
      String doubleQuotation = "\"";
      List<Integer> lineIntList = new ArrayList();
      List<Integer> intColList = null;

      try {
         String[] lineStrArr = lineStr.split("#_#", -1);

         for(int i = 0; i < colTypeList.size(); ++i) {
            String colType = (String)colTypeList.get(i);
            String curColVal = lineStrArr[i];
            if (StringUtils.isBlank(curColVal)) {
               lineIntList.add(254);
               lineIntList.add(255);
            } else {
               curColVal = curColVal.replace(doubleQuotation, "");
               List<Integer> var11 = new ArrayList();
               if (!colType.equalsIgnoreCase("VARCHAR2") && !colType.equalsIgnoreCase("CHAR")) {
                  if (!colType.equalsIgnoreCase("NVARCHAR2") && !colType.equalsIgnoreCase("NCHAR")) {
                     if (!colType.equals("NUMBER") && !colType.equalsIgnoreCase("float")) {
                        if (colType.equals("DATE")) {
                           var11 = dateToDmpBtyeArr(curColVal);
                        } else if (colType.equalsIgnoreCase("TIMESTAMP")) {
                           var11 = timestampToDmpBtyeArr(curColVal);
                        } else if (colType.equalsIgnoreCase("LONG")) {
                           var11 = longToDmpBtyeArr(curColVal);
                        }
                     } else {
                        var11 = numberToDmpBtyeArr(curColVal);
                     }
                  } else {
                     var11 = nGbkToDmpBtyeArr(curColVal);
                  }
               } else {
                  var11 = gbkToDmpBtyeArr(curColVal);
               }

               if (0 == ((List)var11).size()) {
                  lineIntList.add(254);
                  lineIntList.add(255);
               } else {
                  lineIntList.add(((List)var11).size());
                  lineIntList.add(0);
               }

               lineIntList.addAll((Collection)var11);
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return lineIntList;
   }

   private static int binary16_10(String str) {
      return Integer.parseInt(str, 16);
   }

   private static List<Integer> gbkToDmpBtyeArr(String colValStr) {
      List<Integer> intColLst = new ArrayList();
      byte[] bs = null;

      try {
         char[] chars = colValStr.toCharArray();
         bs = colValStr.getBytes("gbk");

         for(int i = 0; i < bs.length; ++i) {
            intColLst.add(bs[i] & 255);
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return intColLst;
   }

   private static List<Integer> nGbkToDmpBtyeArr(String colValStr) {
      List<Integer> intColLst = new ArrayList();
      byte[] bs = null;
      char[] charArray = colValStr.toCharArray();

      try {
         for(char c : charArray) {
            if (c >= 913 && c <= '￥') {
               bs = colValStr.getBytes("utf-16");

               for(int i = 0; i < bs.length; ++i) {
                  intColLst.add(bs[i] & 255);
               }

               intColLst.remove(0);
               intColLst.remove(0);
               break;
            }

            if (c >= 0 && c <= 255) {
               bs = colValStr.getBytes("gbk");

               for(int i = 0; i < bs.length; ++i) {
                  intColLst.add(0);
                  intColLst.add(bs[i] & 255);
               }
               break;
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return intColLst;
   }

   private static List<Integer> dateToDmpBtyeArr(String colValStr) {
      List<Integer> intColLst = new ArrayList();
      Calendar calendar = Calendar.getInstance();
      String datefmt = "yyyy-MM-dd HH:mm:ss";
      SimpleDateFormat sdf = new SimpleDateFormat(datefmt);

      try {
         Date colDate = sdf.parse(colValStr);
         calendar.setTime(colDate);
         int year = calendar.get(1);
         int month = calendar.get(2) + 1;
         int date = calendar.get(5);
         int hour24 = calendar.get(11);
         int minute = calendar.get(12);
         int second = calendar.get(13);
         String year1 = String.valueOf(year).substring(0, 2);
         String year2 = String.valueOf(year).substring(2, 4);
         intColLst.add(Integer.valueOf(year1) + 100);
         intColLst.add(Integer.valueOf(year2) + 100);
         intColLst.add(month);
         intColLst.add(date);
         intColLst.add(hour24 + 1);
         intColLst.add(minute + 1);
         intColLst.add(second + 1);
      } catch (ParseException e) {
         e.printStackTrace();
      }

      return intColLst;
   }

   private static List<Integer> timestampToDmpBtyeArr(String colValStr) {
      List<Integer> timestampIntList = new ArrayList();
      new Timestamp(System.currentTimeMillis());
      String timestampPartOfMS = "";
      String timestampPartOfDate = "";
      if (StringUtils.isNotBlank(colValStr)) {
         String[] timestampArr = colValStr.split("\\.");
         timestampPartOfDate = timestampArr[0];
         timestampIntList = dateToDmpBtyeArr(timestampPartOfDate);
         if (timestampArr.length > 1) {
            timestampPartOfMS = timestampArr[1];
            String strHex = Integer.toHexString(Integer.valueOf(timestampPartOfMS));
            if (strHex.length() % 2 != 0) {
               strHex = "0" + strHex;
            }

            char[] strHexArr = strHex.toCharArray();

            for(int i = 0; i < strHexArr.length; i += 2) {
               timestampIntList.add(Integer.valueOf(strHexArr[i] + "" + strHexArr[i + 1], 16));
            }
         }
      }

      return timestampIntList;
   }

   private static List<Integer> numberToDmpBtyeArr(String colValStr) {
      List<Integer> intColLst = new ArrayList();
      Boolean positiveFlg = false;
      String intpart = "";

      try {
         if (0 == colValStr.indexOf("-")) {
            colValStr = colValStr.replaceFirst("-", "");
         } else {
            positiveFlg = true;
         }

         if (StringUtils.isNotBlank(colValStr) && -1 != colValStr.toUpperCase().indexOf("E")) {
            BigDecimal bd = new BigDecimal(colValStr);
            colValStr = bd.toPlainString();
         }

         if (positiveFlg) {
            if ("0".equals(colValStr)) {
               intColLst.add(128);
            } else if ("".equals(colValStr)) {
               intColLst.add(30);
            } else {
               List<Integer> positiveLst = new ArrayList();
               List<Integer> decimalList = new ArrayList();
               String[] numberStrArr = colValStr.split("\\.");
               intpart = numberStrArr[0];
               if ("0".equals(intpart)) {
                  positiveLst.add(192);
               } else {
                  if (0 != intpart.length() % 2) {
                     intpart = "0" + intpart;
                  }

                  char[] positiveCharArr = intpart.toCharArray();
                  int idx = positiveCharArr.length / 2 - 1;
                  int prefixNum = 193 + idx;
                  positiveLst.add(prefixNum);

                  for(int i = 0; i < positiveCharArr.length; i += 2) {
                     positiveLst.add(Integer.valueOf(positiveCharArr[i] + "" + positiveCharArr[i + 1]) + 1);
                  }
               }

               if (numberStrArr.length < 2 || Integer.valueOf(numberStrArr[1]) == 0) {
                  while(1 == (Integer)positiveLst.get(positiveLst.size() - 1)) {
                     positiveLst.remove(positiveLst.size() - 1);
                  }
               }

               intColLst.addAll(positiveLst);
               if (numberStrArr.length > 1) {
                  String decimal = numberStrArr[1];
                  if (0 != Integer.valueOf(decimal)) {
                     if (0 != decimal.length() % 2) {
                        decimal = decimal + "0";
                     }

                     char[] decimalCharArr = decimal.toCharArray();

                     for(int i = 0; i < decimalCharArr.length; i += 2) {
                        decimalList.add(Integer.valueOf(decimalCharArr[i] + "" + decimalCharArr[i + 1]) + 1);
                     }

                     intColLst.addAll(decimalList);
                  }
               }
            }
         } else {
            List<Integer> positiveLst = new ArrayList();
            List<Integer> decimalList = new ArrayList();
            String[] numberStrArr = colValStr.split("\\.");
            intpart = numberStrArr[0];
            if ("0".equals(intpart)) {
               positiveLst.add(63);
            } else {
               if (0 != intpart.length() % 2) {
                  intpart = "0" + intpart;
               }

               char[] positiveCharArr = intpart.toCharArray();
               int idx = positiveCharArr.length / 2 - 1;
               int prefixNum = 62 - idx;
               positiveLst.add(prefixNum);

               for(int i = 0; i < positiveCharArr.length; i += 2) {
                  positiveLst.add(101 - Integer.valueOf(positiveCharArr[i] + "" + positiveCharArr[i + 1]));
               }

               if (numberStrArr.length < 2 || Integer.valueOf(numberStrArr[1]) == 0) {
                  while(101 == (Integer)positiveLst.get(positiveLst.size() - 1)) {
                     positiveLst.remove(positiveLst.size() - 1);
                  }
               }

               intColLst.addAll(positiveLst);
            }

            if (numberStrArr.length > 1) {
               String decimal = numberStrArr[1];
               if (0 != Integer.valueOf(decimal)) {
                  if (0 != decimal.length() % 2) {
                     decimal = decimal + "0";
                  }

                  char[] decimalCharArr = decimal.toCharArray();

                  for(int i = 0; i < decimalCharArr.length; i += 2) {
                     decimalList.add(101 - Integer.valueOf(decimalCharArr[i] + "" + decimalCharArr[i + 1]));
                  }

                  intColLst.addAll(decimalList);
               }
            }

            intColLst.add(102);
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return intColLst;
   }

   private static List<Integer> longToDmpBtyeArr(String colValStr) {
      List<Integer> intColLst = new ArrayList();
      Boolean positiveFlg = false;
      Boolean isSingle = false;
      if (0 == colValStr.indexOf("-")) {
         colValStr = colValStr.replaceFirst("-", "");
      } else {
         positiveFlg = true;
      }

      int longNum = Integer.parseInt(colValStr);
      if (longNum < 10) {
         isSingle = true;
      }

      if (!positiveFlg) {
         intColLst.add(45);
      }

      if (isSingle) {
         intColLst.add(longNum + 48);
      } else if (longNum < 100) {
         intColLst.add(longNum / 10 + 48);
         intColLst.add(longNum % 10 + 48);
      } else {
         intColLst.add(longNum / 100 + 48);
         intColLst.add(longNum / 10 % 10 + 48);
         intColLst.add(longNum % 10 + 48);
      }

      return intColLst;
   }

   private static String timestampParsing(List<Integer> intColList) {
      List<Integer> subColList1 = intColList.subList(0, 7);
      String dateStr = dateParsing(subColList1);
      List<Integer> subColList2 = intColList.subList(7, intColList.size());
      String content16MsPart = "";

      for(int i = 0; i < subColList2.size(); ++i) {
         content16MsPart = content16MsPart + Integer.toHexString((Integer)subColList2.get(i));
      }

      int intStr = binary16_10(content16MsPart);
      dateStr = dateStr + "." + intStr;
      return dateStr;
   }

   private static String dateParsing(List<Integer> intColLst) {
      String datefmt = "yyyy-MM-dd HH:mm:ss";
      Calendar calendar = Calendar.getInstance();
      int[] date = new int[6];
      String reStr = "";

      for(int i = 0; i < intColLst.size(); ++i) {
         int sz = (Integer)intColLst.get(i);
         if (i == 0 || i == 1) {
            sz -= 100;
         }

         reStr = reStr + String.format("%02d", sz);
         if (i != 0) {
            date[i - 1] = Integer.parseInt(reStr);
            reStr = "";
         }
      }

      calendar.set(date[0], date[1] - 1, date[2], date[3] - 1, date[4] - 1, date[5] - 1);
      SimpleDateFormat sdf = new SimpleDateFormat(datefmt);
      String dateStr = sdf.format(calendar.getTime());
      return dateStr;
   }

   public static String subZeroAndDot(String s) {
      if (s.indexOf(".") > 0) {
         s = s.replaceAll("0+?$", "");
         s = s.replaceAll("[.]$", "");
      }

      return s;
   }

   private static String numberParsing(List<Integer> intColLst) {
      int prefixNum = (Integer)intColLst.get(0);
      int ws = prefixNum - 192;
      String reInt = "";
      if (ws >= 0) {
         int idx = prefixNum - 193;
         intColLst.remove(0);

         while(intColLst.size() < idx + 1) {
            intColLst.add(1);
         }

         BigDecimal reDouble = new BigDecimal(0);

         for(int i = 0; i < intColLst.size(); ++i) {
            int codeInt = (Integer)intColLst.get(i);
            double codedouble = (double)(codeInt - 1) * Math.pow((double)100.0F, (double)idx);
            BigDecimal bg = new BigDecimal(codedouble);
            if (idx < 0) {
               bg = bg.setScale(idx * 2 * -1, RoundingMode.HALF_DOWN);
            }

            reDouble = reDouble.add(bg);
            --idx;
         }

         reInt = subZeroAndDot(String.valueOf(reDouble));
      } else if (ws < 0) {
         if (1 == intColLst.size() && "128".equals(((Integer)intColLst.get(0)).toString())) {
            reInt = "0";
         } else if (1 == intColLst.size() && "30".equals(((Integer)intColLst.get(0)).toString())) {
            reInt = "";
         } else {
            int idx = 62 - (Integer)intColLst.get(0);
            intColLst.remove(intColLst.size() - 1);
            intColLst.remove(0);

            while(intColLst.size() < idx + 1) {
               intColLst.add(101);
            }

            BigDecimal reDouble = new BigDecimal(0);

            for(int i = 0; i < intColLst.size(); ++i) {
               int codeInt = (Integer)intColLst.get(i);
               double codedouble = (double)(codeInt - 101) * Math.pow((double)100.0F, (double)idx);
               BigDecimal bg = new BigDecimal(codedouble);
               if (idx < 0) {
                  bg = bg.setScale(idx * 2 * -1, RoundingMode.HALF_DOWN);
               }

               reDouble = reDouble.add(bg);
               --idx;
            }

            reInt = subZeroAndDot(String.valueOf(reDouble));
         }
      }

      return reInt;
   }

   private static List<String> createTableSql(String dmpFilePath) {
      Date startDate = new Date();
      List<String> createTableSqlList = new ArrayList();
      List<String> insertTableSql = new ArrayList();
      List<String> uniqueTableSql = new ArrayList();
      List<String> synonTableSql = new ArrayList();
      List<String> viewTableSql = new ArrayList();

      try {
         FileInputStream is = new FileInputStream(dmpFilePath);
         Reader reader = new InputStreamReader(is);
         BufferedReader bufferedReader = new BufferedReader(reader);
         String line = "";
         int lineNum = 0;

         while((line = bufferedReader.readLine()) != null) {
            ++lineNum;
            line = new String(line.getBytes("ISO-8859-1"), "GBK");
            if (line.length() > 12) {
               String top12 = line.substring(0, 12);
               if (top12.equals("CREATE TABLE")) {
                  createTableSqlList.add(lineNum + line);
               } else if (top12.equals("INSERT INTO ")) {
                  insertTableSql.add(line);
               } else if (top12.equals("CREATE UNIQU")) {
                  uniqueTableSql.add(line);
               } else if (top12.equals("CREATE SYNON")) {
                  synonTableSql.add(line);
               } else if (top12.equals("CREATE VIEW ")) {
                  viewTableSql.add(line);
               }
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      Date endDate = new Date();
      DateTime1Tool.dateBetween(startDate, endDate);
      return createTableSqlList;
   }

   private static String tableName2HexStr(String tablename) {
      byte[] tablenameByteArr = tablename.getBytes();
      StringBuffer tableNameHexBuf = new StringBuffer();

      for(int i = 0; i < tablenameByteArr.length; ++i) {
         byte tablenameByte = tablenameByteArr[i];
         String tablenameHexStr = toHex(tablenameByte);
         tableNameHexBuf.append(tablenameHexStr);
      }

      return tableNameHexBuf.toString();
   }

   private static String toHex(byte b) {
      int i = b & 255;
      String s = "";
      if (null != Integer.toHexString(i)) {
         s = Integer.toHexString(i).toUpperCase();
         if (s.length() == 1) {
            s = '0' + s;
         }
      } else {
         System.out.println("btye is:" + b + ":toHex 方法：十进制数转换为十六进制字符串时返回了NULL!");
      }

      return s;
   }

   private static String toIntStr(byte b) {
      int i = b & 255;
      String s = "";
      s = s + i;
      return s;
   }

   public static List<String> getAllTableNameList(String dmpFilePath) {
      List<String> createTableSqlList = createTableSql(dmpFilePath);
      List<String> tableNameList = new ArrayList();

      for(int i = 0; i < createTableSqlList.size(); ++i) {
         String createTableSqlStr = (String)createTableSqlList.get(i);
         int tableNameStartIndex = createTableSqlStr.indexOf("TABLE") + 5;
         int tableNameEndIndex = createTableSqlStr.indexOf("(");
         String tableNameBuf = createTableSqlStr.substring(tableNameStartIndex, tableNameEndIndex);
         tableNameBuf = tableNameBuf.trim();
         String tName = tableNameBuf.replaceAll("\"", "");
         tableNameList.add(tName);
      }

      return tableNameList;
   }

   private static Map<String, List<String>> getTypeNameListByTableNameList(String dmpFilePath, List<String> tablenameList) {
      Map<String, List<String>> typeNameLstMap = new HashMap();
      if (null != tablenameList && tablenameList.size() != 0) {
         new ArrayList();
         List<String> createTableSqlList = createTableSql(dmpFilePath);

         for(int i = 0; i < tablenameList.size(); ++i) {
            String tmpTableName = (String)tablenameList.get(i);
            if (StringUtils.isNotBlank(tmpTableName)) {
               typeNameLstMap.put(tmpTableName, null);
            }
         }

         for(int i = 0; i < createTableSqlList.size(); ++i) {
            String createTableSqlStr = (String)createTableSqlList.get(i);
            int tableNameStartIndex = createTableSqlStr.indexOf("TABLE") + 5;
            int tableNameEndIndex = createTableSqlStr.indexOf("(");
            String tableNameBuf = createTableSqlStr.substring(tableNameStartIndex, tableNameEndIndex);
            tableNameBuf = tableNameBuf.trim();
            String tName = tableNameBuf.replaceAll("\"", "");
            if (typeNameLstMap.containsKey(tName)) {
               List<String> typeNameLst = new ArrayList();
               int colInfoStartIndex = createTableSqlStr.indexOf("(") + 1;
               int colInfoEndIndex = createTableSqlStr.indexOf(")  PCTFREE");
               String colInfosBuf = createTableSqlStr.substring(colInfoStartIndex, colInfoEndIndex);
               colInfosBuf = colInfosBuf.trim();
               String[] colInfoArr = colInfosBuf.split(", \"");

               for(int j = 0; j < colInfoArr.length; ++j) {
                  String colInfoBuf = colInfoArr[j];
                  colInfoBuf = colInfoBuf.trim();
                  String[] colInfoBufArr = colInfoBuf.split("\" ");
                  String columnname = colInfoBufArr[0];
                  columnname = columnname.replaceAll("\"", "");
                  String colTypeBuf = colInfoBufArr[1];
                  String typename = colTypeBuf;
                  int colTypeEndIndex = colTypeBuf.indexOf("(");
                  if (colTypeEndIndex > 0) {
                     typename = colTypeBuf.substring(0, colTypeEndIndex);
                  }

                  typeNameLst.add(typename.trim());
               }

               typeNameLstMap.put(tName, typeNameLst);
            }
         }

         return typeNameLstMap;
      } else {
         return typeNameLstMap;
      }
   }

   private static List<String> getTypeNameListByTableName(String dmpFilePath, String tablename) {
      if (StringUtils.isBlank(tablename)) {
         return null;
      } else {
         List<String> typeNameLst = new ArrayList();
         List<String> createTableSqlList = createTableSql(dmpFilePath);

         for(int i = 0; i < createTableSqlList.size(); ++i) {
            String createTableSqlStr = (String)createTableSqlList.get(i);
            int tableNameStartIndex = createTableSqlStr.indexOf("TABLE") + 5;
            int tableNameEndIndex = createTableSqlStr.indexOf("(");
            String tableNameBuf = createTableSqlStr.substring(tableNameStartIndex, tableNameEndIndex);
            tableNameBuf = tableNameBuf.trim();
            String tName = tableNameBuf.replaceAll("\"", "");
            if (tablename.equalsIgnoreCase(tName)) {
               int colInfoStartIndex = createTableSqlStr.indexOf("(") + 1;
               int colInfoEndIndex = createTableSqlStr.indexOf(")  PCTFREE");
               String colInfosBuf = createTableSqlStr.substring(colInfoStartIndex, colInfoEndIndex);
               colInfosBuf = colInfosBuf.trim();
               String[] colInfoArr = colInfosBuf.split(", \"");

               for(int j = 0; j < colInfoArr.length; ++j) {
                  String colInfoBuf = colInfoArr[j];
                  colInfoBuf = colInfoBuf.trim();
                  String[] colInfoBufArr = colInfoBuf.split("\" ");
                  String columnname = colInfoBufArr[0];
                  columnname = columnname.replaceAll("\"", "");
                  String colTypeBuf = colInfoBufArr[1];
                  String typename = colTypeBuf;
                  int colTypeEndIndex = colTypeBuf.indexOf("(");
                  if (colTypeEndIndex > 0) {
                     typename = colTypeBuf.substring(0, colTypeEndIndex);
                  }

                  typeNameLst.add(typename);
               }
            }
         }

         return typeNameLst;
      }
   }

   public static List<ColumnInfoVO> getColListByTableName(String dmpFilePath, String tablename) {
      if (StringUtils.isBlank(tablename)) {
         return null;
      } else {
         List<ColumnInfoVO> columnInfoLst = new ArrayList();
         List<String> createTableSqlList = createTableSql(dmpFilePath);

         for(int i = 0; i < createTableSqlList.size(); ++i) {
            String createTableSqlStr = (String)createTableSqlList.get(i);
            int tableNameStartIndex = createTableSqlStr.indexOf("TABLE") + 5;
            int tableNameEndIndex = createTableSqlStr.indexOf("(");
            String tableNameBuf = createTableSqlStr.substring(tableNameStartIndex, tableNameEndIndex);
            tableNameBuf = tableNameBuf.trim();
            String tName = tableNameBuf.replaceAll("\"", "");
            if (tablename.equalsIgnoreCase(tName)) {
               int colInfoStartIndex = createTableSqlStr.indexOf("(") + 1;
               int colInfoEndIndex = createTableSqlStr.indexOf(")  PCTFREE");
               String colInfosBuf = createTableSqlStr.substring(colInfoStartIndex, colInfoEndIndex);
               colInfosBuf = colInfosBuf.trim();
               String[] colInfoArr = colInfosBuf.split(", \"");

               for(int j = 0; j < colInfoArr.length; ++j) {
                  ColumnInfoVO columnInfo = new ColumnInfoVO();
                  String colInfoBuf = colInfoArr[j];
                  colInfoBuf = colInfoBuf.trim();
                  String[] colInfoBufArr = colInfoBuf.split("\" ");
                  String columnname = colInfoBufArr[0];
                  columnname = columnname.replaceAll("\"", "");
                  String colTypeBuf = colInfoBufArr[1];
                  String typename = colTypeBuf;
                  String columnsize = "";
                  String decimaldigits = null;
                  int colTypeEndIndex = colTypeBuf.indexOf("(");
                  if (colTypeEndIndex > 0) {
                     typename = colTypeBuf.substring(0, colTypeEndIndex);
                     int digitsEndIndex = colTypeBuf.indexOf(")");
                     String precisionStr = colTypeBuf.substring(colTypeEndIndex + 1, digitsEndIndex);
                     String[] precisionArr = precisionStr.split(",");
                     columnsize = precisionArr[0].trim();
                     if ("*".equalsIgnoreCase(columnsize) && "NUMBER".equalsIgnoreCase(typename)) {
                        columnsize = "38";
                     }

                     if (precisionArr.length > 1) {
                        decimaldigits = precisionArr[1].trim();
                     }
                  }

                  if ("date".equalsIgnoreCase(typename)) {
                     columnsize = "7";
                  }

                  columnInfo.setTablename(tablename);
                  columnInfo.setColumnname(columnname);
                  columnInfo.setTypename(typename);
                  columnInfo.setColumnsize(columnsize == null ? "" : columnsize);
                  columnInfo.setDecimaldigits(decimaldigits == null ? "" : decimaldigits);
                  columnInfo.setMaskingruleid("");
                  columnInfo.setMaskingrulename("");
                  columnInfo.setRegextype("");
                  columnInfo.setTargettypename("");
                  columnInfo.setRemarks("");
                  columnInfoLst.add(columnInfo);
               }
               break;
            }
         }

         return columnInfoLst;
      }
   }

   public static void createPipeFile(String taskname, String tablename) {
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String path = props.getProperty("dmp_exp_table_file_path");
      String pipeFilePath = path + taskname + "/";
      FileTool.createFolder(pipeFilePath);
      String pipeFileName = tablename + ".pipe";
      String rmPipeFileCmd = "rm -rf " + pipeFilePath + pipeFileName;
      String mkrPipeFileCmd = "mkfifo " + pipeFilePath + pipeFileName;
      System.out.println(">>>>>>>>>>>mkrPipeFileCmd:" + mkrPipeFileCmd);
      CommandTool.command(rmPipeFileCmd);
      CommandTool.command(mkrPipeFileCmd);
      CommandTool.command("chmod -R 777 " + pipeFilePath + pipeFileName);
   }

   public static void prasingDataByTableName(String dmpFilePath, String taskname, List<String> tablenameList, String tarDmpPath) {
      if (null != tablenameList) {
         Properties props = new Properties();

         try {
            props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         } catch (IOException e) {
            e.printStackTrace();
         }

         String dmpFileName = dmpFilePath.substring(dmpFilePath.lastIndexOf("/") + 1, dmpFilePath.length());
         Map<String, String> tablenameHexStrMap = new HashMap();

         for(int i = 0; i < tablenameList.size(); ++i) {
            String maskTableName = (String)tablenameList.get(i);
            String tablenameHexStr = tableName2HexStr((String)tablenameList.get(i));
            tablenameHexStrMap.put(tablenameHexStr, maskTableName);
         }

         Map<String, List<String>> colTypeListMap = getTypeNameListByTableNameList(dmpFilePath, tablenameList);

         try {
            String path = props.getProperty("dmp_exp_table_file_path");
            File f = new File(dmpFilePath);
            int len = (int)f.length();
            byte[] btyebufArr = new byte[10000];
            byte[] impBtyeArr = new byte[20000];
            int impBtyebufArrIndex = 0;
            StreamFileReader fis = new StreamFileReader(dmpFilePath, 10000);
            new StringBuffer();
            new StringBuffer();
            int count00 = 0;
            boolean issys = false;
            String lastbuf16 = "";
            int i = 0;
            fis.read();
            btyebufArr = fis.getArray();
            int btyebufArrIndex = 0;
            String finishFlg = "0";
            String createTableStartMark = "0";
            StringBuffer createTableStartMarkStrBuf = new StringBuffer();
            int createTableStartMarkLen = 14;
            int createTableStartMarkIndex = 0;
            String tableNameStartFlg = "0";
            StringBuffer createTableNameStrBuf = new StringBuffer();
            String createTableStartFlg = "0";
            String isMatchTable = "0";
            String tardmpFilePath = "";
            tardmpFilePath = tarDmpPath + "/" + dmpFileName;
            FileOutputStream fileOutputStream = new FileOutputStream(tardmpFilePath);
            String curImpTableName = "";
            String curTableDataInsertFinishFlg = "0";
            List<String> colTypeList = null;

            while(i < len) {
               byte bufbyte = btyebufArr[btyebufArrIndex];
               String buf10 = toIntStr(bufbyte);
               String buf16 = toHex(bufbyte);
               if ("0".equals(createTableStartFlg)) {
                  if ("43".equals(buf16)) {
                     createTableStartMark = "1";
                     createTableStartMarkIndex = 0;
                     createTableStartMarkStrBuf = new StringBuffer();
                  }

                  if ("1".equals(createTableStartMark)) {
                     createTableStartMarkStrBuf.append(buf16);
                     ++createTableStartMarkIndex;
                     if (createTableStartMarkIndex == createTableStartMarkLen) {
                        createTableStartMarkIndex = 0;
                        if ("435245415445205441424C452022".equalsIgnoreCase(createTableStartMarkStrBuf.toString())) {
                           tableNameStartFlg = "1";
                           createTableStartFlg = "1";
                        } else {
                           createTableStartMarkStrBuf = new StringBuffer();
                        }

                        createTableStartMark = "0";
                     }
                  }
               } else if ("1".equals(createTableStartFlg) && !"1".equals(isMatchTable)) {
                  if ("1".equals(tableNameStartFlg)) {
                     if ("22".equals(buf16)) {
                        tableNameStartFlg = "0";
                     } else {
                        createTableNameStrBuf.append(buf16);
                     }
                  } else if ("0".equals(tableNameStartFlg)) {
                     if (tablenameHexStrMap.containsKey(createTableNameStrBuf.toString())) {
                        isMatchTable = "1";
                        curImpTableName = (String)tablenameHexStrMap.get(createTableNameStrBuf.toString());
                        colTypeList = (List)colTypeListMap.get(curImpTableName);
                     } else {
                        createTableStartFlg = "0";
                     }

                     createTableNameStrBuf = new StringBuffer();
                  }
               }

               if ("1".equals(isMatchTable)) {
                  if (!issys) {
                     if (count00 == 5) {
                        if (!buf16.equals("00")) {
                           issys = true;
                        } else {
                           count00 = -1;
                        }
                     }

                     if (buf16.equals("00")) {
                        ++count00;
                     } else {
                        count00 = 0;
                     }
                  }

                  if (!issys) {
                     impBtyeArr[impBtyebufArrIndex] = bufbyte;
                     ++impBtyebufArrIndex;
                  } else if ("0".equals(curTableDataInsertFinishFlg)) {
                     ArrayList<Integer> tableDataList = new ArrayList();
                     String tarDmpPipePath = props.getProperty("dmp_imp_table_file_path");
                     String tarPipePathStr = tarDmpPipePath + "/" + taskname + "/" + curImpTableName + ".pipe";
                     byte[] impBtyeArr2 = Arrays.copyOf(impBtyeArr, impBtyebufArrIndex);
                     fileOutputStream.write(impBtyeArr2);
                     impBtyeArr = new byte[10000];
                     impBtyebufArrIndex = 0;

                     try {
                        InputStreamReader fr = new InputStreamReader(new FileInputStream(tarPipePathStr), "UTF-8");
                        BufferedReader bf = new BufferedReader(fr);
                        int lineCnt = 0;

                        String lineStr;
                        while((lineStr = bf.readLine()) != null) {
                           ++lineCnt;
                           List<Integer> lineIntList = parsingDataByLine(colTypeList, lineStr);
                           lineIntList.add(0);
                           lineIntList.add(0);
                           tableDataList.addAll(lineIntList);
                           if (0 == lineCnt % 10000) {
                              byte[] impDataBtyeArr = new byte[tableDataList.size()];

                              for(int tIdx = 0; tIdx < tableDataList.size(); ++tIdx) {
                                 impDataBtyeArr[tIdx] = (byte)((Integer)tableDataList.get(tIdx) & 255);
                              }

                              fileOutputStream.write(impDataBtyeArr);
                              tableDataList = new ArrayList();
                           }
                        }

                        tableDataList.add(255);
                        tableDataList.add(255);
                        byte[] impDataBtyeArr = new byte[tableDataList.size()];

                        for(int tIdx = 0; tIdx < tableDataList.size(); ++tIdx) {
                           impDataBtyeArr[tIdx] = (byte)((Integer)tableDataList.get(tIdx) & 255);
                        }

                        fileOutputStream.write(impDataBtyeArr);
                        bf.close();
                        fr.close();
                     } catch (IOException e) {
                        e.printStackTrace();
                     }

                     curTableDataInsertFinishFlg = "1";
                  } else if (buf16.equals("FF") && lastbuf16.equals("FF")) {
                     issys = false;
                     isMatchTable = "0";
                     curTableDataInsertFinishFlg = "0";
                  }
               } else {
                  impBtyeArr[impBtyebufArrIndex] = bufbyte;
                  ++impBtyebufArrIndex;
               }

               lastbuf16 = buf16;
               ++i;
               ++btyebufArrIndex;
               if (btyebufArrIndex >= 10000) {
                  byte[] impBtyeArr2 = Arrays.copyOf(impBtyeArr, impBtyebufArrIndex);
                  fileOutputStream.write(impBtyeArr2);
                  impBtyeArr = new byte[10000];
                  impBtyebufArrIndex = 0;
                  fis.read();
                  btyebufArr = fis.getArray();
                  btyebufArrIndex = 0;
               }
            }

            byte[] impBtyeArr2 = Arrays.copyOf(impBtyeArr, impBtyebufArrIndex);
            fileOutputStream.write(impBtyeArr2);
            fileOutputStream.flush();
            fileOutputStream.close();
         } catch (Exception e) {
            e.printStackTrace();
         }

      }
   }

   public static void main(String[] args) {
      new DmpTool();
      String dmpFilePath = "WXBtest3.dmp";
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String dmppath = props.getProperty("dmp_file_path");
      (new StringBuilder()).append(dmppath).append(dmpFilePath).toString();
      long starttime = (new Date()).getTime();
      String tablename = "DMP_TEST";
      tablename = tablename.toUpperCase();
      List<String> tablenameList = new ArrayList();
      tablenameList.add("PAM_R_AC_CUM_DATA_SHOW");
      String tarPipePath = props.getProperty("dmp_exp_table_file_path");
      dmpFilePath = "F:/dmp/lhy/aaaa.dmp";
      tarPipePath = "F:/dmp/lhy/tar/";
      prasingDataByTableName(dmpFilePath, "191016101532_dmp2dmptest2", tablenameList, tarPipePath);
      List<Integer> intColList = new ArrayList();
      intColList.add(120);
      intColList.add(104);
      intColList.add(12);
      intColList.add(15);
      intColList.add(17);
      intColList.add(15);
      intColList.add(53);
      String colValStr = "2004-12-15 16:14:52";
      intColList = new ArrayList();
      intColList.add(120);
      intColList.add(119);
      intColList.add(7);
      intColList.add(16);
      intColList.add(18);
      intColList.add(4);
      intColList.add(1);
      intColList.add(13);
      intColList.add(242);
      intColList.add(201);
      intColList.add(24);
      timestampParsing(intColList);
      colValStr = "2004-12-15 16:14:52.738000000";
      List<String> notConfirmColLst = new ArrayList();
      notConfirmColLst.add("NAME");
      long endtime = (new Date()).getTime();
      System.out.println("总耗时:" + (endtime - starttime) + "毫秒");
   }

   public static String dmpNum(String num) {
      int len = num.length();
      if (len % 2 != 0) {
         num = "0" + num;
      }

      char[] numChrArr = num.toCharArray();
      String reCode = "";
      String codeBuf = "";

      for(int i = numChrArr.length - 1; i >= 0; i -= 2) {
         String buf = numChrArr[i - 1] + String.valueOf(numChrArr[i]);
         int bufInt = Integer.valueOf(buf);
         ++bufInt;
         codeBuf = String.format("%02x", bufInt);
         reCode = codeBuf + reCode;
      }

      String preHexCode = toHex((numChrArr.length - 2) / 2 + 193);
      reCode = preHexCode + reCode;
      System.out.println("数字：" + num + "通过dmp转为code：  " + reCode);
      return reCode;
   }

   public static String toHex(int num) {
      if (num == 0) {
         return "0";
      } else {
         String result;
         for(result = ""; num != 0; num >>>= 4) {
            int x = num & 15;
            result = map[x] + result;
         }

         return result;
      }
   }
}
