package com.chenyang.nse.bussiness.tools.dmp;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class StreamFileReader {
   private BufferedInputStream fileIn;
   private long fileLength;
   private int arraySize;
   private byte[] array;

   public StreamFileReader(String fileName, int arraySize) throws IOException {
      this.fileIn = new BufferedInputStream(new FileInputStream(fileName), arraySize);
      this.fileLength = (long)this.fileIn.available();
      this.arraySize = arraySize;
   }

   public int read() throws IOException {
      byte[] tmpArray = new byte[this.arraySize];
      int bytes = this.fileIn.read(tmpArray);
      if (bytes != -1) {
         this.array = new byte[bytes];
         System.arraycopy(tmpArray, 0, this.array, 0, bytes);
         return bytes;
      } else {
         return -1;
      }
   }

   public void close() throws IOException {
      this.fileIn.close();
      this.array = null;
   }

   public byte[] getArray() {
      return this.array;
   }

   public long getFileLength() {
      return this.fileLength;
   }

   public static void main(String[] args) throws IOException {
      StreamFileReader reader = new StreamFileReader("C:\\Users\\Administrator\\Desktop\\脱敏平台相关支援\\9、DMP文件解析20190619\\other\\test4.dmp", 1000);
      long start = System.nanoTime();

      while(reader.read() != -1) {
      }

      long end = System.nanoTime();
      reader.close();
      System.out.println("StreamFileReader: " + (end - start));
   }
}
