package com.chenyang.nse.bussiness.tools.encryption;

import com.chenyang.nse.bussiness.common.PropertiesConstant;
import com.chenyang.nse.bussiness.tools.encryption.sm4fpe.SM4FPEAddressUtil;
import com.chenyang.nse.bussiness.tools.encryption.sm4fpe.SM4FPECellPhoneUtil;
import com.chenyang.nse.bussiness.tools.encryption.sm4fpe.SM4FPECompanyUtil;
import com.chenyang.nse.bussiness.tools.encryption.sm4fpe.SM4FPEEmailUtil;
import com.chenyang.nse.bussiness.tools.encryption.sm4fpe.SM4FPEIdentityUtil;
import com.chenyang.nse.bussiness.tools.encryption.sm4fpe.SM4FPENameUtil;

public class ElasticSearchEncDecProvider {
   private static String ENCRYPT_LABEL;

   public static String encrypt(String type, String key, String text, String isLike, String keepFirst, String encDigit, String twoIndex) throws Exception {
      if (type == null) {
         throw new IllegalArgumentException("type");
      } else if (text == null) {
         return text;
      } else if (text.length() > ENCRYPT_LABEL.length() << 1 && ENCRYPT_LABEL.equals(text.substring(0, ENCRYPT_LABEL.length())) && ENCRYPT_LABEL.equals(text.substring(text.length() - ENCRYPT_LABEL.length()))) {
         return text;
      } else {
         String encrypt;
         switch (type) {
            case "SM4":
               encrypt = SM4Util.encryptEcb(key, text, isLike, keepFirst, encDigit, twoIndex);
               break;
            case "SM4_ECB":
            case "SM4_CBC":
            case "SM4_OFB":
            case "SM4_CFB":
            case "SM4_GCM":
            case "SM4_CCM":
               encrypt = SM4Util.encryptEcb(key, text, isLike, keepFirst, encDigit, twoIndex, type);
               break;
            case "SM4_FPE_IDENTITYNO":
               encrypt = SM4FPEIdentityUtil.encryptEcb(key, text, isLike, keepFirst, encDigit, twoIndex);
               break;
            case "SM4_FPE_PHONE":
               encrypt = SM4FPECellPhoneUtil.encryptEcb(key, text, isLike, keepFirst, encDigit, twoIndex);
               break;
            case "SM4_FPE_EMAIL":
               encrypt = SM4FPEEmailUtil.encryptEcb(key, text, isLike, keepFirst, encDigit, twoIndex);
               break;
            case "SM4_FPE_NAME":
               encrypt = SM4FPENameUtil.encryptEcb(key, text, isLike, keepFirst, encDigit, twoIndex);
               break;
            case "SM4_FPE_COMPANY_NAME":
               encrypt = SM4FPECompanyUtil.encryptEcb(key, text, isLike, keepFirst, encDigit, twoIndex);
               break;
            case "SM4_FPE_ADDRESS":
               encrypt = SM4FPEAddressUtil.encryptEcb(key, text, isLike, keepFirst, encDigit, twoIndex);
               break;
            case "AES":
            case "AES128":
            case "AES192":
            case "AES256":
               encrypt = AesEncryptUtils.encrypt(key, text, isLike, keepFirst, encDigit, twoIndex);
               break;
            case "DES":
               encrypt = DESUtil.encryptEcb(key, text, isLike, keepFirst, encDigit, twoIndex);
               break;
            case "3DES":
               encrypt = DES3Util.encryptEcb(key, text, isLike, keepFirst, encDigit, twoIndex, "ECB");
               break;
            default:
               throw new UnSupportedEncTypeException(type);
         }

         return ENCRYPT_LABEL + encrypt + ENCRYPT_LABEL;
      }
   }

   public static String decrypt(String type, String key, String text, String isLike, String keepFirst, String encDigit, String twoIndex) throws Exception {
      if (type == null) {
         throw new IllegalArgumentException("type");
      } else if (text == null) {
         return text;
      } else {
         text = text.trim();
         if (text.equals("")) {
            return text;
         } else if (text.length() <= ENCRYPT_LABEL.length() << 1) {
            return text;
         } else if (ENCRYPT_LABEL.equals(text.substring(0, ENCRYPT_LABEL.length())) && ENCRYPT_LABEL.equals(text.substring(text.length() - ENCRYPT_LABEL.length()))) {
            text = text.substring(ENCRYPT_LABEL.length(), text.length() - ENCRYPT_LABEL.length());
            if (type != null) {
               type = type.toUpperCase();
            }

            try {
               switch (type) {
                  case "SM4":
                     return SM4Util.decryptEcb(key, text, isLike, keepFirst, encDigit, twoIndex);
                  case "SM4_ECB":
                  case "SM4_GCM":
                  case "SM4_CBC":
                  case "SM4_OFB":
                  case "SM4_CFB":
                  case "SM4_CCM":
                     return SM4Util.decryptEcb(key, text, isLike, keepFirst, encDigit, twoIndex, type);
                  case "SM4_FPE_IDENTITYNO":
                     return SM4FPEIdentityUtil.decryptEcb(key, text, isLike, keepFirst, encDigit, twoIndex);
                  case "SM4_FPE_PHONE":
                     return SM4FPECellPhoneUtil.decryptEcb(key, text, isLike, keepFirst, encDigit, twoIndex);
                  case "SM4_FPE_EMAIL":
                     return SM4FPEEmailUtil.decryptEcb(key, text, isLike, keepFirst, encDigit, twoIndex);
                  case "SM4_FPE_NAME":
                     return SM4FPENameUtil.decryptEcb(key, text, isLike, keepFirst, encDigit, twoIndex);
                  case "SM4_FPE_COMPANY_NAME":
                     return SM4FPECompanyUtil.decryptEcb(key, text, isLike, keepFirst, encDigit, twoIndex);
                  case "SM4_FPE_ADDRESS":
                     return SM4FPEAddressUtil.decryptEcb(key, text, isLike, keepFirst, encDigit, twoIndex);
                  case "AES":
                  case "AES128":
                  case "AES256":
                  case "AES192":
                     return AesEncryptUtils.decrypt(key, text, isLike, keepFirst, encDigit, twoIndex);
                  case "DES":
                     return DESUtil.decryptEcb(key, text, isLike, keepFirst, encDigit, twoIndex);
                  case "3DES":
                     return DES3Util.decryptEcb(key, text, isLike, keepFirst, encDigit, twoIndex, "ECB");
                  default:
                     throw new UnSupportedEncTypeException(type);
               }
            } catch (Exception var9) {
               return ENCRYPT_LABEL + text + ENCRYPT_LABEL;
            }
         } else {
            return text;
         }
      }
   }

   static {
      ENCRYPT_LABEL = PropertiesConstant.properties.getProperty("encryption.es.label");
   }
}
