package com.chenyang.nse.bussiness.tools.encryption.sm4fpe;

import java.util.Map;

public class SM4FPEEmailUtil {
   public static String generateKey() {
      SM4FPEBase base = new SM4FPEBase();
      return base.generateKey();
   }

   public static String encryptEcb(String hexKey, String a, String isLike, String keepfirst, String encdigit, String twoindex) throws Exception {
      Map<String, String> map = SM4FPETools.parseInput(a, keepfirst, encdigit, twoindex);
      String prefix = (String)map.get("prefix");
      String suffix = (String)map.get("suffix");
      String middle = (String)map.get("middle");
      String out = middle;
      if (SM4FPEEmail.check(middle)) {
         SM4FPEEmail email = new SM4FPEEmail();
         out = email.encryptEcb(hexKey, middle);
         if (!SM4FPEEmail.check(out)) {
            System.out.println("The encrypt result must be email. result:" + out);
            out = middle;
         }
      }

      return prefix + out + suffix;
   }

   public static String decryptEcb(String hexKey, String input, String isLike, String keepfirst, String encdigit, String twoindex) throws Exception {
      Map<String, String> map = SM4FPETools.parseInput(input, keepfirst, encdigit, twoindex);
      String prefix = (String)map.get("prefix");
      String suffix = (String)map.get("suffix");
      String middle = (String)map.get("middle");
      String out = middle;
      if (SM4FPEEmail.check(middle)) {
         SM4FPEEmail email = new SM4FPEEmail();
         out = email.decryptEcb(hexKey, middle);
         if (!SM4FPEEmail.check(out)) {
            System.out.println("The decrypt result must be email. result:" + out);
            out = middle;
         }
      }

      return prefix + out + suffix;
   }
}
