package com.chenyang.nse.bussiness.tools.es;

import bean.Column;
import bean.DataBase;
import bean.Schema;
import bean.Table;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.chenyang.nse.bussiness.entity.db.ColumnInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.tools.http.HttpUtils;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import com.chenyang.nse.bussiness.tools.utils.GHCAUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.frameworkset.elasticsearch.entity.ESIndice;
import org.frameworkset.elasticsearch.entity.MetaMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.JdbcCacheUtil;

/** @deprecated */
@Deprecated
public class EsUtil {
   private static final Logger log = LoggerFactory.getLogger(EsUtil.class);
   private final String host = "";
   private final int port = 9200;
   ClientInterface clientUtil = null;
   public Map properties = null;

   ClientInterface getClientUtil(TCoreDatasystem datasystem) {
      return GHCAUtils.getInstance().connectToES(datasystem.getDbip(), datasystem.getDbport(), datasystem.getUsername(), AesTool.decrypt(datasystem.getPassword(), "ghca"));
   }

   public Object[] queryAllIndex(String host, Integer port, String username, String password) throws Exception {
      Object[] indices = null;

      try {
         this.clientUtil = GHCAUtils.getInstance().connectToES(host, port.toString(), username, password);
         List<ESIndice> indexes = this.clientUtil.getIndexes();
         if (null != indexes) {
            indices = ((List)indexes.stream().map((in) -> in.getIndex()).collect(Collectors.toList())).toArray();
            return indices;
         } else {
            return indices;
         }
      } catch (Exception e) {
         e.printStackTrace();
         throw e;
      }
   }

   public List<String> getESSchema(String host, String port) {
      Optional<DataBase> dataBase = null;
      List<DataBase> dataBaseList = JdbcCacheUtil.dataBaseList;
      List<String> schemas = new ArrayList();
      dataBase = dataBaseList.stream().filter((x) -> x.getIp_port().equals(host + ":" + port)).findFirst();
      if (dataBase.isPresent()) {
         List<Schema> schemaList = ((DataBase)dataBase.get()).getSchemaList();
         schemaList.stream().forEach((s) -> schemas.add(s.getName()));
      }

      return schemas;
   }

   public List<String> getESType(String host, String port, String schemaName) {
      List<String> types = new ArrayList();
      Optional<DataBase> dataBase = null;
      Optional<Schema> schema = null;
      List<DataBase> dataBaseList = JdbcCacheUtil.dataBaseList;
      dataBase = dataBaseList.stream().filter((x) -> x.getIp_port().equals(host + ":" + port)).findFirst();
      if (dataBase.isPresent()) {
         List<Schema> schemaList = ((DataBase)dataBase.get()).getSchemaList();
         schema = schemaList.stream().filter((s) -> schemaName.equals(s.getName())).findFirst();
         if (schema.isPresent()) {
            List<Table> tableList = ((Schema)schema.get()).getTableList();
            tableList.stream().forEach((t) -> types.add(t.getName()));
         }
      }

      return types;
   }

   public Set<String> getESType(TCoreDatasystem datasystem, String schemaName) {
      Set<String> types = new HashSet();
      List<ColumnInfo> jsonKeyList = new ArrayList();
      ClientInterface clientUtil = this.getClientUtil(datasystem);
      String jsonStr = null;

      try {
         jsonStr = this.getMapping((ClientInterface)clientUtil, schemaName, (String)null);
         GetMetaDataUtils.getJsonKeyList(jsonKeyList, jsonStr, "");
         boolean versionDelType = this.getVersionDelType(clientUtil);
         if (versionDelType) {
            types.add("_doc");
         } else {
            types = (Set)jsonKeyList.stream().map((x) -> {
               String columnname = x.getColumnname();
               return columnname.split("\\.")[0];
            }).collect(Collectors.toSet());
         }
      } catch (IOException e) {
         e.printStackTrace();
      } catch (Exception e) {
         e.printStackTrace();
      }

      return types;
   }

   public Object[] fetchTypes(String host, int port, String index, String username, String password, String version) throws IOException {
      Object[] types = null;
      new ArrayList();
      List<String> jsonTypeList = new ArrayList();
      final CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
      credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(username, AesTool.decrypt(password, "ghca")));
      RestClient restClient = RestClient.builder(new HttpHost[]{new HttpHost(host, port, "http")}).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback() {
         public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
            return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
         }
      }).build();

      try {
         Request getRequest = new Request("GET", "/" + index + "/_mapping?include_type_name");
         Response response1 = restClient.performRequest(getRequest);
         HttpEntity entity = response1.getEntity();
         String indexMapping = EntityUtils.toString(entity);
         JSONObject jsonObject = JSONObject.fromObject(indexMapping);
         JSONObject mapping = jsonObject.getJSONObject(index);
         JSONObject jsonObjectTable = mapping.getJSONObject("mappings");
         Iterator iterator = jsonObjectTable.keySet().iterator();

         String table;
         for(table = ""; iterator.hasNext(); table = iterator.next().toString()) {
         }

         if (!"_doc".equals(table) && !"".equals(table)) {
            jsonTypeList.add(table);
            return jsonTypeList.toArray();
         }
      } catch (IOException e) {
         e.printStackTrace();
      }

      return jsonTypeList.toArray();
   }

   public String getMapping(TCoreDatasystem datasystem, String index, String type) throws IOException {
      String json = "";
      this.clientUtil = GHCAUtils.getInstance().connectToES(datasystem.getDbip(), datasystem.getDbport(), datasystem.getUsername(), AesTool.decrypt(datasystem.getPassword(), "ghca"));
      String mapping = this.clientUtil.getIndexMapping(index, true);
      return mapping;
   }

   public String getMapping(ClientInterface clientUtil, String index, String type) throws IOException {
      String json = "";
      String mapping = clientUtil.getIndexMapping(index, true);
      return mapping;
   }

   public Set<String> getColumns(TCoreDatasystem datasystem, String index, String type) throws Exception {
      Set<String> sortSet = new TreeSet<>((o1, o2) -> o1.compareTo(o2));
      String jsonStr = this.getMapping(datasystem, index, type);
      Set<String> jsonKeySet = new HashSet();
      GetMetaDataUtils.getJsonKeySet(jsonKeySet, jsonStr, "");
      boolean versionDelType = this.getVersionDelType(this.getClientUtil(datasystem));
      if (!versionDelType) {
         if (type != null && !"_doc".equalsIgnoreCase(type)) {
            jsonKeySet = (Set)jsonKeySet.stream().filter((r) -> r.startsWith(type)).collect(Collectors.toSet());
         }

         jsonKeySet = (Set)jsonKeySet.stream().map((x) -> x.substring(x.indexOf(".") + 1)).collect(Collectors.toSet());
      }

      sortSet.addAll(jsonKeySet);
      return sortSet;
   }

   public Set<String> getColumnsAndIndex(TCoreDatasystem datasystem, String index, String type) throws Exception {
      Set<String> sortSet = new TreeSet<>((o1, o2) -> o1.compareTo(o2));
      String jsonStr = this.getMapping(datasystem, index, type);
      Set<String> jsonKeySet = new HashSet();
      GetMetaDataUtils.getJsonKeySetIndex(jsonKeySet, jsonStr, "");
      boolean versionDelType = this.getVersionDelType(this.getClientUtil(datasystem));
      if (!versionDelType) {
         if (type != null && !"_doc".equalsIgnoreCase(type)) {
            jsonKeySet = (Set)jsonKeySet.stream().filter((r) -> r.startsWith(type)).collect(Collectors.toSet());
         }

         jsonKeySet = (Set)jsonKeySet.stream().map((x) -> x.substring(x.indexOf(".") + 1)).collect(Collectors.toSet());
      }

      sortSet.addAll(jsonKeySet);
      return sortSet;
   }

   public Set<String> getColumnsIncludeCopyColumn(TCoreDatasystem datasystem, String index, String type) throws Exception {
      Set<String> sortSet = new TreeSet<>((o1, o2) -> o1.compareTo(o2));
      String jsonStr = this.getMapping(datasystem, index, type);
      Set<String> jsonKeySet = new HashSet();
      GetMetaDataUtils.getJsonKeySetIncludeCopyColumn(jsonKeySet, jsonStr, "");
      boolean versionDelType = this.getVersionDelType(this.getClientUtil(datasystem));
      if (!versionDelType) {
         jsonKeySet = (Set)jsonKeySet.stream().map((x) -> x.substring(x.indexOf(".") + 1)).collect(Collectors.toSet());
      }

      sortSet.addAll(jsonKeySet);
      return sortSet;
   }

   public Map<String, ArrayList> getData(TCoreDatasystem datasystem, String index, String type, String hits) throws Exception {
      List<Map> searchHitArr = this.findDataByType(datasystem, index, type, hits);
      String jsonStr = "";
      Map<String, ArrayList> jsonKeySet = new HashMap();
      if (searchHitArr != null) {
         for(Map searchHit : searchHitArr) {
            jsonStr = JSON.toJSONString(searchHit, new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            GetJSONValueUtils.getJsonKeyArray(jsonKeySet, jsonStr, "");
         }
      }

      return jsonKeySet;
   }

   public Map<String, ArrayList> getDataByClient(ClientInterface clientUtil, String index, String type, String columnName) {
      List<Map> searchHitArr = null;
      Map<String, ArrayList> jsonKeySet = new HashMap();

      try {
         searchHitArr = this.findDataByType(clientUtil, index, type, columnName);
         String jsonStr = "";
         if (searchHitArr != null) {
            for(Map searchHit : searchHitArr) {
               jsonStr = JSON.toJSONString(searchHit, new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
               GetJSONValueUtils.getJsonKeyArray(jsonKeySet, jsonStr, "");
            }
         }
      } catch (IOException e) {
         e.printStackTrace();
      } catch (Exception e) {
         e.printStackTrace();
      }

      return jsonKeySet;
   }

   public Map<String, ArrayList> getDataByClientQueryParam(ClientInterface clientUtil, String index, String type, String columnName, String param) {
      List<Map> searchHitArr = null;
      Map<String, ArrayList> jsonKeySet = new HashMap();

      try {
         searchHitArr = this.findDataByTypeAndParam(clientUtil, index, type, columnName, param);
         String jsonStr = "";
         if (searchHitArr != null) {
            for(Map searchHit : searchHitArr) {
               jsonStr = JSON.toJSONString(searchHit, new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
               GetJSONValueUtils.getJsonKeyArray(jsonKeySet, jsonStr, "");
            }
         }
      } catch (IOException e) {
         e.printStackTrace();
      } catch (Exception e) {
         e.printStackTrace();
      }

      return jsonKeySet;
   }

   public List<Map> findDataByType(TCoreDatasystem datasystem, String index, String type, String hits) throws IOException {
      List<Map> dataList = null;

      try {
         this.clientUtil = GHCAUtils.getInstance().connectToES(datasystem.getDbip(), datasystem.getDbport(), datasystem.getUsername(), datasystem.getPassword());
         String dsl = "{\"from\":0,\"size\":" + Integer.parseInt(hits) + ",\"query\": {\"match_all\": {}}}";
         ESDatas<Map> esDatas = this.clientUtil.searchList(index + "/" + type + "/_search", dsl, Map.class);
         dataList = esDatas.getDatas();
      } catch (Exception var8) {
      }

      return dataList;
   }

   public List<Map> findDataByType(ClientInterface clientUtil, String index, String type, String columnName) throws IOException {
      List<Map> dataList = null;

      try {
         String dsl = "{\"query\": {\"match_all\": {}}, \"_source\":\"" + columnName + "\"}";
         ESDatas<Map> esDatas = clientUtil.searchList(index + "/" + type + "/_search", dsl, Map.class);
         dataList = esDatas.getDatas();
      } catch (Exception var8) {
      }

      return dataList;
   }

   public List<Map> findDataByTypeAndParam(ClientInterface clientUtil, String index, String type, String columnName, String param) throws IOException {
      List<Map> dataList = null;

      try {
         String dsl = "{\n  \"query\": {\n    \"bool\": {\n      \"must_not\": \n        {\n          \"regexp\": {\n            \"" + columnName + "\": \"" + param + ".*\"\n          }\n        }\n      \n    }\n  },\n  \"_source\":\"" + columnName + "\"\n}";
         ESDatas<Map> esDatas = clientUtil.searchList(index + "/" + type + "/_search", dsl, Map.class);
         dataList = esDatas.getDatas();
      } catch (Exception var9) {
      }

      return dataList;
   }

   public List<MetaMap> searchListPage(ClientInterface clientUtil, String index, String type, String columnName, int count, int max, boolean enc) throws IOException {
      List<MetaMap> dataList = null;

      try {
         String must = "must";
         if (enc) {
            must = "must_not";
         }

         String dsl = "{\n\t\"from\":" + count + ",\n\t\"size\":" + max + ",\n\t\"query\": {\n\t\t\"bool\": {\n\t\t\t\"" + must + "\": {\n\t\t\t\t\"regexp\": {\n\t\t\t\t\t\"" + columnName + "\": \"jm_.*\"\n\t\t\t\t}\n\t\t\t},\n\t\t\t\"filter\": {\n\t\t\t\t\"exists\": {\n\t\t\t\t\t\"field\": \"" + columnName + "\"\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t},\n\t\"_source\": \"" + columnName + "\"\n}";
         ESDatas<MetaMap> esDatas = clientUtil.searchList(index + "/" + type + "/_search", dsl, MetaMap.class);
         dataList = esDatas.getDatas();
      } catch (Exception var12) {
      }

      return dataList;
   }

   public String addColumnCopy(ClientInterface clientUtil, String index, String type, String columnName, String copySuffix) throws IOException {
      List<Map> dataList = null;

      try {
         String dsl = "{\"properties\": {\"" + columnName + copySuffix + "\": {\"type\":\"text\"}}}";
         return this.getVersionDelType(clientUtil) ? clientUtil.updateIndiceMapping(index + "/_mapping", dsl) : clientUtil.updateIndiceMapping(index + "/" + type + "/_mapping", dsl);
      } catch (Exception e) {
         e.printStackTrace();
         return null;
      }
   }

   public String delColumnCopy(ClientInterface clientUtil, String index, String type, String columnName, String copySuffix) throws IOException {
      String dsl = "{\n    \"query\": {\n        \"constant_score\": {\n            \"filter\": {\n                \"exists\": {\n                    \"field\": \"" + columnName + copySuffix + "\"\n                }\n            }\n        }\n    },\n    \"script\": {\n       \"source\": \"ctx._source.remove('" + columnName + copySuffix + "')\",\n        \"lang\": \"painless\"\n    }\n}";
      return clientUtil.updateByQuery(index + "/" + type + "/_update_by_query", dsl);
   }

   public List<MetaMap> queryAllColumn(ClientInterface clientUtil, String index, String type, int count, int max) throws IOException {
      List<MetaMap> dataList = null;

      try {
         String dsl = "{\"from\":" + count + ",\"size\":" + max + ",\"query\": {\"match_all\": {}}}";
         ESDatas<MetaMap> esDatas = clientUtil.searchList(index + "/" + type + "/_search", dsl, MetaMap.class);
         dataList = esDatas.getDatas();
      } catch (Exception e) {
         e.printStackTrace();
      }

      return dataList;
   }

   public String updateColumnCopyByColumn(ClientInterface clientUtil, String index, String type, String columnName, String copySuffix) throws IOException {
      List<Map> dataList = null;

      try {
         String dsl = "{\n    \"query\": {\n        \"constant_score\": {\n            \"filter\": {\n                \"exists\": {\n                    \"field\": \"" + columnName + "\"\n                }\n            }\n        }\n    },\n    \"script\": {\n       \"source\": \"ctx._source." + columnName + copySuffix + "= ctx._source." + columnName + "\",\n        \"lang\": \"painless\"\n    }\n}";
         return clientUtil.updateByQuery(index + "/" + type + "/_update_by_query", dsl);
      } catch (Exception e) {
         e.printStackTrace();
         return null;
      }
   }

   public List<ColumnInfo> getColumnInfoList(TCoreDatasystem datasystem, String index, String type) throws Exception {
      List<ColumnInfo> jsonKeyList = new ArrayList();
      String jsonStr = this.getMapping(datasystem, index, type);
      GetMetaDataUtils.getJsonKeyList(jsonKeyList, jsonStr, "");
      return jsonKeyList;
   }

   public List<ColumnInfo> getColumnInfoList(ClientInterface clientUtil, String index, String type) throws Exception {
      List<ColumnInfo> jsonKeyList = new ArrayList();
      String jsonStr = this.getMapping(clientUtil, index, type);
      GetMetaDataUtils.getJsonKeyList(jsonKeyList, jsonStr, "");
      boolean versionDelType = this.getVersionDelType(clientUtil);
      if (!versionDelType) {
         jsonKeyList = (List)jsonKeyList.stream().map((x) -> {
            String columnname = x.getColumnname();
            columnname = columnname.substring(columnname.indexOf(".") + 1);
            x.setColumnname(columnname);
            return x;
         }).collect(Collectors.toList());
      }

      return jsonKeyList;
   }

   public List<Object> getAllLowLevelIndexes(String ip, String port) {
      RestClient restClient = RestClient.builder(new HttpHost[]{new HttpHost(ip, Integer.parseInt(port), "http")}).build();
      List<Object> indices = new ArrayList();

      try {
         Response resp = restClient.performRequest(new Request("GET", "/_aliases"));
         com.alibaba.fastjson.JSONObject jsonObject = JSON.parseObject(EntityUtils.toString(resp.getEntity()));
         String s = JSON.toJSONString(jsonObject);
         Map maps = (Map)JSON.parse(s);

         for(Object map : maps.entrySet()) {
            indices.add(((Map.Entry)map).getKey());
         }

         restClient.close();
      } catch (IOException e) {
         e.printStackTrace();
      }

      return indices;
   }

   public List<Object> getLowLevelTypes(String ip, String port, String index) {
      String json = "";
      List<Object> types = new ArrayList();
      RestClient restClient = RestClient.builder(new HttpHost[]{new HttpHost(ip, Integer.parseInt(port), "http")}).build();
      String method = "GET";
      String endpoint = "/" + index + "/_mapping";
      HttpEntity entity = new NStringEntity("{\n \"query\": {\n \"match_all\": {}\n }\n}", ContentType.APPLICATION_JSON);
      Response response = null;

      try {
         Request request = new Request(method, endpoint + " \r\n" + entity);
         response = restClient.performRequest(request);
      } catch (IOException e) {
         e.printStackTrace();
      }

      try {
         json = EntityUtils.toString(response.getEntity());
         Map maps = (Map)JSON.parse(json);

         for(Object map : maps.entrySet()) {
            Map mapping = (Map)((Map.Entry)map).getValue();
            Map mappings = (Map)mapping.get("mappings");

            for(Object m : mappings.entrySet()) {
               types.add(((Map.Entry)m).getKey());
            }
         }

         restClient.close();
      } catch (IOException e) {
         e.printStackTrace();
      }

      return types;
   }

   public Set<String> getLowLevelColumns(String host, String port, String index, String type) throws IOException {
      String json = "";
      Set<String> jsonKeySet1 = new HashSet();
      RestClient restClient = RestClient.builder(new HttpHost[]{new HttpHost(host, Integer.parseInt(port), "http")}).build();
      String method = "GET";
      String endpoint = "/" + index + "/_mapping";
      HttpEntity entity = new NStringEntity("{\n \"query\": {\n \"match_all\": {}\n }\n}", ContentType.APPLICATION_JSON);
      Request request = new Request(method, endpoint + " \r\n" + entity);
      Response response = restClient.performRequest(request);
      json = EntityUtils.toString(response.getEntity());
      Set<String> jsonKeySet = new HashSet();

      try {
         jsonKeySet1 = GetMetaDataUtils.getJsonKeySet(jsonKeySet, json, "");

         for(String var15 : jsonKeySet1) {
            ;
         }

         restClient.close();
      } catch (Exception e) {
         e.printStackTrace();
      }

      return jsonKeySet1;
   }

   public static boolean connectES(TCoreDatasystem datasystem) {
      InputStream stream = null;
      ByteArrayOutputStream output = null;
      final CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
      credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(datasystem.getUsername(), AesTool.decrypt(datasystem.getPassword(), "ghca")));
      RestClient restClient = RestClient.builder(new HttpHost[]{new HttpHost(datasystem.getDbip(), Integer.parseInt(datasystem.getDbport()), "http")}).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback() {
         public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
            return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
         }
      }).build();

      boolean var9;
      try {
         Request getRequest = new Request("GET", "");
         Response response1 = restClient.performRequest(getRequest);
         HttpEntity entity = response1.getEntity();
         String e = EntityUtils.toString(entity);
         if (!e.contains("missing authentication credentials for REST request")) {
            restClient.close();
            return true;
         }

         var9 = false;
      } catch (ConnectException e) {
         e.printStackTrace();
         boolean response1 = false;
         return response1;
      } catch (IOException e) {
         e.printStackTrace();
         return true;
      } finally {
         if (stream != null) {
            try {
               stream.close();
            } catch (IOException e) {
               e.printStackTrace();
            }
         }

         if (output != null) {
            try {
               output.close();
            } catch (IOException e) {
               e.printStackTrace();
            }
         }

      }

      return var9;
   }

   public static List<ColumnInfo> getESColumnInfoList(TCoreDatasystem datasystem, String schemaName, String tableName) {
      List<ColumnInfo> columnInfoList = new ArrayList();
      List<String> types = new ArrayList();
      Optional<DataBase> dataBase = null;
      Optional<Schema> schema = null;
      Optional<Table> table = null;
      List<DataBase> dataBaseList = JdbcCacheUtil.dataBaseList;
      dataBase = dataBaseList.stream().filter((x) -> x.getIp_port().equals(datasystem.getDbip() + ":" + datasystem.getDbport())).findFirst();
      if (dataBase.isPresent()) {
         List<Schema> schemaList = ((DataBase)dataBase.get()).getSchemaList();
         schema = schemaList.stream().filter((s) -> schemaName.equals(s.getName())).findFirst();
         if (schema.isPresent()) {
            List<Table> tableList = ((Schema)schema.get()).getTableList();
            tableList.stream().forEach((t) -> types.add(t.getName()));
            table = tableList.stream().filter((t) -> tableName.equals(t.getName())).findFirst();
            if (table.isPresent()) {
               for(Column c : ((Table)table.get()).getColumnList()) {
                  ColumnInfo columnInfo = new ColumnInfo();
                  columnInfo.setColumnname(c.getColumnName());
                  columnInfo.setTablename(c.getTable());
                  columnInfo.setTableschem(c.getSchema());
                  columnInfo.setDatatype(c.getDataType());
                  columnInfoList.add(columnInfo);
               }
            }
         }
      }

      return columnInfoList;
   }

   public String query(TCoreDatasystem tCoreDatasystem, String essql) {
      final CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
      credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(tCoreDatasystem.getUsername(), AesTool.decrypt(tCoreDatasystem.getPassword(), "ghca")));
      RestClient restClient = RestClient.builder(new HttpHost[]{new HttpHost(tCoreDatasystem.getDbip(), Integer.parseInt(tCoreDatasystem.getDbport()), "http")}).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback() {
         public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
            return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
         }
      }).build();
      String indexMapping = null;

      try {
         Request getRequest = new Request("GET", essql);
         Response response1 = restClient.performRequest(getRequest);
         HttpEntity entity = response1.getEntity();
         indexMapping = EntityUtils.toString(entity);
      } catch (Exception var9) {
         if (var9 instanceof RuntimeException && "UTF_8".equals(var9.getMessage())) {
            return HttpUtils.doPostES("http://" + tCoreDatasystem.getDbip() + ":" + tCoreDatasystem.getDbport() + essql, tCoreDatasystem.getUsername(), tCoreDatasystem.getPassword());
         }

         var9.printStackTrace();
      }

      return indexMapping;
   }

   public String webtoolsquery(TCoreDatasystem tCoreDatasystem, String essql) {
      final CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
      credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(tCoreDatasystem.getUsername(), tCoreDatasystem.getPassword()));
      RestClient restClient = RestClient.builder(new HttpHost[]{new HttpHost(tCoreDatasystem.getDbip(), Integer.parseInt(tCoreDatasystem.getDbport()), "http")}).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback() {
         public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
            return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
         }
      }).build();
      String indexMapping = null;

      try {
         Request getRequest = new Request("GET", essql);
         Response response1 = restClient.performRequest(getRequest);
         HttpEntity entity = response1.getEntity();
         indexMapping = EntityUtils.toString(entity);
      } catch (Exception var9) {
         if (var9 instanceof RuntimeException && "UTF_8".equals(var9.getMessage())) {
            return HttpUtils.doPostES("http://" + tCoreDatasystem.getDbip() + ":" + tCoreDatasystem.getDbport() + essql, tCoreDatasystem.getUsername(), tCoreDatasystem.getPassword());
         }

         var9.printStackTrace();
      }

      return indexMapping;
   }

   public boolean getVersionDelType(ClientInterface clientUtil) {
      LinkedHashMap version = (LinkedHashMap)clientUtil.getClusterInfo().get("version");
      String number = (String)version.get("number");
      if (StringUtils.isNotEmpty(number)) {
         String[] split = number.split("\\.");
         int i = Integer.parseInt(split[0]);
         if (i > 6) {
            return true;
         }
      }

      return false;
   }

   public static String getDocumentValue(String columnName, MetaMap data) {
      if (!columnName.contains(".")) {
         Object o = data.get(columnName);
         if (null == o) {
            return "";
         } else {
            return o instanceof String ? (String)o : "";
         }
      } else {
         String[] columns = columnName.split("\\.");
         int length = columns.length;
         LinkedHashMap o = (LinkedHashMap)data.get(columns[0]);

         for(int i = 1; i < length; ++i) {
            if (o.get(columns[i]) instanceof String) {
               return (String)o.get(columns[i]);
            }

            o = (LinkedHashMap)o.get(columns[i]);
         }

         return "";
      }
   }

   public static MetaMap putDocumentValue(String columnName, String value, MetaMap data) {
      if (!columnName.contains(".")) {
         data.put(columnName, value);
         return data;
      } else {
         setNestedValue(data, columnName.split("\\."), value);
         return data;
      }
   }

   private static void setNestedValue(LinkedHashMap<String, Object> map, String[] keys, String value) {
      for(int i = 0; i < keys.length - 1; ++i) {
         String key = keys[i];
         LinkedHashMap<String, Object> nestedMap = (LinkedHashMap)map.get(key);
         if (nestedMap == null) {
            nestedMap = new LinkedHashMap();
            map.put(key, nestedMap);
         }

         map = nestedMap;
      }

      String lowestKey = keys[keys.length - 1];
      map.put(lowestKey, value);
   }

   public static void main(String[] args) throws Exception {
      EsUtil esUtil = new EsUtil();
      Object[] objects = esUtil.queryAllIndex("192.168.2.191", 9600, "elastic", "elastic6");

      for(Object object : objects) {
         System.out.println(object);
      }

   }
}
