package com.chenyang.nse.bussiness.tools.http;

import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.ParseException;
import org.apache.commons.lang3.StringUtils;

public class ObjectUtils {
   public static Number getNumber(Object obj) {
      if (obj != null && !StringUtils.isEmpty(String.valueOf(obj))) {
         Number result;
         if (obj instanceof Number) {
            result = (Number)obj;
         } else {
            result = new BigInteger((String)obj);
         }

         return result;
      } else {
         return 0;
      }
   }

   public static int getInteger(Object obj) {
      if (obj != null && !StringUtils.isEmpty(String.valueOf(obj))) {
         int result;
         if (obj instanceof Number) {
            result = ((Number)obj).intValue();
         } else {
            try {
               result = NumberFormat.getInstance().parse((String)obj).intValue();
            } catch (ParseException e) {
               result = 0;
               e.printStackTrace();
            }
         }

         return result;
      } else {
         return 0;
      }
   }

   public static long getLong(Object obj) {
      if (obj != null && !StringUtils.isEmpty(String.valueOf(obj))) {
         long result;
         if (obj instanceof Number) {
            result = ((Number)obj).longValue();
         } else {
            result = Long.parseLong((String)obj);
         }

         return result;
      } else {
         return 0L;
      }
   }

   public static String getString(Object obj) {
      if (obj == null) {
         return "";
      } else {
         String result;
         if (obj instanceof Number) {
            result = ((Number)obj).toString();
         } else {
            result = (String)obj;
         }

         return result;
      }
   }
}
