package com.chenyang.nse.bussiness.tools.jdbc;

import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.power.xml.entity.ColumnInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class JDBCUtils {
   private String ip;
   private String port;
   private String servicename;
   private String user;
   private String pwd;

   public JDBCUtils(TCoreDatasystem tcoreDatasystem) {
      this.ip = tcoreDatasystem.getDbip();
      this.port = tcoreDatasystem.getDbport();
      this.servicename = tcoreDatasystem.getServername();
      this.user = tcoreDatasystem.getUsername();
      this.pwd = tcoreDatasystem.getPassword();
   }

   public Connection getOracleConnection() {
      String ORACLE_DRIVER = "oracle.jdbc.OracleDriver";
      String ORACLE_URL = "jdbc:oracle:thin:@" + this.ip + ":" + this.port + ":" + this.servicename;
      String ORACLE_USER = this.user;
      String ORACLE_PASSWORD = this.pwd;
      Connection conn = null;

      try {
         Class.forName(ORACLE_DRIVER);
         conn = DriverManager.getConnection(ORACLE_URL, ORACLE_USER, ORACLE_PASSWORD);
      } catch (ClassNotFoundException e) {
         e.printStackTrace();
      } catch (SQLException e) {
         e.printStackTrace();
      }

      return conn;
   }

   public void close(ResultSet rs, Statement stmt, Connection conn) {
      if (rs != null) {
         try {
            rs.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }
      }

      if (stmt != null) {
         try {
            stmt.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }
      }

      if (conn != null) {
         try {
            conn.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }
      }

   }

   public List<String> getOracleTablesOrdinary() {
      String sql = "select table_name from tabs ";
      Connection conn = null;
      PreparedStatement pstmt = null;
      ResultSet rs = null;
      ResultSetMetaData rsmd = null;
      List<String> tableList = new ArrayList();

      try {
         conn = this.getOracleConnection();
         pstmt = conn.prepareStatement(sql);
         rs = pstmt.executeQuery();

         while(rs.next()) {
            tableList.add(rs.getString("TABLE_NAME"));
         }
      } catch (SQLException var11) {
         System.out.println("此用户权限不足");
      } finally {
         this.close(rs, pstmt, conn);
      }

      return tableList;
   }

   public List<String> getOracleTablesDBA(String schema) {
      String sql = "select table_name from dba_tables where owner='" + schema + "'";
      Connection conn = null;
      PreparedStatement pstmt = null;
      ResultSet rs = null;
      ResultSetMetaData rsmd = null;
      List<String> tableList = new ArrayList();

      try {
         conn = this.getOracleConnection();
         pstmt = conn.prepareStatement(sql);
         rs = pstmt.executeQuery();

         while(rs.next()) {
            tableList.add(rs.getString("TABLE_NAME"));
         }
      } catch (SQLException var12) {
         System.out.println("此用户权限不足");
      } finally {
         this.close(rs, pstmt, conn);
      }

      return tableList;
   }

   public List<ColumnInfo> getOracleColumnInfoOrdinary(String tableName) {
      String sql = "select * from user_tab_columns where table_Name='" + tableName + "'";
      Connection conn = null;
      PreparedStatement pstmt = null;
      ResultSet rs = null;
      ResultSetMetaData rsmd = null;
      List<ColumnInfo> columnInfoList = new ArrayList();

      try {
         conn = this.getOracleConnection();
         pstmt = conn.prepareStatement(sql);
         rs = pstmt.executeQuery();

         while(rs.next()) {
            ColumnInfo columninfo = new ColumnInfo();
            String columnName = rs.getString("COLUMN_NAME");
            String typeName = rs.getString("DATA_TYPE");
            String columnSize = rs.getString("DATA_LENGTH");
            String decimalDigits = rs.getString("DATA_SCALE");
            String nullLable = rs.getString("NULLABLE");
            columninfo.setColumnName(columnName);
            columninfo.setDataType(typeName);
            if (nullLable.equals("Y")) {
               columninfo.setNullable(0);
            } else {
               columninfo.setNullable(1);
            }

            columninfo.setPrecision(columnSize);
            columninfo.setScale(decimalDigits);
            columnInfoList.add(columninfo);
         }
      } catch (SQLException var17) {
         System.out.println("此用户权限不足,无法读取" + tableName + "表结构");
      } finally {
         if (columnInfoList.size() == 0) {
            System.out.println("此用户权限不足,无法读取" + tableName + "表结构");
         }

         this.close(rs, pstmt, conn);
      }

      return columnInfoList;
   }

   public List<ColumnInfo> getOracleColumnInfoDBA(String schema, String tableName) {
      Connection conn = null;
      PreparedStatement pstmt = null;
      ResultSet rs = null;
      ResultSetMetaData rsmd = null;
      List<ColumnInfo> columnInfoList = new ArrayList();

      try {
         conn = this.getOracleConnection();
         DatabaseMetaData metaData = conn.getMetaData();
         rs = metaData.getColumns((String)null, schema, tableName, (String)null);

         while(rs.next()) {
            ColumnInfo columninfo = new ColumnInfo();
            String columnName = rs.getString("COLUMN_NAME");
            String typeName = rs.getString("TYPE_NAME");
            String columnSize = rs.getString("COLUMN_SIZE");
            String decimalDigits = rs.getString("DECIMAL_DIGITS");
            int nullLable = rs.getInt("NULLABLE");
            columninfo.setColumnName(columnName);
            columninfo.setDataType(typeName);
            columninfo.setNullable(nullLable);
            columninfo.setPrecision(columnSize);
            columninfo.setScale(decimalDigits);
            columnInfoList.add(columninfo);
         }
      } catch (SQLException e) {
         e.printStackTrace();
         System.out.println("此用户权限不足,无法读取" + tableName + "表结构");
      } finally {
         if (columnInfoList.size() == 0) {
            System.out.println("此用户权限不足,无法读取" + tableName + "表结构");
         }

         this.close(rs, pstmt, conn);
      }

      return columnInfoList;
   }
}
