package com.chenyang.nse.bussiness.tools.jdbc;

import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.tools.es.EsUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class QueryBloodTool {
   public static double getTabelNum(TCoreDatasystem datasystem, Connection conn, String schema, String dbtype) {
      ResultSet rs = null;
      PreparedStatement ps = null;
      double tablenum = (double)0.0F;

      try {
         try {
            String sql = "";
            if (!dbtype.equals("MYSQL") && !dbtype.equals("POSTGRESQL") && !dbtype.equals("GAUSS") && !dbtype.equals("GREENPLUM") && !dbtype.equals("OCEANBASE") && !dbtype.equals("MARIADB")) {
               if (!dbtype.equals("ORACLE") && !dbtype.equals("DM")) {
                  if (dbtype.equals("KINGBASE")) {
                     sql = "select count(*) TABLENUM from INFORMATION_SCHEMA.TABLES where TABLE_TYPE = 'BASE TABLE' and TABLE_SCHEMA = '" + schema + "'";
                  } else if (dbtype.equals("MSSQLSERVER")) {
                     sql = "select count(*) TABLENUM from sys.objects o join sys.schemas s on o.schema_id = s.schema_id where s.name = '" + schema + "'  and o.type = 'U'";
                  } else if (dbtype.equals("HIVE")) {
                     JdbcTool.closeConnection(conn);
                     conn = JdbcTool.getConnection("jdbc:hive2://" + datasystem.getDbip() + ":" + datasystem.getDbport() + "/" + schema, datasystem.getUsername(), datasystem.getPassword());
                     sql = "show tables";
                  } else if (dbtype.equals("HIVE_TDH")) {
                     sql = "SELECT count(*) TABLENUM FROM `system`.`tables_v` where `database_name` = '" + schema + "'";
                  } else if (dbtype.equals("MONGODB")) {
                     tablenum = (double)MongodbTool.getTableCount(datasystem, schema);
                  } else if (dbtype.equals("ES")) {
                     EsUtil esUtil = new EsUtil();
                     Set<String> esType = esUtil.getESType(datasystem, schema);
                     tablenum = (double)esType.size();
                  } else if (dbtype.equals("DB2")) {
                     sql = "SELECT count(*) TABLENUM FROM syscat.tables where tabschema = '" + schema + "'";
                  }
               } else {
                  sql = "SELECT COUNT(DISTINCT TABLE_NAME) TABLENUM FROM all_tab_cols WHERE OWNER ='" + schema + "'";
               }
            } else {
               sql = "SELECT COUNT(DISTINCT TABLE_NAME) TABLENUM FROM INFORMATION_SCHEMA. COLUMNS WHERE table_schema = '" + schema + "'";
            }

            if ("HIVE".equals(dbtype)) {
               if (!"".equals(sql) && conn != null) {
                  ps = conn.prepareStatement(sql);

                  for(rs = ps.executeQuery(); rs.next(); tablenum = (double)rs.getRow()) {
                  }

                  rs.close();
                  ps.close();
               }
            } else if (!"".equals(sql) && conn != null) {
               ps = conn.prepareStatement(sql);

               for(rs = ps.executeQuery(); rs.next(); tablenum = rs.getDouble("TABLENUM")) {
               }

               rs.close();
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

         return tablenum;
      } finally {
         ;
      }
   }

   public static double getColumnNum(TCoreDatasystem datasystem, Connection conn, String schema, String dbtype) {
      ResultSet rs = null;
      PreparedStatement ps = null;
      double colnum = (double)0.0F;

      try {
         try {
            String sql = "";
            if (!dbtype.equals("MYSQL") && !dbtype.equals("POSTGRESQL") && !dbtype.equals("GAUSS") && !dbtype.equals("GREENPLUM") && !dbtype.equals("OCEANBASE") && !dbtype.equals("MARIADB")) {
               if (!dbtype.equals("ORACLE") && !dbtype.equals("DM")) {
                  if (dbtype.equals("KINGBASE")) {
                     sql = "select COUNT(*) COLUMNNUM from INFORMATION_SCHEMA.COLUMNS where TABLE_SCHEMA = '" + schema + "'";
                  } else if (dbtype.equals("MSSQLSERVER")) {
                     sql = "select count(*) COLUMNNUM  FROM SysColumns Where id in (select object_id from sys.objects o join sys.schemas s on o.schema_id = s.schema_id where s.name = '" + schema + "'  and o.type = 'U')";
                  } else if (dbtype.equals("HIVE")) {
                     sql = "desc " + schema + ".";
                  } else if (dbtype.equals("HIVE_TDH")) {
                     sql = "SELECT count(*) COLUMNNUM FROM `system`.`columns_v`  WHERE `database_name` = '" + schema + "'";
                  } else if (dbtype.equals("DB2")) {
                     sql = "SELECT count(*) COLUMNNUM FROM syscat.columns  WHERE tabschema = '" + schema + "'";
                  }
               } else {
                  sql = " SELECT  COUNT(COLUMN_NAME) COLUMNNUM FROM all_tab_cols WHERE OWNER = '" + schema + "'";
               }
            } else {
               sql = "SELECT COUNT(COLUMN_NAME) COLUMNNUM  FROM INFORMATION_SCHEMA. COLUMNS WHERE table_schema = '" + schema + "'";
            }

            if (dbtype.equals("HIVE")) {
               JdbcTool.closeConnection(conn);
               conn = JdbcTool.getConnection("jdbc:hive2://" + datasystem.getDbip() + ":" + datasystem.getDbport() + "/" + schema, datasystem.getUsername(), datasystem.getPassword());
               String sql1 = "show tables";
               List<String> tables = new ArrayList();
               ps = conn.prepareStatement(sql1);
               rs = ps.executeQuery();

               while(rs.next()) {
                  tables.add(rs.getString("tab_name"));
               }

               for(String table : tables) {
                  PreparedStatement ps1 = conn.prepareStatement(sql + table);

                  for(ResultSet rs1 = ps1.executeQuery(); rs1.next(); colnum += (double)rs1.getRow()) {
                  }
               }
            } else if (dbtype.equals("MONGODB")) {
               colnum = (double)MongodbTool.getColumnCount(datasystem, schema);
            } else if (dbtype.equals("ES")) {
               EsUtil esUtil = new EsUtil();
               Set<String> columns = esUtil.getColumns(datasystem, schema, (String)null);
               colnum += (double)columns.size();
            } else if (!"".equals(sql) && conn != null) {
               ps = conn.prepareStatement(sql);

               for(rs = ps.executeQuery(); rs.next(); colnum = rs.getDouble("COLUMNNUM")) {
               }

               rs.close();
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         } catch (Exception e) {
            e.printStackTrace();
         }

         return colnum;
      } finally {
         ;
      }
   }
}
