package com.chenyang.nse.bussiness.tools.propertyutil;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import java.io.IOException;
import java.util.Properties;
import org.springframework.stereotype.Component;

@Component
public class PropertyGhcaUtil {
   public static String copySuffix = "_copy";
   public static String initialSuffix = "_initial";
   public static String cipherSuffix = "_cipher";
   public static String digestSuffix = "_enc";
   public static String encryptionlikeopen = "0";
   public static Integer checkNum = 100;
   public static String encryptionlabel = "jm_";
   public static String mongodbpk = "_id";
   public static String ELASTIC_SEARCH_PK = "_id";

   static {
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String copSuffix = props.getProperty("copySuffix");
         if (null != copSuffix && !"".equals(copSuffix.trim())) {
            copySuffix = copSuffix;
         }

         String initiaSuffix = props.getProperty("initialSuffix");
         if (null != initiaSuffix && !"".equals(initiaSuffix.trim())) {
            initialSuffix = initiaSuffix;
         }

         String ciherSuffix = props.getProperty("cipherSuffix");
         if (null != ciherSuffix && !"".equals(ciherSuffix.trim())) {
            cipherSuffix = ciherSuffix;
         }

         String diestSuffix = props.getProperty("digestSuffix");
         if (null != diestSuffix && !"".equals(diestSuffix.trim())) {
            digestSuffix = diestSuffix;
         }

         String encryptionlikeope = props.getProperty("encryption.like.open");
         if (null != encryptionlikeope && !"".equals(encryptionlikeope.trim())) {
            encryptionlikeopen = encryptionlikeope;
         }

         String mongodbp = props.getProperty("encryption.mongodbpk");
         if (null != encryptionlikeope && !"".equals(encryptionlikeope.trim())) {
            mongodbpk = mongodbp;
         }

         String encryptionlabe = props.getProperty("encryption.label");
         if (null != encryptionlabe && !"".equals(encryptionlabe.trim())) {
            encryptionlabel = encryptionlabe;
         }

         checkNum = Integer.parseInt(props.getProperty("checkNum"));
      } catch (IOException e) {
         e.printStackTrace();
      }

   }
}
