package com.chenyang.nse.bussiness.tools.serialize;

import com.chenyang.nse.bussiness.tools.io.FileTool;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SerializeTool {
   public static void saveObject(Object object, String filePath, String fileName) {
      ObjectOutputStream out = null;
      FileOutputStream fout = null;

      try {
         FileTool.createFolder(filePath);
         fout = new FileOutputStream(filePath + fileName + ".txt");
         out = new ObjectOutputStream(fout);
         out.writeObject(object);
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         try {
            if (null != fout) {
               fout.close();
            }

            if (null != out) {
               out.close();
            }
         } catch (IOException e) {
            e.printStackTrace();
         }

      }

   }

   public static Object readObject(String filePath, String fileName) {
      ObjectInputStream in = null;
      FileInputStream fin = null;
      Object object = null;

      try {
         FileTool.createFolder(filePath);
         fin = new FileInputStream(filePath + fileName + ".txt");
         in = new ObjectInputStream(fin);
         object = in.readObject();
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         try {
            if (null != fin) {
               fin.close();
            }

            if (null != in) {
               in.close();
            }
         } catch (IOException e) {
            e.printStackTrace();
         }

         return object;
      }
   }
}
