package com.chenyang.nse.bussiness.tools.systemenvironment;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class CpuAndMemory {
   private static String DEFAULTCHART = "UTF-8";
   private static Connection conn;
   private String ip;
   private String userName;
   private String userPwd;

   public CpuAndMemory() {
   }

   public CpuAndMemory(String ip, String userName, String userPwd) {
      this.ip = ip;
      this.userName = userName;
      this.userPwd = userPwd;
   }

   public Boolean login() {
      boolean flg = false;

      try {
         conn = new Connection(this.ip);
         conn.connect();
         flg = conn.authenticateWithPassword(this.userName, this.userPwd);
         if (flg) {
            System.out.println("认证成功！");
         }
      } catch (IOException e) {
         e.printStackTrace();
      }

      return flg;
   }

   public String execute(String cmd) {
      String result = "";

      try {
         if (this.login()) {
            Session session = conn.openSession();
            session.execCommand(cmd);
            result = processStdout(session.getStdout(), DEFAULTCHART);
            if (StringUtils.isBlank(result)) {
               result = processStdout(session.getStderr(), DEFAULTCHART);
            }

            conn.close();
            session.close();
         }
      } catch (IOException e) {
         e.printStackTrace();
      }

      return result;
   }

   public String executeSuccess(String cmd) {
      String result = "";

      try {
         if (this.login()) {
            Session session = conn.openSession();
            session.execCommand(cmd);
            result = processStdout(session.getStdout(), DEFAULTCHART);
            conn.close();
            session.close();
         }
      } catch (IOException e) {
         e.printStackTrace();
      }

      return result;
   }

   public static String processStdout(InputStream in, String charset) {
      InputStream stdout = new StreamGobbler(in);
      StringBuffer buffer = new StringBuffer();

      try {
         BufferedReader br = new BufferedReader(new InputStreamReader(stdout, charset));
         String line = null;

         while((line = br.readLine()) != null) {
            buffer.append(line + "\n");
         }

         br.close();
      } catch (UnsupportedEncodingException e) {
         e.printStackTrace();
      } catch (IOException e) {
         e.printStackTrace();
      }

      return buffer.toString();
   }

   public static List<String[]> command(String ip, String username) {
      CpuAndMemory rec = new CpuAndMemory(ip, "root", "root");
      List<String[]> cpuAndMemory = new ArrayList();

      try {
         if (rec.login()) {
            Session session = conn.openSession();
            session.execCommand("ps -aux | grep " + username);
            String result = processStdout(session.getStdout(), DEFAULTCHART);
            if (StringUtils.isBlank(result)) {
               System.out.println("脚本出错");
               result = processStdout(session.getStderr(), DEFAULTCHART);
            }

            String regex = "\\S+\\s+[0-9]+\\s+[0-9]+.[0-9]\\s+[0-9]+.[0-9]";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(result);

            while(m.find()) {
               cpuAndMemory.add(m.group().split("\\s+"));
            }

            session.close();
            conn.close();
         }
      } catch (IOException e) {
         e.printStackTrace();
      }

      return cpuAndMemory;
   }

   public static void main(String[] args) {
      new ArrayList();
      Double cpu = (double)0.0F;
      Double memory = (double)0.0F;

      for(String[] strings : command("192.168.2.221", "gpadmin")) {
         cpu = cpu + (double)Float.parseFloat(strings[2]);
      }

      System.out.println(cpu);
   }
}
