package com.chenyang.nse.bussiness.tools.xml;

import com.chenyang.nse.bussiness.entity.orm.table.core.mappletxml.TCoreRulEKeyStrInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.mappletxml.TCoreRulePort;
import com.chenyang.nse.bussiness.entity.orm.table.core.mappletxml.TCoreRuleRandomNumInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.mappletxml.TCoreRuleRandomStrInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.mappletxml.TCoreRuleSubstitutionInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.mappletxml.TCoreRuleTransformationInfo;
import com.chenyang.nse.bussiness.entity.vo.mappletxml.MappletxmlVO;
import com.chenyang.nse.bussiness.entity.vo.mappletxml.TCoreRulePortVO;
import com.chenyang.nse.bussiness.entity.vo.mappletxml.TCoreRuleTransformationInfoVO;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Document;

public class MappletXmlImpl implements MappletXml {
   public Document generateMapplet(MappletxmlVO mappletxmlVO, Document doc) throws Exception {
      Map<String, String> mappletxml = new HashMap();
      List<TCoreRuleTransformationInfoVO> transformationInfoList = mappletxmlVO.getTransformationInfoList();
      mappletxml.put("NAME", mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname());
      doc = DomUtils.addEditElement(doc, "MAPPLET", mappletxml);
      doc = DomUtils.removeElement(doc, "MAPPLET[1]");
      Map<String, String> sessionattr = new HashMap();
      List<String> transformationInfotypelist = new ArrayList();

      for(TCoreRuleTransformationInfoVO TransformationInfovo : transformationInfoList) {
         TCoreRuleTransformationInfo transformationInfo = TransformationInfovo.gettCoreRuleTransformationInfo();
         transformationInfotypelist.add(transformationInfo.getType());
         sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@TYPE='Mapplet']--NAME", mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname());
         if (transformationInfo.getType().equals("Data_Masking")) {
            Map<String, String> transformationmap = new HashMap();
            transformationmap.put("NAME", TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname());
            doc = DomUtils.addEditElements(doc, "TRANSFORMATION[4]", transformationmap);

            for(TCoreRulePortVO tCoreRulePortVO : TransformationInfovo.getPortListVO()) {
               TCoreRulePort tCoreRulePort = tCoreRulePortVO.gettCoreRulePort();
               Map<String, String> transformfieldmap = new HashMap();
               transformfieldmap.put("NAME", tCoreRulePort.getPortname());
               doc = DomUtils.addEditElementss(doc, "MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[1]", transformfieldmap);
               sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[@NAME='" + tCoreRulePort.getPortname() + "']--SCALE", tCoreRulePort.getScalesss());
               sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[@NAME='" + tCoreRulePort.getPortname() + "']--PRECISION", tCoreRulePort.getPrecisionsss());
               sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[@NAME='" + tCoreRulePort.getPortname() + "']--DATATYPE", tCoreRulePort.getDatatypesss());
               sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@TYPE='Mapplet']/TRANSFORMFIELD[@PORTTYPE='INPUT']--PRECISION", tCoreRulePort.getPrecisionsss());
               sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@TYPE='Mapplet']/TRANSFORMFIELD[@PORTTYPE='INPUT']--DATATYPE", tCoreRulePort.getDatatypesss());
               sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@TYPE='Mapplet']/TRANSFORMFIELD[@PORTTYPE='INPUT']--SCALE", tCoreRulePort.getScalesss());
            }

            for(TCoreRulePortVO tCoreRulePortVO : TransformationInfovo.getPortListVO()) {
               TCoreRulePort tCoreRulePort = tCoreRulePortVO.gettCoreRulePort();
               Map<String, String> transformfieldmaps = new HashMap();
               transformfieldmaps.put("NAME", tCoreRulePort.getAssociateOP());
               doc = DomUtils.addEditElementss(doc, "MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[2]", transformfieldmaps);
               sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[@NAME='" + tCoreRulePort.getAssociateOP() + "']--SCALE", tCoreRulePort.getScalesss());
               sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[@NAME='" + tCoreRulePort.getAssociateOP() + "']--PRECISION", tCoreRulePort.getPrecisionsss());
               sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[@NAME='" + tCoreRulePort.getAssociateOP() + "']--DATATYPE", tCoreRulePort.getDatatypesss());
            }

            doc = DomUtils.removeElementss(doc, "MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[@NAME='']");
            doc = DomUtils.removeElementss(doc, "MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[1]");

            for(int i = 1; i <= 16; ++i) {
               doc = DomUtils.addEditElementss(doc, "MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TABLEATTRIBUTE[" + i + "]", (Map)null);
            }

            for(int i = 1; i <= 16; ++i) {
               doc = DomUtils.removeElementss(doc, "MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TABLEATTRIBUTE[1]");
            }

            for(int i = 1; i <= 2; ++i) {
               doc = DomUtils.addEditElementss(doc, "MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/INITPROP[" + i + "]", (Map)null);
            }

            for(int i = 1; i <= 2; ++i) {
               doc = DomUtils.removeElementss(doc, "MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/INITPROP[1]");
            }

            doc = DomUtils.addEditElementss(doc, "MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/METADATAEXTENSION[1]", (Map)null);

            for(TCoreRulePortVO tCoreRulePortVO : TransformationInfovo.getPortListVO()) {
               TCoreRulePort tCoreRulePort = tCoreRulePortVO.gettCoreRulePort();
               if (!"无屏蔽".equals(tCoreRulePort.getMaskingOption())) {
                  doc = DomUtils.addEditElementss(doc, "MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/METADATAEXTENSION[2]", (Map)null);
               }

               if ("substitution".equals(tCoreRulePort.getMaskingOption())) {
                  TCoreRuleSubstitutionInfo substitutionInfo = tCoreRulePortVO.gettCoreRuleSubstitutionInfo();
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/METADATAEXTENSION[2][@DATATYPE='XML']--VALUE", "<?xml version='1.0' encoding='UTF-16' standalone='no' ?><PORT_INFORMATION><CODEPAGE ID='en_US' NAME='English'/><PORTINFO><PORT DATA_TYPE=\"" + tCoreRulePort.getDatatypesss() + "\" MASKING_OPTION=\"" + tCoreRulePort.getMaskingOption() + "\" NAME=\"" + tCoreRulePort.getPortname() + "\" PRECISION=\"" + tCoreRulePort.getPrecisionsss() + "\" SCALE=\"" + tCoreRulePort.getScalesss() + "\" SEED=\"" + substitutionInfo.getSeedvalue() + "\" SPECIAL=\"\" TYPE='14'><SUBSTITUTION COLUMNNAME=\"" + substitutionInfo.getColumnname() + "\" CONDITIONCOLUMN='' DATASOURCE='' DICTCOLUMN=\"" + substitutionInfo.getDictcolumn() + "\" FILEENCODING='936' FILELOCALE='_.MS936@default' INPUTPORT=\"" + substitutionInfo.getInputport() + "\" IS_DICTIONARY_RELATIONAL='FALSE' IS_KEY_MASKED=\"" + substitutionInfo.getIsKeyMasked() + "\" IS_OUTPUT_UNIQUE=\"" + substitutionInfo.getIsOutputUnique() + "\" IS_PARAMETRIZED='FALSE' IS_SHUFFLE='FALSE' TABLENAME=\"" + substitutionInfo.getTablename() + "\" UNIQUE_COLUMN=\"" + substitutionInfo.getUniqueColumn() + "\"><TABLECOLUMN NAME=\"" + substitutionInfo.getDictcolumn() + "\"/><TABLECOLUMN NAME=\"" + substitutionInfo.getColumnname() + "\"/><TABLECOLUMNINT NAMEINT=\"" + substitutionInfo.getDictcolumn() + "\"/><TABLECOLUMNINT NAMEINT=\"" + substitutionInfo.getColumnname() + "\"/><TABLECOLUMNSTR NAMESTR=\"" + substitutionInfo.getDictcolumn() + "\"/><TABLECOLUMNSTR NAMESTR=\"" + substitutionInfo.getColumnname() + "\"/></SUBSTITUTION></PORT></PORTINFO></PORT_INFORMATION>");
               } else if ("randomstr".equals(tCoreRulePort.getMaskingOption())) {
                  TCoreRuleRandomStrInfo randomStrInfo = tCoreRulePortVO.gettCoreRuleRandomStrInfo();
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/METADATAEXTENSION[2][@DATATYPE='XML']--VALUE", "<?xml version='1.0' encoding='UTF-16' standalone='no' ?><PORT_INFORMATION><CODEPAGE ID='zh_CN' NAME='English'/><PORTINFO><PORT DATA_TYPE=\"" + tCoreRulePort.getDatatypesss() + "\" MASKING_OPTION=\"Random\" NAME=\"" + tCoreRulePort.getPortname() + "\" PRECISION=\"" + tCoreRulePort.getPrecisionsss() + "\" SCALE=\"" + tCoreRulePort.getScalesss() + "\" SPECIAL=\"\" TYPE='2'><STRING FILTER_SOURCE_CHARACTERS=\"" + randomStrInfo.getFilterSourceCharacters() + "\" FILTER_SOURCE_OPTION=\"" + randomStrInfo.getFilterSourceOption() + "\"  FILTER_TARGET_CHARACTERS=\"" + randomStrInfo.getFilterTargetCharacters() + "\" FILTER_TARGET_OPTION=\"" + randomStrInfo.getFilterTargetOption() + "\" MASK_FORMAT=\"" + randomStrInfo.getMaskFormat() + "\" MAXIMUM_WIDTH=\"" + randomStrInfo.getMaximumWidth() + "\" MINIMUM_WIDTH=\"" + randomStrInfo.getMinimumWidth() + "\" RANDOM_STRING='FALSE' SOURCE_CHARACTERS=\"" + randomStrInfo.getSourceCharacters() + "\" TARGET_CHARACTERS=\"" + randomStrInfo.getTargetCharacters() + "\"/></PORT></PORTINFO></PORT_INFORMATION>");
               } else if ("keystr".equals(tCoreRulePort.getMaskingOption())) {
                  TCoreRulEKeyStrInfo keyStrInfo = tCoreRulePortVO.gettCoreRulEKeyStrInfo();
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/METADATAEXTENSION[2][@DATATYPE='XML']--VALUE", "<?xml version='1.0' encoding='UTF-16' standalone='no' ?><PORT_INFORMATION><CODEPAGE ID='zh_CN' NAME='English'/><PORTINFO><PORT DATA_TYPE=\"" + tCoreRulePort.getDatatypesss() + "\" MASKING_OPTION=\"Key\" NAME=\"" + tCoreRulePort.getPortname() + "\" PRECISION=\"" + tCoreRulePort.getPrecisionsss() + "\" SCALE=\"" + tCoreRulePort.getScalesss() + "\" SEED=\"" + keyStrInfo.getSeedvalue() + "\" SPECIAL=\"\" TYPE='3'><STRING_WITHKEY FILTER_SOURCE_CHARACTERS=\"" + keyStrInfo.getFilterSourceCharacters() + "\" FILTER_SOURCE_OPTION=\"" + keyStrInfo.getFilterSourceOption() + "\" FILTER_TARGET_CHARACTERS=\"" + keyStrInfo.getFilterTargetCharacters() + "\" FILTER_TARGET_OPTION=\"" + keyStrInfo.getFilterTargetOption() + "\" IS_PARAMETRIZED='FALSE' MASK_FORMAT=\"" + keyStrInfo.getMaskFormat() + "\" SOURCE_CHARACTERS=\"" + keyStrInfo.getSourceCharacters() + "\" TARGET_CHARACTERS=\"" + keyStrInfo.getTargetCharacters() + "\"/></PORT></PORTINFO></PORT_INFORMATION>");
               } else if ("randomnum".equals(tCoreRulePort.getMaskingOption())) {
                  TCoreRuleRandomNumInfo randomNumInfo = tCoreRulePortVO.gettCoreRuleRandomNumInfo();
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/METADATAEXTENSION[2][@DATATYPE='XML']--VALUE", "<?xml version='1.0' encoding='UTF-16' standalone='no' ?><PORT_INFORMATION><CODEPAGE ID='en_US' NAME='US-ASCII'/><PORTINFO><PORT DATA_TYPE=\"" + tCoreRulePort.getDatatypesss() + "\" MASKING_OPTION=\"Random\" NAME=\"" + tCoreRulePort.getPortname() + "\" PRECISION=\"" + tCoreRulePort.getPrecisionsss() + "\" SCALE=\"" + tCoreRulePort.getScalesss() + "\" SPECIAL=\"\" TYPE='1'><NUMERIC BLUR=\"" + randomNumInfo.getBlur() + "\" BLURRING=\"" + randomNumInfo.getBlurring() + "\" BOUNDS=\"" + randomNumInfo.getBounds() + "\" HIGH_RANGE=\"" + randomNumInfo.getHighRange() + "\" LOW_RANGE=\"" + randomNumInfo.getLowRange() + "\" MAXIMUM=\"" + randomNumInfo.getMaximum() + "\" MINIMUM=\"" + randomNumInfo.getMinimum() + "\"/></PORT></PORTINFO></PORT_INFORMATION>");
               } else if ("keynum".equals(tCoreRulePort.getMaskingOption()) && "decimal".equals(tCoreRulePort.getDatatypesss())) {
                  TCoreRulEKeyStrInfo keyStrInfo = tCoreRulePortVO.gettCoreRulEKeyStrInfo();
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/METADATAEXTENSION[2][@DATATYPE='XML']--VALUE", "<?xml version='1.0' encoding='UTF-16' standalone='no' ?><PORT_INFORMATION><CODEPAGE ID='zh_CN' NAME='English'/><PORTINFO><PORT DATA_TYPE=\"" + tCoreRulePort.getDatatypesss() + "\" MASKING_OPTION=\"Key\" NAME=\"" + tCoreRulePort.getPortname() + "\" PRECISION=\"" + tCoreRulePort.getPrecisionsss() + "\" SCALE=\"" + tCoreRulePort.getScalesss() + "\" SEED=\"" + keyStrInfo.getSeedvalue() + "\" SPECIAL=\"\" TYPE='5'><NUMERIC_WITHKEY IS_PARAMETRIZED='FALSE'/></PORT></PORTINFO></PORT_INFORMATION>");
               } else if ("keynum".equals(tCoreRulePort.getMaskingOption()) && "date/time".equals(tCoreRulePort.getDatatypesss())) {
                  TCoreRulEKeyStrInfo keyStrInfo = tCoreRulePortVO.gettCoreRulEKeyStrInfo();
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/METADATAEXTENSION[2][@DATATYPE='XML']--VALUE", "<?xml version='1.0' encoding='UTF-16' standalone='no' ?><PORT_INFORMATION><CODEPAGE ID='zh_CN' NAME='English'/><PORTINFO><PORT DATA_TYPE=\"" + tCoreRulePort.getDatatypesss() + "\" MASKING_OPTION=\"Key\" NAME=\"" + tCoreRulePort.getPortname() + "\" PRECISION=\"" + tCoreRulePort.getPrecisionsss() + "\" SCALE=\"" + tCoreRulePort.getScalesss() + "\" SEED=\"" + keyStrInfo.getSeedvalue() + "\" SPECIAL=\"\" TYPE='5'><DATE_WITHKEY IS_PARAMETRIZED='FALSE'/></PORT></PORTINFO></PORT_INFORMATION>");
               } else if ("randomdate".equals(tCoreRulePort.getMaskingOption())) {
                  TCoreRuleRandomNumInfo randomNumInfo = tCoreRulePortVO.gettCoreRuleRandomNumInfo();
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/METADATAEXTENSION[2][@DATATYPE='XML']--VALUE", "<?xml version='1.0' encoding='UTF-16' standalone='no' ?><PORT_INFORMATION><CODEPAGE ID='zh_CN' NAME='English'/><PORTINFO><PORT DATA_TYPE=\"" + tCoreRulePort.getDatatypesss() + "\" MASKING_OPTION=\"Random\" NAME=\"" + tCoreRulePort.getPortname() + "\" PRECISION=\"" + tCoreRulePort.getPrecisionsss() + "\" SCALE=\"" + tCoreRulePort.getScalesss() + "\" SPECIAL='' TYPE='4'><DATE MAX=\"" + randomNumInfo.getMax() + "\" MIN=\"" + randomNumInfo.getMin() + "\" UNIT=\"" + randomNumInfo.getUnit() + "\" VALUE_SUBSTITUTION=\"" + randomNumInfo.getSubstitution() + "\"/></PORT></PORTINFO></PORT_INFORMATION>");
               }
            }

            doc = DomUtils.addEditElementss(doc, "MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/METADATAEXTENSION[3]", (Map)null);

            for(int i = 1; i <= 3; ++i) {
               doc = DomUtils.removeElementss(doc, "MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/METADATAEXTENSION[1]");
            }

            for(int i = 1; i <= 3; ++i) {
               doc = DomUtils.addEditElementss(doc, "MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELDATTRDEF[" + i + "]", (Map)null);
            }

            for(int i = 1; i <= 3; ++i) {
               doc = DomUtils.removeElementss(doc, "MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELDATTRDEF[1]");
            }
         } else if (!transformationInfo.getType().equals("EXPTRANS")) {
            if (transformationInfo.getType().equals("input")) {
               sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@TYPE='Input Transformation']--NAME", TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname());

               for(TCoreRulePortVO tCoreRulePortVO : TransformationInfovo.getPortListVO()) {
                  TCoreRulePort tCoreRulePort = tCoreRulePortVO.gettCoreRulePort();
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@TYPE='Input Transformation']/TRANSFORMFIELD--NAME", tCoreRulePort.getPortname());
               }
            } else if (transformationInfo.getType().equals("output")) {
               sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@TYPE='Output Transformation']--NAME", TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname());

               for(TCoreRulePortVO tCoreRulePortVO : TransformationInfovo.getPortListVO()) {
                  TCoreRulePort tCoreRulePort = tCoreRulePortVO.gettCoreRulePort();
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@TYPE='Output Transformation']/TRANSFORMFIELD--NAME", tCoreRulePort.getPortname());
               }
            }
         } else {
            Map<String, String> transformationmaps = new HashMap();
            transformationmaps.put("NAME", TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname());
            doc = DomUtils.addEditElements(doc, "TRANSFORMATION[1]", transformationmaps);

            for(TCoreRulePortVO tCoreRulePortVO : TransformationInfovo.getPortListVO()) {
               TCoreRulePort tCoreRulePort = tCoreRulePortVO.gettCoreRulePort();
               if ("INPUT".equals(tCoreRulePort.getPorttypesss())) {
                  Map<String, String> transformfieldmapss = new HashMap();
                  transformfieldmapss.put("NAME", tCoreRulePort.getPortname());
                  doc = DomUtils.addEditElementss(doc, "MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[1]", transformfieldmapss);
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[@NAME='" + tCoreRulePort.getPortname() + "']--SCALE", tCoreRulePort.getScalesss());
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[@NAME='" + tCoreRulePort.getPortname() + "']--PRECISION", tCoreRulePort.getPrecisionsss());
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[@NAME='" + tCoreRulePort.getPortname() + "']--DATATYPE", tCoreRulePort.getDatatypesss());
               } else if ("INPUT/OUTPUT".equals(tCoreRulePort.getPorttypesss())) {
                  Map<String, String> transformfieldmapsss = new HashMap();
                  transformfieldmapsss.put("NAME", tCoreRulePort.getPortname());
                  doc = DomUtils.addEditElementss(doc, "MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[2]", transformfieldmapsss);
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[@NAME='" + tCoreRulePort.getPortname() + "']--SCALE", tCoreRulePort.getScalesss());
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[@NAME='" + tCoreRulePort.getPortname() + "']--PRECISION", tCoreRulePort.getPrecisionsss());
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[@NAME='" + tCoreRulePort.getPortname() + "']--DATATYPE", tCoreRulePort.getDatatypesss());
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[@NAME='" + tCoreRulePort.getPortname() + "']--EXPRESSION", tCoreRulePort.getExpression());
               } else if ("本地变量".equals(tCoreRulePort.getPorttypesss())) {
                  Map<String, String> transformfieldmapsss = new HashMap();
                  transformfieldmapsss.put("NAME", tCoreRulePort.getPortname());
                  doc = DomUtils.addEditElementss(doc, "MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[3]", transformfieldmapsss);
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[@NAME='" + tCoreRulePort.getPortname() + "']--SCALE", tCoreRulePort.getScalesss());
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[@NAME='" + tCoreRulePort.getPortname() + "']--PRECISION", tCoreRulePort.getPrecisionsss());
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[@NAME='" + tCoreRulePort.getPortname() + "']--DATATYPE", tCoreRulePort.getDatatypesss());
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[@NAME='" + tCoreRulePort.getPortname() + "']--EXPRESSION", tCoreRulePort.getExpression());
               } else if ("OUTPUT".equals(tCoreRulePort.getPorttypesss())) {
                  Map<String, String> transformfieldmaps = new HashMap();
                  transformfieldmaps.put("NAME", tCoreRulePort.getPortname());
                  doc = DomUtils.addEditElementss(doc, "MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[4]", transformfieldmaps);
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[@NAME='" + tCoreRulePort.getPortname() + "']--SCALE", tCoreRulePort.getScalesss());
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[@NAME='" + tCoreRulePort.getPortname() + "']--PRECISION", tCoreRulePort.getPrecisionsss());
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[@NAME='" + tCoreRulePort.getPortname() + "']--DATATYPE", tCoreRulePort.getDatatypesss());
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[@NAME='" + tCoreRulePort.getPortname() + "']--EXPRESSION", tCoreRulePort.getExpression());
               }

               sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@TYPE='Mapplet']/TRANSFORMFIELD[@PORTTYPE='OUTPUT']--PRECISION", tCoreRulePort.getPrecisionsss());
               sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@TYPE='Mapplet']/TRANSFORMFIELD[@PORTTYPE='OUTPUT']--DATATYPE", tCoreRulePort.getDatatypesss());
               sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@TYPE='Mapplet']/TRANSFORMFIELD[@PORTTYPE='OUTPUT']--SCALE", tCoreRulePort.getScalesss());
            }

            doc = DomUtils.addEditElementss(doc, "MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TABLEATTRIBUTE[1]", (Map)null);
            doc = DomUtils.removeElementss(doc, "MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TABLEATTRIBUTE[1]");

            for(int i = 1; i <= 4; ++i) {
               doc = DomUtils.removeElementss(doc, "MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']/TRANSFORMFIELD[1]");
            }
         }
      }

      for(TCoreRuleTransformationInfoVO TransformationInfovo : transformationInfoList) {
         TCoreRuleTransformationInfo transformationInfo = TransformationInfovo.gettCoreRuleTransformationInfo();
         if (!transformationInfotypelist.contains("Data_Masking") && transformationInfo.getType().equals("EXPTRANS")) {
            for(TCoreRulePortVO tCoreRulePortVO : TransformationInfovo.getPortListVO()) {
               TCoreRulePort tCoreRulePort = tCoreRulePortVO.gettCoreRulePort();
               sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@TYPE='Mapplet']/TRANSFORMFIELD[@PORTTYPE='INPUT']--PRECISION", tCoreRulePort.getPrecisionsss());
               sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@TYPE='Mapplet']/TRANSFORMFIELD[@PORTTYPE='INPUT']--DATATYPE", tCoreRulePort.getDatatypesss());
               sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@TYPE='Mapplet']/TRANSFORMFIELD[@PORTTYPE='INPUT']--SCALE", tCoreRulePort.getScalesss());
            }
         }

         if (!transformationInfotypelist.contains("EXPTRANS") && transformationInfo.getType().equals("Data_Masking")) {
            for(TCoreRulePortVO tCoreRulePortVO : TransformationInfovo.getPortListVO()) {
               TCoreRulePort tCoreRulePort = tCoreRulePortVO.gettCoreRulePort();
               sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@TYPE='Mapplet']/TRANSFORMFIELD[@PORTTYPE='OUTPUT']--PRECISION", tCoreRulePort.getPrecisionsss());
               sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@TYPE='Mapplet']/TRANSFORMFIELD[@PORTTYPE='OUTPUT']--DATATYPE", tCoreRulePort.getDatatypesss());
               sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/TRANSFORMATION[@TYPE='Mapplet']/TRANSFORMFIELD[@PORTTYPE='OUTPUT']--SCALE", tCoreRulePort.getScalesss());
            }
         }
      }

      for(TCoreRuleTransformationInfoVO TransformationInfovo : transformationInfoList) {
         TCoreRuleTransformationInfo transformationInfo = TransformationInfovo.gettCoreRuleTransformationInfo();
         if (transformationInfo.getType().equals("Data_Masking")) {
            Map<String, String> instancemap = new HashMap();
            instancemap.put("NAME", TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname());
            doc = DomUtils.addEditElements(doc, "INSTANCE[4]", instancemap);
            sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/INSTANCE[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']--TRANSFORMATION_NAME", TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname());
         } else if (transformationInfo.getType().equals("EXPTRANS")) {
            Map<String, String> instancemaps = new HashMap();
            instancemaps.put("NAME", TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname());
            doc = DomUtils.addEditElements(doc, "INSTANCE[1]", instancemaps);
            sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/INSTANCE[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']--TRANSFORMATION_NAME", TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname());
         } else if (transformationInfo.getType().equals("input")) {
            Map<String, String> instancemapss = new HashMap();
            instancemapss.put("NAME", TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname());
            doc = DomUtils.addEditElements(doc, "INSTANCE[2]", instancemapss);
            sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/INSTANCE[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']--TRANSFORMATION_NAME", TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname());
         } else if (transformationInfo.getType().equals("output")) {
            Map<String, String> instancemapsss = new HashMap();
            instancemapsss.put("NAME", TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname());
            doc = DomUtils.addEditElements(doc, "INSTANCE[3]", instancemapsss);
            sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/INSTANCE[@NAME='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']--TRANSFORMATION_NAME", TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname());
         }
      }

      for(TCoreRuleTransformationInfoVO TransformationInfovo : transformationInfoList) {
         TCoreRuleTransformationInfo transformationInfo = TransformationInfovo.gettCoreRuleTransformationInfo();
         if (transformationInfo.getType().equals("Data_Masking")) {
            int a = 0;

            for(TCoreRulePortVO tCoreRulePortVO : TransformationInfovo.getPortListVO()) {
               TCoreRulePort tCoreRulePort = tCoreRulePortVO.gettCoreRulePort();
               String preTransformationType = tCoreRulePort.getPreTransformationType();
               if (preTransformationType != null && preTransformationType != "") {
                  Map<String, String> connectormap = new HashMap();
                  connectormap.put("TOINSTANCE", TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname());
                  doc = DomUtils.addEditElements(doc, "CONNECTOR[3]", connectormap);
                  ++a;
               }

               sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "'][" + a + "]--TOFIELD", tCoreRulePort.getPortname());
               if ("input".equals(preTransformationType)) {
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "'][" + a + "]--FROMINSTANCETYPE", "Input Transformation");
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "'][" + a + "]--FROMINSTANCE", "INPUT");
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "'][" + a + "]--FROMFIELD", tCoreRulePort.getPrePort());
               }

               if ("Data_Masking".equals(preTransformationType)) {
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "'][" + a + "]--FROMINSTANCETYPE", "Custom Transformation");
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "'][" + a + "]--FROMINSTANCE", tCoreRulePort.getPreTransformationName());
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "'][" + a + "]--FROMFIELD", tCoreRulePort.getPrePort());
               }

               if ("EXPTRANS".equals(preTransformationType)) {
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "'][" + a + "]--FROMINSTANCETYPE", "Expression");
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "'][" + a + "]--FROMINSTANCE", tCoreRulePort.getPreTransformationName());
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "'][" + a + "]--FROMFIELD", tCoreRulePort.getPrePort());
               }
            }
         } else if (transformationInfo.getType().equals("EXPTRANS")) {
            int b = 0;

            for(TCoreRulePortVO tCoreRulePortVO : TransformationInfovo.getPortListVO()) {
               TCoreRulePort tCoreRulePort = tCoreRulePortVO.gettCoreRulePort();
               String preTransformationType = tCoreRulePort.getPreTransformationType();
               if (preTransformationType != null && preTransformationType != "") {
                  Map<String, String> connectormaps = new HashMap();
                  connectormaps.put("TOINSTANCE", TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname());
                  doc = DomUtils.addEditElements(doc, "CONNECTOR[1]", connectormaps);
                  ++b;
               }

               if (!"OUTPUT".equals(tCoreRulePort.getPorttypesss()) && !"本地变量".equals(tCoreRulePort.getPorttypesss())) {
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "'][" + b + "]--TOFIELD", tCoreRulePort.getPortname());
               }

               if ("input".equals(preTransformationType)) {
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "'][" + b + "]--FROMINSTANCETYPE", "Input Transformation");
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "'][" + b + "]--FROMINSTANCE", "INPUT");
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "'][" + b + "]--FROMFIELD", tCoreRulePort.getPrePort());
               }

               if ("Data_Masking".equals(preTransformationType)) {
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "'][" + b + "]--FROMINSTANCETYPE", "Custom Transformation");
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "'][" + b + "]--FROMINSTANCE", tCoreRulePort.getPreTransformationName());
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "'][" + b + "]--FROMFIELD", tCoreRulePort.getPrePort());
               }

               if ("EXPTRANS".equals(preTransformationType)) {
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "'][" + b + "]--FROMINSTANCETYPE", "Expression");
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "'][" + b + "]--FROMINSTANCE", tCoreRulePort.getPreTransformationName());
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "'][" + b + "]--FROMFIELD", tCoreRulePort.getPrePort());
               }
            }
         } else if (transformationInfo.getType().equals("output")) {
            Map<String, String> connectormapss = new HashMap();
            connectormapss.put("TOINSTANCE", TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname());
            doc = DomUtils.addEditElements(doc, "CONNECTOR[2]", connectormapss);

            for(TCoreRulePortVO tCoreRulePortVO : TransformationInfovo.getPortListVO()) {
               TCoreRulePort tCoreRulePort = tCoreRulePortVO.gettCoreRulePort();
               sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']--TOFIELD", tCoreRulePort.getPortname());
               String preTransformationType = tCoreRulePort.getPreTransformationType();
               if ("input".equals(preTransformationType)) {
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']--FROMINSTANCETYPE", "Input Transformation");
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']--FROMINSTANCE", "INPUT");
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']--FROMFIELD", tCoreRulePort.getPrePort());
               }

               if ("Data_Masking".equals(preTransformationType)) {
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']--FROMINSTANCETYPE", "Custom Transformation");
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']--FROMINSTANCE", tCoreRulePort.getPreTransformationName());
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']--FROMFIELD", tCoreRulePort.getPrePort());
               }

               if ("EXPTRANS".equals(preTransformationType)) {
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']--FROMINSTANCETYPE", "Expression");
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']--FROMINSTANCE", tCoreRulePort.getPreTransformationName());
                  sessionattr.put("MAPPLET[@NAME='" + mappletxmlVO.gettCoreRuleMappletInfo().getMappletenglishname() + "']/CONNECTOR[@TOINSTANCE='" + TransformationInfovo.gettCoreRuleTransformationInfo().gettCoreRuleTransformationname() + "']--FROMFIELD", tCoreRulePort.getPrePort());
               }
            }
         }
      }

      if ("函数模式".equals(mappletxmlVO.gettCoreRuleMappletInfo().getNote())) {
         for(TCoreRuleTransformationInfoVO TransformationInfovo : transformationInfoList) {
            TCoreRuleTransformationInfo transformationInfo = TransformationInfovo.gettCoreRuleTransformationInfo();
            if (transformationInfo.getType().equals("EXPTRANS")) {
               for(TCoreRulePortVO tCoreRulePortVO : TransformationInfovo.getPortListVO()) {
                  TCoreRulePort tCoreRulePort = tCoreRulePortVO.gettCoreRulePort();
                  if ("OUTPUT".equals(tCoreRulePort.getPorttypesss())) {
                     String expression = tCoreRulePort.getExpression();
                     if (expression.indexOf("$$") != -1) {
                        int first = expression.indexOf("(");
                        int lastIndexOf = expression.lastIndexOf(")");
                        String substring = expression.substring(first + 1, lastIndexOf);
                        String[] split = substring.split(",");

                        for(int i = 0; i < split.length; ++i) {
                           if (split[i].indexOf("$$") != -1) {
                              Map<String, String> mappingvariable = new HashMap();
                              mappingvariable.put("NAME", split[i]);
                              mappingvariable.put("SCALE", "0");
                              mappingvariable.put("PRECISION", "50");
                              mappingvariable.put("DATATYPE", "string");
                              mappingvariable.put("DEFAULTVALUE", "");
                              mappingvariable.put("USERDEFINED", "YES");
                              mappingvariable.put("ISPARAM", "NO");
                              mappingvariable.put("ISEXPRESSIONVARIABLE", "NO");
                              mappingvariable.put("AGGFUNCTION", "MAX");
                              doc = DomUtils.addEditElements(doc, "MAPPINGVARIABLE", mappingvariable);
                           }
                        }
                     }
                  }
               }
            }
         }
      }

      new HashMap();
      doc = DomUtils.addEditElements(doc, "ERPINFO[1]", (Map)null);
      doc = DomUtils.removeElements(doc, "TRANSFORMATION[@NAME='']");
      doc = DomUtils.removeElements(doc, "TRANSFORMATION[3]");

      for(int j = 0; j < 4; ++j) {
         doc = DomUtils.removeElements(doc, "INSTANCE[1]");
      }

      for(int i = 0; i < 3; ++i) {
         doc = DomUtils.removeElements(doc, "CONNECTOR[1]");
      }

      doc = DomUtils.removeElements(doc, "MAPPINGVARIABLE[1]");
      doc = DomUtils.removeElements(doc, "ERPINFO[1]");
      doc = DomUtils.editElement(doc, sessionattr);
      return doc;
   }

   public Document editSeed(Document doc, int batchnumber) {
      List list = doc.selectNodes("//POWERMART/REPOSITORY/FOLDER/MAPPLET/TRANSFORMATION/METADATAEXTENSION/@VALUE");
      for (Iterator<Attribute> it = list.iterator(); it.hasNext(); ) {
         Attribute attr = it.next();
         Pattern pattern = Pattern.compile("SEED=\"([\\s\\S]*?)\"");
         Matcher matcher = pattern.matcher(attr.getValue());
         if (matcher.find() &&
                 matcher.group().length() > 7) {
            String attrvalue = attr.getValue();
            attr.setValue(attrvalue.replace(matcher.group(), "SEED=\"" + batchnumber + "\""));
         }
      }
      return doc;
   }
}
