package com.chenyang.nse.bussiness.tools.xml.xmlclass.product;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.ProcMem;
import org.hyperic.sigar.ProcTime;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;
import org.hyperic.sigar.cmd.Ps;

public class GetDetail {
   private static final int SLEEP_TIME = 1000;
   private static final String HEADER = "PID\tUSER\t\tSTIME\t\t\tSIZE\tRSS\tSHARE\tSTATE\tTIME\t%CPU\t%MEM\tCOMMAND";

   public static void getProcessCpu_top(String Osuser, String Collectedfiledumpdir) {
      try {
         Sigar sigarImpl = new Sigar();
         SigarProxy sigarProxy = SigarProxyCache.newInstance(sigarImpl, 1000);
         StringBuffer infosStr = new StringBuffer();
         File file = new File(Collectedfiledumpdir);
         if (!file.isFile()) {
            file.createNewFile();
         }

         new FileWriter(Collectedfiledumpdir);
         FileOutputStream fileOutputStream = new FileOutputStream(Collectedfiledumpdir, true);
         BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fileOutputStream, "UTF-8"));
         int cnt = 1;

         while(cnt-- > 0) {
            long[] pids = sigarImpl.getProcList();
            int k = 1024;

            for(int i = 0; i < pids.length; ++i) {
               long pid = pids[i];

               List info;
               try {
                  info = Ps.getInfo(sigarProxy, pid);
               } catch (SigarException var40) {
                  continue;
               }

               try {
                  if (info.get(1).equals(Osuser)) {
                     ProcCpu cpu = sigarProxy.getProcCpu(pid);
                     long total = cpu.getTotal();
                     long user = cpu.getUser();
                     DecimalFormat df = new DecimalFormat("0.00");
                     String cpuUsages = "";
                     if (total == 0L) {
                        cpuUsages = "0.00";
                     } else {
                        cpuUsages = df.format((double)((float)Math.round((float)user / (float)total * 100.0F) / 100.0F));
                     }

                     ProcMem procMem = sigarProxy.getProcMem(pid);
                     long size = procMem.getSize();
                     long resident = procMem.getResident();
                     String usedPercent = df.format((double)((float)Math.round((float)resident / (float)size * 100.0F) / 100.0F));
                     ProcTime procTime = sigarProxy.getProcTime(pid);
                     long startTime = procTime.getStartTime();
                     SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                     long lt = new Long(startTime);
                     Date date = new Date(lt);
                     String res = simpleDateFormat.format(date);
                     info.set(2, res);
                     info.add(info.size() - 1, cpuUsages);
                     info.add(info.size() - 1, usedPercent);

                     for(int j = 0; j < info.size(); ++j) {
                        infosStr.append(info.get(j) + "||");
                     }

                     infosStr.append("\r\n");
                  }
               } catch (SigarException var39) {
               }
            }

            bw.write(infosStr.toString());
            bw.flush();
            Thread.sleep(1000L);
            SigarProxyCache.clear(sigarProxy);
         }
      } catch (Exception var41) {
      }

   }

   public static void getProcessSession_top(String Osuser, String Collectedfilesessiondir) {
      Process process = null;

      try {
         StringBuffer infosStr = new StringBuffer();
         File file = new File(Collectedfilesessiondir);
         if (!file.isFile()) {
            file.createNewFile();
         }

         OutputStreamWriter output = new OutputStreamWriter(new FileOutputStream(Collectedfilesessiondir, true), "UTF-8");
         String[] cmds = new String[]{"/bin/sh", "-c", "ps -ef|grep " + Osuser + "|grep pmdtm"};
         process = Runtime.getRuntime().exec(cmds);
         InputStream is = process.getInputStream();
         BufferedReader reader = new BufferedReader(new InputStreamReader(is));

         String line;
         while((line = reader.readLine()) != null) {
            int i = line.indexOf("-s");
            int j = line.indexOf("-dn");
            if (i != -1) {
               List<String> list = new ArrayList();
               String substring = line.substring(i + 2, j);
               String[] split2 = substring.split(":");
               String[] split3 = split2[1].split("\\.");
               list.add(split2[0].trim());
               list.add(split3[0].trim());
               list.add(split3[1].trim());
               String[] split = line.split(" ");

               for(int k = 0; k < split.length; ++k) {
                  if (!"".equals(split[k])) {
                     list.add(split[k]);
                  }
               }

               String string = (new SimpleDateFormat("yyyy-MM-dd")).format(new Date()).toString();
               String time = string + " " + (String)list.get(7);
               infosStr.append((String)list.get(4) + "||");
               infosStr.append(time + "||");
               infosStr.append((String)list.get(0) + "||");
               infosStr.append((String)list.get(1) + "||");
               infosStr.append((String)list.get(2) + "||");
               BufferedReader input = new BufferedReader(new FileReader(file));
               if (input.readLine() == null) {
                  output.append(infosStr.toString() + "\r\n");
                  output.flush();
               }

               String text;
               while((text = input.readLine()) != null) {
                  if (!"".equals(text)) {
                     String[] split4 = text.split("\\|\\|");
                     if (!((String)list.get(4)).equals(split4[0])) {
                        output.append(infosStr.toString() + "\r\n");
                        output.flush();
                     }
                  }
               }
            }
         }

         output.close();
         is.close();
         reader.close();
      } catch (Exception var23) {
      }

   }
}
