package com.chenyang.nse.bussiness.webtools.controller.core;

import com.chenyang.nse.bussiness.webtools.dao.PageInfo;
import com.chenyang.nse.bussiness.webtools.entity.db.ColumnInfo;
import com.chenyang.nse.bussiness.webtools.entity.db.IndexInfo;
import com.chenyang.nse.bussiness.webtools.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.webtools.entity.vo.DBTableVO;
import com.chenyang.nse.bussiness.webtools.entity.vo.DataPreviewVO;
import com.chenyang.nse.bussiness.webtools.entity.vo.DatasystemVO;
import com.chenyang.nse.bussiness.webtools.entity.vo.MviewVO;
import com.chenyang.nse.bussiness.webtools.entity.vo.ProcedureVO;
import com.chenyang.nse.bussiness.webtools.entity.vo.SequenceVO;
import com.chenyang.nse.bussiness.webtools.entity.vo.SynonymsVO;
import com.chenyang.nse.bussiness.webtools.entity.vo.TableVO;
import com.chenyang.nse.bussiness.webtools.entity.vo.ViewVO;
import com.chenyang.nse.bussiness.webtools.json.RespHelper;
import com.chenyang.nse.bussiness.webtools.json.Response;
import com.chenyang.nse.bussiness.webtools.service.core.WebToolsDataPreviewService;
import com.chenyang.nse.bussiness.webtools.service.core.WebToolsDataSystemService;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@EnableAsync
@RestController
@RequestMapping({"/webtools/core/datapreview"})
public class WebToolsDataPreviewController {
   private static Logger logger = LoggerFactory.getLogger(WebToolsDataPreviewController.class);
   @Autowired
   private WebToolsDataPreviewService dataPreviewService;
   @Autowired
   private WebToolsDataSystemService dataSystemService;

   @ResponseBody
   @RequestMapping(
      value = {"/query"},
      method = {RequestMethod.POST}
   )
   public Response<DataPreviewVO> queryPreviewBysql(@RequestBody DataPreviewVO dataPreviewVO) {
      PageInfo pageInfo = new PageInfo();
      pageInfo.setPageno(dataPreviewVO.getPage());
      pageInfo.setPagesize(dataPreviewVO.getRows());
      long s = System.currentTimeMillis();
      new DataPreviewVO();

      DataPreviewVO retDataPreviewVO;
      try {
         retDataPreviewVO = this.dataPreviewService.queryDataPreviewBysql(pageInfo, dataPreviewVO);
      } catch (Exception e) {
         return RespHelper.exceptionResp(e.getMessage());
      }

      long e = System.currentTimeMillis();
      retDataPreviewVO.setExecute_time(e - s);
      retDataPreviewVO.setPageInfo(pageInfo);
      return RespHelper.<DataPreviewVO>successResp(retDataPreviewVO);
   }

   @ResponseBody
   @RequestMapping(
      value = {"/querySchemas"},
      method = {RequestMethod.POST}
   )
   public Response<List<ComboboxVO>> querySchemas(@RequestBody DatasystemVO datasystem) {
      try {
         return RespHelper.<List<ComboboxVO>>successResp(this.dataSystemService.queryShemas(datasystem));
      } catch (Exception e) {
         return RespHelper.exceptionResp(e.getMessage());
      }
   }

   @ResponseBody
   @RequestMapping(
      value = {"/querySequences"},
      method = {RequestMethod.POST}
   )
   public Response<List<ComboboxVO>> querySequences(@RequestBody DatasystemVO datasystem) {
      try {
         return RespHelper.<List<ComboboxVO>>successResp(this.dataSystemService.querySequences(datasystem));
      } catch (Exception e) {
         e.printStackTrace();
         return RespHelper.exceptionResp(e.getMessage());
      }
   }

   @ResponseBody
   @RequestMapping(
      value = {"/querySequenceAttr"},
      method = {RequestMethod.POST}
   )
   public Response<List<SequenceVO>> querySequenceAttr(@RequestBody DatasystemVO datasystem) {
      try {
         return RespHelper.<List<SequenceVO>>successResp(this.dataSystemService.querySequenceAttr(datasystem));
      } catch (Exception e) {
         return RespHelper.exceptionResp(e.getMessage());
      }
   }

   @ResponseBody
   @RequestMapping(
      value = {"/queryTables"},
      method = {RequestMethod.POST}
   )
   public Response<List<String>> queryTables(@RequestBody DatasystemVO datasystem) {
      List<DBTableVO> list = this.dataSystemService.queryTablename(datasystem);
      List<String> tables = (List)list.stream().map((e) -> new String(e.getTablename())).collect(Collectors.toList());
      Collections.sort(tables);
      return RespHelper.<List<String>>successResp(tables);
   }

   @ResponseBody
   @RequestMapping(
      value = {"/queryViews"},
      method = {RequestMethod.POST}
   )
   public Response<List<String>> queryViews(@RequestBody DatasystemVO datasystem) {
      List<String> list = this.dataSystemService.queryView(datasystem);
      Collections.sort(list);
      return RespHelper.<List<String>>successResp(list);
   }

   @ResponseBody
   @RequestMapping(
      value = {"/querySynonyms"},
      method = {RequestMethod.POST}
   )
   public Response<List<String>> querySynonyms(@RequestBody DatasystemVO datasystem) {
      List<String> list = this.dataSystemService.querySynonym(datasystem);
      Collections.sort(list);
      return RespHelper.<List<String>>successResp(list);
   }

   @ResponseBody
   @RequestMapping(
      value = {"/queryProcedures"},
      method = {RequestMethod.POST}
   )
   public Response<List<String>> queryProcedures(@RequestBody DatasystemVO datasystem) {
      List<String> list = this.dataSystemService.queryProcedures(datasystem);
      Collections.sort(list);
      return RespHelper.<List<String>>successResp(list);
   }

   @ResponseBody
   @RequestMapping(
      value = {"/queryFunctions"},
      method = {RequestMethod.POST}
   )
   public Response<List<String>> queryFunctions(@RequestBody DatasystemVO datasystem) {
      List<String> list = this.dataSystemService.queryFunctions(datasystem);
      Collections.sort(list);
      return RespHelper.<List<String>>successResp(list);
   }

   @ResponseBody
   @RequestMapping(
      value = {"/queryMviewList"},
      method = {RequestMethod.POST}
   )
   public Response<List<String>> queryMviewList(@RequestBody DatasystemVO datasystem) {
      List<String> list = this.dataSystemService.queryMviewList(datasystem);
      Collections.sort(list);
      return RespHelper.<List<String>>successResp(list);
   }

   @ResponseBody
   @RequestMapping(
      value = {"/querySynonymAttr"},
      method = {RequestMethod.POST}
   )
   public Response<List<SynonymsVO>> querySynonymAttr(@RequestBody DatasystemVO datasystem) {
      try {
         return RespHelper.<List<SynonymsVO>>successResp(this.dataSystemService.querySynonymAttr(datasystem));
      } catch (Exception e) {
         return RespHelper.exceptionResp(e.getMessage());
      }
   }

   @ResponseBody
   @RequestMapping(
      value = {"/queryViewDeclare"},
      method = {RequestMethod.POST}
   )
   public Response<List<ViewVO>> queryViewDeclare(@RequestBody DatasystemVO datasystem) {
      try {
         return RespHelper.<List<ViewVO>>successResp(this.dataSystemService.queryViewDeclare(datasystem));
      } catch (Exception e) {
         return RespHelper.exceptionResp(e.getMessage());
      }
   }

   @ResponseBody
   @RequestMapping(
      value = {"/queryTableColumn"},
      method = {RequestMethod.POST}
   )
   public Response<List<ColumnInfo>> queryViewColumn(@RequestBody DatasystemVO datasystem) {
      try {
         return RespHelper.<List<ColumnInfo>>successResp(this.dataSystemService.queryViewColumn(datasystem));
      } catch (Exception e) {
         return RespHelper.exceptionResp(e.getMessage());
      }
   }

   @ResponseBody
   @RequestMapping(
      value = {"/queryTableIndex"},
      method = {RequestMethod.POST}
   )
   public Response<List<IndexInfo>> queryTableIndex(@RequestBody DatasystemVO datasystem) {
      try {
         return RespHelper.<List<IndexInfo>>successResp(this.dataSystemService.queryTableIndex(datasystem));
      } catch (Exception e) {
         return RespHelper.exceptionResp(e.getMessage());
      }
   }

   @ResponseBody
   @RequestMapping(
      value = {"/queryMViewAttr2Declare"},
      method = {RequestMethod.POST}
   )
   public Response<List<MviewVO>> queryMViewAttr2Declare(@RequestBody DatasystemVO datasystem) {
      try {
         return RespHelper.<List<MviewVO>>successResp(this.dataSystemService.queryMViewAttr2Declare(datasystem));
      } catch (Exception e) {
         return RespHelper.exceptionResp(e.getMessage());
      }
   }

   @ResponseBody
   @RequestMapping(
      value = {"/queryTableComment2Space"},
      method = {RequestMethod.POST}
   )
   public Response<TableVO> queryTableComment2Space(@RequestBody DatasystemVO datasystem) {
      try {
         return RespHelper.<TableVO>successResp(this.dataSystemService.queryTableComment2Space(datasystem));
      } catch (Exception e) {
         return RespHelper.exceptionResp(e.getMessage());
      }
   }

   @ResponseBody
   @RequestMapping(
      value = {"/queryViewComments"},
      method = {RequestMethod.POST}
   )
   public Response<ViewVO> queryViewComments(@RequestBody DatasystemVO datasystem) {
      try {
         return RespHelper.<ViewVO>successResp(this.dataSystemService.queryViewComments(datasystem));
      } catch (Exception e) {
         return RespHelper.exceptionResp(e.getMessage());
      }
   }

   @ResponseBody
   @RequestMapping(
      value = {"/queryProcedureAttr2Declare"},
      method = {RequestMethod.POST}
   )
   public Response<ProcedureVO> queryProcedureAttr2Declare(@RequestBody DatasystemVO datasystem) {
      try {
         return RespHelper.<ProcedureVO>successResp(this.dataSystemService.queryProcedureAttr2Declare(datasystem));
      } catch (Exception e) {
         return RespHelper.exceptionResp(e.getMessage());
      }
   }

   @ResponseBody
   @RequestMapping(
      value = {"/queryFunctionAttr2Declare"},
      method = {RequestMethod.POST}
   )
   public Response<ProcedureVO> queryFunctionAttr2Declare(@RequestBody DatasystemVO datasystem) {
      try {
         return RespHelper.<ProcedureVO>successResp(this.dataSystemService.queryFunctionAttr2Declare(datasystem));
      } catch (Exception e) {
         return RespHelper.exceptionResp(e.getMessage());
      }
   }
}
