package com.chenyang.nse.bussiness.webtools.entity.db;

import com.chenyang.nse.bussiness.webtools.enumeration.EdbType;
import com.chenyang.nse.bussiness.webtools.tools.jdbc.JdbcTool;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class IndexInfo {
   private String expression = "";
   private String tablespace = "";
   private String tablecat;
   private String tableschem;
   private String tablename;
   private boolean nonunique;
   private String indexqualifier;
   private String indexname;
   private short type;
   private short ordinalposition;
   private String columnname;
   private String ascordesc;
   private int cardinality;
   private int pages;
   private String filtercondition;

   public IndexInfo() {
   }

   public IndexInfo(String tablecat, String tableschema, String tablename, boolean nonunique, String indexqualifier, String indexname, short type, short ordinalposition, String columnname, String ascordesc, int cardinality, int pages, String filtercondition) {
      this.tablecat = tablecat;
      this.tableschem = tableschema;
      this.tablename = tablename;
      this.nonunique = nonunique;
      this.indexqualifier = indexqualifier;
      this.indexname = indexname;
      this.type = type;
      this.ordinalposition = ordinalposition;
      this.columnname = columnname;
      this.ascordesc = ascordesc;
      this.cardinality = cardinality;
      this.pages = pages;
      this.filtercondition = filtercondition;
   }

   public String getTablecat() {
      return this.tablecat;
   }

   public void setTablecat(String tablecat) {
      this.tablecat = tablecat;
   }

   public String getTableschem() {
      return this.tableschem;
   }

   public void setTableschem(String tableschem) {
      this.tableschem = tableschem;
   }

   public String getTablename() {
      return this.tablename;
   }

   public void setTablename(String tablename) {
      this.tablename = tablename;
   }

   public boolean isNonunique() {
      return this.nonunique;
   }

   public void setNonunique(boolean nonunique) {
      this.nonunique = nonunique;
   }

   public String getIndexqualifier() {
      return this.indexqualifier;
   }

   public void setIndexqualifier(String indexqualifier) {
      this.indexqualifier = indexqualifier;
   }

   public String getIndexname() {
      return this.indexname;
   }

   public void setIndexname(String indexname) {
      this.indexname = indexname;
   }

   public short getType() {
      return this.type;
   }

   public void setType(short type) {
      this.type = type;
   }

   public short getOrdinalposition() {
      return this.ordinalposition;
   }

   public void setOrdinalposition(short ordinalposition) {
      this.ordinalposition = ordinalposition;
   }

   public String getColumnname() {
      return this.columnname;
   }

   public void setColumnname(String columnname) {
      this.columnname = columnname;
   }

   public String getAscordesc() {
      return this.ascordesc;
   }

   public void setAscordesc(String ascordesc) {
      this.ascordesc = ascordesc;
   }

   public int getCardinality() {
      return this.cardinality;
   }

   public void setCardinality(int cardinality) {
      this.cardinality = cardinality;
   }

   public int getPages() {
      return this.pages;
   }

   public void setPages(int pages) {
      this.pages = pages;
   }

   public String getFiltercondition() {
      return this.filtercondition;
   }

   public void setFiltercondition(String filtercondition) {
      this.filtercondition = filtercondition;
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.ascordesc == null ? 0 : this.ascordesc.hashCode());
      result = 31 * result + this.cardinality;
      result = 31 * result + (this.columnname == null ? 0 : this.columnname.hashCode());
      result = 31 * result + (this.filtercondition == null ? 0 : this.filtercondition.hashCode());
      result = 31 * result + (this.indexname == null ? 0 : this.indexname.hashCode());
      result = 31 * result + (this.indexqualifier == null ? 0 : this.indexqualifier.hashCode());
      result = 31 * result + (this.nonunique ? 1231 : 1237);
      result = 31 * result + this.ordinalposition;
      result = 31 * result + this.pages;
      result = 31 * result + (this.tablecat == null ? 0 : this.tablecat.hashCode());
      result = 31 * result + (this.tablename == null ? 0 : this.tablename.hashCode());
      result = 31 * result + (this.tableschem == null ? 0 : this.tableschem.hashCode());
      result = 31 * result + this.type;
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         IndexInfo other = (IndexInfo)obj;
         if (this.ascordesc == null) {
            if (other.ascordesc != null) {
               return false;
            }
         } else if (!this.ascordesc.equals(other.ascordesc)) {
            return false;
         }

         if (this.cardinality != other.cardinality) {
            return false;
         } else {
            if (this.columnname == null) {
               if (other.columnname != null) {
                  return false;
               }
            } else if (!this.columnname.equals(other.columnname)) {
               return false;
            }

            if (this.filtercondition == null) {
               if (other.filtercondition != null) {
                  return false;
               }
            } else if (!this.filtercondition.equals(other.filtercondition)) {
               return false;
            }

            if (this.indexname == null) {
               if (other.indexname != null) {
                  return false;
               }
            } else if (!this.indexname.equals(other.indexname)) {
               return false;
            }

            if (this.indexqualifier == null) {
               if (other.indexqualifier != null) {
                  return false;
               }
            } else if (!this.indexqualifier.equals(other.indexqualifier)) {
               return false;
            }

            if (this.nonunique != other.nonunique) {
               return false;
            } else if (this.ordinalposition != other.ordinalposition) {
               return false;
            } else if (this.pages != other.pages) {
               return false;
            } else {
               if (this.tablecat == null) {
                  if (other.tablecat != null) {
                     return false;
                  }
               } else if (!this.tablecat.equals(other.tablecat)) {
                  return false;
               }

               if (this.tablename == null) {
                  if (other.tablename != null) {
                     return false;
                  }
               } else if (!this.tablename.equals(other.tablename)) {
                  return false;
               }

               if (this.tableschem == null) {
                  if (other.tableschem != null) {
                     return false;
                  }
               } else if (!this.tableschem.equals(other.tableschem)) {
                  return false;
               }

               return this.type == other.type;
            }
         }
      }
   }

   public String toString() {
      return "IndexInfo [tablecat=" + this.tablecat + ", tableschem=" + this.tableschem + ", tablename=" + this.tablename + ", nonunique=" + this.nonunique + ", indexqualifier=" + this.indexqualifier + ", indexname=" + this.indexname + ", type=" + this.type + ", ordinalposition=" + this.ordinalposition + ", columnname=" + this.columnname + ", ascordesc=" + this.ascordesc + ", cardinality=" + this.cardinality + ", pages=" + this.pages + ", filtercondition=" + this.filtercondition + "]";
   }

   public static List<IndexInfo> getIndexInfoByConnection(Connection conn, String schemaPattern, String tableNamePattern) {
      List<IndexInfo> list = null;
      if (null == conn) {
         return list;
      } else {
         list = new ArrayList();
         DatabaseMetaData dbmd = null;
         PreparedStatement ps = null;
         ResultSet rs = null;
         String querySql = "";

         try {
            dbmd = conn.getMetaData();
            EdbType dbtype = DbInfo.getEdbTypeByConnection(conn);
            if (dbtype.getDbcode().equals(EdbType.OCEANBASE.getDbcode())) {
               querySql = "select * from user_ind_columns where table_name='" + tableNamePattern.toUpperCase() + "' and column_name not in  (Select col.column_name from all_constraints con,all_cons_columns col where con.constraint_name=col.constraint_name and con.constraint_type='P' and col.table_name='" + tableNamePattern.toUpperCase() + "' and con.owner = '" + schemaPattern.toUpperCase() + "' )";
               ps = conn.prepareStatement(querySql);
               rs = ps.executeQuery();

               while(rs.next()) {
                  String index_name = rs.getString("INDEX_NAME");
                  String tablename = rs.getString("TABLE_NAME");
                  String columnname = rs.getString("COLUMN_NAME");
                  IndexInfo temp = new IndexInfo();
                  temp.setTableschem(schemaPattern);
                  temp.setTablename(tablename);
                  temp.setColumnname(columnname);
                  temp.setIndexname(index_name);
                  list.add(temp);
               }
            } else if (dbtype.getDbcode().equals(EdbType.MYSQL.getDbcode())) {
               conn.prepareStatement("use " + schemaPattern).execute();
               String sql = "show index from " + schemaPattern + "." + tableNamePattern;
               ps = conn.prepareStatement(sql);
               rs = ps.executeQuery();
               boolean nonunique = true;

               while(rs.next()) {
                  String columnname = rs.getString("COLUMN_NAME");
                  String indexname = rs.getString("KEY_NAME");
                  String NON_UNIQUE = rs.getString("NON_UNIQUE");
                  if (NON_UNIQUE.equals("1")) {
                     nonunique = true;
                  } else {
                     nonunique = false;
                  }

                  IndexInfo temp = new IndexInfo();
                  temp.setNonunique(nonunique);
                  temp.setTableschem(schemaPattern);
                  temp.setTablename(tableNamePattern);
                  temp.setColumnname(columnname);
                  temp.setIndexname(indexname);
                  list.add(temp);
               }
            } else {
               rs = dbmd.getIndexInfo((String)null, schemaPattern, tableNamePattern, false, true);

               while(rs.next()) {
                  String tablecat = rs.getString("TABLE_CAT");
                  String tableschema = rs.getString("TABLE_SCHEM");
                  String tablename = rs.getString("TABLE_NAME");
                  boolean nonunique = rs.getBoolean("NON_UNIQUE");
                  String indexqualifier = rs.getString("INDEX_QUALIFIER");
                  String indexname = rs.getString("INDEX_NAME");
                  short type = rs.getShort("TYPE");
                  short ordinalposition = rs.getShort("ORDINAL_POSITION");
                  String columnname = rs.getString("COLUMN_NAME");
                  if (columnname != null) {
                     String ascordesc = rs.getString("ASC_OR_DESC");
                     int cardinality = rs.getInt("CARDINALITY");
                     int pages = rs.getInt("PAGES");
                     String filtercondition = rs.getString("FILTER_CONDITION");
                     IndexInfo temp = new IndexInfo(tablecat, tableschema, tablename, nonunique, indexqualifier, indexname, type, ordinalposition, columnname, ascordesc, cardinality, pages, filtercondition);
                     list.add(temp);
                  }
               }
            }
         } catch (SQLException e) {
            e.printStackTrace();
         } finally {
            try {
               if (rs != null) {
                  rs.close();
               }

               if (ps != null) {
                  ps.close();
               }
            } catch (SQLException e) {
               e.printStackTrace();
            }

         }

         return list;
      }
   }

   public static List<String> getIndexInfoList(Connection conn, String schemaPattern, String tableNamePattern) {
      List<String> list = null;
      List<IndexInfo> indexInfo = getIndexInfoByConnection(conn, schemaPattern, tableNamePattern);
      if (indexInfo != null && indexInfo.size() > 0) {
         list = new ArrayList();

         for(IndexInfo item : indexInfo) {
            list.add(item.getColumnname());
         }
      }

      return list;
   }

   public static void main(String[] args) throws SQLException {
      Connection conn = JdbcTool.getConnection("com.ibm.db2.jcc.DB2Driver", "jdbc:db2://192.168.1.100:50000/SAMPLE:retrieveMessagesFromServerOnGetMessage=true;", "ghca", "ghca");
      if (conn != null) {
         System.out.println("connection is ok!");
      }

      for(IndexInfo indexInfo : getIndexInfoByConnection(conn, "ghca", "T_BASE_GROUP")) {
         System.out.println(indexInfo);
      }

      conn.close();
   }

   public String getExpression() {
      return this.expression;
   }

   public void setExpression(String expression) {
      this.expression = expression;
   }

   public String getTablespace() {
      return this.tablespace;
   }

   public void setTablespace(String tablespace) {
      this.tablespace = tablespace;
   }
}
