package com.chenyang.nse.bussiness.webtools.enumeration;

import java.util.ArrayList;
import java.util.List;

public enum EdbType {
   DB2("DB2", "DB2", "com.ibm.db2.jcc.DB2Driver", "jdbc:db2://{ip}:{port}/{servername}"),
   AS400("AS400", "AS400", "com.ibm.as400.access.AS400JDBCDriver", "jdbc:as400://{ip}"),
   MSSQLSERVER("MSSQLSERVER", "MSSQLSERVER", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "jdbc:sqlserver://{ip}:{port};DatabaseName={servername}"),
   MYSQL("MYSQL", "MYSQL", "com.mysql.cj.jdbc.Driver", "jdbc:mysql://{ip}:{port}/{servername}?zeroDateTimeBehavior=convertToNull"),
   MARIADB("MARIADB", "MYSQL", "com.mysql.cj.jdbc.Driver", "jdbc:mysql://{ip}:{port}/{servername}?zeroDateTimeBehavior=convertToNull"),
   ORACLE("ORACLE", "ORACLE", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST={ip})(PORT={port}))(CONNECT_DATA=(SERVER=DEDICATED)(SERVICE_NAME={servername})))"),
   ORACLEINS("ORACLEINS", "ORACLE", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:thin:@{ip}:{port}:{servername}"),
   HIVE("HIVE", "HIVE", "org.apache.hive.jdbc.HiveDriver", "jdbc:hive2://{ip}:{port}/{servername}"),
   SYBASE("SYBASE", "SYBASE", "net.sourceforge.jtds.jdbc.Driver", "jdbc:jtds:sybase://{ip}:{port}/{servername}"),
   SYBASE_IQ("SYBASE_IQ", "SYBASE_IQ", "com.sybase.jdbc4.jdbc.SybDriver", "jdbc:sybase:Tds:{ip}:{port}/{servername}"),
   TERADATA("TERADATA", "TERADATA", "com.teradata.jdbc.TeraDriver", "jdbc:teradata://{ip}/DATABASE={servername},DBS_PORT={port},LOB_SUPPORT=off,tmode=TERA"),
   INFORMIX("INFORMIX", "INFORMIX", "com.informix.jdbc.IfxDriver", "jdbc:informix-sqli://{ip}:{port}/{servername}:INFORMIXSERVER={server};DB_LOCALE=en_us.8859-1;"),
   GREENPLUM("GREENPLUM", "GREENPLUM", "org.postgresql.Driver", "jdbc:postgresql://{ip}:{port}/{servername}"),
   POSTGRESQL("POSTGRESQL", "GREENPLUM", "org.postgresql.Driver", "jdbc:postgresql://{ip}:{port}/{servername}"),
   HANA("HANA", "HANA", "com.sap.db.jdbc.Driver", "jdbc:sap://{ip}:{port}?reconnect=true"),
   RAPIDSDB("RAPIDSDB", "RAPIDSDB", "com.mysql.cj.jdbc.Driver", "jdbc:mysql://{ip}:{port}"),
   MONGODB("MONGODB", "MONGODB", "com.mongodb.jdbc.MongoDriver", "mongodb://{ip}:{port}/admin"),
   OCEANBASE("OCEANBASE", "OCEANBASE", "com.alipay.oceanbase.obproxy.mysql.jdbc.Driver", "jdbc:oceanbase://{ip}:{port}/{servername}?useUnicode=true&characterEncoding=utf-8"),
   KAFKA("KAFKA", "KAFKA", "", "bootstrap.servers://{ip}:{port}?characterEncoding=utf-8"),
   DM("DM", "DM", "dm.jdbc.driver.DmDriver", "jdbc:dm://{ip}:{port}:{servername}");

   private String dbcode;
   private String dbname;
   private String dbdriver;
   private String urltemplate;

   private EdbType(String dbcode, String dbname, String dbdriver, String urltemplate) {
      this.dbcode = dbcode;
      this.dbname = dbname;
      this.dbdriver = dbdriver;
      this.urltemplate = urltemplate;
   }

   public String getDbcode() {
      return this.dbcode;
   }

   public void setDbcode(String dbcode) {
      this.dbcode = dbcode;
   }

   public String getDbname() {
      return this.dbname;
   }

   public void setDbname(String dbname) {
      this.dbname = dbname;
   }

   public String getDbdriver() {
      return this.dbdriver;
   }

   public void setDbdriver(String dbdriver) {
      this.dbdriver = dbdriver;
   }

   public String getUrltemplate() {
      return this.urltemplate;
   }

   public void setUrltemplate(String urltemplate) {
      this.urltemplate = urltemplate;
   }

   public static EdbType getEdbTypeByDbcode(String dbcode) {
      EdbType[] db = values();

      for(EdbType item : db) {
         String f = item.getDbcode();
         if (f.equals(dbcode)) {
            return item;
         }
      }

      return null;
   }

   public static String getUrlByEdbType(com.chenyang.nse.bussiness.enumeration.EdbType db, String ip, String port, String servername) {
      String url = db.getUrltemplate().replace("{ip}", ip).replace("{port}", port).replace("{servername}", servername).replace(" ", "");
      return url;
   }

   public static String getUrlByEdbcode(String dbcode, String ip, String dbservername) {
      EdbType db = getEdbTypeByDbcode(dbcode);
      String url = db.getUrltemplate().replace("{ip}", ip).replace(" ", "");
      return url;
   }

   public static String getUrlByEdbcode(String dbcode, String ip, String port, String dbservername) {
      EdbType db = getEdbTypeByDbcode(dbcode);
      String url = db.getUrltemplate().replace("{ip}", ip).replace("{port}", port).replace("{servername}", dbservername).replace(" ", "");
      if (dbcode.equals("MYSQL")) {
         url = url + "&useSSL=false&rewriteBatchedStatements=true&serverTimezone=UTC";
      }

      return url;
   }

   public static String getUrlByEdbcode(String dbcode, String ip, String port, String dbservername, String servername) {
      EdbType db = getEdbTypeByDbcode(dbcode);
      String url = db.getUrltemplate().replace("{ip}", ip).replace("{port}", port).replace("{servername}", dbservername).replace("{server}", servername).replace(" ", "");
      return url;
   }

   public static String getUrlByEdbcode(String dbcode, String ip, String port, String dbservername, String servername, String pageCode) {
      EdbType db = getEdbTypeByDbcode(dbcode);
      String url = db.getUrltemplate().replace("{ip}", ip).replace("{port}", port).replace("{servername}", dbservername).replace("{server}", servername == null ? "" : servername).replace(" ", "");
      if (dbcode.equals("TERADATA")) {
         url = url + ",charset=UTF8";
      } else if (!dbcode.equals("MYSQL") && dbcode.equals("MARIADB")) {
      }

      return url;
   }

   public static List<String> getDbTypeList() {
      List<String> list = new ArrayList();
      com.chenyang.nse.bussiness.enumeration.EdbType[] db = com.chenyang.nse.bussiness.enumeration.EdbType.values();

      for(com.chenyang.nse.bussiness.enumeration.EdbType item : db) {
         list.add(item.getDbcode());
      }

      return list;
   }
}
