package com.chenyang.nse.bussiness.bean;

import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DBTableVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.service.core.impl.DataSystemServiceImpl;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import util.JdbcCacheUtil;

public class CacheThreadImmediately extends Thread {
   private DataSystemServiceImpl dataSystemService;
   private TCoreDatasystem datasystem;

   public CacheThreadImmediately(DataSystemServiceImpl dataSystemService, TCoreDatasystem datasystem) {
      this.dataSystemService = dataSystemService;
      this.datasystem = datasystem;
   }

   public void run() {
      this.cacheImmediately();
   }

   public void cacheImmediately() {
      try {
         DataBase dataBase = new DataBase();
         dataBase.setDatasystemid(this.datasystem.getId());
         dataBase.setDbType(this.datasystem.getDbtype());
         dataBase.setIp_port(this.datasystem.getDbip() + ":" + this.datasystem.getDbport());
         dataBase.setDbType(this.datasystem.getDbtype());
         boolean exist = false;

         for(DataBase base : DataCache.dataList) {
            if (base.getDatasystemid().equals(this.datasystem.getId())) {
               ;
            }
         }

         if (!exist) {
            DataCache.dataList.add(dataBase);
         }

         Connection conn = null;
         if (!"ES".equals(this.datasystem.getDbtype())) {
            conn = this.dataSystemService.getConnection(this.datasystem.getId());
         } else {
            String content = "{\n      \"ip_port\": \"" + this.datasystem.getDbip() + ":" + this.datasystem.getDbport() + "\",\n      \"url\": \"http://" + this.datasystem.getDbip() + ":" + this.datasystem.getDbport() + "/\",\n      \"username\": \"" + this.datasystem.getUsername() + "\",\n      \"password\": \"" + AesTool.decrypt(this.datasystem.getPassword(), "ghca") + "\",\n      \"dbType\": \"es\"\n}";
            JdbcCacheUtil.initData(content);
         }

         List<ComboboxVO> shemas = this.dataSystemService.querySchema_new(this.datasystem, conn);
         List<Schema> schemaList = new ArrayList();

         for(ComboboxVO schemaObj : shemas) {
            Schema schema = new Schema(schemaObj.getValue());
            schemaList.add(schema);
            List<DBTableVO> tables = this.dataSystemService.queryTablename_new(this.datasystem, schemaObj.getValue(), conn);
            List<Table> tableList = new ArrayList();
            schema.setTableList(tableList);

            for(DBTableVO tableObj : tables) {
               Table table = new Table(tableObj.getTablename(), schemaObj.getValue());
               tableList.add(table);
               List<ColumnInfoVO> columns = this.dataSystemService.queryColumnInfo_new(conn, schemaObj.getValue(), tableObj.getTablename());
               List<Column> columnList = new ArrayList();
               table.setColumnList(columnList);

               for(ColumnInfoVO columnObj : columns) {
                  Column column = new Column(columnObj.getColumnname(), schemaObj.getValue(), tableObj.getTablename());
                  column.setPrimarykey(columnObj.getPrimarykey());
                  columnList.add(column);
               }
            }
         }

         dataBase.setSchemaList(schemaList);
         dataBase.easyCache = new DBEasyCache(dataBase);
         dataBase.easyCache.init();
         if (conn != null) {
            conn.close();
         }
      } catch (Throwable e) {
         e.printStackTrace();
      }

   }
}
