package com.chenyang.nse.bussiness.controller.console;

import com.chenyang.nse.bussiness.entity.orm.table.console.mapping.TConsoleDatamappingTargetfield;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.enumeration.datamapping.EdataMappingFlag;
import com.chenyang.nse.bussiness.enumeration.datamapping.EdataMappingType;
import com.chenyang.nse.bussiness.service.console.DataMappingService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/console/datamapping"})
public class DataMappingController {
   @Autowired
   private DataMappingService dataMappingService;

   @RequestMapping({"", "/"})
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "/console/datamapping";
   }

   @RequestMapping({"/getdatatype"})
   @ResponseBody
   public List<ComboboxVO> getdatatype() {
      List<ComboboxVO> list = new ArrayList();

      for(EdataMappingType em : EdataMappingType.values()) {
         ComboboxVO vo = new ComboboxVO(em.getFlag(), em.getName());
         list.add(vo);
      }

      return list;
   }

   @RequestMapping({"/getdataflag"})
   @ResponseBody
   public List<ComboboxVO> getdataflag() {
      List<ComboboxVO> list = new ArrayList();

      for(EdataMappingFlag em : EdataMappingFlag.values()) {
         ComboboxVO vo = new ComboboxVO(em.getFlag(), em.getName());
         list.add(vo);
      }

      return list;
   }

   @RequestMapping({"/getdatamappinginfo"})
   @ResponseBody
   public List<Map<String, String>> getdatamappinginfo(String sourcesystemtype, String targetsystemtype) {
      return this.dataMappingService.getDatamappingInfo(sourcesystemtype, targetsystemtype);
   }

   @RequestMapping({"/gettargetfield"})
   @ResponseBody
   public List<ComboboxVO> gettargetfield(String datasystemtype) {
      List<TConsoleDatamappingTargetfield> list = this.dataMappingService.getTargetFieldByType(datasystemtype);
      List<ComboboxVO> volist = new ArrayList();

      for(TConsoleDatamappingTargetfield item : list) {
         ComboboxVO vo = new ComboboxVO(item.getId(), item.getFieldname());
         volist.add(vo);
      }

      return volist;
   }

   @RequestMapping({"/modifydatainfo"})
   @ResponseBody
   public void modifydatainfo(@RequestParam Map<String, String> map) {
      this.dataMappingService.modifyDataInfo(map);
   }
}
