package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatadis;
import com.chenyang.nse.bussiness.service.core.DataDisService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/datadis"})
public class DataDisController {
   @Autowired
   private DataDisService dataDisService;

   @ResponseBody
   @GetMapping({"/queryAll"})
   public Response query(String dbtype) {
      List<TCoreDatadis> list = this.dataDisService.queryDistByType(dbtype);
      return RespHelper.successResp(list);
   }
}
