package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.entity.orm.table.core.HgToFlFj;
import com.chenyang.nse.bussiness.entity.orm.table.core.HgToYuan;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreFullChart;
import com.chenyang.nse.bussiness.service.console.DictionaryService;
import com.chenyang.nse.bussiness.service.console.SearchRegexService;
import com.chenyang.nse.bussiness.service.core.ComplianceDirectoryService;
import com.chenyang.nse.bussiness.service.core.CoreProjectService;
import com.chenyang.nse.bussiness.service.core.DataScopeService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.ImportMaskingRuleService;
import com.chenyang.nse.bussiness.service.core.SearchFieldService;
import com.chenyang.nse.bussiness.service.core.SensitiveColumnService;
import com.chenyang.nse.bussiness.service.core.SensitiveLevelService;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/fullchart"})
public class FullchartController {
   @Autowired
   private SensitiveColumnService sensitiveColumnService;
   @Autowired
   private DataScopeService dataScopeService;
   @Autowired
   private ComplianceDirectoryService complianceDirectoryService;
   @Autowired
   private SensitiveLevelService sensitiveLevelService;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private SearchRegexService searchRegexService;
   @Autowired
   private SearchFieldService searchFieldService;
   @Autowired
   private DictionaryService dictionaryService;
   @Autowired
   private ImportMaskingRuleService maskingRuleService;
   @Autowired
   private RedisService redisService;
   @Autowired
   private CoreProjectService coreProjectService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/datascope/reportchart/fullchart";
   }

   @ResponseBody
   @RequestMapping({"getOne"})
   public Map getOne() {
      Map map = new HashMap();
      List<TCoreDatasystem> dsl = this.dataSystemService.query("1");
      List<Map> sfl = this.dataScopeService.findAllScopeField();
      String datasystem = "";

      for(TCoreDatasystem sl : dsl) {
         datasystem = datasystem + sl.getDblinkname() + ",";
      }

      map.put("datasystem", dsl);
      return map;
   }

   @ResponseBody
   @RequestMapping({"getOne1"})
   public Map getOne1() {
      Map map = new HashMap();
      List<TCoreFullChart> sfl = this.dataScopeService.queryALl();
      String datasystem = "";

      for(TCoreFullChart sfl1 : sfl) {
         datasystem = datasystem + sfl1.getDatasystem_name() + ",";
      }

      map.put("datasystem", sfl);
      return map;
   }

   @ResponseBody
   @RequestMapping({"gettwo"})
   public Map getTwo() {
      Map map = new HashMap();
      List<HgToFlFj> sfl = this.dataScopeService.queryALltwo();
      String datasystem = "";

      for(HgToFlFj sfl1 : sfl) {
         datasystem = datasystem + sfl1.getHgname() + ",";
      }

      map.put("datasystem", sfl);
      return map;
   }

   @ResponseBody
   @RequestMapping({"getthree"})
   public Map getThree() {
      Map map = new HashMap();
      List<HgToYuan> sfl = this.dataScopeService.queryAllThree();
      String datasystem = "";

      for(HgToYuan sfl1 : sfl) {
         datasystem = datasystem + sfl1.getHgname() + ",";
      }

      map.put("datasystem", sfl);
      return map;
   }
}
