package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import com.chenyang.nse.bussiness.entity.orm.table.core.ImportMaskingExecute;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationMonitor;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.service.core.ImportDesensitizationtaskService;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import com.chenyang.nse.bussiness.thread.ExecuteParam;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import java.io.IOException;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@EnableAsync
@Controller
@RequestMapping({"/core/importdesensitizationtask"})
public class ImportDesensitizationController {
   private static Logger logger = LoggerFactory.getLogger(ImportDesensitizationController.class);
   @Autowired
   private ImportDesensitizationtaskService importDesensitizationtaskService;
   @Autowired
   private RedisService redisService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/importdesensitizationtask/importdesensitizationtasklist";
   }

   @RequestMapping({"importpage"})
   public String importpage(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/importdesensitizationtask/import";
   }

   @RequestMapping(
      value = {"/importDesensitizationTask"},
      method = {RequestMethod.POST}
   )
   @ResponseBody
   public ResultVO importDesensitizationTask(MultipartFile importfile) {
      new ResultVO();
      ResultVO result = this.importDesensitizationtaskService.importTask(importfile);
      return result;
   }

   @RequestMapping({"/querytask"})
   @ResponseBody
   public DataGridVO<ImportMaskingExecute> querytask(String engineid, String taskname, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<ImportMaskingExecute> list = this.importDesensitizationtaskService.queryTask(taskname, pageInfo);

      for(ImportMaskingExecute importMaskingExecute : list) {
         String tasknamereal = importMaskingExecute.getTaskname();
         if (importMaskingExecute.getStatus() != 0) {
            this.redisService.remove(tasknamereal + "_zcount");
            this.redisService.remove(tasknamereal + "_ncount");
         } else {
            String time_exe = (String)this.redisService.get(tasknamereal + "_ntime");
            String count_exe = (String)this.redisService.get(tasknamereal + "_zcount");
            String ncount_exe = (String)this.redisService.get(tasknamereal + "_ncount");
            long ncount_exe_num = 0L;
            long count_exe_num = 1L;

            try {
               if (ncount_exe == null) {
                  ncount_exe = "0";
               }

               if (count_exe == null) {
                  count_exe = "1";
               }

               ncount_exe_num = new Long(ncount_exe);
               count_exe_num = new Long(count_exe);
            } catch (Exception var22) {
            }

            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.format((double)ncount_exe_num / (double)count_exe_num * (double)100.0F);
         }
      }

      DataGridVO<ImportMaskingExecute> vo = new DataGridVO<ImportMaskingExecute>(pageInfo.getCount(), list);
      return vo;
   }

   @RequestMapping({"/isrun"})
   @ResponseBody
   public boolean isrun(String taskid, HttpServletRequest request, @RequestParam Map<String, String> tableInfoMap) {
      long num_exeing = this.importDesensitizationtaskService.getExeTaskNum();
      long num_table = 1L;
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      long num_thread = new Long(props.getProperty("threadPool.queueCapacity"));
      return num_exeing + num_table < num_thread;
   }

   @RequestMapping({"/executeDesensitizationTask"})
   public String executeDesensitizationTask(HttpServletRequest request, Model model, String taskid) {
      System.out.println("start");

      try {
         ImportMaskingExecute importMaskingExecute = this.importDesensitizationtaskService.getImportMaskingExecute(taskid);
         String foldername = importMaskingExecute.getFoldername();
         String taskname = importMaskingExecute.getTaskname();
         importMaskingExecute.setFoldername(foldername);
         this.importDesensitizationtaskService.saveImportMaskingExecute(importMaskingExecute);
         ExecuteParam executeParam = new ExecuteParam();
         InfoProperty infoProperty = this.importDesensitizationtaskService.getInfoProperty();
         executeParam.setInfoProperty(infoProperty);
         executeParam.setFolderName(foldername);
         long groupId = (new Date()).getTime();
         StringBuilder batchInserSql = new StringBuilder();
         List<String> list_table = JdbcTool.sql_insert_q(new DesensitizationMonitor());
         list_table.add("id");
         String sqlBase = JdbcTool.sql_insert_z(list_table, "desensitization_monitor");
         batchInserSql.append(sqlBase);
         DesensitizationMonitor desensitizationMonitor = new DesensitizationMonitor();
         String id = UUID.randomUUID().toString();
         desensitizationMonitor.setId(id);
         desensitizationMonitor.setSourcename("源");
         desensitizationMonitor.setTargetname("目标");
         desensitizationMonitor.setRunstatus(1);
         desensitizationMonitor.setGroupid(new BigInteger(String.valueOf(groupId)));
         desensitizationMonitor.setTaskid(taskid);
         desensitizationMonitor.setTasktype("");
         batchInserSql.append(JdbcTool.sql_insert_h(desensitizationMonitor, list_table));
         this.importDesensitizationtaskService.saveDesensitizationMonitor(batchInserSql.deleteCharAt(batchInserSql.length() - 1));
         this.importDesensitizationtaskService.executeTask(taskid, id, executeParam, taskname);
         model.addAttribute("taskid", taskid);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return "core/desensitizationimportmonitor/monitorimportrun";
   }

   @RequestMapping({"/removetask"})
   @ResponseBody
   public boolean removetask(String taskid, HttpServletRequest request, @RequestParam Map<String, String> tableInfoMap) {
      this.importDesensitizationtaskService.removetask(taskid);
      return true;
   }
}
