package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.entity.orm.table.core.notice.SnmpTrapInfomation;
import com.chenyang.nse.bussiness.service.core.SnmpTrapService;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping({"/core/snmp"})
public class SnmpTrapController {
   private static Logger logger = LoggerFactory.getLogger(ControlledAssetController.class);
   @Autowired
   private SnmpTrapService snmpTrapService;
   private static final Logger ddmauditLogger = LoggerFactory.getLogger("ddmauditLogger");
   private static final Logger operationLogger = LoggerFactory.getLogger("operationLogger");

   @RequestMapping({"/queryAll"})
   @ResponseBody
   public Response query(@RequestParam Map<String, String> params, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<SnmpTrapInfomation> list = this.snmpTrapService.queryAll();
      ddmauditLogger.info(MesUtil.getMsg("DDM_01802", new String[]{CommonUtils.loginUsername(), CommonUtils.loginUsername()}));
      return RespHelper.successResp(list);
   }

   @RequestMapping({"/initEdit"})
   @ResponseBody
   public Response<SnmpTrapInfomation> initControlledAsset(@RequestParam Map<String, String> params) {
      String id = String.valueOf(params.get("id"));
      ddmauditLogger.info(MesUtil.getMsg("DDM_01804", new String[]{CommonUtils.loginUsername(), CommonUtils.loginUsername()}));
      if (id != null && id.toString().length() != 0) {
         SnmpTrapInfomation email = this.snmpTrapService.initSnmp(id);
         return RespHelper.<SnmpTrapInfomation>successResp(email);
      } else {
         return RespHelper.<SnmpTrapInfomation>paramErrResp();
      }
   }

   @PostMapping({"/add"})
   @ResponseBody
   public Response<SnmpTrapInfomation> addControlledAsset(@RequestBody SnmpTrapInfomation snmpTrapInfomation, HttpServletRequest request) {
      if (StringUtils.isBlank(snmpTrapInfomation.getId())) {
         ddmauditLogger.info(MesUtil.getMsg("DDM_01804", new String[]{CommonUtils.loginUsername(), snmpTrapInfomation.getSnmp_server_name()}));
      } else {
         ddmauditLogger.info(MesUtil.getMsg("DDM_01803", new String[]{CommonUtils.loginUsername(), snmpTrapInfomation.getSnmp_server_name()}));
      }

      this.snmpTrapService.addSnmp(snmpTrapInfomation);
      return RespHelper.<SnmpTrapInfomation>successResp(snmpTrapInfomation);
   }

   @PostMapping({"/del"})
   @ResponseBody
   public Response remove(@RequestBody Map<String, Object> params, HttpServletRequest request, HttpServletResponse response, Model model) {
      String id = (String)params.get("id");
      String name = (String)params.get("snmpServerName");
      ddmauditLogger.info(MesUtil.getMsg("DDM_01805", new String[]{CommonUtils.loginUsername(), name}));
      this.snmpTrapService.remove(id);
      return RespHelper.successResp();
   }
}
