package com.chenyang.nse.bussiness.controller.core.log.auditbysyslog;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.vo.auditlog.AuditBySyslogVO;
import com.chenyang.nse.bussiness.tools.datatime.DateTimeTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import net.sf.json.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/log/app/auditbysyslog"})
public class AuditBySysLogController {
   @PostMapping({"/getabslog"})
   @ResponseBody
   public Response getAuditBySyslog(@RequestBody Map<String, String> map) throws IOException {
      int pagenum = Integer.parseInt((String)map.get("page"));
      int pagesize = Integer.parseInt((String)map.get("rows"));
      PageInfo pageInfo = new PageInfo();
      pageInfo.setPageno(pagenum);
      pageInfo.setPagesize(pagesize);
      String username = (String)map.get("username");
      String range = (String)map.get("range");
      new Properties();
      Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      String filepath = props.getProperty("syslog4auditserverlogpath");
      List<AuditBySyslogVO> arrayList = new ArrayList();
      Date today = new Date();
      if ("0".equals(range)) {
         String fm = "yyyy-MM-dd";
         String toFileName = DateTimeTool.formatDateTime(today, fm);
         File file = new File(filepath + "/syslog4audit/" + toFileName + ".txt");
         InputStreamReader inputReader = new InputStreamReader(new FileInputStream(file), StandardCharsets.UTF_8);
         BufferedReader bf = new BufferedReader(inputReader);

         String str1;
         while((str1 = bf.readLine()) != null) {
            JSONObject jsonObject = JSONObject.fromObject(str1);
            AuditBySyslogVO vo = (AuditBySyslogVO)JSONObject.toBean(jsonObject, AuditBySyslogVO.class);
            vo.setMessage((String)jsonObject.getJSONObject("message").get("message"));
            arrayList.add(vo);
         }

         bf.close();
         inputReader.close();
      }

      List<String> files = new ArrayList();
      if (!"0".equals(range)) {
         String path = filepath + "syslog4audit";
         File file1 = new File(path);
         File[] tempList = file1.listFiles();

         for(int i = 0; i < ((File[])Objects.requireNonNull(tempList)).length; ++i) {
            if (tempList[i].isFile()) {
               String fileName = tempList[i].getName().substring(0, tempList[i].getName().indexOf("txt") - 1);
               Date date = DateTimeTool.parseDateTime(fileName, "yyyy-MM-dd");
               today = new Date();
               if (!"全部".equals(range)) {
                  if (DateTimeTool.beforeDays(today, Integer.parseInt(range) + 1).before(date)) {
                     files.add(tempList[i].getName());
                  }
               } else {
                  files.add(tempList[i].getName());
               }
            }
         }

         for(String s : files) {
            File file2 = new File(filepath + "syslog4audit/" + s);
            InputStreamReader inReader = new InputStreamReader(new FileInputStream(file2), StandardCharsets.UTF_8);
            BufferedReader bf1 = new BufferedReader(inReader);

            String str1;
            while((str1 = bf1.readLine()) != null) {
               JSONObject jsonObject = JSONObject.fromObject(str1);
               AuditBySyslogVO vo = (AuditBySyslogVO)JSONObject.toBean(jsonObject, AuditBySyslogVO.class);
               vo.setMessage((String)jsonObject.getJSONObject("message").get("message"));
               arrayList.add(vo);
            }

            bf1.close();
            inReader.close();
         }
      }

      new ArrayList();
      List var26;
      if (arrayList.size() < pagenum * pagesize) {
         var26 = arrayList.subList((pagenum - 1) * pagesize, arrayList.size());
      } else {
         var26 = arrayList.subList((pagenum - 1) * pagesize, pagenum * pagesize);
      }

      pageInfo.setCount((long)var26.size());
      return RespHelper.updateResp(pageInfo, var26);
   }
}
