package com.chenyang.nse.bussiness.dao.table.core;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRule;
import com.chenyang.nse.bussiness.entity.vo.TmaskingRuleCustMapping;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.util.List;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreMaskingruleDao extends BaseDao<TCoreMaskingRule, String> {
   public List<TmaskingRuleCustMapping> queryRuleCustByEngineId(String engineid) {
      String sql = XmlTool.getSql("maskingrule", "queryRuleCustByEngineId");
      return this.getSession().createNativeQuery(sql).setParameter("engineid", engineid).setResultTransformer(Transformers.aliasToBean(TmaskingRuleCustMapping.class)).getResultList();
   }
}
