package com.chenyang.nse.bussiness.dao.table.core.dataproject;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDictionary;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectDatasource;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DataSourceAndTaskVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.DatasystemProjectdatasourceVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreProjectDatasourceVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreProjectDatasourceDao extends BaseDao<TCoreProjectDatasource, String> {
   public List<Map<String, Object>> selectSource(String id, String userid) {
      String sql = "";
      if (!"".equals(userid)) {
         sql = "SELECT count(1) as s FROM T_CORE_PROJECT_DATASOURCE where systemstyle ='1' and project_id ='" + id + "' and systemsource_id in ( select sysid from t_base_usersys where userid in " + userid + ")  union all SELECT count(1) as s FROM T_CORE_PROJECT_DATASOURCE where systemstyle ='2' and project_id ='" + id + "'  and systemsource_id in ( select sysid from t_base_usersys where userid in " + userid + ")  union all SELECT count(1) as s FROM T_CORE_PROJECT_DATASOURCE where systemstyle ='3' and project_id ='" + id + "'  and systemsource_id in ( select sysid from t_base_usersys where userid in " + userid + ") ";
         if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
            sql = "SELECT count(1) as \"s\" FROM T_CORE_PROJECT_DATASOURCE where systemstyle ='1' and project_id ='" + id + "' and systemsource_id in ( select sysid from t_base_usersys where userid in " + userid + ")  union all SELECT count(1) as s FROM T_CORE_PROJECT_DATASOURCE where systemstyle ='2' and project_id ='" + id + "'  and systemsource_id in ( select sysid from t_base_usersys where userid in " + userid + ")  union all SELECT count(1) as s FROM T_CORE_PROJECT_DATASOURCE where systemstyle ='3' and project_id ='" + id + "'  and systemsource_id in ( select sysid from t_base_usersys where userid in " + userid + ") ";
         }
      } else {
         sql = "SELECT count(1) as s FROM T_CORE_PROJECT_DATASOURCE where systemstyle ='1' and project_id ='" + id + "' union all SELECT count(1) as s FROM T_CORE_PROJECT_DATASOURCE where systemstyle ='2' and project_id ='" + id + "' union all SELECT count(1) as s FROM T_CORE_PROJECT_DATASOURCE where systemstyle ='3' and project_id ='" + id + "' ";
         if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
            sql = "SELECT count(1) as \"s\" FROM T_CORE_PROJECT_DATASOURCE where systemstyle ='1' and project_id ='" + id + "' union all SELECT count(1) as s FROM T_CORE_PROJECT_DATASOURCE where systemstyle ='2' and project_id ='" + id + "' union all SELECT count(1) as s FROM T_CORE_PROJECT_DATASOURCE where systemstyle ='3' and project_id ='" + id + "' ";
         }
      }

      List<Map<String, Object>> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }

   public List<DatasystemProjectdatasourceVO> queryDatasystemByProId(String projectid) {
      String sql = "select a.project_id,b.id,b.flag,b.sysname,b.localdir,b.versionname,b.dbtype,b.pagecode,b.dbip,b.dbport,b.servername,b.dbservername,b.dblinkname,b.username, b.password,b.istargetdb, b.createtime  from  t_core_datasystem b inner JOIN t_core_project_datasource a on (a.systemsource_id=b.id and a.project_id = '" + projectid + "' ) where 1=1 ";
      List<DatasystemProjectdatasourceVO> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(DatasystemProjectdatasourceVO.class)).getResultList();
      return list;
   }

   public List<DatasystemProjectdatasourceVO> queryDatasourceByProjectId(String projectid) {
      String sql = "select a.project_id,b.id as tid,b.flag,b.sysname,b.localdir,b.versionname,b.dbtype,b.pagecode,b.dbip,b.dbport,b.servername,b.dbservername,b.dblinkname,b.username, b.password,b.istargetdb, b.createtime,b.defaultschema  from  t_core_datasystem b inner JOIN t_core_project_datasource a on (a.systemsource_id=b.id and a.project_id = '" + projectid + "' ) where 1=1 ";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "select a.project_id as \"project_id\",b.id as \"tid\",b.flag as \"flag\",b.sysname as \"sysname\",b.localdir as \"localdir\",b.versionname as \"versionname\",b.dbtype as \"dbtype\",b.pagecode as \"pagecode\",b.dbip as \"dbip\",b.dbport as \"dbport\",b.servername as \"servername\",b.dbservername as \"dbservername\",b.dblinkname as \"dblinkname\",b.username as \"username\", b.password as \"password\",b.istargetdb as \"istargetdb\", b.createtime as \"createtime\",b.defaultschema as \"defaultschema\" from  t_core_datasystem b inner JOIN t_core_project_datasource a on (a.systemsource_id=b.id and a.project_id = '" + projectid + "' ) where 1=1 ";
      }

      List<DatasystemProjectdatasourceVO> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public List<DatasystemProjectdatasourceVO> queryDataSystemByProjectIdAndDataSystemId(String projectid, String datasourceid) {
      String sql = "select b.id,b.dbtype,b.dbip,b.dbport,b.dbservername,b.dblinkname,b.username, b.password  from  t_core_datasystem b inner JOIN t_core_project_datasource a on (a.systemsource_id=b.id and a.project_id = '" + projectid + "' ) where 1=1 and b.id = '" + datasourceid + "'";
      List<DatasystemProjectdatasourceVO> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(DatasystemProjectdatasourceVO.class)).getResultList();
      return list;
   }

   public List<DatasystemProjectdatasourceVO> queryDatasourceById(String projectid) {
      String sql = "select a.id as project_id,b.id,b.flag,b.sysname,b.localdir,b.versionname,b.dbtype,b.pagecode,b.dbip,b.dbport,b.servername,b.dbservername,b.dblinkname,b.username, b.password,b.istargetdb, b.createtime,b.defaultschema  from  t_core_datasystem b inner JOIN t_core_controlled_asset a on (a.datasourceid=b.id and a.id = '" + projectid + "' ) where 1=1 ";
      List<DatasystemProjectdatasourceVO> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public List<TCoreProjectDatasourceVO> queryDatasourceList(String projectid) {
      String sql = "select a.project_id,a.systemsource_id as id,b.sysname from t_core_project_datasource a LEFT JOIN t_core_datasystem b on a.systemsource_id=b.id where a.project_id='" + projectid + "'";
      List<TCoreProjectDatasourceVO> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }

   public List<DataSourceAndTaskVO> queryDiscoverydate(PageInfo pageInfo, String sourceid) {
      pageInfo.setCount(this.count(new Criterion[]{Restrictions.eq("systemsource_id", sourceid)}));
      String sql = "SELECT a.project,a.createtime,b.tname,b.updatetime FROM t_core_data_project a,t_core_discovery_task b,t_core_project_datasource c where a.id=b.projectid AND b.projectid=c.project_id GROUP BY b.tname AND c.systemsource_id='" + sourceid + "'";
      return this.getSession().createNativeQuery(sql).setParameter("systemsource_id", sourceid).setFirstResult(pageInfo.getOffset()).setMaxResults(pageInfo.getPagesize()).setResultTransformer(Transformers.aliasToBean(TConsoleDictionary.class)).getResultList();
   }

   public List<ComboboxVO> queryFilesource(String projectid, String filetype, String userid) {
      String sql = "SELECT distinct b.id as value,b.sysname as text FROM t_core_project_datasource a LEFT JOIN t_core_datasystem b ON a.systemsource_id = b.id LEFT JOIN t_base_usersys us ON a.systemsource_id = us.sysid WHERE a.project_id = '" + projectid + "' and b.flag='2' and b.dbtype='" + filetype + "' and us.userid='" + userid + "'";
      List<ComboboxVO> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }

   public List<DatasystemProjectdatasourceVO> queryByFlagAll(String flag, String projectid, String dbtype, String userid) {
      String sql = "";
      if ("全部".equals(dbtype)) {
         sql = "select a.project_id,b.id,b.flag,b.sysname,b.localdir,b.versionname,b.dbtype,b.pagecode,b.dbip,b.dbport,b.servername,b.dbservername,b.dblinkname,b.username, b.password,b.istargetdb, b.createtime  from  t_core_datasystem b LEFT JOIN t_core_project_datasource a on (a.systemsource_id=b.id and a.project_id = '" + projectid + "' ) where b.flag='" + flag + "'";
      } else {
         sql = "select a.project_id,b.id,b.flag,b.sysname,b.localdir,b.versionname,b.dbtype,b.pagecode,b.dbip,b.dbport,b.servername,b.dbservername,b.dblinkname,b.username, b.password,b.istargetdb, b.createtime  from  t_core_datasystem b LEFT JOIN t_core_project_datasource a on (a.systemsource_id=b.id and a.project_id = '" + projectid + "' ) where b.flag='" + flag + "' and b.dbtype='" + dbtype + "'";
      }

      if (!"".equals(userid)) {
         sql = sql + "   and b.id in ( select u.sysid from t_base_usersys u where u.userid in " + userid + ")  GROUP BY b.id order by b.createtime desc";
      } else {
         sql = sql + "  GROUP BY b.id order by b.createtime desc";
      }

      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
   }

   public List<DatasystemProjectdatasourceVO> queryByFlagAll(String dbtype, String flag, String userid) {
      String sql = "";
      if ("全部".equals(dbtype)) {
         sql = "select b.id as tid,b.flag,b.sysname,b.localdir,b.versionname,b.dbtype,b.pagecode,b.dbip,b.dbport,b.servername,b.dbservername,b.dblinkname,b.username, b.password,b.istargetdb, b.createtime  from  t_core_datasystem b where 1=1";
         if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
            sql = "select b.id as \"tid\",b.flag as \"flag\",b.sysname as \"sysname\",b.localdir as \"localdir\",b.versionname as \"versionname\",b.dbtype as \"dbtype\",b.pagecode as \"pagecode\",b.dbip as \"dbip\",b.dbport as \"dbport\",b.servername as \"servername\",b.dbservername as \"dbservername\",b.dblinkname as \"dblinkname\",b.username as \"username\", b.password as \"password\",b.istargetdb as \"istargetdb\", b.createtime as \"createtime\"  from  t_core_datasystem b where 1=1";
         }
      } else {
         sql = "select b.id as tid,b.flag,b.sysname,b.localdir,b.versionname,b.dbtype,b.pagecode,b.dbip,b.dbport,b.servername,b.dbservername,b.dblinkname,b.username, b.password,b.istargetdb, b.createtime  from  t_core_datasystem b  where b.dbtype='" + dbtype + "'";
         if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
            sql = "select b.id as \"tid\",b.flag as \"flag\",b.sysname as \"sysname\",b.localdir as \"localdir\",b.versionname as \"versionname\",b.dbtype as \"dbtype\",b.pagecode as \"pagecode\",b.dbip as \"dbip\",b.dbport as \"dbport\",b.servername as \"servername\",b.dbservername as d\"bservername\",b.dblinkname as \"dblinkname\",b.username as \"username\", b.password as \"password\",b.istargetdb as \"istargetdb\", b.createtime as \"createtime\" from  t_core_datasystem b  where b.dbtype='" + dbtype + "'";
         }
      }

      if (!"".equals(userid)) {
         sql = sql + "   and b.id in ( select u.datasystemid from t_core_datasystemuser u where u.userid in " + userid + ")   order by b.createtime desc";
      } else {
         sql = sql + "  order by b.createtime desc";
      }

      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
   }

   public List<String> getTaskDataSource(String projectid) {
      String sql = "select  distinct(datasourceid) as systemsource_id from t_core_discovery_column where projectid = '" + projectid + "' union select  distinct(datasourceid) as systemsource_id from  desensitizationsource a,desensitizationtask c where c.id = a.taskid and c.projectid = '" + projectid + "' union select  distinct(datasourceid) as systemsource_id from desensitizationtarget b,desensitizationtask c where c.id = b.taskid and c.projectid = '" + projectid + "'";
      List<Map<String, Object>> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      List<String> list = new ArrayList();

      for(Map<String, Object> map : vo) {
         list.add((String)map.get("systemsource_id"));
      }

      return list;
   }

   public List<TCoreProjectDatasource> queryAllProDataSource(String flag, String projectid, String dbtype, String userid) {
      String sql = "";
      if ("全部".equals(dbtype)) {
         sql = "select  id as systemsource_id,'" + projectid + "' as project_id, '" + flag + "' as systemstyle from  t_core_datasystem  where flag='" + flag + "' ";
      } else {
         sql = "select  id as systemsource_id,'" + projectid + "' as project_id, '" + flag + "' as systemstyle from  t_core_datasystem  where flag='" + flag + "' and dbtype='" + dbtype + "' ";
      }

      if (!"".equals(userid)) {
         sql = sql + "and id in ( select u.sysid from t_base_usersys u where u.userid in " + userid + ")";
      }

      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreProjectDatasource.class)).getResultList();
   }

   public void saveAll(StringBuilder sql) {
      this.getSession().createNativeQuery(sql.toString()).executeUpdate();
   }

   public List<Map<String, Object>> isChooseAll(String flag, String projectid, String searchval, String dbtype, String userid) {
      String sql = "";
      if (!"3".equals(flag)) {
         if ("全部".equals(dbtype)) {
            sql = "select  a.id from  t_core_datasystem a,t_core_project_datasource b  where b.project_id ='" + projectid + "' and a.id=b.systemsource_id and a.flag='" + flag + "' and a.sysname like '%" + searchval + "%' ";
         } else {
            sql = "select  a.id from  t_core_datasystem a,t_core_project_datasource b where b.project_id ='" + projectid + "' and a.id=b.systemsource_id and a.flag='" + flag + "' and a.dbtype='" + dbtype + "' and a.sysname like '%" + searchval + "%' ";
         }
      } else if (dbtype.contains("星环4.8")) {
         sql = "select  a.id from  t_core_datasystem a,t_core_project_datasource b where b.project_id ='" + projectid + "' and a.id=b.systemsource_id and a.flag='" + flag + "' and a.versionname = '星环4.8' and a.sysname like '%" + searchval + "%' ";
      } else if (dbtype.contains("星环5.2")) {
         sql = "select  a.id from  t_core_datasystem a,t_core_project_datasource b where b.project_id ='" + projectid + "' and a.id=b.systemsource_id and a.flag='" + flag + "' and a.versionname = '星环5.2' and a.sysname like '%" + searchval + "%' ";
      } else if (dbtype.contains("CLOUDERA")) {
         sql = "select  a.id from  t_core_datasystem a,t_core_project_datasource b where b.project_id ='" + projectid + "' and a.id=b.systemsource_id and a.flag='" + flag + "' and a.versionname like '%CLOUDERA' and a.sysname like '%" + searchval + "%' ";
      } else {
         sql = "select  a.id from  t_core_datasystem a,t_core_project_datasource b where b.project_id ='" + projectid + "' and a.id=b.systemsource_id and a.flag='" + flag + "' and a.sysname like '%" + searchval + "%' ";
      }

      if (!"".equals(userid)) {
         sql = sql + "and a.id in ( select u.sysid from t_base_usersys u where u.userid in " + userid + ")";
      }

      List<Map<String, Object>> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }

   public void removeAllProDataSource(String flag, String projectid, String searchval, String dbtype, String userid) {
      String sql = "";
      if (!"3".equals(flag)) {
         if ("全部".equals(dbtype)) {
            sql = "delete t_core_project_datasource  from  t_core_datasystem a,t_core_project_datasource b  where b.project_id ='" + projectid + "' and a.id=b.systemsource_id and a.flag='" + flag + "' and a.sysname like '%" + searchval + "%' ";
         } else {
            sql = "delete t_core_project_datasource from  t_core_datasystem a,t_core_project_datasource b where b.project_id ='" + projectid + "' and a.id=b.systemsource_id and a.flag='" + flag + "' and a.dbtype='" + dbtype + "' and a.sysname like '%" + searchval + "%' ";
         }
      } else if (dbtype.contains("星环4.8")) {
         sql = "delete t_core_project_datasource  from  t_core_datasystem a,t_core_project_datasource b where b.project_id ='" + projectid + "' and a.id=b.systemsource_id and a.flag='" + flag + "' and a.versionname = '星环4.8' and a.sysname like '%" + searchval + "%' ";
      } else if (dbtype.contains("星环5.2")) {
         sql = "delete t_core_project_datasource  from  t_core_datasystem a,t_core_project_datasource b where b.project_id ='" + projectid + "' and a.id=b.systemsource_id and a.flag='" + flag + "' and a.versionname = '星环5.2' and a.sysname like '%" + searchval + "%' ";
      } else if (dbtype.contains("CLOUDERA")) {
         sql = "delete t_core_project_datasource  from  t_core_datasystem a,t_core_project_datasource b where b.project_id ='" + projectid + "' and a.id=b.systemsource_id and a.flag='" + flag + "' and a.versionname like '%CLOUDERA' and a.sysname like '%" + searchval + "%' ";
      } else {
         sql = "delete t_core_project_datasource  from  t_core_datasystem a,t_core_project_datasource b where b.project_id ='" + projectid + "' and a.id=b.systemsource_id and a.flag='" + flag + "' and a.sysname like '%" + searchval + "%' ";
      }

      if (!"".equals(userid)) {
         sql = sql + "and a.id in ( select u.sysid from t_base_usersys u where u.userid in " + userid + ")";
      }

   }

   public List<String> getHasTaskDataSource(String flag, String projectid, String dbtype, String userid) {
      String sql = "";
      if ("全部".equals(dbtype)) {
         sql = "select  a.id systemsource_id from  t_core_datasystem a,t_core_project_datasource b  where b.project_id ='" + projectid + "' and a.id=b.systemsource_id and a.flag='" + flag + "' ";
      } else {
         sql = "select  a.id systemsource_id from  t_core_datasystem a,t_core_project_datasource b where b.project_id ='" + projectid + "' and a.id=b.systemsource_id and a.flag='" + flag + "' and a.dbtype='" + dbtype + "' ";
      }

      if (!"".equals(userid)) {
         sql = sql + "and a.id in ( select u.sysid from t_base_usersys u where u.userid in " + userid + ")";
      }

      List<Map<String, Object>> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      List<String> list = new ArrayList();

      for(Map<String, Object> map : vo) {
         list.add((String)map.get("systemsource_id"));
      }

      return list;
   }

   public String getSysnameByid(String id) {
      String sql = "select sysname from t_core_datasystem where id = :id";
      return this.getSession().createNativeQuery(sql).setParameter("id", id).uniqueResult().toString();
   }

   public String getDbtypeByid(String id) {
      String sql = "select dbtype from t_core_datasystem where id = :id";
      return this.getSession().createNativeQuery(sql).setParameter("id", id).uniqueResult().toString();
   }
}
