package com.chenyang.nse.bussiness.dao.table.core.fieldscope.view;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.view.TViewDataScopeProject;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class TViewDataScopeProjectDao extends BaseDao<TViewDataScopeProject, String> {
   public List<TViewDataScopeProject> queryBylist(PageInfo pageInfo, String projectid, String type, String directory_name, String tablename, String columnname) {
      long count = this.count();
      pageInfo.setCount(count);
      Criteria criteria = this.createCriteria();
      criteria.add(Restrictions.eq("projectid", projectid));
      if (!"".equals(directory_name) && !"0".equals(directory_name)) {
         criteria.add(Restrictions.eq("directory_name", directory_name));
      }

      if (tablename != null && !"".equals(tablename)) {
         criteria.add(Restrictions.like("tablename", tablename, MatchMode.ANYWHERE));
      }

      if (columnname != null && !"".equals(columnname)) {
         criteria.add(Restrictions.like("columnname", columnname, MatchMode.ANYWHERE));
      }

      return criteria.setFirstResult(pageInfo.getOffset()).setMaxResults(pageInfo.getPagesize()).list();
   }
}
