package com.chenyang.nse.bussiness.odbc;

import com.chenyang.nse.bussiness.bean.Column;
import com.chenyang.nse.bussiness.bean.DataBase;
import com.chenyang.nse.bussiness.bean.DataCache;
import com.chenyang.nse.bussiness.bean.Schema;
import com.chenyang.nse.bussiness.bean.Table;
import java.util.ArrayList;
import java.util.List;
import util.JdbcUtil;
import util.getdata.DatabaseCache;

public class DbCache {
   public static void sync() {
      try {
         List<DataBase> dataList = DataCache.dataList;
         List<bean.DataBase> dbList = new ArrayList();

         for(DataBase dataBase : dataList) {
            bean.DataBase db = new bean.DataBase();
            db.setIp_port(dataBase.getIp_port());
            db.setDbType(dataBase.getDbType().toLowerCase());
            db.setUrl(dataBase.getUrl());
            if (dataBase.getSchemaList() != null && dataBase.getSchemaList().size() > 0) {
               for(Schema schema : dataBase.getSchemaList()) {
                  if (schema != null && schema.getName() != null && schema.getName().length() != 0) {
                     bean.Schema sch = new bean.Schema(schema.getName());
                     sch.setRealName(schema.getName());
                     if (schema.getTableList() != null && schema.getTableList().size() != 0) {
                        for(Table table : schema.getTableList()) {
                           if (table != null && table.getName() != null && table.getName().length() != 0) {
                              bean.Table tb = new bean.Table(table.getName(), schema.getName());
                              tb.setRealName(table.getName());
                              tb.setColumnList(new ArrayList());
                              sch.getTableList().add(tb);
                              if (table.getColumnList() != null && table.getColumnList().size() != 0) {
                                 for(Column column : table.getColumnList()) {
                                    if (column != null && column.getColumnName() != null && column.getColumnName().length() != 0) {
                                       bean.Column col = new bean.Column();
                                       col.setColumnName(column.getColumnName());
                                       col.setTable(table.getName());
                                       col.setSchema(schema.getName());
                                       tb.getColumnList().add(col);
                                    }
                                 }
                              }
                           }
                        }

                        db.getSchemaList().add(sch);
                     }
                  }
               }
            }

            DatabaseCache cache = new DatabaseCache(db);
            db.simpleCache = cache;
            cache.init();
            dbList.add(db);
         }

         JdbcUtil.dataBaseList = dbList;
      } catch (Exception e) {
         e.printStackTrace();
      }

   }
}
