package com.chenyang.nse.bussiness.service.console.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.core.encryption.EncryptionLogDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncrypLogDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncrypLog;
import com.chenyang.nse.bussiness.entity.vo.encyption.EncryptionLogVo;
import com.chenyang.nse.bussiness.service.console.EncrypLogService;
import com.chenyang.nse.bussiness.tools.datatime.DateTimeTool;
import com.chenyang.nse.bussiness.tools.encryption.SM3Utils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@Transactional
public class EncrypLogServiceImpl implements EncrypLogService {
   @Autowired
   EncryptionLogDao encryptionLogDao;
   @Autowired
   TCoreEncrypLogDao tCoreEncrypLogDao;

   public List<EncryptionLogVo> queryRow(PageInfo pageInfo, String projectId, String module, String range, String user) {
      Criterion projectCon;
      if (projectId != null && !"".equals(projectId)) {
         projectCon = Restrictions.eq("projectId", projectId);
      } else {
         projectCon = Restrictions.like("projectId", "%%");
      }

      Criterion moduleCon;
      if (module != null && !"".equals(module)) {
         moduleCon = Restrictions.eq("operModule", module);
      } else {
         moduleCon = Restrictions.like("operModule", "%%");
      }

      Criterion userCon;
      if (user != null && !"".equals(user)) {
         userCon = Restrictions.eq("operptionUser", user);
      } else {
         userCon = Restrictions.like("operptionUser", "%%");
      }

      Date today = new Date();
      List<TCoreEncrypLog> logList;
      if (range != null && !"".equals(range)) {
         if (!"0".equals(range)) {
            if (!"全部".equals(range)) {
               Criterion timeCon = Restrictions.between("createtime", DateTimeTool.beforeDays(today, Integer.valueOf(range)), today);
               logList = this.tCoreEncrypLogDao.queryByPageInfo(pageInfo, Order.desc("createtime"), new Criterion[]{projectCon, moduleCon, timeCon, userCon});
            } else {
               logList = this.tCoreEncrypLogDao.queryByPageInfo(pageInfo, Order.desc("createtime"), new Criterion[]{projectCon, moduleCon, userCon});
            }
         } else {
            Criterion timeCon = Restrictions.ge("createtime", DateTimeTool.dayOfStart(today));
            logList = this.tCoreEncrypLogDao.queryByPageInfo(pageInfo, Order.desc("createtime"), new Criterion[]{projectCon, moduleCon, timeCon, userCon});
         }
      } else {
         logList = this.tCoreEncrypLogDao.queryByPageInfo(pageInfo, Order.desc("createtime"), new Criterion[]{projectCon, moduleCon, userCon});
      }

      List<EncryptionLogVo> list = new ArrayList();
      if (!ObjectUtils.isEmpty(logList)) {
         logList.forEach((item) -> {
            EncryptionLogVo encryptionLogVo = new EncryptionLogVo();
            BeanUtils.copyProperties(item, encryptionLogVo);
            list.add(encryptionLogVo);
         });
      }

      return list;
   }

   public List<Map<String, Object>> queryList(String projectId, String module, String range, String user) {
      Criterion projectCon;
      if (projectId != null && !"".equals(projectId)) {
         projectCon = Restrictions.eq("projectId", projectId);
      } else {
         projectCon = Restrictions.like("projectId", "%%");
      }

      Criterion moduleCon;
      if (module != null && !"".equals(module)) {
         moduleCon = Restrictions.eq("operModule", module);
      } else {
         moduleCon = Restrictions.like("operModule", "%%");
      }

      Criterion userCon;
      if (user != null && !"".equals(user)) {
         userCon = Restrictions.eq("operptionUser", user);
      } else {
         userCon = Restrictions.like("operptionUser", "%%");
      }

      Date today = new Date();
      List<TCoreEncrypLog> logList;
      if (range != null && !"".equals(range)) {
         if (!"0".equals(range)) {
            if (!"全部".equals(range)) {
               Criterion timeCon = Restrictions.between("createtime", DateTimeTool.beforeDays(today, Integer.valueOf(range)), today);
               logList = this.tCoreEncrypLogDao.queryAll(Order.desc("createtime"), new Criterion[]{projectCon, moduleCon, timeCon, userCon});
            } else {
               logList = this.tCoreEncrypLogDao.queryAll(Order.desc("createtime"), new Criterion[]{projectCon, moduleCon, userCon});
            }
         } else {
            Criterion timeCon = Restrictions.ge("createtime", DateTimeTool.dayOfStart(today));
            logList = this.tCoreEncrypLogDao.queryAll(Order.desc("createtime"), new Criterion[]{projectCon, moduleCon, timeCon, userCon});
         }
      } else {
         logList = this.tCoreEncrypLogDao.queryAll(Order.desc("createtime"), new Criterion[]{projectCon, moduleCon, userCon});
      }

      List<Map<String, Object>> mapList = new ArrayList();

      for(TCoreEncrypLog encryptionLogVo : logList) {
         Map<String, Object> resultMap = new HashMap();
         resultMap.put("用户", encryptionLogVo.getOperptionUser());
         resultMap.put("时间", encryptionLogVo.getCreatetime());
         resultMap.put("操作代码", encryptionLogVo.getCode());
         resultMap.put("操作模块", encryptionLogVo.getOperModule());
         resultMap.put("操作信息", encryptionLogVo.getOperptionMassage());
         mapList.add(resultMap);
      }

      return mapList;
   }

   public boolean checkEnc(String projectId, String module, String range, String user) {
      Criterion projectCon;
      if (projectId != null && !"".equals(projectId)) {
         projectCon = Restrictions.eq("projectId", projectId);
      } else {
         projectCon = Restrictions.like("projectId", "%%");
      }

      Criterion moduleCon;
      if (module != null && !"".equals(module)) {
         moduleCon = Restrictions.eq("operModule", module);
      } else {
         moduleCon = Restrictions.like("operModule", "%%");
      }

      Criterion userCon;
      if (user != null && !"".equals(user)) {
         userCon = Restrictions.eq("operptionUser", user);
      } else {
         userCon = Restrictions.like("operptionUser", "%%");
      }

      Date today = new Date();
      List<TCoreEncrypLog> logList;
      if (range != null && !"".equals(range)) {
         if (!"0".equals(range)) {
            if (!"全部".equals(range)) {
               Criterion timeCon = Restrictions.between("createtime", DateTimeTool.beforeDays(today, Integer.valueOf(range)), today);
               logList = this.tCoreEncrypLogDao.queryAll(Order.desc("createtime"), new Criterion[]{projectCon, moduleCon, timeCon, userCon});
            } else {
               logList = this.tCoreEncrypLogDao.queryAll(Order.desc("createtime"), new Criterion[]{projectCon, moduleCon, userCon});
            }
         } else {
            Criterion timeCon = Restrictions.ge("createtime", DateTimeTool.dayOfStart(today));
            logList = this.tCoreEncrypLogDao.queryAll(Order.desc("createtime"), new Criterion[]{projectCon, moduleCon, timeCon, userCon});
         }
      } else {
         logList = this.tCoreEncrypLogDao.queryAll(Order.desc("createtime"), new Criterion[]{projectCon, moduleCon, userCon});
      }

      SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

      for(TCoreEncrypLog encryptionLog : logList) {
         Date date = encryptionLog.getCreatetime();
         String dateString = sdf.format(date);

         try {
            if (!SM3Utils.encrypt(encryptionLog.getOperptionUser() + dateString + encryptionLog.getOperptionMassage()).equals(encryptionLog.getColumn_enc())) {
               return false;
            }
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

      return true;
   }
}
