package com.chenyang.nse.bussiness.service.core.encryption;

import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreSecretkey;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryption;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryptionTypeField;
import com.chenyang.nse.bussiness.entity.vo.AutoDetectVO;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public interface TCoreEncryptionService {
   void save(TCoreEncryption encryption);

   List<ComboboxVO> initEncryptionTypeList();

   List<TCoreEncryptionTypeField> deleteEncryption(String encryptionId);

   String getRandomValue(String type);

   String testEncryption(String type, String param, String isLike, String secret_key, String keepfirst, String encdigit, String twoindex);

   void saveSecretKey(TCoreSecretkey tCoreSecretKey);

   List<TCoreEncryptionTypeField> delSecretKey(String keyId);

   List<TCoreEncryption> queryEncryptionList(String encryption_name);

   Map<String, String> queryEncryptionInfo(String secretKeyId);

   Map<String, String> queryEncryptionInfo(String keyName, String sKeyName);

   AutoDetectVO autoDetect(AutoDetectVO autoDetectVO) throws SQLException;

   String getProcesslog(String path);

   void updateFlag(String projectId, String dataSystemId, String schema, String tableName, String columnName, String flag);
}
