package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.TcoreDiscoverySensitivecolumnDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoverySensitivecolumn;
import com.chenyang.nse.bussiness.service.core.DiscoverySensitivecolumnService;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DiscoverySensitivecolumnServiceImpl implements DiscoverySensitivecolumnService {
   @Autowired
   private TcoreDiscoverySensitivecolumnDao tcoreDiscoverySensitivecolumnDao;
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;

   public List<TcoreDiscoverySensitivecolumn> querySensitiveColumnsByGroupIdByVersion(String groupid, String version) {
      List<TcoreDiscoverySensitivecolumn> list = this.tcoreDiscoverySensitivecolumnDao.queryAll(Order.desc("tablename"), new Criterion[]{Restrictions.eq("groupid", groupid), Restrictions.eq("taskversion", version)});
      return list;
   }

   public void save(TcoreDiscoverySensitivecolumn tcoreDiscoverySensitivecolumn) {
      this.tcoreDiscoverySensitivecolumnDao.save(tcoreDiscoverySensitivecolumn);
   }

   public List<TcoreDiscoverySensitivecolumn> querySensitiveColumnsByGroupIdByVersionByCheck(String groupid, String version, String check) {
      List<TcoreDiscoverySensitivecolumn> list = this.tcoreDiscoverySensitivecolumnDao.queryAll(new Criterion[]{Restrictions.eq("groupid", groupid), Restrictions.eq("taskversion", version), Restrictions.eq("checked", check)});
      return list;
   }

   public List<TcoreDiscoverySensitivecolumn> getSensitiveByIdBySchema(String datasystemid, String schema, String table) {
      PageInfo pageInfo = new PageInfo();
      pageInfo.setPagesize(1);
      List<TcoreDiscoverySensitivecolumn> list = this.tcoreDiscoverySensitivecolumnDao.queryByPageInfo(pageInfo, Order.desc("taskversion"), new Criterion[]{Restrictions.eq("datasourceid", datasystemid), Restrictions.eq("tschema", schema), Restrictions.eq("tablename", table)});
      List<TcoreDiscoverySensitivecolumn> listc = new ArrayList();
      if (list != null && list.size() > 0) {
         String taskversion = ((TcoreDiscoverySensitivecolumn)list.get(0)).getTaskversion();
         listc = this.tcoreDiscoverySensitivecolumnDao.queryAll(new Criterion[]{Restrictions.eq("taskversion", taskversion), Restrictions.eq("datasourceid", datasystemid), Restrictions.eq("tschema", schema), Restrictions.eq("tablename", table)});
      }

      return listc;
   }

   public void saveTcoreDiscoverySensitivecolumn(StringBuilder sql) {
      this.tcoreDiscoverySensitivecolumnDao.saveTcoreDiscoverySensitivecolumn(sql);
   }
}
