package com.chenyang.nse.bussiness.service.info.db;

import com.chenyang.nse.bussiness.entity.redis.TCoreMaskingTaskTableInfo;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import com.power.xml.entity.ColumnInfo;
import com.power.xml.entity.Config;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HIVE extends CommonMethod implements DatabaseTool {
   public static final String fastexportname = "fastexport";
   public static final String fastloadname = "fastload";
   public static final String hdfsexportname = "hdfsexport";
   public static final String hdfsloadname = "hdfsload";
   public static final String fastexportmark = "快速导出";
   public static final String fastloadmark = "快速导入";
   public static final String hdfsexportmark = "HDFS导出";
   public static final String hdfsloadmark = "HDFS导入";
   public static final String[][] exporttype = new String[][]{{"hdfsexport", "HDFS导出", "selected"}, {"fastexport", "快速导出", ""}};
   public static final String[][] importtype = new String[][]{{"hdfsload", "HDFS导入", "selected"}};

   public String ImportMethod() {
      StringBuffer targetradio = new StringBuffer();
      targetradio.append("<select name='execution_type' >");

      for(String[] radio : importtype) {
         targetradio.append(MessageFormat.format(this.sourceradio(), "'" + radio[0] + "'", radio[1], radio[2]));
      }

      targetradio.append("</select>");
      return targetradio.toString();
   }

   public String ExportMethod() {
      StringBuffer sourceradio = new StringBuffer();
      sourceradio.append("<select name='execution_type' >");

      for(String[] radio : exporttype) {
         sourceradio.append(MessageFormat.format(this.sourceradio(), "'" + radio[0] + "'", radio[1], radio[2]));
      }

      sourceradio.append("</select>");
      return sourceradio.toString();
   }

   public Map TargetParameter_normal() {
      Map<String, String> map = this.TargetParameter_fnormal();
      return map;
   }

   public Map TargetParameter_normal1() {
      Map<String, String> map = this.TargetParameter_fnormal();
      return map;
   }

   public Map TargetParameter_notNormal() {
      Map<String, String> map = new HashMap();
      map.put("targetParameter", this.isrebuild());
      return map;
   }

   public List<StringBuffer> SynTriggersParam(Connection s_conn, Map map) {
      return null;
   }

   public List<StringBuffer> SynFunctionParam(Connection s_conn, Map map) {
      return null;
   }

   public List<StringBuffer> SynProcedureParam(Connection s_conn, Map map) {
      return null;
   }

   public ColumnInfo getPwc_columnInfo_target(Map map) {
      ColumnInfo pwc_columnInfo_target = new ColumnInfo();
      TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo = (TCoreMaskingTaskTableInfo)map.get("tCoreMaskingTaskTableInfo");
      int type = (Integer)map.get("type");
      Map<String, String> data_by_source = (Map)map.get("data_by_source");
      Boolean issomedb = (Boolean)map.get("issomedb");
      Map<String, Map<String, String>> data_target_length = (Map)map.get("data_target_length");
      Map<String, Map<String, String>> data_target = (Map)map.get("data_target");
      Map<String, Map<String, String>> data_t_x_length = (Map)map.get("data_t_x_length");
      Map<String, String> data_rule = (Map)map.get("data_rule");
      String qualifierType = (String)map.get("qualifierType");
      Config pwc_config = (Config)map.get("pwc_config");
      String source = StringTool.delparentheses(tCoreMaskingTaskTableInfo.getSourceType().toLowerCase());
      String pwc_type = (String)data_by_source.get(source);
      String targetype = "";
      String targetlength = "";
      String targetscancale = "";
      String targetpwcsqlength = "";
      String targetpwcsqscale = "";
      String targetpwcdateformat = "";
      if (type == 0) {
         if (issomedb) {
            targetype = source;
            targetlength = (String)((Map)data_target_length.get(source)).get("sourcelength");
            targetscancale = (String)((Map)data_target_length.get(source)).get("sourcescancale");
            targetpwcsqlength = (String)((Map)data_target_length.get(source)).get("pwcsqlength");
            targetpwcsqscale = (String)((Map)data_target_length.get(source)).get("pwcsqscale");
            targetpwcdateformat = (String)((Map)data_target_length.get(source)).get("pwcdateformat");
         } else {
            targetype = ((String)((Map)data_target.get(pwc_type)).get("sourcefieldname")).toLowerCase();
            targetlength = (String)((Map)data_target_length.get(targetype)).get("sourcelength");
            targetscancale = (String)((Map)data_target_length.get(targetype)).get("sourcescancale");
            targetpwcsqlength = (String)((Map)data_target_length.get(targetype)).get("pwcsqlength");
            targetpwcsqscale = (String)((Map)data_target_length.get(targetype)).get("pwcsqscale");
            targetpwcdateformat = (String)((Map)data_target_length.get(targetype)).get("pwcdateformat");
         }
      } else {
         targetype = StringTool.delparentheses(tCoreMaskingTaskTableInfo.getTargetType().toLowerCase());
         targetlength = "";
         targetscancale = "";
         targetpwcsqlength = "";
         targetpwcsqscale = "";
         targetpwcdateformat = "";
      }

      pwc_columnInfo_target.setColumnName(tCoreMaskingTaskTableInfo.getColumnName());
      if ("SYSDATE".equalsIgnoreCase(pwc_columnInfo_target.getColumnName())) {
         pwc_columnInfo_target.setColumnName(tCoreMaskingTaskTableInfo.getColumnName() + "1");
      }

      pwc_columnInfo_target.setDataType(StringTool.delparentheses(targetype.toUpperCase()));
      pwc_columnInfo_target.setKeyType(tCoreMaskingTaskTableInfo.getIsPrimaryKey().equals("1") ? 1 : (tCoreMaskingTaskTableInfo.getIsForeignKey() != null ? (tCoreMaskingTaskTableInfo.getIsForeignKey().equals("1") ? 2 : 0) : 0));
      pwc_columnInfo_target.setMaskingRule((String)data_rule.get(tCoreMaskingTaskTableInfo.getRegexRuleId()));
      pwc_columnInfo_target.setNullable(pwc_columnInfo_target.getKeyType() != 0 ? 1 : 0);
      pwc_columnInfo_target.setQualifierType(qualifierType.toLowerCase());
      pwc_columnInfo_target.setScale("");
      pwc_columnInfo_target.setPrecision(targetlength != null && !targetlength.equals("") ? targetlength : tCoreMaskingTaskTableInfo.getColumnLength());
      if (pwc_columnInfo_target.getPrecision() == null || "".equals(pwc_columnInfo_target.getPrecision())) {
         pwc_columnInfo_target.setPrecision(tCoreMaskingTaskTableInfo.getColumnLength());
      }

      return pwc_columnInfo_target;
   }

   public ColumnInfo getPwc_columnInfo_source(Map map) {
      ColumnInfo pwc_columnInfo_source = new ColumnInfo();
      TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo = (TCoreMaskingTaskTableInfo)map.get("tCoreMaskingTaskTableInfo");
      Map<String, Map<String, String>> data_source_length = (Map)map.get("data_source_length");
      Map<String, String> data_rule = (Map)map.get("data_rule");
      String qualifierType = (String)map.get("qualifierType");
      Config pwc_config = (Config)map.get("pwc_config");
      String sourcetype = StringTool.delparentheses(tCoreMaskingTaskTableInfo.getSourceType().toUpperCase());
      String source = StringTool.delparentheses(tCoreMaskingTaskTableInfo.getSourceType().toLowerCase());
      pwc_columnInfo_source.setColumnName(tCoreMaskingTaskTableInfo.getColumnName());
      if ("SYSDATE".equalsIgnoreCase(pwc_columnInfo_source.getColumnName())) {
         pwc_columnInfo_source.setColumnName(tCoreMaskingTaskTableInfo.getColumnName() + "1");
      }

      pwc_columnInfo_source.setDataType(sourcetype);
      pwc_columnInfo_source.setKeyType(tCoreMaskingTaskTableInfo.getIsPrimaryKey().equals("1") ? 1 : (tCoreMaskingTaskTableInfo.getIsForeignKey() != null ? (tCoreMaskingTaskTableInfo.getIsForeignKey().equals("1") ? 2 : 0) : 0));
      pwc_columnInfo_source.setMaskingRule((String)data_rule.get(tCoreMaskingTaskTableInfo.getRegexRuleId()));
      pwc_columnInfo_source.setNullable(pwc_columnInfo_source.getKeyType() != 0 ? 1 : 0);
      pwc_columnInfo_source.setQualifierType(qualifierType.toLowerCase());
      String sourcelength = (String)((Map)data_source_length.get(source)).get("sourcelength");
      String sourcescancale = (String)((Map)data_source_length.get(source)).get("sourcescancale");
      String pwcsqlength = (String)((Map)data_source_length.get(source)).get("pwcsqlength");
      String pwcsqscale = (String)((Map)data_source_length.get(source)).get("pwcsqscale");
      String pwcdateformat = (String)((Map)data_source_length.get(source)).get("pwcdateformat");
      pwc_columnInfo_source.setScale("");
      pwc_columnInfo_source.setPrecision(sourcelength != null && !sourcelength.equals("") ? sourcelength : tCoreMaskingTaskTableInfo.getColumnLength());
      return pwc_columnInfo_source;
   }

   public List<StringBuffer> SynViewParam(Connection srcconn, Map map) {
      return null;
   }

   public String SynConstraintParam(Connection srcconn, Map map) {
      return null;
   }

   public String SynPartition(Connection s_conn, Map map) {
      return null;
   }

   public Map TargetParameter_normalEM() {
      return null;
   }
}
