package com.chenyang.nse.bussiness.service.info.db;

import com.power.xml.entity.ColumnInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class POSTGRESQL extends CommonMethod implements DatabaseTool {
   public static final String greenplumloadname = "greenplumload";
   public static final String greenplumloadmark = "快速导入";
   public static final String[][] exporttype = new String[][]{{"normal", "正常导出", "selected"}};
   public static final String[][] importtype = new String[][]{{"normal", "正常导入", "selected"}, {"greenplumload", "快速导入", ""}};

   public String ImportMethod() {
      StringBuffer targetradio = new StringBuffer();
      targetradio.append("<select name='execution_type' >");

      for(String[] radio : importtype) {
         targetradio.append(MessageFormat.format(this.sourceradio(), "'" + radio[0] + "'", radio[1], radio[2]));
      }

      targetradio.append("</select>");
      return targetradio.toString();
   }

   public String ExportMethod() {
      StringBuffer sourceradio = new StringBuffer();
      sourceradio.append("<select name='execution_type' >");

      for(String[] radio : exporttype) {
         sourceradio.append(MessageFormat.format(this.sourceradio(), "'" + radio[0] + "'", radio[1], radio[2]));
      }

      sourceradio.append("</select>");
      return sourceradio.toString();
   }

   public Map TargetParameter_normal() {
      Map<String, String> map = this.TargetParameter_fnormal();
      map.put("targetParameter", this.isrebuild());
      return map;
   }

   public Map TargetParameter_normal1() {
      Map<String, String> map = this.TargetParameter_fnormal();
      map.put("targetParameter", this.isrebuild());
      return map;
   }

   public Map TargetParameter_notNormal() {
      Map<String, String> map = this.TargetParameter_fnotnormal();
      return map;
   }

   public List<StringBuffer> SynTriggersParam(Connection s_conn, Map map) {
      return null;
   }

   public List<StringBuffer> SynFunctionParam(Connection s_conn, Map map) {
      List<StringBuffer> listTriggers = new ArrayList();
      String targetSchemaName = (String)map.get("targetSchemaName");
      String sourceSchemaName = (String)map.get("sourceSchema");
      PreparedStatement ps = null;
      ResultSet rs = null;
      String sql = "select  t.prosrc from pg_proc t join pg_namespace t2 on t.pronamespace = t2.oid where   t2.nspname='" + sourceSchemaName + "'";

      try {
         ps = s_conn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            StringBuffer sb = new StringBuffer();
            sb.append(rs.getString("prosrc").replaceAll(sourceSchemaName, targetSchemaName));
            listTriggers.add(sb);
            System.out.println(sb.toString());
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return listTriggers;
   }

   public List<StringBuffer> SynProcedureParam(Connection s_conn, Map map) {
      return null;
   }

   public ColumnInfo getPwc_columnInfo_target(Map map) {
      ColumnInfo columnInfo = this.getPwc_columnInfo_target_all_base(map);
      return columnInfo;
   }

   public ColumnInfo getPwc_columnInfo_source(Map map) {
      ColumnInfo columnInfo = this.getPwc_columnInfo_source_all_base(map);
      return columnInfo;
   }

   public List<StringBuffer> SynViewParam(Connection s_conn, Map map) {
      List<StringBuffer> listProcedure = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;
      String targetSchemaName = (String)map.get("targetSchemaName");
      String sourceSchemaName = (String)map.get("sourceSchemaName");
      String sql = "select dbms_metadata.get_ddl('VIEW',u.object_name) as view_sql from user_objects u where object_type  = 'VIEW'";
      String sql_user = "select USERNAME from user_users";

      try {
         ps = s_conn.prepareStatement(sql_user);
         rs = ps.executeQuery();
         if (rs.next()) {
            sourceSchemaName = rs.getString("USERNAME");
         }

         ps = s_conn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            StringBuffer sb = new StringBuffer();
            sb.append(rs.getString("view_sql").replaceAll(sourceSchemaName, targetSchemaName));
            listProcedure.add(sb);
            System.out.println(sb.toString());
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return listProcedure;
   }

   public String SynConstraintParam(Connection s_conn, Map map) {
      return null;
   }

   public String SynPartition(Connection s_conn, Map map) {
      return null;
   }

   public Map TargetParameter_normalEM() {
      return null;
   }
}
