package com.chenyang.nse.bussiness.tools.ha;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngineServerInfo;
import com.chenyang.nse.bussiness.init.HighAvailabilityInitListener;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class TcpSynTool {
   public static String synchronizationXmlFile(String xmlFileName, String dataProcessType) {
      String reStr = "1";
      String xmlFilePath = "";

      try {
         if ("1".equals(dataProcessType)) {
            xmlFilePath = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("xmlLocationself");
         } else {
            xmlFilePath = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("xmlLocation");
         }

         String resSynTcpServerPort = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("ha_resources_syn_tcp_server_port");
         String connTcpTimes = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("ha_conn_tcp_times");
         List<String> tableNameList = new ArrayList();
         File path = new File(xmlFilePath + xmlFileName + "/");
         if (path.isDirectory()) {
            File[] files = path.listFiles();

            for(File fileInfo : files) {
               if (!fileInfo.isDirectory()) {
                  String filePath = fileInfo.getPath();
                  tableNameList.add(filePath);
               }
            }
         }

         List<TCoreEngineServerInfo> esInfoLst = getTCoreEngineServeInfoLst();

         for(int i = esInfoLst.size() - 1; i >= 0; --i) {
            TCoreEngineServerInfo esInfo = (TCoreEngineServerInfo)esInfoLst.get(i);
            if (!"1".equals(esInfo.getFlag())) {
               try {
                  TcpClient client = new TcpClient(esInfo.getIp(), new Integer(resSynTcpServerPort));
                  String isSynSuccess = "1";

                  for(int j = 0; j < tableNameList.size(); ++j) {
                     String isFilePath = (String)tableNameList.get(j);
                     String conStatus = HighAvailabilityInitListener.getConnectStatus(esInfo.getIp(), new Integer(resSynTcpServerPort), new Integer(connTcpTimes));
                     if ("1".equals(conStatus)) {
                        String reupFileStr = client.uploadFile(isFilePath, j == 0 ? "1" : "0");
                        if (!"1".equals(reupFileStr)) {
                           isSynSuccess = "0";
                           System.out.println(">>>>>>>>>>>>>>脱敏任务：" + xmlFileName + " 存在同步文件出错，需要重新同步！");
                           break;
                        }
                     } else {
                        System.out.println("IP:" + esInfo.getIp() + ",PORT:" + resSynTcpServerPort + "的TCP服务的不可用");
                     }
                  }

                  if ("0".equals(isSynSuccess)) {
                     reStr = "0";
                     break;
                  }
               } catch (Exception e) {
                  e.printStackTrace();
               }
            }
         }

         return reStr;
      } catch (Exception e) {
         e.printStackTrace();
         return reStr;
      } finally {
         ;
      }
   }

   public static List<TCoreEngineServerInfo> getTCoreEngineServeInfoLst() {
      List<TCoreEngineServerInfo> tCoreEngineServerInfoList = new ArrayList();
      Connection connection = null;
      ResultSet rs = null;
      Statement statement = null;

      try {
         String driver = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("jdbc.driver");
         String url = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("jdbc.url");
         String user = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("jdbc.user");
         String password = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("jdbc.password");
         connection = JdbcTool.getConnection(driver, url, user, password);
         statement = connection.createStatement();
         String sql = "SELECT b.id,b.ip,b.username,b.pwd,b.isrun,b.createtime,b.updatetime,c.isprimaryserver as flag FROM T_CORE_SERVER_STATUS a inner join t_core_engine_server_info b on a.id = b.serverid and b.delflg ='0' inner join T_CORE_SERVER_INFO_STATUS c on a.id = c.serverid and c.isactive ='1' and c.delflg ='0' where b.isrun = '1' and a.delflg='0' order by b.updatetime desc";
         rs = statement.executeQuery(sql);
         TCoreEngineServerInfo tCoreEngineServerInfo = null;
         int i = 0;

         while(rs.next()) {
            ++i;
            tCoreEngineServerInfo = new TCoreEngineServerInfo();
            tCoreEngineServerInfo.setId(rs.getString("id"));
            tCoreEngineServerInfo.setIp(rs.getString("ip"));
            tCoreEngineServerInfo.setUsername(rs.getString("username"));
            tCoreEngineServerInfo.setPwd(rs.getString("pwd"));
            tCoreEngineServerInfo.setIsrun(rs.getString("isrun"));
            tCoreEngineServerInfo.setCreatetime(rs.getDate("createtime"));
            tCoreEngineServerInfo.setUpdatetime(rs.getDate("updatetime"));
            tCoreEngineServerInfo.setFlag(rs.getString("flag"));
            tCoreEngineServerInfoList.add(tCoreEngineServerInfo);
         }
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         if (null != statement) {
            try {
               statement.close();
            } catch (Exception e) {
               e.printStackTrace();
            }
         }

         if (null != connection) {
            try {
               connection.close();
            } catch (Exception e) {
               e.printStackTrace();
            }
         }

      }

      return tCoreEngineServerInfoList;
   }
}
