package com.chenyang.nse.bussiness.tools.syslog;

import cn.hutool.json.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import org.graylog2.syslog4j.Syslog;
import org.graylog2.syslog4j.SyslogIF;
import org.graylog2.syslog4j.impl.net.udp.UDPNetSyslogConfig;

public class MySyslogClient {
   private static final String HOST = "192.168.2.218";
   private static final int PORT = 40000;

   public void sendSyslog(String hostname, Integer port) {
      SyslogIF syslog = Syslog.getInstance("tcp");
      UDPNetSyslogConfig udpConfig = (UDPNetSyslogConfig)syslog.getConfig();
      udpConfig.setMaxMessageLength(10240);
      syslog.getConfig().setHost(hostname);
      syslog.getConfig().setPort(port);
      StringBuffer buffer = new StringBuffer();
      buffer.append("syslog 内容");
      JSONObject jsonObject = new JSONObject();
      jsonObject.put("message", buffer.toString());

      try {
         syslog.log(0, URLDecoder.decode(jsonObject.toString(), "utf-8"));
      } catch (UnsupportedEncodingException e) {
         System.out.println("generate log get exception " + e);
      }

      System.out.println("发送sendSyslog 成功!");
   }

   public void generate() {
      SyslogIF syslog = Syslog.getInstance("udp");
      syslog.getConfig().setHost("192.168.2.218");
      syslog.getConfig().setPort(40000);
      StringBuffer buffer = new StringBuffer();
      buffer.append("约会时间:" + (new Date()).toString().substring(4, 20) + ";").append("羞答答的美女:我是小红啦;").append("暗号:万般皆下品，唯有编码屌;");
      JSONObject jsonObject = new JSONObject();
      jsonObject.put("message", buffer.toString());

      try {
         syslog.log(0, URLDecoder.decode(jsonObject.toString(), "utf-8"));
      } catch (UnsupportedEncodingException e) {
         System.out.println("generate log get exception " + e);
      }

      System.out.println("哎呀，老娘的第一次dating，竟然还得先搭讪!");
   }

   public static void main(String[] args) {
      (new MySyslogClient()).generate();
   }
}
